/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.JNIHandleBlock;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class JNIHandles {
    private static AddressField globalHandlesField;
    private static AddressField weakGlobalHandlesField;
    private static OopField deletedHandleField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JNIHandles");
        globalHandlesField = type.getAddressField("_global_handles");
        weakGlobalHandlesField = type.getAddressField("_weak_global_handles");
        deletedHandleField = type.getOopField("_deleted_handle");
    }

    public JNIHandleBlock globalHandles() {
        Address handleAddr = globalHandlesField.getValue();
        if (handleAddr == null) {
            return null;
        }
        return new JNIHandleBlock(handleAddr);
    }

    public JNIHandleBlock weakGlobalHandles() {
        Address handleAddr = weakGlobalHandlesField.getValue();
        if (handleAddr == null) {
            return null;
        }
        return new JNIHandleBlock(handleAddr);
    }

    public OopHandle deletedHandle() {
        return deletedHandleField.getValue();
    }

    public boolean isDeletedHandle(OopHandle handle) {
        return handle != null && handle.equals(this.deletedHandle());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                JNIHandles.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

