/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.code.ScopeDesc;
import sun.jvm.hotspot.runtime.CompiledVFrame;
import sun.jvm.hotspot.runtime.ExternalVFrame;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.InterpretedVFrame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class VFrame {
    protected Frame fr;
    protected RegisterMap regMap;
    protected JavaThread thread;

    protected VFrame(Frame f, RegisterMap regMap, JavaThread thread) {
        this.regMap = (RegisterMap)regMap.clone();
        if (f != null) {
            this.fr = (Frame)f.clone();
        }
        this.thread = thread;
    }

    public static VFrame newVFrame(Frame f, RegisterMap regMap, JavaThread thread, boolean unsafe, boolean mayBeImprecise) {
        CodeBlob cb;
        if (f.isInterpretedFrame()) {
            return new InterpretedVFrame(f, regMap, thread);
        }
        if (!VM.getVM().isCore() && (cb = unsafe ? VM.getVM().getCodeCache().findBlobUnsafe(f.getPC()) : VM.getVM().getCodeCache().findBlob(f.getPC())) != null) {
            if (cb.isNMethod()) {
                NMethod nm = (NMethod)cb;
                ScopeDesc scope = null;
                scope = mayBeImprecise || VM.getVM().isDebugging() ? nm.getScopeDescNearDbg(f.getPC()) : nm.getScopeDescAt(f.getPC());
                return new CompiledVFrame(f, regMap, thread, scope, mayBeImprecise);
            }
            if (f.isGlueFrame()) {
                RegisterMap tempMap = regMap.copy();
                Frame s = f.sender(tempMap);
                return VFrame.newVFrame(s, tempMap, thread, unsafe, false);
            }
        }
        return new ExternalVFrame(f, regMap, thread, mayBeImprecise);
    }

    public static VFrame newVFrame(Frame f, RegisterMap regMap, JavaThread thread) {
        return VFrame.newVFrame(f, regMap, thread, false, false);
    }

    public Frame getFrame() {
        return this.fr;
    }

    public RegisterMap getRegisterMap() {
        return this.regMap;
    }

    public JavaThread getThread() {
        return this.thread;
    }

    public VFrame sender() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isTop(), "just checking");
        }
        return this.sender(false);
    }

    public VFrame sender(boolean mayBeImprecise) {
        RegisterMap tempMap = (RegisterMap)this.getRegisterMap().clone();
        if (this.fr.isFirstFrame()) {
            return null;
        }
        Frame s = this.fr.realSender(tempMap);
        if (s == null) {
            Assert.that(VM.getVM().getCPU().equals("ia64"), "Only ia64 should have null here");
            return null;
        }
        if (s.isFirstFrame()) {
            return null;
        }
        return VFrame.newVFrame(s, tempMap, this.getThread(), VM.getVM().isDebugging(), mayBeImprecise);
    }

    public JavaVFrame javaSender() {
        boolean imprecise = false;
        if (VM.getVM().isDebugging() && !this.isJavaFrame()) {
            imprecise = this.mayBeImpreciseDbg();
        }
        for (VFrame f = this.sender(imprecise); f != null; f = f.sender(imprecise)) {
            if (!f.isJavaFrame()) continue;
            return (JavaVFrame)f;
        }
        return null;
    }

    public boolean isTop() {
        return true;
    }

    public VFrame top() {
        VFrame vf = this;
        while (!vf.isTop()) {
            vf = vf.sender();
        }
        return vf;
    }

    public boolean isEntryFrame() {
        return false;
    }

    public boolean isJavaFrame() {
        return false;
    }

    public boolean isInterpretedFrame() {
        return false;
    }

    public boolean isCompiledFrame() {
        return false;
    }

    public boolean isDeoptimized() {
        return false;
    }

    public boolean mayBeImpreciseDbg() {
        return false;
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        if (VM.getVM().wizardMode()) {
            this.fr.printValueOn(tty);
        }
    }

    public void printValue() {
        this.printValueOn(System.out);
    }

    public void printValueOn(PrintStream tty) {
        this.printOn(tty);
    }
}

