/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import sun.jvm.hotspot.runtime.Arguments;
import sun.jvm.hotspot.tools.SysPropsDumper;
import sun.jvm.hotspot.tools.Tool;

public class JInfo
extends Tool {
    public static final int MODE_FLAGS = 0;
    public static final int MODE_SYSPROPS = 1;
    public static final int MODE_BOTH = 2;
    private int mode;

    public JInfo(int m) {
        this.mode = m;
    }

    protected boolean needsJavaPrefix() {
        return false;
    }

    public String getName() {
        return "jinfo";
    }

    protected void printFlagsUsage() {
        System.out.println("    -flags\tto print VM flags");
        System.out.println("    -sysprops\tto print Java System properties");
        System.out.println("    <no option>\tto print both of the above");
        super.printFlagsUsage();
    }

    public void run() {
        Tool tool = null;
        switch (this.mode) {
            case 0: {
                this.printVMFlags();
                return;
            }
            case 1: {
                tool = new SysPropsDumper();
                break;
            }
            case 2: {
                tool = new Tool(){

                    public void run() {
                        SysPropsDumper sysProps = new SysPropsDumper();
                        sysProps.setAgent(this.getAgent());
                        System.out.println("Java System Properties:");
                        System.out.println();
                        sysProps.run();
                        System.out.println();
                        System.out.println("VM Flags:");
                        JInfo.this.printVMFlags();
                        System.out.println();
                    }
                };
                break;
            }
            default: {
                this.usage();
            }
        }
        tool.setAgent(this.getAgent());
        tool.run();
    }

    public static void main(String[] args) {
        int mode = -1;
        switch (args.length) {
            case 1: {
                if (args[0].charAt(0) == '-') {
                    new JInfo(mode).usage();
                    break;
                }
                mode = 2;
                break;
            }
            case 2: 
            case 3: {
                String modeFlag = args[0];
                if (modeFlag.equals("-flags")) {
                    mode = 0;
                } else if (modeFlag.equals("-sysprops")) {
                    mode = 1;
                } else if (modeFlag.charAt(0) == '-') {
                    new JInfo(mode).usage();
                } else {
                    mode = 2;
                }
                if (mode == 2) break;
                String[] newArgs = new String[args.length - 1];
                for (int i = 0; i < newArgs.length; ++i) {
                    newArgs[i] = args[i + 1];
                }
                args = newArgs;
                break;
            }
            default: {
                new JInfo(mode).usage();
            }
        }
        JInfo jinfo = new JInfo(mode);
        jinfo.start(args);
        jinfo.stop();
    }

    private void printVMFlags() {
        String str = Arguments.getJVMFlags();
        if (str != null) {
            System.out.println(str);
        }
        if ((str = Arguments.getJVMArgs()) != null) {
            System.out.println(str);
        }
    }
}

