/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.List;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;
import javax.crypto.SunJCE_b;
import sun.security.jca.GetInstance;
import sun.security.util.Debug;

public class Mac
implements Cloneable {
    private static final Debug a = Debug.getInstance("jca", "Mac");
    private Provider b;
    private MacSpi c;
    private final String d;
    private boolean e = false;
    private Provider.Service f;
    private Iterator g;
    private final Object h;
    private static int i = 10;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.c = macSpi;
        this.b = provider;
        this.d = string;
        this.g = null;
        this.h = null;
    }

    private Mac(Provider.Service service, Iterator iterator, String string) {
        this.f = service;
        this.g = iterator;
        this.d = string;
        this.h = new Object();
    }

    public final String getAlgorithm() {
        return this.d;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        List<Provider.Service> list = GetInstance.getServices("Mac", string);
        Iterator<Provider.Service> iterator = list.iterator();
        while (iterator.hasNext()) {
            Provider.Service service = iterator.next();
            if (!SunJCE_b.b(service.getProvider())) continue;
            return new Mac(service, iterator, string);
        }
        throw new NoSuchAlgorithmException("Algorithm " + string + " not available");
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = SunJCE_b.a("Mac", MacSpi.class, string, string2);
        return new Mac((MacSpi)instance.impl, instance.provider, string);
    }

    public static final Mac getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = SunJCE_b.a("Mac", MacSpi.class, string, provider);
        return new Mac((MacSpi)instance.impl, instance.provider, string);
    }

    void a() {
        if (this.c != null || this.g == null) {
            return;
        }
        Object object = this.h;
        synchronized (object) {
            Object object2;
            int n;
            if (this.c != null) {
                return;
            }
            if (a != null && (n = --i) >= 0) {
                a.println("Mac.init() not first method called, disabling delayed provider selection");
                if (n == 0) {
                    a.println("Further warnings of this type will be suppressed");
                }
                new Exception("Call trace").printStackTrace();
            }
            NoSuchAlgorithmException noSuchAlgorithmException = null;
            while (this.f != null || this.g.hasNext()) {
                if (this.f != null) {
                    object2 = this.f;
                    this.f = null;
                } else {
                    object2 = (Provider.Service)this.g.next();
                }
                if (!SunJCE_b.b(((Provider.Service)object2).getProvider())) continue;
                try {
                    Object object3 = ((Provider.Service)object2).newInstance(null);
                    if (!(object3 instanceof MacSpi)) continue;
                    this.c = (MacSpi)object3;
                    this.b = ((Provider.Service)object2).getProvider();
                    this.f = null;
                    this.g = null;
                    return;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    noSuchAlgorithmException = noSuchAlgorithmException2;
                }
            }
            object2 = new ProviderException("Could not construct MacSpi instance");
            if (noSuchAlgorithmException != null) {
                ((Throwable)object2).initCause(noSuchAlgorithmException);
            }
            throw object2;
        }
    }

    private void a(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object = this.h;
        synchronized (object) {
            Object object2;
            if (this.c != null) {
                this.c.engineInit(key, algorithmParameterSpec);
                return;
            }
            Exception exception = null;
            while (this.f != null || this.g.hasNext()) {
                if (this.f != null) {
                    object2 = this.f;
                    this.f = null;
                } else {
                    object2 = (Provider.Service)this.g.next();
                }
                if (!((Provider.Service)object2).supportsParameter(key) || !SunJCE_b.b(((Provider.Service)object2).getProvider())) continue;
                try {
                    MacSpi macSpi = (MacSpi)((Provider.Service)object2).newInstance(null);
                    macSpi.engineInit(key, algorithmParameterSpec);
                    this.b = ((Provider.Service)object2).getProvider();
                    this.c = macSpi;
                    this.f = null;
                    this.g = null;
                    return;
                }
                catch (Exception exception2) {
                    if (exception != null) continue;
                    exception = exception2;
                }
            }
            if (exception instanceof InvalidKeyException) {
                throw (InvalidKeyException)exception;
            }
            if (exception instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            object2 = key != null ? key.getClass().getName() : "(null)";
            throw new InvalidKeyException("No installed provider supports this key: " + (String)object2, exception);
        }
    }

    public final Provider getProvider() {
        this.a();
        return this.b;
    }

    public final int getMacLength() {
        this.a();
        return this.c.engineGetMacLength();
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            if (this.c != null) {
                this.c.engineInit(key, null);
            } else {
                this.a(key, null);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("init() failed", invalidAlgorithmParameterException);
        }
        this.e = true;
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.c != null) {
            this.c.engineInit(key, algorithmParameterSpec);
        } else {
            this.a(key, algorithmParameterSpec);
        }
        this.e = true;
    }

    public final void update(byte by) throws IllegalStateException {
        this.a();
        if (!this.e) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.c.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        this.a();
        if (!this.e) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (byArray != null) {
            this.c.engineUpdate(byArray, 0, byArray.length);
        }
    }

    public final void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        this.a();
        if (!this.e) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (byArray != null) {
            if (n < 0 || n2 > byArray.length - n || n2 < 0) {
                throw new IllegalArgumentException("Bad arguments");
            }
            this.c.engineUpdate(byArray, n, n2);
        }
    }

    public final void update(ByteBuffer byteBuffer) {
        this.a();
        if (!this.e) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Buffer must not be null");
        }
        this.c.engineUpdate(byteBuffer);
    }

    public final byte[] doFinal() throws IllegalStateException {
        this.a();
        if (!this.e) {
            throw new IllegalStateException("MAC not initialized");
        }
        byte[] byArray = this.c.engineDoFinal();
        this.c.engineReset();
        return byArray;
    }

    public final void doFinal(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        this.a();
        if (!this.e) {
            throw new IllegalStateException("MAC not initialized");
        }
        int n2 = this.getMacLength();
        if (byArray == null || byArray.length - n < n2) {
            throw new ShortBufferException("Cannot store MAC in output buffer");
        }
        byte[] byArray2 = this.doFinal();
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        this.a();
        if (!this.e) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.update(byArray);
        return this.doFinal();
    }

    public final void reset() {
        this.a();
        this.c.engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        this.a();
        Mac mac = (Mac)super.clone();
        mac.c = (MacSpi)this.c.clone();
        return mac;
    }
}

