/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.addressing.W3CAddressingConstants;
import com.sun.xml.internal.ws.addressing.WsaTube;
import com.sun.xml.internal.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.internal.ws.addressing.model.InvalidMapException;
import com.sun.xml.internal.ws.addressing.model.MapRequiredException;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.message.FaultDetailHeader;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;

public final class WsaServerTube
extends WsaTube {
    private WSEndpointReference replyTo;
    private WSEndpointReference faultTo;
    private boolean isAnonymousRequired = false;
    private WSDLBoundOperation wbo;
    public static final String REQUEST_MESSAGE_ID = "com.sun.xml.internal.ws.addressing.request.messageID";
    private static final Logger LOGGER = Logger.getLogger(WsaServerTube.class.getName());

    public WsaServerTube(@NotNull WSDLPort wSDLPort, WSBinding wSBinding, Tube tube) {
        super(wSDLPort, wSBinding, tube);
    }

    public WsaServerTube(WsaServerTube wsaServerTube, TubeCloner tubeCloner) {
        super(wsaServerTube, tubeCloner);
    }

    public WsaServerTube copy(TubeCloner tubeCloner) {
        return new WsaServerTube(this, tubeCloner);
    }

    @NotNull
    public NextAction processRequest(Packet packet) {
        Packet packet2;
        Message message = packet.getMessage();
        if (message == null) {
            return this.doInvoke(this.next, packet);
        }
        HeaderList headerList = packet.getMessage().getHeaders();
        try {
            this.replyTo = headerList.getReplyTo(this.addressingVersion, this.soapVersion);
            this.faultTo = headerList.getFaultTo(this.addressingVersion, this.soapVersion);
        }
        catch (InvalidMapException invalidMapException) {
            Object object;
            SOAPFault sOAPFault = this.helper.newInvalidMapFault(invalidMapException, this.addressingVersion);
            if (packet.getMessage().isOneWay(this.wsdlPort)) {
                packet.createServerResponse(null, this.wsdlPort, null, this.binding);
                return this.doInvoke(this.next, packet);
            }
            Message message2 = Messages.create(sOAPFault);
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                object = new FaultDetailHeader(this.addressingVersion, this.addressingVersion.problemHeaderQNameTag.getLocalPart(), invalidMapException.getMapQName());
                message2.getHeaders().add((Header)object);
            }
            object = packet.createServerResponse(message2, this.wsdlPort, null, this.binding);
            return this.doReturnWith((Packet)object);
        }
        String string = headerList.getMessageID(this.addressingVersion, this.soapVersion);
        packet.invocationProperties.put(REQUEST_MESSAGE_ID, string);
        if (this.replyTo == null) {
            this.replyTo = this.addressingVersion.anonymousEpr;
        }
        if (this.faultTo == null) {
            this.faultTo = this.replyTo;
        }
        this.wbo = this.getWSDLBoundOperation(packet);
        if (this.wbo != null && this.wbo.getAnonymous() == WSDLBoundOperation.ANONYMOUS.required) {
            this.isAnonymousRequired = true;
        }
        if ((packet2 = this.validateInboundHeaders(packet)).getMessage() == null) {
            return this.doReturnWith(packet2);
        }
        if (packet2.getMessage().isFault()) {
            if (!this.isAnonymousRequired && !this.faultTo.isAnonymous() && packet.transportBackChannel != null) {
                packet.transportBackChannel.close();
            }
            return this.processResponse(packet2);
        }
        if (!(this.isAnonymousRequired || this.replyTo.isAnonymous() || this.faultTo.isAnonymous() || packet.transportBackChannel == null)) {
            packet.transportBackChannel.close();
        }
        return this.doInvoke(this.next, packet2);
    }

    @NotNull
    public NextAction processResponse(Packet packet) {
        WSEndpointReference wSEndpointReference;
        Message message = packet.getMessage();
        if (message == null) {
            return this.doReturnWith(packet);
        }
        WSEndpointReference wSEndpointReference2 = wSEndpointReference = message.isFault() ? this.faultTo : this.replyTo;
        if (wSEndpointReference.isAnonymous() || this.isAnonymousRequired) {
            return this.doReturnWith(packet);
        }
        if (wSEndpointReference.isNone()) {
            packet.setMessage(null);
            return this.doReturnWith(packet);
        }
        this.processNonAnonymousReply(packet, wSEndpointReference);
        packet.setMessage(null);
        return this.doReturnWith(packet);
    }

    private void processNonAnonymousReply(Packet packet, WSEndpointReference wSEndpointReference) {
        String string;
        EndpointAddress endpointAddress;
        if (packet.transportBackChannel != null) {
            packet.transportBackChannel.close();
        }
        if (packet.getMessage().isOneWay(this.wsdlPort)) {
            LOGGER.fine(AddressingMessages.NON_ANONYMOUS_RESPONSE_ONEWAY());
            return;
        }
        try {
            endpointAddress = new EndpointAddress(URI.create(wSEndpointReference.getAddress()));
        }
        catch (NullPointerException nullPointerException) {
            throw new WebServiceException(nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new WebServiceException(illegalArgumentException);
        }
        Tube tube = TransportTubeFactory.create(Thread.currentThread().getContextClassLoader(), new ClientTubeAssemblerContext(endpointAddress, this.wsdlPort, null, this.binding));
        packet.endpointAddress = endpointAddress;
        packet.soapAction = string = packet.getMessage().isFault() ? this.helper.getFaultAction(this.wbo, packet) : this.helper.getOutputAction(this.wbo);
        Fiber.current().runSync(tube, packet);
    }

    public void validateAction(Packet packet) {
        WSDLBoundOperation wSDLBoundOperation = this.getWSDLBoundOperation(packet);
        if (wSDLBoundOperation == null) {
            return;
        }
        String string = packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
        if (string == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_SERVER_NULL_ACTION());
        }
        String string2 = this.helper.getInputAction(packet);
        String string3 = this.helper.getSOAPAction(packet);
        if (this.helper.isInputActionDefault(packet) && string3 != null && !string3.equals("")) {
            string2 = string3;
        }
        if (string2 != null && !string.equals(string2)) {
            throw new ActionNotSupportedException(string);
        }
    }

    public void checkCardinality(Packet packet) {
        super.checkCardinality(packet);
        WSDLBoundOperation wSDLBoundOperation = this.getWSDLBoundOperation(packet);
        this.checkAnonymousSemantics(wSDLBoundOperation, this.replyTo, this.faultTo);
        this.checkNonAnonymousAddresses(this.replyTo, this.faultTo);
    }

    private void checkNonAnonymousAddresses(WSEndpointReference wSEndpointReference, WSEndpointReference wSEndpointReference2) {
        if (!wSEndpointReference.isAnonymous()) {
            try {
                new EndpointAddress(URI.create(wSEndpointReference.getAddress()));
            }
            catch (Exception exception) {
                throw new InvalidMapException(this.addressingVersion.replyToTag, this.addressingVersion.invalidAddressTag);
            }
        }
    }

    protected void checkMandatoryHeaders(Packet packet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super.checkMandatoryHeaders(packet, bl, bl2, bl3, bl4);
        WSDLBoundOperation wSDLBoundOperation = this.getWSDLBoundOperation(packet);
        if (wSDLBoundOperation == null) {
            return;
        }
        if (!bl2) {
            throw new MapRequiredException(this.addressingVersion.toTag);
        }
        if (!wSDLBoundOperation.getOperation().isOneWay() && !bl3) {
            throw new MapRequiredException(this.addressingVersion.messageIDTag);
        }
    }

    final void checkAnonymousSemantics(WSDLBoundOperation wSDLBoundOperation, WSEndpointReference wSEndpointReference, WSEndpointReference wSEndpointReference2) {
        if (this.addressingVersion == null || this.addressingVersion == AddressingVersion.MEMBER) {
            return;
        }
        if (wSDLBoundOperation == null) {
            return;
        }
        WSDLBoundOperation.ANONYMOUS aNONYMOUS = wSDLBoundOperation.getAnonymous();
        String string = null;
        String string2 = null;
        if (wSEndpointReference != null) {
            string = wSEndpointReference.getAddress();
        }
        if (wSEndpointReference2 != null) {
            string2 = wSEndpointReference2.getAddress();
        }
        switch (aNONYMOUS) {
            case optional: {
                break;
            }
            case prohibited: {
                if (string != null && string.equals(this.addressingVersion.anonymousUri)) {
                    throw new InvalidMapException(this.addressingVersion.replyToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (string2 == null || !string2.equals(this.addressingVersion.anonymousUri)) break;
                throw new InvalidMapException(this.addressingVersion.faultToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
            }
            case required: {
                if (string != null && !string.equals(this.addressingVersion.anonymousUri)) {
                    throw new InvalidMapException(this.addressingVersion.replyToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (string2 == null || string2.equals(this.addressingVersion.anonymousUri)) break;
                throw new InvalidMapException(this.addressingVersion.faultToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
            }
            default: {
                throw new WebServiceException(AddressingMessages.INVALID_WSAW_ANONYMOUS(aNONYMOUS.toString()));
            }
        }
    }
}

