/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.messaging.saaj.packaging.mime.util.OutputUtil;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.UUID;

abstract class MimeCodec
implements Codec {
    public static final String MULTIPART_RELATED_MIME_TYPE = "multipart/related";
    private String boundary;
    private String messageContentType;
    private boolean hasAttachments;
    protected Codec rootCodec;
    protected final SOAPVersion version;

    protected MimeCodec(SOAPVersion sOAPVersion) {
        this.version = sOAPVersion;
    }

    public String getMimeType() {
        return MULTIPART_RELATED_MIME_TYPE;
    }

    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        Message message = packet.getMessage();
        if (message == null) {
            return null;
        }
        if (this.hasAttachments) {
            OutputUtil.writeln("--" + this.boundary, outputStream);
            OutputUtil.writeln("Content-Type: " + this.rootCodec.getMimeType(), outputStream);
            OutputUtil.writeln(outputStream);
        }
        ContentType contentType = this.rootCodec.encode(packet, outputStream);
        if (this.hasAttachments) {
            OutputUtil.writeln(outputStream);
            for (Attachment attachment : message.getAttachments()) {
                OutputUtil.writeln("--" + this.boundary, outputStream);
                String string = attachment.getContentId();
                if (string != null && string.length() > 0 && string.charAt(0) != '<') {
                    string = '<' + string + '>';
                }
                OutputUtil.writeln("Content-Id:" + string, outputStream);
                OutputUtil.writeln("Content-Type: " + attachment.getContentType(), outputStream);
                OutputUtil.writeln("Content-Transfer-Encoding: binary", outputStream);
                OutputUtil.writeln(outputStream);
                attachment.writeTo(outputStream);
                OutputUtil.writeln(outputStream);
            }
            OutputUtil.writeAsAscii("--" + this.boundary, outputStream);
            OutputUtil.writeAsAscii("--", outputStream);
        }
        return this.hasAttachments ? new ContentTypeImpl(this.messageContentType, packet.soapAction, null) : contentType;
    }

    public ContentType getStaticContentType(Packet packet) {
        Message message = packet.getMessage();
        boolean bl = this.hasAttachments = !message.getAttachments().isEmpty();
        if (this.hasAttachments) {
            this.boundary = "uuid:" + UUID.randomUUID().toString();
            String string = "boundary=\"" + this.boundary + "\"";
            this.messageContentType = "multipart/related; type=\"" + this.rootCodec.getMimeType() + "\"; " + string;
            return new ContentTypeImpl(this.messageContentType, packet.soapAction, null);
        }
        return this.rootCodec.getStaticContentType(packet);
    }

    protected MimeCodec(MimeCodec mimeCodec) {
        this.version = mimeCodec.version;
    }

    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        MimeMultipartParser mimeMultipartParser = new MimeMultipartParser(inputStream, string);
        this.decode(mimeMultipartParser, packet);
    }

    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        throw new UnsupportedOperationException();
    }

    protected abstract void decode(MimeMultipartParser var1, Packet var2) throws IOException;

    public abstract MimeCodec copy();
}

