/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.net.httpserver.HttpContext;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.server.InstanceResolver;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.server.EndpointFactory;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.transport.http.server.HttpEndpoint;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServicePermission;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object actualEndpoint;
    private final WSBinding binding;
    private final Object implementor;
    private List<Source> metadata;
    private Executor executor;
    private Map<String, Object> properties = Collections.emptyMap();
    private boolean stopped;

    public EndpointImpl(@NotNull BindingID bindingID, @NotNull Object object) {
        this.binding = BindingImpl.create(bindingID);
        this.implementor = object;
    }

    public EndpointImpl(WSEndpoint wSEndpoint, Object object) {
        this.actualEndpoint = new HttpEndpoint(wSEndpoint, this.executor);
        ((HttpEndpoint)this.actualEndpoint).publish(object);
        this.binding = wSEndpoint.getBinding();
        this.implementor = null;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public Object getImplementor() {
        return this.implementor;
    }

    @Override
    public void publish(String string) {
        URL uRL;
        this.canPublish();
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Cannot create URL for this address " + string);
        }
        if (!uRL.getProtocol().equals("http")) {
            throw new IllegalArgumentException(uRL.getProtocol() + " protocol based address is not supported");
        }
        if (!uRL.getPath().startsWith("/")) {
            throw new IllegalArgumentException("Incorrect WebService address=" + string + ". The address's path should start with /");
        }
        this.createEndpoint();
        ((HttpEndpoint)this.actualEndpoint).publish(string);
    }

    @Override
    public void publish(Object object) {
        this.canPublish();
        if (!HttpContext.class.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(object.getClass() + " is not a supported context.");
        }
        this.createEndpoint();
        ((HttpEndpoint)this.actualEndpoint).publish(object);
    }

    @Override
    public void stop() {
        if (this.isPublished()) {
            ((HttpEndpoint)this.actualEndpoint).stop();
            this.actualEndpoint = null;
            this.stopped = true;
        }
    }

    @Override
    public boolean isPublished() {
        return this.actualEndpoint != null;
    }

    @Override
    public List<Source> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(List<Source> list) {
        if (this.isPublished()) {
            throw new IllegalStateException("Cannot set Metadata. Endpoint is already published");
        }
        this.metadata = list;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        this.properties = new HashMap<String, Object>(map);
    }

    private void createEndpoint() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ENDPOINT_PUBLISH_PERMISSION);
        }
        try {
            Class.forName("com.sun.net.httpserver.HttpServer");
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("NOT SUPPORTED");
        }
        WSEndpoint<?> wSEndpoint = WSEndpoint.create(this.implementor.getClass(), true, InstanceResolver.createSingleton(this.implementor).createInvoker(), this.getProperty(QName.class, "javax.xml.ws.wsdl.service"), this.getProperty(QName.class, "javax.xml.ws.wsdl.port"), null, this.binding, this.getPrimaryWsdl(), this.buildDocList(), (EntityResolver)null);
        this.actualEndpoint = new HttpEndpoint(wSEndpoint, this.executor);
    }

    private <T> T getProperty(Class<T> clazz, String string) {
        Object object = this.properties.get(string);
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw new IllegalArgumentException("Property " + string + " has to be of type " + clazz);
    }

    private List<SDDocumentSource> buildDocList() {
        ArrayList<SDDocumentSource> arrayList = new ArrayList<SDDocumentSource>();
        if (this.metadata != null) {
            Transformer transformer = XmlUtil.newTransformer();
            for (Source source : this.metadata) {
                try {
                    XMLStreamBufferResult xMLStreamBufferResult = new XMLStreamBufferResult();
                    transformer.transform(source, xMLStreamBufferResult);
                    String string = source.getSystemId();
                    arrayList.add(SDDocumentSource.create(new URL(string), xMLStreamBufferResult.getXMLStreamBuffer()));
                }
                catch (TransformerException transformerException) {
                    throw new ServerRtException("server.rt.err", new Object[]{transformerException});
                }
                catch (IOException iOException) {
                    throw new ServerRtException("server.rt.err", new Object[]{iOException});
                }
            }
        }
        return arrayList;
    }

    @Nullable
    private SDDocumentSource getPrimaryWsdl() {
        Class<?> clazz = this.implementor.getClass();
        String string = EndpointFactory.getWsdlLocation(clazz);
        if (string != null) {
            ClassLoader classLoader = clazz.getClassLoader();
            URL uRL = classLoader.getResource(string);
            if (uRL != null) {
                return SDDocumentSource.create(uRL);
            }
            throw new ServerRtException("cannot.load.wsdl", string);
        }
        return null;
    }

    private void canPublish() {
        if (this.isPublished()) {
            throw new IllegalStateException("Cannot publish this endpoint. Endpoint has been already published.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Cannot publish this endpoint. Endpoint has been already stopped.");
        }
    }

    @Override
    public EndpointReference getEndpointReference(Element ... elementArray) {
        return this.getEndpointReference(W3CEndpointReference.class, elementArray);
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... elementArray) {
        if (!this.isPublished()) {
            throw new WebServiceException("Endpoint is not published yet");
        }
        return ((HttpEndpoint)this.actualEndpoint).getEndpointReference(clazz, elementArray);
    }
}

