/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.security.CodeSigner;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import sun.misc.BASE64Decoder;
import sun.security.provider.Sun;
import sun.security.util.Debug;

public class ManifestEntryVerifier {
    private static final Debug debug = Debug.getInstance("jar");
    private static final Provider sunProvider = new Sun();
    HashMap createdDigests = new HashMap(11);
    ArrayList digests = new ArrayList();
    ArrayList manifestHashes = new ArrayList();
    private BASE64Decoder decoder = new BASE64Decoder();
    private String name = null;
    private Manifest man;
    private boolean skip = true;
    private JarEntry entry;
    private CodeSigner[] signers = null;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ManifestEntryVerifier(Manifest manifest) {
        this.man = manifest;
    }

    public void setEntry(String string, JarEntry jarEntry) throws IOException {
        this.digests.clear();
        this.manifestHashes.clear();
        this.name = string;
        this.entry = jarEntry;
        this.skip = true;
        this.signers = null;
        if (this.man == null || string == null) {
            return;
        }
        Attributes attributes = this.man.getAttributes(string);
        if (attributes == null && (attributes = this.man.getAttributes("./" + string)) == null && (attributes = this.man.getAttributes("/" + string)) == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string2 = entry.getKey().toString();
            if (!string2.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST")) continue;
            String string3 = string2.substring(0, string2.length() - 7);
            MessageDigest messageDigest = (MessageDigest)this.createdDigests.get(string3);
            if (messageDigest == null) {
                try {
                    messageDigest = MessageDigest.getInstance(string3, sunProvider);
                    this.createdDigests.put(string3, messageDigest);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (messageDigest == null) continue;
            this.skip = false;
            messageDigest.reset();
            this.digests.add(messageDigest);
            this.manifestHashes.add(this.decoder.decodeBuffer((String)entry.getValue()));
        }
    }

    public void update(byte by) {
        if (this.skip) {
            return;
        }
        for (int i = 0; i < this.digests.size(); ++i) {
            ((MessageDigest)this.digests.get(i)).update(by);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.skip) {
            return;
        }
        for (int i = 0; i < this.digests.size(); ++i) {
            ((MessageDigest)this.digests.get(i)).update(byArray, n, n2);
        }
    }

    public JarEntry getEntry() {
        return this.entry;
    }

    public CodeSigner[] verify(Hashtable hashtable, Hashtable hashtable2) throws JarException {
        if (this.skip) {
            return null;
        }
        if (this.signers != null) {
            return this.signers;
        }
        for (int i = 0; i < this.digests.size(); ++i) {
            MessageDigest messageDigest = (MessageDigest)this.digests.get(i);
            byte[] byArray = (byte[])this.manifestHashes.get(i);
            byte[] byArray2 = messageDigest.digest();
            if (debug != null) {
                debug.println("Manifest Entry: " + this.name + " digest=" + messageDigest.getAlgorithm());
                debug.println("  manifest " + ManifestEntryVerifier.toHex(byArray));
                debug.println("  computed " + ManifestEntryVerifier.toHex(byArray2));
                debug.println();
            }
            if (MessageDigest.isEqual(byArray2, byArray)) continue;
            throw new SecurityException(messageDigest.getAlgorithm() + " digest error for " + this.name);
        }
        this.signers = (CodeSigner[])hashtable2.remove(this.name);
        if (this.signers != null) {
            hashtable.put(this.name, this.signers);
        }
        return this.signers;
    }

    static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexc[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexc[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }
}

