#!/bin/bash

#######################################################################
# Program: compile.gd
# Purpose: Compile the Boutell GD graphics libraries for PHP
# Author : Stuart Winter <stuart@polplex.co.uk> heavily if not entirely
#          based on Slackware's php/SlackBuild script
# Date...: 20/12/02
#######################################################################
# Note: This does NOT get installed onto the system.  It's purely for
#       this particular build of PHP
#######################################################################

# This is no longer required because as of PHP 4.3.0, GD version 2
# is bundled with the PHP source.

echo "Compiling GD for php"

# Work out where we were called from
CWD=$PWD

BUILDPATH=/tmp/compiling-slackpacks/gd-for-php
rm -rf $BUILDPATH  #clean up any existing compilation
mkdir -pm700 $BUILDPATH

# Enter into the temp build path
cd $BUILDPATH
tar zxvvf $CWD/source/gd*gz
mv gd* gd
cd gd

#This bit is based on Slackware build script for php
make 
mkdir bin include lib

cp libgd.a lib
cp gd.h gdcache.h gd_io.h gdfontg.h gdfontmb.h gdfonts.h gdfontt.h include
cp pngtogd pngtogd2 gdtopng gd2topng gd2copypal gdparttopng webpng bdftogd \
   bin/


