/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.engine.DefaultSet;
import sun.plugin.converter.engine.PluginConverter;
import sun.plugin.converter.gui.ConverterGUI;
import sun.plugin.converter.util.CommandLine;
import sun.plugin.converter.util.CommandLineException;
import sun.plugin.converter.util.FileAccessException;
import sun.plugin.converter.util.FlexFilter;
import sun.plugin.converter.util.NotDirectoryException;

public class HTMLConverter {
    private CommandLine cmdLine;
    private FlexFilter fileFilter = new FlexFilter();
    private PluginConverter converter = null;
    private DefaultSet set = null;
    private File logFile = null;
    private boolean stdin = false;
    private boolean stdout = false;
    private String sourceStr = null;
    private String backupStr = null;
    private String destStr = null;
    private String tempStr = null;
    private String logStr = null;
    private String sep = System.getProperty("file.separator");

    public HTMLConverter(String[] stringArray) {
        try {
            this.cmdLine = new CommandLine(stringArray);
            if (this.cmdLine.justHelp()) {
                this.showHelp();
                System.exit(-1);
            } else if (this.cmdLine.doGUI()) {
                this.processWithGUI();
            } else {
                this.processCommandLine();
            }
        }
        catch (CommandLineException commandLineException) {
            this.showHelp();
            System.exit(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.showHelp();
            System.exit(-1);
        }
        catch (NotDirectoryException notDirectoryException) {
            System.out.println(notDirectoryException.getMessage());
            System.exit(-1);
        }
        catch (FileAccessException fileAccessException) {
            System.out.println(fileAccessException.getMessage());
            System.exit(-1);
        }
    }

    private void processWithGUI() {
        ConverterGUI converterGUI = new ConverterGUI();
        converterGUI.pack();
        converterGUI.setVisible(true);
    }

    private void processCommandLine() throws NotDirectoryException, FileAccessException {
        Enumeration enumeration;
        try {
            this.converter = new PluginConverter(this.cmdLine.isLogFile(), this.cmdLine.showProgress());
            this.converter.setStaticVersioning(this.cmdLine.getStaticVersioning());
            this.converter.setOverwrite(this.cmdLine.isOverwrite());
            this.set = new DefaultSet();
            this.converter.setConvertSet(this.set);
            this.converter.setCommandLine(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            HTMLConverter hTMLConverter = this;
            System.out.println(ResourceHandler.getMessage("notemplate_dialog.info0") + hTMLConverter.converter.getDefaultTemplateFileName() + ResourceHandler.getMessage("notemplate_dialog.info1"));
            System.exit(-2);
        }
        if (this.cmdLine.isStdIn()) {
            this.stdin = true;
            Vector vector = this.cmdLine.getStandardInput();
            if (vector != null) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.fileFilter.addDescriptor((String)enumeration.nextElement());
                }
            }
        } else {
            Vector vector = this.cmdLine.getFileSpecs();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.fileFilter.addDescriptor((String)enumeration.nextElement());
            }
        }
        if (this.cmdLine.doSubDirs()) {
            this.fileFilter.setFilesOnly(false);
            this.converter.setRecurse(true);
        }
        if (this.cmdLine.showProgress()) {
            this.converter.setShowProgressStdOut(true);
        }
        if (this.cmdLine.isStdOut()) {
            this.stdout = true;
        }
        this.setSource();
        this.setDest();
        this.setBack();
        this.setTemp();
        this.setLog();
        enumeration = this.set.getFilesEnumeration();
        if (!this.stdin && this.set.getFileCount() == 0) {
            System.out.println(ResourceHandler.getMessage("plugin_converter.nofiles"));
            System.exit(-2);
        } else if (this.cmdLine.justSimulate()) {
            this.simulate(enumeration);
        } else {
            this.converter.setSourceType(this.stdin);
            this.converter.setDestType(this.stdout);
            this.converter.startConversion();
        }
    }

    private void showHelp() {
        System.out.println(ResourceHandler.getMessage("plugin_converter.help_message"));
    }

    public static boolean checkTrue(String string) {
        return (string = string.trim().toUpperCase()).equals("TRUE") || string.equals("T") || string.equals("YES") || string.equals("Y");
    }

    private void setSource() throws NotDirectoryException {
        this.sourceStr = this.cmdLine.getSourceDir();
        if (this.sourceStr != null) {
            File file = new File(this.sourceStr);
            this.set.setSourcePath(file, this.fileFilter);
        } else {
            this.set.setFiles(this.fileFilter);
        }
    }

    private void setDest() {
        this.destStr = this.cmdLine.getDestDir();
        if (this.destStr != null) {
            File file = new File(this.destStr);
            this.set.setDestinationPath(file);
        }
        this.set.setDestinationPath(this.set.getDefaultDestPath());
    }

    private void setBack() {
        this.backupStr = this.cmdLine.getBackupDir();
        if (this.backupStr != null) {
            File file = new File(this.backupStr);
            this.set.setBackupPath(file);
        } else if (!this.stdin) {
            this.set.setBackupPath(this.set.getDefaultBackupPath());
        }
    }

    private void setTemp() {
        this.tempStr = this.cmdLine.getTemplateDir();
        if (this.tempStr != null) {
            try {
                InputStream inputStream = HTMLConverter.class.getClassLoader().getResourceAsStream(this.tempStr);
                this.converter.setTemplateFilePath(this.tempStr);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(ResourceHandler.getMessage("nottemplatefile_dialog.info2") + ":  " + this.tempStr);
                System.exit(-2);
            }
        }
    }

    private void setLog() {
        this.logStr = this.cmdLine.getLogFile();
        if (this.logStr != null) {
            this.logFile = new File(this.logStr);
            this.converter.setLogFile(this.logFile);
        }
    }

    private void simulate(Enumeration enumeration) {
        System.out.println(ResourceHandler.getMessage("plugin_converter.files"));
        while (enumeration.hasMoreElements()) {
            System.out.println(this.set.getSourcePath() + this.sep + (String)enumeration.nextElement());
        }
        System.out.println("\n" + ResourceHandler.getMessage("plugin_converter.backup_path") + ":\t" + this.set.getBackupPath());
        if (this.logFile != null) {
            System.out.println(ResourceHandler.getMessage("plugin_converter.log_path") + ":\t" + (this.cmdLine.getLogFile() == null ? this.converter.getDefaultLogFile().getAbsolutePath() : this.logFile.getAbsolutePath()));
        }
        System.out.println("\n" + ResourceHandler.getMessage("plugin_converter.template_file") + ":\t" + this.converter.getTemplateFilePath());
        System.out.println(ResourceHandler.getMessage("plugin_converter.process_subdirs") + ":\t" + this.converter.isRecurse());
        System.out.println(ResourceHandler.getMessage("plugin_converter.show_progress") + ":\t" + this.converter.isShowProgressStdOut());
        System.out.println("");
    }

    public static void main(String[] stringArray) {
        HTMLConverter hTMLConverter = new HTMLConverter(stringArray);
    }
}

