/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class JExtendedComboBox
extends JComboBox {
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private boolean closingWithSeparator = false;
    private int lastSelectedIndex = 0;

    public JExtendedComboBox() {
        this.setModel((ComboBoxModel)this.model);
        this.setRenderer(new ExtendedComboListRenderer());
    }

    public void setModel(ComboBoxModel aModel) {
        if (!(aModel instanceof DefaultComboBoxModel)) {
            throw new RuntimeException("Only DefaultComboBoxModel is supported for this component");
        }
        this.model = (DefaultComboBoxModel)aModel;
        super.setModel(this.model);
    }

    public void firePopupMenuWillBecomeInvisible() {
        if (this.getSelectedItem() instanceof JSeparator) {
            this.closingWithSeparator = true;
        }
        super.firePopupMenuWillBecomeInvisible();
    }

    protected void fireItemStateChanged(ItemEvent e) {
        switch (e.getStateChange()) {
            case 1: {
                if (!(e.getItem() instanceof JSeparator)) break;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JExtendedComboBox.this.selectNextItem();
                    }
                });
                break;
            }
            case 2: {
                if (e.getItem() instanceof JSeparator) break;
                this.lastSelectedIndex = this.model.getIndexOf(e.getItem());
            }
        }
        super.fireItemStateChanged(e);
    }

    private void selectNextItem() {
        int currentSelectedIndex = this.getSelectedIndex();
        if (this.closingWithSeparator) {
            this.setSelectedIndex(this.lastSelectedIndex);
            this.closingWithSeparator = false;
        } else if (currentSelectedIndex > this.lastSelectedIndex) {
            this.setSelectedIndex(currentSelectedIndex + 1);
        } else {
            this.setSelectedIndex(currentSelectedIndex - 1);
        }
    }

    private class ExtendedComboListRenderer
    extends DefaultListCellRenderer {
        private ExtendedComboListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && value instanceof JSeparator) {
                return (JSeparator)value;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

