/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;

public class JExtendedTablePanel
extends JPanel {
    protected CustomExtendedTableViewport extendedTableViewport;
    protected JExtendedTable extendedTable;
    protected JScrollPane extendedTableScrollPane;

    public JExtendedTablePanel(JExtendedTable extendedTable) {
        super(new BorderLayout());
        this.extendedTable = extendedTable;
        this.initComponents();
        this.hookHeaderColumnResize();
    }

    public void setCorner(String key, Component corner) {
        this.extendedTableScrollPane.setCorner(key, corner);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateVerticalScrollbar();
        this.extendedTable.setEnabled(enabled);
        this.extendedTableViewport.updateBackgroundColor();
    }

    public JScrollPane getScrollPane() {
        return this.extendedTableScrollPane;
    }

    private void hookHeaderColumnResize() {
        if (this.extendedTable.getTableHeader() != null) {
            this.extendedTable.getTableHeader().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                public void columnAdded(TableColumnModelEvent e) {
                    JExtendedTablePanel.this.extendedTableViewport.repaint();
                }

                public void columnMoved(TableColumnModelEvent e) {
                    JExtendedTablePanel.this.extendedTableViewport.repaint();
                }

                public void columnRemoved(TableColumnModelEvent e) {
                    JExtendedTablePanel.this.extendedTableViewport.repaint();
                }

                public void columnMarginChanged(ChangeEvent e) {
                    JExtendedTablePanel.this.extendedTableViewport.repaint();
                }

                public void columnSelectionChanged(ListSelectionEvent e) {
                }
            });
        }
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.extendedTableScrollPane = new JScrollPane(22, 31);
        this.extendedTableScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extendedTableViewport = new CustomExtendedTableViewport(this.extendedTable);
        this.extendedTableScrollPane.setViewport(this.extendedTableViewport);
        this.extendedTableScrollPane.addMouseWheelListener(this.extendedTable);
        this.extendedTableScrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JExtendedTablePanel.this.updateVerticalScrollbar();
            }
        });
        this.add((Component)this.extendedTableScrollPane, "Center");
    }

    private void updateVerticalScrollbar() {
        if (this.extendedTableScrollPane.getVerticalScrollBar().getModel().getExtent() == this.extendedTableScrollPane.getVerticalScrollBar().getModel().getMaximum()) {
            this.extendedTableScrollPane.getVerticalScrollBar().setEnabled(false);
        } else {
            this.extendedTableScrollPane.getVerticalScrollBar().setEnabled(this.isEnabled());
        }
    }

    private class CustomExtendedTableViewport
    extends JViewport {
        private JTableHeader tableHeader;

        public CustomExtendedTableViewport(JExtendedTable extendedTable) {
            this.setView(extendedTable);
            this.updateBackgroundColor();
            this.tableHeader = extendedTable.getTableHeader();
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.paintVerticalLines(g);
        }

        private int getEmptySpaceY() {
            if (this.getView() == null) {
                return 0;
            }
            return this.getView().getHeight();
        }

        private void paintVerticalLines(Graphics g) {
            int emptySpaceY = this.getEmptySpaceY();
            if (emptySpaceY > 0) {
                g.setColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
                int cellX = 0;
                for (int i = 0; i < JExtendedTablePanel.this.extendedTable.getColumnModel().getColumnCount(); ++i) {
                    int cellWidth = JExtendedTablePanel.this.extendedTable.getColumnModel().getColumn(i).getWidth();
                    g.drawLine(cellX + cellWidth - 1, emptySpaceY, cellX + cellWidth - 1, this.getHeight() - 1);
                    cellX += cellWidth;
                }
            }
        }

        private void updateBackgroundColor() {
            this.setBackground(JExtendedTablePanel.this.extendedTable.isEnabled() ? JExtendedTablePanel.this.extendedTable.getBackground() : UIManager.getColor("TextField.inactiveBackground"));
        }
    }
}

