/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModelDataResetListener;
import org.netbeans.modules.profiler.History;
import org.netbeans.modules.profiler.HistoryListener;
import org.openide.util.NbBundle;

public class HistoryPanel
extends GraphPanel
implements ChartModelListener,
VMTelemetryXYChartModelDataResetListener,
HistoryListener {
    private static final String TOOLTIP_CLASS = NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel_ToolTipClass");
    private static final String TOOLTIP_OBJECTS = NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel_ToolTipObjects");
    private static final String TOOLTIP_SIZE = NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel_ToolTipSize");
    private static final String TOOLTIP_CURSOR = NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel_ToolTipCursor");
    private static final String TOOLTIP_TIME = NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel_ToolTipTime");
    private static final String TOOLTIP_LIVE = NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel_ToolTipLive");
    private static final String TOOLTIP_ALLOCATED = NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel_ToolTipAllocated");
    History history;
    private JPanel bigLegendPanel;
    private SynchronousXYChart xyChart;

    public HistoryPanel(History source) {
        this.history = source;
        this.history.addHistoryListener(this);
        this.xyChart = new SynchronousXYChart(1, 50, 0.1){

            public String getToolTipText(MouseEvent event) {
                return HistoryPanel.this.getChartToolTipText(event);
            }
        };
        this.xyChart.setTopChartMargin(50);
        this.xyChart.allowSelection();
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.xyChart.setBackgroundPaint((Paint)Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.xyChart, "Center");
        this.xyChart.setupInitialAppearance(0L, 50L, 0L, 1000L);
        this.xyChart.setUseSecondaryVerticalAxis(true);
        this.xyChart.setVerticalAxisValueString2("B");
        this.xyChart.setVerticalAxisValueAdaptDivider(true);
        this.xyChart.setVerticalAxisValueAdaptDivider2(true);
        this.xyChart.setMinimumVerticalMarksDistance(UIManager.getFont("Panel.font").getSize() + 8);
        this.xyChart.setAccessibleContext(this.getAccessibleContext());
        this.chartDataReset();
        this.xyChart.setModel((SynchronousXYChartModel)this.history);
        this.createBigLegend();
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.xyChart);
    }

    public JPanel getBigLegendPanel() {
        return this.bigLegendPanel;
    }

    public SynchronousXYChart getChart() {
        return this.xyChart;
    }

    public String getChartToolTipText(MouseEvent event) {
        if (this.history.getItemCount() < 2) {
            return null;
        }
        StringBuilder toolTipBuffer = new StringBuilder();
        toolTipBuffer.append("<html><table cellspacing=\"1\" cellpadding=\"0\">");
        HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_CLASS, History.getInstance().getClassName(), false);
        if (!this.history.isLiveness()) {
            HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_OBJECTS, this.intFormat.format(this.history.getYValue(this.history.getItemCount() - 1, 0)), false);
            HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_SIZE, this.intFormat.format(this.history.getYValue(this.history.getItemCount() - 1, 1)) + " B", false);
        } else {
            HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_LIVE, this.intFormat.format(this.history.getYValue(this.history.getItemCount() - 1, 0)), false);
            HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_ALLOCATED, this.intFormat.format(this.history.getYValue(this.history.getItemCount() - 1, 1)), false);
        }
        toolTipBuffer.append("</table><br><table cellspacing=\"1\" cellpadding=\"0\">");
        toolTipBuffer.append("<tr><td colspan=\"2\">" + TOOLTIP_CURSOR + "</td></tr>");
        if (this.history.isLiveness()) {
            HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_LIVE, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 0)), false);
            HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_ALLOCATED, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 1)), false);
        } else {
            HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_OBJECTS, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 0)), false);
            HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_SIZE, this.intFormat.format(this.xyChart.getYValueAtPosition(event.getX(), 1)) + " B", false);
        }
        HistoryPanel.appendToolTipItem(toolTipBuffer, TOOLTIP_TIME, this.xyChart.getTimeAtPosition(event.getX()), true);
        toolTipBuffer.append("</table></html>");
        return toolTipBuffer.toString();
    }

    public JPanel getSmallLegendPanel() {
        return null;
    }

    public void chartDataChanged() {
    }

    public void chartDataReset() {
        this.xyChart.resetChart();
        this.xyChart.resetTrackingEnd();
        this.xyChart.resetFitToWindow();
    }

    public void historyLogging() {
        if (this.history.isLiveness()) {
            this.xyChart.setVerticalAxisValueString2("");
        } else {
            this.xyChart.setVerticalAxisValueString2("B");
        }
        this.updateBigLegend();
    }

    protected void updateBigLegend() {
        ((JLabel)this.bigLegendPanel.getComponent(0)).setText(this.history.getSeriesName(0));
        ((JLabel)this.bigLegendPanel.getComponent(1)).setText(this.history.getSeriesName(1));
    }

    private static void appendToolTipItem(StringBuilder toolTipBuffer, String itemName, String itemValue, boolean lastItem) {
        toolTipBuffer.append("<tr><td><b>");
        toolTipBuffer.append(itemName);
        toolTipBuffer.append("</b>:</td><td>");
        toolTipBuffer.append(itemValue);
        toolTipBuffer.append("</td></tr>");
        if (!lastItem) {
            toolTipBuffer.append("<br>");
        }
    }

    private void createBigLegend() {
        this.bigLegendPanel = new JPanel();
        this.bigLegendPanel.setOpaque(false);
        JLabel userThreadsBig = new JLabel(this.history.getSeriesName(0), (Icon)new ColorIcon(this.history.getSeriesColor(0), Color.BLACK, 18, 9), 10);
        userThreadsBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.bigLegendPanel.add(userThreadsBig);
        userThreadsBig = new JLabel(this.history.getSeriesName(1), (Icon)new ColorIcon(this.history.getSeriesColor(1), Color.BLACK, 18, 9), 10);
        userThreadsBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.bigLegendPanel.add(userThreadsBig);
    }
}

