/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class BrowserUtils {
    private static final String OUT_OF_MEMORY_MSG = NbBundle.getMessage(BrowserUtils.class, (String)"BrowserUtils_OutOfMemoryMsg");
    public static ImageIcon ICON_INSTANCE = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/instance.png"));
    public static ImageIcon ICON_PRIMITIVE = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/primitive.png"));
    public static ImageIcon ICON_ARRAY = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/array.png"));
    public static ImageIcon ICON_PROGRESS = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/progress.png"));
    public static ImageIcon ICON_STATIC = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/static.png"));
    public static ImageIcon ICON_LOOP = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/loop.png"));
    public static ImageIcon ICON_GCROOT = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/gcRoot.png"));
    private static RequestProcessor requestProcessor = new RequestProcessor("HeapWalker Processor", 3);

    public static String getArrayItemType(String arrayTypeName) {
        int arrayBracketsIdx = arrayTypeName.lastIndexOf("[");
        return arrayBracketsIdx == -1 ? arrayTypeName : arrayTypeName.substring(0, arrayBracketsIdx);
    }

    public static String getFullNodeName(HeapWalkerNode node) {
        if (node.isRoot()) {
            return BrowserUtils.getNodeName(node);
        }
        return BrowserUtils.getFullNodeName(node.getParent()) + "." + BrowserUtils.getNodeName(node);
    }

    public static GroupingInfo getGroupingInfo(int itemsCount) {
        int childrenCount = itemsCount;
        int collapseUnitSize = HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_SIZE;
        int containersCount = (int)Math.ceil((float)childrenCount / (float)collapseUnitSize);
        while (containersCount > HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_THRESHOLD && collapseUnitSize < HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_THRESHOLD) {
            containersCount = (int)Math.ceil((float)childrenCount / (float)(collapseUnitSize += HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_SIZE));
        }
        return new GroupingInfo(containersCount, collapseUnitSize);
    }

    public static HeapWalkerNode getRoot(HeapWalkerNode node) {
        while (node != null && !node.isRoot()) {
            node = node.getParent();
        }
        return node == null ? null : node;
    }

    public static String getSimpleType(String fullType) {
        int simpleTypeIdx = fullType.lastIndexOf(".");
        if (simpleTypeIdx == -1) {
            return fullType;
        }
        if (fullType.startsWith("<")) {
            return "<" + fullType.substring(simpleTypeIdx + 1);
        }
        return fullType.substring(simpleTypeIdx + 1);
    }

    public static boolean isStaticField(FieldValue fieldValue) {
        return fieldValue.getField().isStatic();
    }

    public static HeapWalkerNode computeChildrenToNearestGCRoot(InstanceNode instanceNode) {
        Instance p = instanceNode.getInstance();
        Instance next = p.getNearestGCRootPointer();
        while (!p.equals(next)) {
            HeapWalkerNode[] children;
            if (next == null) {
                instanceNode = null;
                break;
            }
            if (instanceNode.currentlyHasChildren()) {
                children = instanceNode.getChildren();
            } else {
                children = instanceNode.getChildrenComputer().computeChildren();
                instanceNode.setChildren(children);
            }
            instanceNode = null;
            for (int i = 0; i < children.length; ++i) {
                InstanceNode inode = (InstanceNode)children[i];
                if (!inode.getInstance().equals(next)) continue;
                instanceNode = inode;
                break;
            }
            p = next;
            next = next.getNearestGCRootPointer();
        }
        return instanceNode;
    }

    public static ImageIcon createGCRootIcon(ImageIcon icon) {
        return new ImageIcon(Utilities.mergeImages((Image)icon.getImage(), (Image)ICON_GCROOT.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createLoopIcon(ImageIcon icon) {
        return new ImageIcon(Utilities.mergeImages((Image)icon.getImage(), (Image)ICON_LOOP.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createStaticIcon(ImageIcon icon) {
        return new ImageIcon(Utilities.mergeImages((Image)icon.getImage(), (Image)ICON_STATIC.getImage(), (int)0, (int)0));
    }

    public static HeapWalkerNode[] lazilyCreateChildren(final HeapWalkerNode parent, final ChildrenComputer childrenComputer) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    public void run() {
                        if (parent instanceof AbstractHeapWalkerNode) {
                            boolean oome = false;
                            try {
                                HeapWalkerNode[] computedChildren = childrenComputer.computeChildren();
                                ((AbstractHeapWalkerNode)parent).changeChildren(computedChildren);
                            }
                            catch (OutOfMemoryError e) {
                                oome = true;
                                HeapWalkerNode[] computedChildren = new HeapWalkerNode[]{HeapWalkerNodeFactory.createOOMNode(parent)};
                                ((AbstractHeapWalkerNode)parent).changeChildren(computedChildren);
                            }
                            HeapWalkerNode root = BrowserUtils.getRoot(parent);
                            if (root instanceof RootNode) {
                                ((RootNode)((Object)root)).refreshView();
                            }
                            if (oome) {
                                NetBeansProfiler.getDefaultNB().displayError(OUT_OF_MEMORY_MSG);
                            }
                        }
                    }
                });
            }
        });
        return new HeapWalkerNode[]{HeapWalkerNodeFactory.createProgressNode(parent)};
    }

    public static void performTask(Runnable task) {
        requestProcessor.post(task);
    }

    private static String getNodeName(HeapWalkerNode node) {
        String name = node.getName();
        if (name.endsWith(")")) {
            name = name.substring(0, name.indexOf("(")).trim();
        }
        return name;
    }

    public static class GroupingInfo {
        public int collapseUnitSize;
        public int containersCount;

        GroupingInfo(int containersCount, int collapseUnitSize) {
            this.containersCount = containersCount;
            this.collapseUnitSize = collapseUnitSize;
        }
    }
}

