/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.profiler.ui.wizards.panels.PerformIntegrationPanel;
import org.netbeans.modules.profiler.ui.wizards.panels.components.StepsPanelComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PerformIntegrationPanelUI
extends JPanel {
    private final String PERFORM_INTEGRATION_MSG = NbBundle.getMessage(this.getClass(), (String)"PerformIntegrationWizardPanelUI_PerformIntegrationHintMsg");
    private final String PERFORMED_INTEGRATION_MSG = NbBundle.getMessage(this.getClass(), (String)"PerformIntegrationWizardPanelUI_IntegrationPerformedMsg");
    private PerformIntegrationPanel.Model model;
    private JButton buttonPerform;
    private StepsPanelComponent integrationSteps;

    PerformIntegrationPanelUI(PerformIntegrationPanel.Model model) {
        this.model = model;
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPerform = new JButton();
        this.integrationSteps = new StepsPanelComponent();
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(300, 400));
        this.setPreferredSize(new Dimension(500, 400));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonPerform, (String)NbBundle.getMessage(PerformIntegrationPanelUI.class, (String)"PerformIntegrationPanelUI.buttonPerform.text"));
        this.buttonPerform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PerformIntegrationPanelUI.this.buttonPerformActionPerformed(evt);
            }
        });
        this.integrationSteps.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/profiler/ui/wizards/panels/Bundle");
        this.integrationSteps.setHintText(bundle.getString("PerformIntegrationWizardPanelUI_PerformIntegrationHintMsg"));
        this.integrationSteps.setMaximumSize(new Dimension(400, 600));
        this.integrationSteps.setPreferredSize(new Dimension(400, 250));
        this.integrationSteps.setTitle(bundle.getString("PerformIntegrationWizardPanelUI_PerformedStepsString"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.integrationSteps, -1, 480, Short.MAX_VALUE).add((Component)this.buttonPerform)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.integrationSteps, -1, 349, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.buttonPerform).addContainerGap()));
        this.buttonPerform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PerformIntegrationPanelUI.class, (String)"PerformIntegrationPanelUI.buttonPerform.AccessibleContext.accessibleDescription"));
    }

    private void buttonPerformActionPerformed(ActionEvent evt) {
        this.model.perform();
        this.refreshCanPerform();
    }

    public void refresh() {
        this.integrationSteps.setSteps(this.model.getSummary());
        this.refreshCanPerform();
    }

    private void refreshCanPerform() {
        this.integrationSteps.setHintText(MessageFormat.format(this.model.canPerform() ? this.PERFORM_INTEGRATION_MSG : this.PERFORMED_INTEGRATION_MSG, this.model.getApplicationName()));
        this.buttonPerform.setEnabled(this.model.canPerform());
    }
}

