/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.win32.Win32Debugger;
import sun.jvm.hotspot.debugger.win32.Win32OopHandle;

class Win32Address
implements Address {
    protected Win32Debugger debugger;
    protected long addr;

    Win32Address(Win32Debugger debugger, long addr) {
        this.debugger = debugger;
        this.addr = addr;
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof Win32Address)) {
            return false;
        }
        return this.addr == ((Win32Address)arg).addr;
    }

    public int hashCode() {
        return (int)this.addr;
    }

    public String toString() {
        return this.debugger.addressValueToString(this.addr);
    }

    public long getCIntegerAt(long offset, long numBytes, boolean isUnsigned) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCInteger(this.addr + offset, numBytes, isUnsigned);
    }

    public Address getAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readAddress(this.addr + offset);
    }

    public boolean getJBooleanAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJBoolean(this.addr + offset);
    }

    public byte getJByteAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJByte(this.addr + offset);
    }

    public char getJCharAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJChar(this.addr + offset);
    }

    public double getJDoubleAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJDouble(this.addr + offset);
    }

    public float getJFloatAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJFloat(this.addr + offset);
    }

    public int getJIntAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJInt(this.addr + offset);
    }

    public long getJLongAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJLong(this.addr + offset);
    }

    public short getJShortAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJShort(this.addr + offset);
    }

    public OopHandle getOopHandleAt(long offset) throws UnalignedAddressException, UnmappedAddressException, NotInHeapException {
        return this.debugger.readOopHandle(this.addr + offset);
    }

    public void setCIntegerAt(long offset, long numBytes, long value) {
        this.debugger.writeCInteger(this.addr + offset, numBytes, value);
    }

    public void setAddressAt(long offset, Address value) {
        this.debugger.writeAddress(this.addr + offset, (Win32Address)value);
    }

    public void setJBooleanAt(long offset, boolean value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeJBoolean(this.addr + offset, value);
    }

    public void setJByteAt(long offset, byte value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeJByte(this.addr + offset, value);
    }

    public void setJCharAt(long offset, char value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeJChar(this.addr + offset, value);
    }

    public void setJDoubleAt(long offset, double value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeJDouble(this.addr + offset, value);
    }

    public void setJFloatAt(long offset, float value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeJFloat(this.addr + offset, value);
    }

    public void setJIntAt(long offset, int value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeJInt(this.addr + offset, value);
    }

    public void setJLongAt(long offset, long value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeJLong(this.addr + offset, value);
    }

    public void setJShortAt(long offset, short value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeJShort(this.addr + offset, value);
    }

    public void setOopHandleAt(long offset, OopHandle value) throws UnmappedAddressException, UnalignedAddressException {
        this.debugger.writeOopHandle(this.addr + offset, (Win32OopHandle)value);
    }

    public Address addOffsetTo(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new Win32Address(this.debugger, value);
    }

    public OopHandle addOffsetToAsOopHandle(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new Win32OopHandle(this.debugger, value);
    }

    public long minus(Address arg) {
        if (arg == null) {
            return this.addr;
        }
        return this.addr - ((Win32Address)arg).addr;
    }

    public boolean lessThan(Address a) {
        if (a == null) {
            return false;
        }
        Win32Address arg = (Win32Address)a;
        if (this.addr >= 0L && arg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && arg.addr >= 0L) {
            return false;
        }
        return this.addr < arg.addr;
    }

    public boolean lessThanOrEqual(Address a) {
        if (a == null) {
            return false;
        }
        Win32Address arg = (Win32Address)a;
        if (this.addr >= 0L && arg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && arg.addr >= 0L) {
            return false;
        }
        return this.addr <= arg.addr;
    }

    public boolean greaterThan(Address a) {
        if (a == null) {
            return true;
        }
        Win32Address arg = (Win32Address)a;
        if (this.addr >= 0L && arg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && arg.addr >= 0L) {
            return true;
        }
        return this.addr > arg.addr;
    }

    public boolean greaterThanOrEqual(Address a) {
        if (a == null) {
            return true;
        }
        Win32Address arg = (Win32Address)a;
        if (this.addr >= 0L && arg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && arg.addr >= 0L) {
            return true;
        }
        return this.addr >= arg.addr;
    }

    public Address andWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr & mask;
        if (value == 0L) {
            return null;
        }
        return new Win32Address(this.debugger, value);
    }

    public Address orWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr | mask;
        if (value == 0L) {
            return null;
        }
        return new Win32Address(this.debugger, value);
    }

    public Address xorWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr ^ mask;
        if (value == 0L) {
            return null;
        }
        return new Win32Address(this.debugger, value);
    }

    long getValue() {
        return this.addr;
    }

    private static void check(boolean arg, String failMessage) {
        if (!arg) {
            System.err.println(failMessage + ": FAILED");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        Win32Address p1 = new Win32Address(null, 0x7FFFFFFFFFFFFFF0L);
        Win32Address p2 = (Win32Address)p1.addOffsetTo(10L);
        Win32Address n1 = (Win32Address)p2.addOffsetTo(10L);
        Win32Address n2 = (Win32Address)n1.addOffsetTo(10L);
        Win32Address.check(p1.lessThan(p2), "lessThan 1");
        Win32Address.check(p1.lessThan(n1), "lessThan 2");
        Win32Address.check(p1.lessThan(n2), "lessThan 3");
        Win32Address.check(p2.lessThan(n1), "lessThan 4");
        Win32Address.check(p2.lessThan(n2), "lessThan 5");
        Win32Address.check(n1.lessThan(n2), "lessThan 6");
        Win32Address.check(!p1.lessThan(p1), "lessThan 7");
        Win32Address.check(!p2.lessThan(p2), "lessThan 8");
        Win32Address.check(!n1.lessThan(n1), "lessThan 9");
        Win32Address.check(!n2.lessThan(n2), "lessThan 10");
        Win32Address.check(!p2.lessThan(p1), "lessThan 11");
        Win32Address.check(!n1.lessThan(p1), "lessThan 12");
        Win32Address.check(!n2.lessThan(p1), "lessThan 13");
        Win32Address.check(!n1.lessThan(p2), "lessThan 14");
        Win32Address.check(!n2.lessThan(p2), "lessThan 15");
        Win32Address.check(!n2.lessThan(n1), "lessThan 16");
        Win32Address.check(p1.lessThanOrEqual(p1), "lessThanOrEqual 1");
        Win32Address.check(p2.lessThanOrEqual(p2), "lessThanOrEqual 2");
        Win32Address.check(n1.lessThanOrEqual(n1), "lessThanOrEqual 3");
        Win32Address.check(n2.lessThanOrEqual(n2), "lessThanOrEqual 4");
        Win32Address.check(p1.lessThanOrEqual(p2), "lessThanOrEqual 5");
        Win32Address.check(p1.lessThanOrEqual(n1), "lessThanOrEqual 6");
        Win32Address.check(p1.lessThanOrEqual(n2), "lessThanOrEqual 7");
        Win32Address.check(p2.lessThanOrEqual(n1), "lessThanOrEqual 8");
        Win32Address.check(p2.lessThanOrEqual(n2), "lessThanOrEqual 9");
        Win32Address.check(n1.lessThanOrEqual(n2), "lessThanOrEqual 10");
        Win32Address.check(!p2.lessThanOrEqual(p1), "lessThanOrEqual 11");
        Win32Address.check(!n1.lessThanOrEqual(p1), "lessThanOrEqual 12");
        Win32Address.check(!n2.lessThanOrEqual(p1), "lessThanOrEqual 13");
        Win32Address.check(!n1.lessThanOrEqual(p2), "lessThanOrEqual 14");
        Win32Address.check(!n2.lessThanOrEqual(p2), "lessThanOrEqual 15");
        Win32Address.check(!n2.lessThanOrEqual(n1), "lessThanOrEqual 16");
        Win32Address.check(n2.greaterThan(p1), "greaterThan 1");
        Win32Address.check(n2.greaterThan(p2), "greaterThan 2");
        Win32Address.check(n2.greaterThan(n1), "greaterThan 3");
        Win32Address.check(n1.greaterThan(p1), "greaterThan 4");
        Win32Address.check(n1.greaterThan(p2), "greaterThan 5");
        Win32Address.check(p2.greaterThan(p1), "greaterThan 6");
        Win32Address.check(!p1.greaterThan(p1), "greaterThan 7");
        Win32Address.check(!p2.greaterThan(p2), "greaterThan 8");
        Win32Address.check(!n1.greaterThan(n1), "greaterThan 9");
        Win32Address.check(!n2.greaterThan(n2), "greaterThan 10");
        Win32Address.check(!p1.greaterThan(n2), "greaterThan 11");
        Win32Address.check(!p2.greaterThan(n2), "greaterThan 12");
        Win32Address.check(!n1.greaterThan(n2), "greaterThan 13");
        Win32Address.check(!p1.greaterThan(n1), "greaterThan 14");
        Win32Address.check(!p2.greaterThan(n1), "greaterThan 15");
        Win32Address.check(!p1.greaterThan(p2), "greaterThan 16");
        Win32Address.check(p1.greaterThanOrEqual(p1), "greaterThanOrEqual 1");
        Win32Address.check(p2.greaterThanOrEqual(p2), "greaterThanOrEqual 2");
        Win32Address.check(n1.greaterThanOrEqual(n1), "greaterThanOrEqual 3");
        Win32Address.check(n2.greaterThanOrEqual(n2), "greaterThanOrEqual 4");
        Win32Address.check(n2.greaterThanOrEqual(p1), "greaterThanOrEqual 5");
        Win32Address.check(n2.greaterThanOrEqual(p2), "greaterThanOrEqual 6");
        Win32Address.check(n2.greaterThanOrEqual(n1), "greaterThanOrEqual 7");
        Win32Address.check(n1.greaterThanOrEqual(p1), "greaterThanOrEqual 8");
        Win32Address.check(n1.greaterThanOrEqual(p2), "greaterThanOrEqual 9");
        Win32Address.check(p2.greaterThanOrEqual(p1), "greaterThanOrEqual 10");
        Win32Address.check(!p1.greaterThanOrEqual(n2), "greaterThanOrEqual 11");
        Win32Address.check(!p2.greaterThanOrEqual(n2), "greaterThanOrEqual 12");
        Win32Address.check(!n1.greaterThanOrEqual(n2), "greaterThanOrEqual 13");
        Win32Address.check(!p1.greaterThanOrEqual(n1), "greaterThanOrEqual 14");
        Win32Address.check(!p2.greaterThanOrEqual(n1), "greaterThanOrEqual 15");
        Win32Address.check(!p1.greaterThanOrEqual(p2), "greaterThanOrEqual 16");
        System.err.println("Win32Address: all tests passed successfully.");
    }
}

