/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeWithCPIndex;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.ResultTypeFinder;
import sun.jvm.hotspot.runtime.SignatureConverter;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeInvoke
extends BytecodeWithCPIndex {
    BytecodeInvoke(Method method, int bci) {
        super(method, bci);
    }

    public static BytecodeInvoke at(Method method, int bci) {
        BytecodeInvoke b = new BytecodeInvoke(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeInvoke atCheck(Method method, int bci) {
        BytecodeInvoke b = new BytecodeInvoke(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeInvoke at(BytecodeStream bcs) {
        return new BytecodeInvoke(bcs.method(), bcs.bci());
    }

    public Symbol name() {
        ConstantPool cp = this.method().getConstants();
        return cp.getNameRefAt(this.index());
    }

    public Symbol signature() {
        ConstantPool cp = this.method().getConstants();
        return cp.getSignatureRefAt(this.index());
    }

    public Method getInvokedMethod() {
        return this.method().getConstants().getMethodRefAt(this.index());
    }

    public int resultType() {
        ResultTypeFinder rts = new ResultTypeFinder(this.signature());
        rts.iterate();
        return rts.type();
    }

    public int adjustedInvokeCode() {
        return this.javaCode();
    }

    public boolean isInvokeinterface() {
        return this.adjustedInvokeCode() == 185;
    }

    public boolean isInvokevirtual() {
        return this.adjustedInvokeCode() == 182;
    }

    public boolean isInvokestatic() {
        return this.adjustedInvokeCode() == 184;
    }

    public boolean isInvokespecial() {
        return this.adjustedInvokeCode() == 183;
    }

    public boolean isValid() {
        return this.isInvokeinterface() || this.isInvokevirtual() || this.isInvokestatic() || this.isInvokespecial();
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check invoke");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getJavaBytecodeName());
        buf.append(" ");
        buf.append('#');
        buf.append(Integer.toString(this.indexForFieldOrMethod()));
        buf.append(" [Method ");
        StringBuffer sigBuf = new StringBuffer();
        new SignatureConverter(this.signature(), sigBuf).iterateReturntype();
        buf.append(sigBuf.toString().replace('/', '.'));
        buf.append(" ");
        buf.append(this.name().asString());
        buf.append('(');
        sigBuf = new StringBuffer();
        new SignatureConverter(this.signature(), sigBuf).iterateParameters();
        buf.append(sigBuf.toString().replace('/', '.'));
        buf.append(')');
        buf.append(']');
        if (this.code() != this.javaCode()) {
            buf.append(" ");
            buf.append('[');
            buf.append(this.getBytecodeName());
            buf.append(']');
        }
        return buf.toString();
    }
}

