/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.JavaThreadState;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.OSThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.StackFrameStream;
import sun.jvm.hotspot.runtime.Thread;
import sun.jvm.hotspot.runtime.VFrame;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class JavaThread
extends Thread {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.JavaThread.DEBUG") != null;
    private static AddressField nextField;
    private static OopField threadObjField;
    private static AddressField anchorField;
    private static AddressField lastJavaSPField;
    private static AddressField lastJavaPCField;
    private static CIntegerField threadStateField;
    private static AddressField osThreadField;
    private static JavaThreadPDAccess access;
    private static int UNINITIALIZED;
    private static int NEW;
    private static int NEW_TRANS;
    private static int IN_NATIVE;
    private static int IN_NATIVE_TRANS;
    private static int IN_VM;
    private static int IN_VM_TRANS;
    private static int IN_JAVA;
    private static int IN_JAVA_TRANS;
    private static int BLOCKED;
    private static int BLOCKED_TRANS;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        nextField = type.getAddressField("_next");
        threadObjField = type.getOopField("_threadObj");
        anchorField = type.getAddressField("_anchor");
        lastJavaSPField = anchorType.getAddressField("_last_Java_sp");
        lastJavaPCField = anchorType.getAddressField("_last_Java_pc");
        threadStateField = type.getCIntegerField("_thread_state");
        osThreadField = type.getAddressField("_osthread");
        UNINITIALIZED = db.lookupIntConstant("_thread_uninitialized");
        NEW = db.lookupIntConstant("_thread_new");
        NEW_TRANS = db.lookupIntConstant("_thread_new_trans");
        IN_NATIVE = db.lookupIntConstant("_thread_in_native");
        IN_NATIVE_TRANS = db.lookupIntConstant("_thread_in_native_trans");
        IN_VM = db.lookupIntConstant("_thread_in_vm");
        IN_VM_TRANS = db.lookupIntConstant("_thread_in_vm_trans");
        IN_JAVA = db.lookupIntConstant("_thread_in_Java");
        IN_JAVA_TRANS = db.lookupIntConstant("_thread_in_Java_trans");
        BLOCKED = db.lookupIntConstant("_thread_blocked");
        BLOCKED_TRANS = db.lookupIntConstant("_thread_blocked_trans");
    }

    public JavaThread(Address addr) {
        super(addr);
    }

    void setThreadPDAccess(JavaThreadPDAccess access) {
        JavaThread.access = access;
    }

    public JavaThread next() {
        Address threadAddr = nextField.getValue(this.addr);
        if (threadAddr == null) {
            return null;
        }
        return VM.getVM().getThreads().createJavaThreadWrapper(threadAddr);
    }

    public boolean isJavaThread() {
        return true;
    }

    public static AddressField getAnchorField() {
        return anchorField;
    }

    public Address getLastJavaSP() {
        Address sp = lastJavaSPField.getValue(this.addr.addOffsetTo(anchorField.getOffset()));
        return sp;
    }

    public Address getLastJavaPC() {
        Address pc = lastJavaPCField.getValue(this.addr.addOffsetTo(anchorField.getOffset()));
        return pc;
    }

    public Address getLastJavaFP() {
        return access.getLastJavaFP(this.addr);
    }

    public Address getBaseOfStackPointer() {
        return access.getBaseOfStackPointer(this.addr);
    }

    public boolean hasLastJavaFrame() {
        return this.getLastJavaSP() != null;
    }

    public Frame getLastFrame() {
        return this.cookLastFrame(this.getLastFramePD());
    }

    protected Frame getLastFramePD() {
        return access.getLastFramePD(this, this.addr);
    }

    public JavaVFrame getLastJavaVFrame(RegisterMap regMap) {
        Frame f;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regMap != null, "a map must be given");
        }
        if ((f = this.getLastFrame()) == null) {
            return null;
        }
        for (VFrame vf = VFrame.newVFrame(f, regMap, this); vf != null; vf = vf.sender()) {
            if (!vf.isJavaFrame()) continue;
            return (JavaVFrame)vf;
        }
        return null;
    }

    public JavaVFrame getLastJavaVFrameDbg() {
        VFrame vf;
        RegisterMap regMap = this.newRegisterMap(true);
        Frame f = this.getCurrentFrameGuess();
        if (f == null) {
            return null;
        }
        boolean imprecise = true;
        if (f.isInterpretedFrame() && !f.isInterpretedFrameValid()) {
            if (DEBUG) {
                System.out.println("Correcting for invalid interpreter frame");
            }
            f = f.sender(regMap);
            imprecise = false;
        }
        if ((vf = VFrame.newVFrame(f, regMap, this, true, imprecise)) == null) {
            if (DEBUG) {
                System.out.println(" (Unable to create vframe for topmost frame guess)");
            }
            return null;
        }
        return vf.isJavaFrame() ? (JavaVFrame)vf : vf.javaSender();
    }

    public RegisterMap newRegisterMap(boolean updateMap) {
        return access.newRegisterMap(this, updateMap);
    }

    public Frame getCurrentFrameGuess() {
        return access.getCurrentFrameGuess(this, this.addr);
    }

    public void printThreadIDOn(PrintStream tty) {
        access.printThreadIDOn(this.addr, tty);
    }

    public void printThreadID() {
        this.printThreadIDOn(System.out);
    }

    public ThreadProxy getThreadProxy() {
        return access.getThreadProxy(this.addr);
    }

    public JavaThreadState getThreadState() {
        int val = (int)threadStateField.getValue(this.addr);
        if (val == UNINITIALIZED) {
            return JavaThreadState.UNINITIALIZED;
        }
        if (val == NEW) {
            return JavaThreadState.NEW;
        }
        if (val == NEW_TRANS) {
            return JavaThreadState.NEW_TRANS;
        }
        if (val == IN_NATIVE) {
            return JavaThreadState.IN_NATIVE;
        }
        if (val == IN_NATIVE_TRANS) {
            return JavaThreadState.IN_NATIVE_TRANS;
        }
        if (val == IN_VM) {
            return JavaThreadState.IN_VM;
        }
        if (val == IN_VM_TRANS) {
            return JavaThreadState.IN_VM_TRANS;
        }
        if (val == IN_JAVA) {
            return JavaThreadState.IN_JAVA;
        }
        if (val == IN_JAVA_TRANS) {
            return JavaThreadState.IN_JAVA_TRANS;
        }
        if (val == BLOCKED) {
            return JavaThreadState.BLOCKED;
        }
        if (val == BLOCKED_TRANS) {
            return JavaThreadState.BLOCKED_TRANS;
        }
        throw new RuntimeException("Illegal thread state " + val);
    }

    public OSThread getOSThread() {
        return (OSThread)VMObjectFactory.newObject(OSThread.class, osThreadField.getValue(this.addr));
    }

    public Oop getThreadObj() {
        return VM.getVM().getObjectHeap().newOop(threadObjField.getValue(this.addr));
    }

    public String getThreadName() {
        Oop threadObj = this.getThreadObj();
        if (threadObj == null) {
            return "<null>";
        }
        return OopUtilities.threadOopGetName(threadObj);
    }

    public void oopsDo(AddressVisitor oopVisitor) {
        super.oopsDo(oopVisitor);
        StackFrameStream fst = new StackFrameStream(this);
        while (!fst.isDone()) {
            fst.getCurrent().oopsDo(oopVisitor, fst.getRegisterMap());
            fst.next();
        }
    }

    public boolean isInStack(Address a) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(VM.getVM().isDebugging(), "Not yet implemented for non-debugging system");
        }
        Address highest = this.highestLock();
        Address sp = this.lastSPDbg();
        if (highest == null || sp == null) {
            return false;
        }
        return highest.greaterThanOrEqual(a) && sp.lessThanOrEqual(a);
    }

    public Oop getCurrentParkBlocker() {
        Oop threadObj = this.getThreadObj();
        if (threadObj != null) {
            return OopUtilities.threadOopGetParkBlocker(threadObj);
        }
        return null;
    }

    public void printInfoOn(PrintStream tty) {
        tty.println("State: " + this.getThreadState().toString());
        Frame tmpFrame = this.getCurrentFrameGuess();
        if (tmpFrame != null) {
            Address sp;
            Address maxSP = sp = tmpFrame.getSP();
            Address minSP = sp;
            RegisterMap tmpMap = this.newRegisterMap(false);
            while (tmpFrame != null && !tmpFrame.isFirstFrame()) {
                if ((tmpFrame = tmpFrame.sender(tmpMap)) == null) continue;
                sp = tmpFrame.getSP();
                maxSP = AddressOps.max(maxSP, sp);
                minSP = AddressOps.min(minSP, sp);
            }
            tty.println("Stack in use by Java: " + minSP + " .. " + maxSP);
        } else {
            tty.println("No Java frames present");
        }
        tty.println("Base of Stack: " + this.getBaseOfStackPointer());
        tty.println("Last_Java_SP: " + this.getLastJavaSP());
        tty.println("Last_Java_FP: " + this.getLastJavaFP());
        tty.println("Last_Java_PC: " + this.getLastJavaPC());
        access.printInfoOn(this.addr, tty);
    }

    private Frame cookLastFrame(Frame fr) {
        if (fr == null) {
            return null;
        }
        Address pc = fr.getPC();
        if (Assert.ASSERTS_ENABLED && pc == null) {
            Assert.that(VM.getVM().isDebugging(), "must have PC");
        }
        return fr;
    }

    private Address lastSPDbg() {
        return access.getLastSP(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                JavaThread.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

