/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.VariableGridLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadTab
extends Tab
implements ActionListener,
DocumentListener,
ListSelectionListener {
    PlotterPanel threadMeter;
    TimeComboBox timeComboBox;
    JTabbedPane threadListTabbedPane;
    DefaultListModel listModel;
    JTextField filterTF;
    JLabel messageLabel;
    JSplitPane threadsSplitPane;
    HashMap<Long, String> nameCache = new HashMap();
    private ThreadOverviewPanel overviewPanel;
    private boolean plotterListening = false;
    private static final String threadCountKey = "threadCount";
    private static final String peakKey = "peak";
    private static final String threadCountName = Resources.getText("Live Threads", new Object[0]);
    private static final String peakName = Resources.getText("Peak", new Object[0]);
    private static final Color threadCountColor = Plotter.defaultColor;
    private static final Color peakColor = Color.red;
    private static final Border thinEmptyBorder = new EmptyBorder(2, 2, 2, 2);
    private static final String infoLabelFormat = "ThreadTab.infoLabelFormat";
    private long[] oldThreads = new long[0];
    long lastSelected = -1L;

    public static String getTabName() {
        return Resources.getText("Threads", new Object[0]);
    }

    public ThreadTab(VMPanel vMPanel) {
        super(vMPanel, ThreadTab.getTabName());
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new VariableGridLayout(0, 1, 4, 4, true, true));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 20, 5));
        jPanel.add((Component)jPanel3, "Center");
        this.threadMeter = new PlotterPanel(Resources.getText("Number of Threads", new Object[0]), Plotter.Unit.NONE, true);
        this.threadMeter.plotter.createSequence(threadCountKey, threadCountName, threadCountColor, true);
        this.threadMeter.plotter.createSequence(peakKey, peakName, peakColor, true);
        Utilities.setAccessibleName(this.threadMeter.plotter, Resources.getText("ThreadTab.threadPlotter.accessibleName", new Object[0]));
        jPanel2.add(this.threadMeter);
        this.timeComboBox = new TimeComboBox(this.threadMeter.plotter);
        jPanel3.add(new LabeledComponent(Resources.getText("Time Range:", new Object[0]), Resources.getMnemonicInt("Time Range:"), this.timeComboBox));
        this.listModel = new DefaultListModel();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(thinEmptyBorder);
        jTextArea.setEditable(false);
        Utilities.setAccessibleName(jTextArea, Resources.getText("ThreadTab.threadInfo.accessibleName", new Object[0]));
        ThreadJList threadJList = new ThreadJList(this.listModel, jTextArea);
        Dimension dimension = new Dimension(super.getPreferredSize());
        dimension.width = Math.min(dimension.width, 200);
        JScrollPane jScrollPane = new JScrollPane(threadJList);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setBorder(null);
        JScrollPane jScrollPane2 = new JScrollPane(jTextArea);
        jScrollPane2.setBorder(null);
        this.threadListTabbedPane = new JTabbedPane(1);
        this.threadsSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        this.threadsSplitPane.setOneTouchExpandable(true);
        this.threadsSplitPane.setBorder(null);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setOpaque(false);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 2));
        jPanel5.setOpaque(false);
        this.filterTF = new PromptingTextField("Filter", 20);
        this.filterTF.getDocument().addDocumentListener(this);
        jPanel5.add(this.filterTF);
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(new Dimension(jSeparator.getPreferredSize().width, this.filterTF.getPreferredSize().height));
        jPanel5.add(jSeparator);
        JButton jButton = new JButton(Resources.getText("Detect Deadlock", new Object[0]));
        jButton.setMnemonic(Resources.getMnemonicInt("Detect Deadlock"));
        jButton.setActionCommand("detectDeadlock");
        jButton.addActionListener(this);
        jButton.setToolTipText(Resources.getText("Detect Deadlock.toolTip", new Object[0]));
        jPanel5.add(jButton);
        this.messageLabel = new JLabel();
        jPanel5.add(this.messageLabel);
        jPanel4.add((Component)this.threadsSplitPane, "Center");
        jPanel4.add((Component)jPanel5, "South");
        this.threadListTabbedPane.addTab(Resources.getText("Threads", new Object[0]), jPanel4);
        jPanel2.add(this.threadListTabbedPane);
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        final ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (!this.plotterListening) {
            proxyClient.addWeakPropertyChangeListener(this.threadMeter.plotter);
            this.plotterListening = true;
        }
        return new SwingWorker<Boolean, Object>(){
            private int tlCount;
            private int tpCount;
            private long ttCount;
            private long[] threads;
            private long timeStamp;

            @Override
            public Boolean doInBackground() {
                try {
                    ThreadMXBean threadMXBean = proxyClient.getThreadMXBean();
                    this.tlCount = threadMXBean.getThreadCount();
                    this.tpCount = threadMXBean.getPeakThreadCount();
                    this.ttCount = ThreadTab.this.overviewPanel != null ? threadMXBean.getTotalStartedThreadCount() : 0L;
                    for (long l : this.threads = threadMXBean.getAllThreadIds()) {
                        String string;
                        ThreadInfo threadInfo;
                        if (ThreadTab.this.nameCache.get(l) != null || (threadInfo = threadMXBean.getThreadInfo(l)) == null || (string = threadInfo.getThreadName()) == null) continue;
                        ThreadTab.this.nameCache.put(l, string);
                    }
                    this.timeStamp = System.currentTimeMillis();
                    return true;
                }
                catch (IOException iOException) {
                    return false;
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    return false;
                }
            }

            @Override
            protected void done() {
                String string;
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (ExecutionException executionException) {
                    if (JConsole.isDebug()) {
                        executionException.printStackTrace();
                    }
                    return;
                }
                ThreadTab.this.threadMeter.plotter.addValues(this.timeStamp, this.tlCount, this.tpCount);
                ThreadTab.this.threadMeter.setValueLabel(this.tlCount + "");
                if (ThreadTab.this.overviewPanel != null) {
                    ThreadTab.this.overviewPanel.updateThreadsInfo(this.tlCount, this.tpCount, this.ttCount, this.timeStamp);
                }
                boolean bl = (string = ThreadTab.this.filterTF.getText().toLowerCase(Locale.ENGLISH)).length() > 0;
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (long l : this.threads) {
                    arrayList.add(l);
                }
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    long l = (Long)object.next();
                    String string2 = ThreadTab.this.nameCache.get(l);
                    if (!bl || string2 == null || string2.toLowerCase(Locale.ENGLISH).indexOf(string) >= 0) continue;
                    object.remove();
                }
                long[] lArray = this.threads;
                if (arrayList.size() < this.threads.length) {
                    lArray = new long[arrayList.size()];
                    for (int i = 0; i < lArray.length; ++i) {
                        lArray[i] = (Long)arrayList.get(i);
                    }
                }
                for (long l : ThreadTab.this.oldThreads) {
                    int n = 0;
                    for (long l2 : lArray) {
                        if (l2 != l) continue;
                        n = 1;
                        break;
                    }
                    if (n != 0) continue;
                    ThreadTab.this.listModel.removeElement(l);
                    if (bl) continue;
                    ThreadTab.this.nameCache.remove(l);
                }
                for (int i = lArray.length - 1; i >= 0; --i) {
                    long l = lArray[i];
                    boolean bl2 = false;
                    for (long l3 : ThreadTab.this.oldThreads) {
                        if (l != l3) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    ThreadTab.this.listModel.addElement(l);
                }
                ThreadTab.access$202(ThreadTab.this, lArray);
            }
        };
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ThreadJList threadJList = (ThreadJList)listSelectionEvent.getSource();
        final JTextArea jTextArea = threadJList.textArea;
        Long l = (Long)threadJList.getSelectedValue();
        if (l == null) {
            if (this.lastSelected != -1L) {
                l = this.lastSelected;
            }
        } else {
            this.lastSelected = l;
        }
        jTextArea.setText("");
        if (l != null) {
            final long l2 = l;
            this.workerAdd(new Runnable(){

                public void run() {
                    Object object;
                    ProxyClient proxyClient = ThreadTab.this.vmPanel.getProxyClient();
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        object = proxyClient.getThreadMXBean();
                        ThreadInfo threadInfo = null;
                        MonitorInfo[] monitorInfoArray = null;
                        if (proxyClient.isLockUsageSupported() && object.isObjectMonitorUsageSupported()) {
                            ThreadInfo[] threadInfoArray = object.dumpAllThreads(true, false);
                            for (ThreadInfo object2 : threadInfoArray) {
                                if (object2.getThreadId() != l2) continue;
                                threadInfo = object2;
                                monitorInfoArray = object2.getLockedMonitors();
                                break;
                            }
                        } else {
                            threadInfo = object.getThreadInfo(l2, Integer.MAX_VALUE);
                        }
                        if (threadInfo != null) {
                            if (threadInfo.getLockName() == null) {
                                stringBuilder.append(Resources.getText("Name State", threadInfo.getThreadName(), threadInfo.getThreadState().toString()));
                            } else if (threadInfo.getLockOwnerName() == null) {
                                stringBuilder.append(Resources.getText("Name State LockName", threadInfo.getThreadName(), threadInfo.getThreadState().toString(), threadInfo.getLockName()));
                            } else {
                                stringBuilder.append(Resources.getText("Name State LockName LockOwner", threadInfo.getThreadName(), threadInfo.getThreadState().toString(), threadInfo.getLockName(), threadInfo.getLockOwnerName()));
                            }
                            stringBuilder.append(Resources.getText("BlockedCount WaitedCount", threadInfo.getBlockedCount(), threadInfo.getWaitedCount()));
                            stringBuilder.append(Resources.getText("Stack trace", new Object[0]));
                            int n = 0;
                            for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
                                stringBuilder.append(stackTraceElement.toString() + "\n");
                                if (monitorInfoArray != null) {
                                    for (MonitorInfo monitorInfo : monitorInfoArray) {
                                        if (monitorInfo.getLockedStackDepth() != n) continue;
                                        stringBuilder.append(Resources.getText("Monitor locked", monitorInfo.toString()));
                                    }
                                }
                                ++n;
                            }
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (UndeclaredThrowableException undeclaredThrowableException) {
                        proxyClient.markAsDead();
                    }
                    object = stringBuilder.toString();
                    SwingUtilities.invokeLater(new Runnable((String)object){
                        final /* synthetic */ String val$text;
                        {
                            this.val$text = string;
                        }

                        public void run() {
                            jTextArea.setText(this.val$text);
                            jTextArea.setCaretPosition(0);
                        }
                    });
                }
            });
        }
    }

    private void doUpdate() {
        this.workerAdd(new Runnable(){

            public void run() {
                ThreadTab.this.update();
            }
        });
    }

    private void detectDeadlock() {
        this.workerAdd(new Runnable(){

            public void run() {
                try {
                    final Long[][] longArray = ThreadTab.this.getDeadlockedThreadIds();
                    if (longArray == null || longArray.length == 0) {
                        new Thread(){

                            public void run() {
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            String string = Resources.getText("No deadlock detected", new Object[0]);
                                            ThreadTab.this.messageLabel.setText(string);
                                            ThreadTab.this.threadListTabbedPane.revalidate();
                                        }
                                    });
                                    1.sleep(30000L);
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    // empty catch block
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        ThreadTab.this.messageLabel.setText("");
                                    }
                                });
                            }
                        }.start();
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            while (ThreadTab.this.threadListTabbedPane.getTabCount() > 1) {
                                ThreadTab.this.threadListTabbedPane.removeTabAt(1);
                            }
                            if (longArray != null) {
                                for (int i = 0; i < longArray.length; ++i) {
                                    DefaultListModel<Long> defaultListModel = new DefaultListModel<Long>();
                                    JTextArea jTextArea = new JTextArea();
                                    jTextArea.setBorder(thinEmptyBorder);
                                    jTextArea.setEditable(false);
                                    Utilities.setAccessibleName(jTextArea, Resources.getText("ThreadTab.threadInfo.accessibleName", new Object[0]));
                                    ThreadJList threadJList = new ThreadJList(defaultListModel, jTextArea);
                                    JScrollPane jScrollPane = new JScrollPane(threadJList);
                                    JScrollPane jScrollPane2 = new JScrollPane(jTextArea);
                                    jScrollPane.setBorder(null);
                                    jScrollPane2.setBorder(null);
                                    JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
                                    jSplitPane.setOneTouchExpandable(true);
                                    jSplitPane.setBorder(null);
                                    jSplitPane.setDividerLocation(ThreadTab.this.threadsSplitPane.getDividerLocation());
                                    String string = longArray.length > 1 ? Resources.getText("deadlockTabN", i + 1) : Resources.getText("deadlockTab", new Object[0]);
                                    ThreadTab.this.threadListTabbedPane.addTab(string, jSplitPane);
                                    Long[] longArray2 = longArray[i];
                                    int n = longArray2.length;
                                    for (int j = 0; j < n; ++j) {
                                        long l = longArray2[j];
                                        defaultListModel.addElement(l);
                                    }
                                }
                                ThreadTab.this.threadListTabbedPane.setSelectedIndex(1);
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    ThreadTab.this.vmPanel.getProxyClient().markAsDead();
                }
            }
        });
    }

    public Long[][] getDeadlockedThreadIds() throws IOException {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        ThreadMXBean threadMXBean = proxyClient.getThreadMXBean();
        long[] lArray = proxyClient.findDeadlockedThreads();
        if (lArray == null) {
            return null;
        }
        ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(lArray, Integer.MAX_VALUE);
        ArrayList<Long[]> arrayList = new ArrayList<Long[]>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        boolean[] blArray = new boolean[lArray.length];
        int n = -1;
        block0: while (true) {
            if (n < 0) {
                if (arrayList2.size() > 0) {
                    arrayList.add(arrayList2.toArray(new Long[0]));
                    arrayList2 = new ArrayList();
                }
                for (int i = 0; i < lArray.length; ++i) {
                    if (blArray[i]) continue;
                    n = i;
                    blArray[i] = true;
                    break;
                }
                if (n < 0) break;
            }
            arrayList2.add(lArray[n]);
            long l = threadInfoArray[n].getLockOwnerId();
            int n2 = 0;
            while (true) {
                if (n2 >= lArray.length) continue block0;
                ThreadInfo threadInfo = threadInfoArray[n2];
                if (threadInfo.getThreadId() == l) {
                    if (blArray[n2]) {
                        n = -1;
                        continue block0;
                    }
                    n = n2;
                    blArray[n2] = true;
                    continue block0;
                }
                ++n2;
            }
            break;
        }
        return (Long[][])arrayList.toArray((T[])new Long[0][0]);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((AbstractButton)actionEvent.getSource()).getActionCommand();
        if (string == "detectDeadlock") {
            this.messageLabel.setText("");
            this.detectDeadlock();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.doUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.doUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.doUpdate();
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new ThreadOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    static /* synthetic */ long[] access$202(ThreadTab threadTab, long[] lArray) {
        threadTab.oldThreads = lArray;
        return lArray;
    }

    private static class ThreadOverviewPanel
    extends OverviewPanel {
        ThreadOverviewPanel() {
            super(Resources.getText("Threads", new Object[0]), ThreadTab.threadCountKey, threadCountName, null);
        }

        private void updateThreadsInfo(long l, long l2, long l3, long l4) {
            this.getPlotter().addValues(l4, l);
            this.getInfoLabel().setText(Resources.getText(ThreadTab.infoLabelFormat, l, l2, l3));
        }
    }

    private class PromptingTextField
    extends JTextField
    implements FocusListener {
        private String prompt;
        boolean promptRemoved;
        Color fg;

        public PromptingTextField(String string, int n) {
            super(string, n);
            this.promptRemoved = false;
            this.prompt = string;
            this.updateForeground();
            this.addFocusListener(this);
            Utilities.setAccessibleName(this, string);
        }

        public void revalidate() {
            super.revalidate();
            this.updateForeground();
        }

        private void updateForeground() {
            this.fg = UIManager.getColor("TextField.foreground");
            if (this.promptRemoved) {
                this.setForeground(this.fg);
            } else {
                this.setForeground(Color.gray);
            }
        }

        public String getText() {
            if (!this.promptRemoved) {
                return "";
            }
            return super.getText();
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!this.promptRemoved) {
                this.setText("");
                this.setForeground(this.fg);
                this.promptRemoved = true;
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.promptRemoved && this.getText().equals("")) {
                this.setText(this.prompt);
                this.setForeground(Color.gray);
                this.promptRemoved = false;
            }
        }
    }

    private class ThreadJList
    extends JList {
        private JTextArea textArea;

        ThreadJList(DefaultListModel defaultListModel, JTextArea jTextArea) {
            super(defaultListModel);
            this.textArea = jTextArea;
            this.setBorder(thinEmptyBorder);
            this.addListSelectionListener(ThreadTab.this);
            this.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object != null) {
                        String string = ThreadTab.this.nameCache.get(object);
                        if (string == null) {
                            string = object.toString();
                        }
                        this.setText(string);
                    }
                    return this;
                }
            });
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.max(dimension.width, 100);
            return dimension;
        }
    }
}

