/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.Stack;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.instrumentation.SingleMethodScaner;

public abstract class Injector
extends SingleMethodScaner {
    private static final int MAX_SHORT = Short.MAX_VALUE;
    private static final int MIN_SHORT = Short.MIN_VALUE;
    private static final int STACK_INCREMENT = 2;
    private static Stack changes;
    private static byte[] _overwrite;
    private static byte[] reusableExcTable;
    private static final byte[] injProfilePointHitCode;
    private static final int injProfilePointHitIDCodeIdx = 1;
    private static final int injProfilePointHitMethodIdx = 4;
    protected byte[] exceptionTable;
    protected int baseCPoolCount;
    protected int excTableEntryCount;
    protected int maxLocals;
    protected int maxStack;
    protected int origBytecodesLength;
    protected int origExcTableEntryCount;
    private boolean changeTypeIsInjectNewInstr;
    private boolean injectionBindsToFollowingInstruction;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Injector() {
    }

    protected Injector(ClassInfo clazz, int methodIdx) {
        super(clazz, methodIdx);
        this.origBytecodesLength = this.bytecodesLength;
        this.maxStack = Injector.getU2(this.origMethodInfo, this.bytecodesStartIdx - 8);
        this.maxLocals = Injector.getU2(this.origMethodInfo, this.bytecodesStartIdx - 6);
        this.initExceptionTable();
        this.origExcTableEntryCount = this.excTableEntryCount;
    }

    public abstract byte[] instrumentMethod();

    protected void addExceptionTableEntry(int startPC, int endPC, int handlerPC, int typeCPIndex) {
        int pos = this.excTableEntryCount * 8;
        Injector.putU2(this.exceptionTable, pos, startPC);
        Injector.putU2(this.exceptionTable, pos + 2, endPC);
        Injector.putU2(this.exceptionTable, pos + 4, handlerPC);
        Injector.putU2(this.exceptionTable, pos + 6, typeCPIndex);
        ++this.excTableEntryCount;
    }

    protected void appendCode(byte[] appendedBytes, int appendedBytesCount) {
        System.arraycopy(appendedBytes, 0, this.bytecodes, this.bytecodesLength, appendedBytesCount);
        this.bytecodesLength += appendedBytesCount;
    }

    protected byte[] createPackedMethodInfo() {
        int diff = this.bytecodesLength - this.origBytecodesLength + (this.excTableEntryCount - this.origExcTableEntryCount) * 8;
        byte[] ret = new byte[this.origMethodInfo.length + diff];
        System.arraycopy(this.origMethodInfo, 0, ret, 0, this.bytecodesStartIdx);
        System.arraycopy(this.bytecodes, 0, ret, this.bytecodesStartIdx, this.bytecodesLength);
        int attrLength = Injector.getU4(this.origMethodInfo, this.bytecodesStartIdx - 12);
        Injector.putU4(ret, this.bytecodesStartIdx - 12, attrLength += diff);
        Injector.putU4(ret, this.bytecodesStartIdx - 4, this.bytecodesLength);
        System.arraycopy(this.origMethodInfo, this.bytecodesStartIdx + this.origBytecodesLength, ret, this.bytecodesStartIdx + this.bytecodesLength, this.origMethodInfo.length - this.bytecodesStartIdx - this.origBytecodesLength);
        int excTableOldStart = this.clazz.getExceptionTableStartOffsetInMethodInfo(this.methodIdx);
        int excTableNewStart = excTableOldStart + (this.bytecodesLength - this.origBytecodesLength);
        int excTableOldLen = this.origExcTableEntryCount * 8;
        int excTableNewLen = this.excTableEntryCount * 8;
        if (excTableOldLen != excTableNewLen) {
            System.arraycopy(ret, excTableNewStart + excTableOldLen, ret, excTableNewStart + excTableNewLen, this.origMethodInfo.length - excTableOldStart - excTableOldLen);
            Injector.putU2(ret, excTableNewStart, this.excTableEntryCount);
        }
        System.arraycopy(this.exceptionTable, 0, ret, excTableNewStart + 2, excTableNewLen);
        Injector.putU2(ret, this.bytecodesStartIdx - 8, this.maxStack + 2);
        Injector.putU2(ret, this.bytecodesStartIdx - 6, this.maxLocals);
        return ret;
    }

    protected void injectCodeAndRewrite(byte[] injectedBytes, int injectedBytesCount, int injectionPos, boolean injectionBindsToFollowingInstruction) {
        this.injectionBindsToFollowingInstruction = injectionBindsToFollowingInstruction;
        this.relocateCode(injectionPos, 0, injectedBytesCount, true);
        System.arraycopy(injectedBytes, 0, this.bytecodes, injectionPos, injectedBytesCount);
        this.handleCodeChanges();
    }

    protected void insertProfilingPoints(RuntimeProfilingPoint[] points, int ppHitCPMethodIdx) {
        for (int i = 0; i < points.length; ++i) {
            RuntimeProfilingPoint point = points[i];
            if (!$assertionsDisabled && i != 0 && point.getBci() < points[i - 1].getBci()) {
                throw new AssertionError();
            }
            int ppbci = point.getBci() + i * injProfilePointHitCode.length;
            this.injectProfilePointHit(point, ppbci, ppHitCPMethodIdx);
            this.maxStack = Math.max(this.maxStack, 4);
        }
    }

    void handleJumpWiden(int bci, int delta) {
        int ilen = this.rcInstrLen(bci);
        if (ilen != 3) {
            return;
        }
        this.relocateCode(bci, 3, 2, false);
        int bc = this.bytecodes[bci] & 0xFF;
        switch (bc) {
            case 167: {
                this.bytecodes[bci] = -56;
                break;
            }
            case 168: {
                this.bytecodes[bci] = -55;
                break;
            }
            default: {
                System.err.println("*** Profiler Engine: error - should not reach here in handleJumpWiden!");
            }
        }
        if (delta > 0) {
            delta += 2;
        }
        this.putInt(bci + 1, delta);
    }

    private int getOrigSwitchPadding(int bci, boolean isLookupSwitch) {
        for (int k = 0; k < changes.size(); ++k) {
            ChangeItem ci = (ChangeItem)changes.elementAt(k);
            if (!(ci instanceof ChangeSwitchPadding)) continue;
            ChangeSwitchPadding csp = (ChangeSwitchPadding)ci;
            if (csp.isLookupSwitch != isLookupSwitch || csp.bci != bci) continue;
            return csp.padding;
        }
        return -1;
    }

    private void changeJump(int bci, int offset, boolean isShort, int breakBCI, int delta) {
        int bciDelta = isShort ? this.getShort(offset) : this.getInt(offset);
        int targ = bci + bciDelta;
        boolean doRewrite = false;
        if (this.changeTypeIsInjectNewInstr) {
            if (breakBCI == 0) {
                return;
            }
            if (this.injectionBindsToFollowingInstruction) {
                if (bci < breakBCI && targ > breakBCI || bci >= breakBCI && targ <= breakBCI) {
                    doRewrite = true;
                }
            } else if (bci < breakBCI && targ >= breakBCI || bci >= breakBCI && targ < breakBCI) {
                doRewrite = true;
            }
        } else if (bci <= breakBCI && targ > breakBCI || bci >= breakBCI && targ < breakBCI) {
            doRewrite = true;
        }
        if (doRewrite) {
            int newDelta;
            int n = newDelta = bciDelta > 0 ? bciDelta + delta : bciDelta - delta;
            if (isShort && (newDelta > Short.MAX_VALUE || newDelta < Short.MIN_VALUE)) {
                changes.push(new ChangeJumpWiden(bci, newDelta));
            } else if (isShort) {
                this.putShort(offset, (short)newDelta);
            } else {
                this.putInt(offset, newDelta);
            }
        }
    }

    private void changeJumps(int breakBCI, int delta) {
        int bci = 0;
        block4: while (bci < this.bytecodesLength) {
            int bc = this.bytecodes[bci] & 0xFF;
            if (bc >= 153 && bc <= 166 || bc == 198 || bc == 199 || bc == 167 || bc == 168) {
                this.changeJump(bci, bci + 1, true, breakBCI, delta);
            } else {
                switch (bc) {
                    case 200: 
                    case 201: {
                        this.changeJump(bci, bci + 1, false, breakBCI, delta);
                        break;
                    }
                    case 170: 
                    case 171: {
                        int new_bci;
                        int newPad;
                        int oldPad;
                        int recPad = this.getOrigSwitchPadding(bci, bc != 170);
                        int n = oldPad = recPad != -1 ? recPad : Injector.align(bci + 1) - (bci + 1);
                        if (bci > breakBCI && (newPad = Injector.align((new_bci = bci + delta) + 1) - (new_bci + 1)) != oldPad && recPad == -1) {
                            changes.push(new ChangeSwitchPadding(bci, oldPad, bc != 170));
                        }
                        if (bc == 170) {
                            this.changeJump(bci, bci + 1 + oldPad, false, breakBCI, delta);
                            int lo = this.getInt(bci + 1 + oldPad + 4);
                            int hi = this.getInt(bci + 1 + oldPad + 8);
                            int n2 = hi - lo + 1;
                            for (int k = 0; k < n2; ++k) {
                                this.changeJump(bci, bci + 1 + oldPad + 4 * (k + 3), false, breakBCI, delta);
                            }
                            bci += 1 + oldPad + (n2 + 3) * 4;
                            continue block4;
                        }
                        this.changeJump(bci, bci + 1 + oldPad, false, breakBCI, delta);
                        int npairs = this.getInt(bci + 1 + oldPad + 4);
                        for (int k = 0; k < npairs; ++k) {
                            this.changeJump(bci, bci + 1 + oldPad + 4 * (2 + 2 * k + 1), false, breakBCI, delta);
                        }
                        bci += 1 + oldPad + (2 + npairs * 2) * 4;
                        continue block4;
                    }
                }
            }
            bci += this.opcodeLength(bci);
        }
    }

    private void handleCodeChanges() {
        while (!changes.empty()) {
            ChangeItem ci = (ChangeItem)changes.pop();
            ci.handleCodeChange(this);
        }
    }

    private void handleSwitchPadding(int bci, int oldPad, boolean isLookupSwitch) {
        int ilen = this.rcInstrLen(bci);
        int newPad = Injector.align(bci + 1) - (bci + 1);
        int padDelta = newPad - oldPad;
        if (padDelta != 0) {
            int len;
            if (!isLookupSwitch) {
                int low = this.getInt(bci + 1 + oldPad + 4);
                int high = this.getInt(bci + 1 + oldPad + 8);
                len = high - low + 1 + 3;
            } else {
                int npairs = this.getInt(bci + 1 + oldPad + 4);
                len = npairs * 2 + 2;
            }
            this.relocateCode(bci, ilen, padDelta, false);
            if (padDelta < 0) {
                System.arraycopy(this.bytecodes, bci + 1 + oldPad, this.bytecodes, bci + 1 + newPad, len * 4 + padDelta);
                System.arraycopy(_overwrite, 0, this.bytecodes, bci + 1 + newPad + len * 4 + padDelta, -padDelta);
            } else {
                System.arraycopy(this.bytecodes, bci + 1 + oldPad, this.bytecodes, bci + 1 + newPad, len * 4);
            }
        }
    }

    private void initExceptionTable() {
        int startOfs = this.clazz.getExceptionTableStartOffsetInMethodInfo(this.methodIdx);
        this.excTableEntryCount = Injector.getU2(this.origMethodInfo, startOfs);
        int len = this.excTableEntryCount * 8;
        if (reusableExcTable.length < len + 40) {
            reusableExcTable = new byte[len * 2 + 40];
        }
        System.arraycopy(this.origMethodInfo, startOfs + 2, reusableExcTable, 0, len);
        this.exceptionTable = reusableExcTable;
    }

    private void injectProfilePointHit(RuntimeProfilingPoint point, int bci, int ppHitCPMethodIdx) {
        Injector.putU2(injProfilePointHitCode, 4, ppHitCPMethodIdx + this.baseCPoolCount);
        Injector.putU2(injProfilePointHitCode, 1, point.getId());
        this.injectCodeAndRewrite(injProfilePointHitCode, injProfilePointHitCode.length, bci, true);
    }

    private int rcInstrLen(int bci) {
        int bc = this.bytecodes[bci] & 0xFF;
        switch (bc) {
            case 170: 
            case 171: {
                int pad = this.getOrigSwitchPadding(bci, bc == 171);
                if (pad == -1) {
                    return this.opcodeLength(bci);
                }
                switch (bc) {
                    case 170: {
                        int lo = this.getInt(bci + 1 + pad + 4);
                        int hi = this.getInt(bci + 1 + pad + 8);
                        int n = hi - lo + 1;
                        return 1 + pad + 4 * (3 + n);
                    }
                    case 171: {
                        int npairs = this.getInt(bci + 1 + pad + 4);
                        return 1 + pad + 4 * (2 + 2 * npairs);
                    }
                }
            }
        }
        return this.opcodeLength(bci);
    }

    private void relocateCode(int bci, int iLen, int delta, boolean injectNewInstr) {
        this.changeTypeIsInjectNewInstr = injectNewInstr;
        if (bci > 0) {
            this.changeJumps(bci, delta);
        }
        if (delta < 0) {
            System.arraycopy(this.bytecodes, bci + iLen + delta, _overwrite, 0, -delta);
        }
        int nextBCI = bci + iLen;
        System.arraycopy(this.bytecodes, nextBCI, this.bytecodes, nextBCI + delta, this.bytecodesLength - nextBCI);
        this.bytecodesLength += delta;
        this.updateExceptionTable(bci, delta);
        for (int j = 0; j < changes.size(); ++j) {
            ChangeItem ci = (ChangeItem)changes.elementAt(j);
            ci.relocate(bci, delta);
        }
    }

    private void updateExceptionTable(int injectionPos, int injectedBytesCount) {
        int pos = 0;
        for (int i = 0; i < this.excTableEntryCount; ++i) {
            int startPC = Injector.getU2(this.exceptionTable, pos);
            int endPC = Injector.getU2(this.exceptionTable, pos + 2);
            int handlerPC = Injector.getU2(this.exceptionTable, pos + 4);
            if (startPC > injectionPos) {
                Injector.putU2(this.exceptionTable, pos, startPC += injectedBytesCount);
                Injector.putU2(this.exceptionTable, pos + 2, endPC += injectedBytesCount);
            } else if (injectionPos < endPC) {
                Injector.putU2(this.exceptionTable, pos + 2, endPC += injectedBytesCount);
            }
            if (handlerPC > injectionPos) {
                Injector.putU2(this.exceptionTable, pos + 4, handlerPC += injectedBytesCount);
            }
            pos += 8;
        }
    }

    static {
        $assertionsDisabled = !Injector.class.desiredAssertionStatus();
        changes = new Stack();
        _overwrite = new byte[3];
        reusableExcTable = new byte[100];
        injProfilePointHitCode = new byte[]{17, 0, 0, -72, 0, 0, 0, 0};
    }

    private static class ChangeSwitchPadding
    extends ChangeItem {
        boolean isLookupSwitch;
        int padding;

        ChangeSwitchPadding(int bci, int padding, boolean isLookupSwitch) {
            super(bci);
            this.padding = padding;
            this.isLookupSwitch = isLookupSwitch;
        }

        void handleCodeChange(Injector r) {
            r.handleSwitchPadding(this.bci, this.padding, this.isLookupSwitch);
        }
    }

    private static class ChangeJumpWiden
    extends ChangeItem {
        int delta;

        ChangeJumpWiden(int bci, int delta) {
            super(bci);
            this.delta = delta;
        }

        void handleCodeChange(Injector r) {
            r.handleJumpWiden(this.bci, this.delta);
        }
    }

    private static abstract class ChangeItem {
        int bci;

        ChangeItem(int bci) {
            this.bci = bci;
        }

        abstract void handleCodeChange(Injector var1);

        void relocate(int breakBCI, int delta) {
            if (this.bci > breakBCI) {
                this.bci += delta;
            }
        }
    }
}

