/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;
import org.netbeans.lib.profiler.results.cpu.cct.RuntimeCPUCCTNodeVisitorAdaptor;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.CategoryCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ServletRequestCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;

public class CPUCallGraphBuilder
extends BaseCallGraphBuilder
implements CPUProfilingResultListener,
CPUCCTProvider {
    private CPUCCTNodeFactory factory;
    private DebugInfoCollector debugCollector = null;
    private InstrumentationFilter instrFilter;
    private boolean stackIntegrityViolationReported;
    private long delta;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPUCCTContainer[] createPresentationCCTs(CPUResultsSnapshot cpuSnapshot) {
        ThreadInfo.beginTrans(false);
        try {
            String[] threadNames = ThreadInfo.getThreadNames();
            if (threadNames == null) {
                CPUCCTContainer[] cPUCCTContainerArray = null;
                return cPUCCTContainerArray;
            }
            int len = threadNames.length;
            if (len == 0) {
                CPUCCTContainer[] cPUCCTContainerArray = null;
                return cPUCCTContainerArray;
            }
            ArrayList<CPUCCTContainer> ccts = new ArrayList<CPUCCTContainer>(len);
            int threadId = 0;
            for (int i = 0; i < len; ++i) {
                ThreadInfo ti = ThreadInfo.threadInfos[i];
                if (ti == null || ti.stack[0] == null) continue;
                double[] activeTimes = this.calculateThreadActiveTimes(ti);
                TimedCPUCCTNode rootNode = ti.stack[0];
                CPUCCTContainer cct = new CPUCCTContainer(rootNode, cpuSnapshot, this.status, this.instrFilter, ti.totalNNodes, activeTimes, threadId++, threadNames[i]);
                if (cct.rootNode == null || cct.rootNode.getNChildren() <= 0) continue;
                ccts.add(cct);
            }
            CPUCCTContainer[] cPUCCTContainerArray = ccts.toArray(new CPUCCTContainer[ccts.size()]);
            return cPUCCTContainerArray;
        }
        finally {
            ThreadInfo.endTrans();
        }
    }

    public void methodEntry(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        switch (methodType) {
            case 1: {
                this.plainMethodEntry(methodId, ti, timeStamp0, timeStamp1);
                break;
            }
            case 2: {
                this.rootMethodEntry(methodId, ti, timeStamp0, timeStamp1);
                break;
            }
            case 3: {
                this.markerMethodEntry(methodId, ti, timeStamp0, timeStamp1);
            }
        }
        this.batchNotEmpty = true;
    }

    public void methodEntryUnstamped(int methodId, int threadId, int methodType) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        switch (methodType) {
            case 1: {
                this.plainMethodEntry(methodId, ti);
                break;
            }
            case 3: {
                this.markerMethodEntry(methodId, ti);
            }
        }
        this.batchNotEmpty = true;
    }

    public void methodExit(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1) {
        TimedCPUCCTNode oneMoreNode;
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        TimedCPUCCTNode oldNode = null;
        switch (methodType) {
            case 1: 
            case 3: {
                oldNode = this.plainMethodExit(methodId, ti, timeStamp0, timeStamp1);
                break;
            }
            case 2: {
                oldNode = this.rootMethodExit(methodId, ti, timeStamp0, timeStamp1);
            }
        }
        if (oldNode != null && (oneMoreNode = ti.peek()) != null && (oneMoreNode instanceof CategoryCPUCCTNode || oneMoreNode instanceof ServletRequestCPUCCTNode)) {
            ti.pop();
        }
        this.batchNotEmpty = true;
    }

    public void methodExitUnstamped(int methodId, int threadId, int methodType) {
        TimedCPUCCTNode oneMoreNode;
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        TimedCPUCCTNode oldNode = null;
        switch (methodType) {
            case 1: 
            case 3: {
                oldNode = this.plainMethodExit(methodId, ti);
            }
        }
        if (oldNode != null && (oneMoreNode = ti.peek()) != null && (oneMoreNode instanceof CategoryCPUCCTNode || oneMoreNode instanceof ServletRequestCPUCCTNode)) {
            ti.pop();
        }
        this.batchNotEmpty = true;
    }

    public void monitorEntry(int threadId, long timeStamp0, long timeStamp1) {
        this.waitEntry(threadId, timeStamp0, timeStamp1);
        this.batchNotEmpty = true;
    }

    public void monitorExit(int threadId, long timeStamp0, long timeStamp1) {
        this.waitEntry(threadId, timeStamp0, timeStamp1);
        this.batchNotEmpty = true;
    }

    public void newThread(int threadId, String threadName, String threadClassName) {
        if (!this.isReady()) {
            return;
        }
        LOGGER.finest("New thread creation for thread id = " + threadId + ", name = " + threadName);
        ThreadInfo.newThreadInfo(threadId, threadName, threadClassName);
        this.batchNotEmpty = true;
    }

    public void servletRequest(int threadId, int requestType, String servletPath, int sessionId) {
        ServletRequestCPUCCTNode servletNode;
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        TimedCPUCCTNode curNode = ti.peek();
        if (curNode == null) {
            curNode = this.factory.createThreadNode(threadId);
            ++ti.totalNNodes;
            ti.push(curNode);
            --ti.totalNInv;
        }
        if ((servletNode = ServletRequestCPUCCTNode.Locator.locate(requestType, servletPath, curNode.getChildren())) == null) {
            servletNode = this.factory.createServletRequestNode(requestType, servletPath);
            curNode.attachNodeAsChild(servletNode);
        }
        ti.push(servletNode);
    }

    public void sleepEntry(int threadId, long timeStamp0, long timeStamp1) {
        long diff;
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ENTRY SLEEP: " + this.debugNode(curNode) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", ti: " + ti);
            this.delta = timeStamp0;
        }
        if ((diff = timeStamp0 - ti.topMethodEntryTime0) > 0L) {
            curNode.addNetTime0(diff);
        } else {
            timeStamp0 = ti.topMethodEntryTime0;
        }
        ti.topMethodEntryTime0 = timeStamp0;
        curNode.setLastWaitOrSleepStamp(timeStamp0);
        this.batchNotEmpty = true;
    }

    public void sleepExit(int threadId, long timeStamp0, long timeStamp1) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
        long lastSleep = timeStamp0 - curNode.getLastWaitOrSleepStamp();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("EXIT SLEEP: " + this.debugNode(curNode) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", slept: " + lastSleep + ", ti: " + ti);
            this.delta = timeStamp0;
            lastSleep = 0L;
        }
        curNode.setLastWaitOrSleepStamp(0L);
        curNode.addSleepTime0(lastSleep);
        if (timeStamp0 - ti.topMethodEntryTime0 > 0L) {
            ti.topMethodEntryTime0 = timeStamp0;
        }
        this.batchNotEmpty = true;
    }

    public void threadsResume(long timeStamp0, long timeStamp1) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo[] tis = ThreadInfo.threadInfos;
        for (int i = 0; i < tis.length; ++i) {
            ThreadInfo ti = tis[i];
            if (ti == null || ti.stackTopIdx < 0) continue;
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.status.collectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
            if (this.status.collectingTwoTimeStamps()) {
                ti.rootMethodEntryTimeAbs = timeStamp0;
                ti.rootMethodEntryTimeThreadCPU = timeStamp1;
                continue;
            }
            ti.rootMethodEntryTimeAbs = timeStamp0;
        }
        this.batchNotEmpty = true;
    }

    public void threadsSuspend(long timeStamp0, long timeStamp1) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo[] tis = ThreadInfo.threadInfos;
        for (int i = 0; i < tis.length; ++i) {
            ThreadInfo ti = tis[i];
            if (ti == null || ti.stackTopIdx < 0) continue;
            TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
            long diff = timeStamp0 - ti.topMethodEntryTime0;
            if (diff > 0L) {
                curNode.addNetTime0(diff);
            }
            if (this.status.collectingTwoTimeStamps()) {
                ti.rootGrossTimeAbs += timeStamp0 - ti.rootMethodEntryTimeAbs;
                diff = timeStamp1 - ti.topMethodEntryTime1;
                if (diff > 0L) {
                    curNode.addNetTime1(diff);
                }
                ti.rootGrossTimeThreadCPU += timeStamp1 - ti.rootMethodEntryTimeThreadCPU;
                continue;
            }
            ti.rootGrossTimeAbs += timeStamp0 - ti.rootMethodEntryTimeAbs;
        }
        this.batchNotEmpty = true;
    }

    public void timeAdjust(final int threadId, final long timeDiff0, final long timeDiff1) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        final ProfilingPointsProcessor ppp = TargetAppRunner.getDefault().getProfilingPointsProcessor();
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        ti.rootMethodEntryTimeAbs += timeDiff0;
        ti.rootMethodEntryTimeThreadCPU += timeDiff1;
        ti.topMethodEntryTime0 += timeDiff0;
        if (this.status.collectingTwoTimeStamps()) {
            ti.topMethodEntryTime1 += timeDiff1;
        }
        this.afterBatchCommands.add(new Runnable(){

            public void run() {
                ppp.timeAdjust(threadId, timeDiff0, timeDiff1);
            }
        });
        this.batchNotEmpty = true;
    }

    public void waitEntry(int threadId, long timeStamp0, long timeStamp1) {
        long diff;
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ENTRY WAIT: " + this.debugNode(curNode) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", ti: " + ti);
            this.delta = timeStamp0;
            LOGGER.finest(this.dumpStack(ti));
        }
        if ((diff = timeStamp0 - ti.topMethodEntryTime0) > 0L) {
            curNode.addNetTime0(diff);
        } else {
            timeStamp0 = ti.topMethodEntryTime0;
        }
        ti.topMethodEntryTime0 = timeStamp0;
        curNode.setLastWaitOrSleepStamp(timeStamp0);
        this.batchNotEmpty = true;
    }

    public void waitExit(int threadId, long timeStamp0, long timeStamp1) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.threadInfos[threadId];
        TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
        long lastWait = timeStamp0 - curNode.getLastWaitOrSleepStamp();
        curNode.setLastWaitOrSleepStamp(0L);
        curNode.addWaitTime0(lastWait);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("EXIT WAIT: " + this.debugNode(curNode) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", waited: " + lastWait + ", ti: " + ti);
            this.delta = timeStamp0;
            LOGGER.finest(this.dumpStack(ti));
        }
        if (timeStamp0 - ti.topMethodEntryTime0 > 0L) {
            ti.topMethodEntryTime0 = timeStamp0;
        }
        this.batchNotEmpty = true;
    }

    protected long[][] getAllThreadsActiveTimes() {
        int len = ThreadInfo.getThreadNames().length;
        long[][] res = new long[2][len];
        for (int i = 0; i < len; ++i) {
            ThreadInfo ti = ThreadInfo.threadInfos[i];
            double[] times = this.calculateThreadActiveTimes(ti);
            res[0][i] = (long)((times[0] - times[2]) * 1000.0 / (double)this.status.timerCountsInSecond[0]);
            res[1][i] = times[1] != -1.0 ? (long)((times[1] - times[3]) * 1000.0 / (double)this.status.timerCountsInSecond[1]) : -1L;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeCCTNode getAppRootNode() {
        if (ThreadInfo.isEmpty()) {
            return null;
        }
        SimpleCPUCCTNode appNode = null;
        ThreadInfo.beginTrans(false);
        try {
            appNode = new SimpleCPUCCTNode(true);
            int len = ThreadInfo.getThreadNames() != null ? ThreadInfo.getThreadNames().length : 0;
            for (int i = 0; i < len; ++i) {
                ThreadInfo ti = ThreadInfo.threadInfos[i];
                if (ti == null || ti.stack[0] == null) continue;
                appNode.attachNodeAsChild(ti.stack[0]);
            }
        }
        finally {
            ThreadInfo.endTrans();
        }
        return appNode;
    }

    double[] calculateThreadActiveTimes(ThreadInfo ti) {
        TimedCPUCCTNode rootNode = ti.stack[0];
        if (rootNode == null) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        long rootGrossTimeAbs = ti.rootGrossTimeAbs;
        if (ti.stackTopIdx != -1) {
            long time0 = this.status.dumpAbsTimeStamp;
            if (ti.topMethodEntryTime0 > time0) {
                time0 = ti.topMethodEntryTime0;
            }
            rootGrossTimeAbs += time0 - ti.rootMethodEntryTimeAbs;
        }
        long rootGrossTimeCPU = ti.rootGrossTimeThreadCPU;
        if (ti.stackTopIdx != -1) {
            rootGrossTimeCPU = this.status.collectingTwoTimeStamps() ? (rootGrossTimeCPU += ti.topMethodEntryTime1 - ti.rootMethodEntryTimeThreadCPU) : -1L;
        }
        int nRootInv = rootNode.getNCalls();
        double timeInInjectedCodeInThreadCPUCounts = 0.0;
        double timeInInjectedCodeInAbsCounts = TimingAdjusterOld.getDefault(this.status).delta(nRootInv, (int)(ti.totalNInv - (long)nRootInv), false);
        timeInInjectedCodeInThreadCPUCounts = this.status.collectingTwoTimeStamps() ? TimingAdjusterOld.getDefault(this.status).delta(nRootInv, (int)(ti.totalNInv - (long)nRootInv), true) : timeInInjectedCodeInAbsCounts * (double)this.status.timerCountsInSecond[1] / (double)this.status.timerCountsInSecond[0];
        return new double[]{rootGrossTimeAbs, rootGrossTimeCPU, timeInInjectedCodeInAbsCounts, timeInInjectedCodeInThreadCPUCounts};
    }

    protected void doBatchStart() {
        ThreadInfo.beginTrans(true);
    }

    protected void doBatchStop() {
        ThreadInfo.endTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReset() {
        boolean threadLocked = ThreadInfo.beginTrans(true, true);
        if (threadLocked) {
            try {
                ThreadInfo.reset();
            }
            finally {
                ThreadInfo.endTrans();
            }
        }
    }

    protected void doShutdown() {
        ThreadInfo.reset();
        this.factory = null;
        this.instrFilter = null;
    }

    protected void doStartup(ProfilerClient profilerClient) {
        this.instrFilter = profilerClient.getSettings().getInstrumentationFilter();
        this.factory = new CPUCCTNodeFactory(this.status.collectingTwoTimeStamps());
        profilerClient.registerCPUCCTProvider(this);
    }

    private synchronized DebugInfoCollector getDebugCollector() {
        if (this.debugCollector == null) {
            this.debugCollector = new DebugInfoCollector();
        }
        return this.debugCollector;
    }

    private boolean isReady() {
        return this.status != null && this.factory != null && this.instrFilter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String debugMethod(int methodId) {
        StringBuffer buffer = new StringBuffer();
        this.status.beginTrans(false);
        try {
            buffer.append(this.status.getInstrMethodClasses()[methodId]).append('.').append(this.status.getInstrMethodNames()[methodId]);
            buffer.append(this.status.getInstrMethodSignatures()[methodId]).append(" (methodId = ").append(methodId).append(')');
        }
        finally {
            this.status.endTrans();
        }
        return buffer.toString();
    }

    private String debugNode(RuntimeCPUCCTNode node) {
        return this.getDebugCollector().getInfo(node);
    }

    private String dumpStack(ThreadInfo ti) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("*** Thread stack dump:\n");
        for (int i = ti.stackTopIdx; i >= 0; --i) {
            DebugInfoCollector collector = new DebugInfoCollector();
            TimedCPUCCTNode frame = ti.stack[i];
            frame.accept(collector);
            buffer.append(collector.getInfo(frame)).append('\n');
        }
        return buffer.toString();
    }

    private TimedCPUCCTNode markerMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1, boolean stamped) {
        TimedCPUCCTNode curNode;
        MarkingEngine engine = MarkingEngine.getDefault();
        Mark mark = engine.getMarker().getMark(methodId, this.status);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("MarkerMEntry" + (!stamped ? "(unstamped)" : "") + " for tId = " + ti.threadId + ", time: " + timeStamp0 + ", method:  " + this.debugMethod(methodId) + ", inRoot: " + ti.rootMethodEntryTimeAbs + ", rootEntryTimeThread: " + ti.rootMethodEntryTimeThreadCPU);
        }
        if ((curNode = ti.peek()) == null) {
            TimedCPUCCTNode rootNode = this.factory.createThreadNode(ti.threadId);
            ++ti.totalNNodes;
            ti.push(rootNode);
            --ti.totalNInv;
            if (!mark.isDefault) {
                curNode = this.factory.createCategory(mark);
                rootNode.attachNodeAsChild(curNode);
                ++ti.totalNNodes;
                ti.push(curNode);
                rootNode = curNode;
            }
            curNode = this.factory.createMethodNode(methodId);
            rootNode.attachNodeAsChild(curNode);
            ++ti.totalNNodes;
            ti.push(curNode);
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.status.collectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        } else {
            MethodCPUCCTNode calleeNode;
            if (stamped) {
                long diff = timeStamp0 - ti.topMethodEntryTime0;
                if (diff > 0L) {
                    curNode.addNetTime0(diff);
                } else {
                    timeStamp0 = ti.topMethodEntryTime0;
                }
                ti.topMethodEntryTime0 = timeStamp0;
                if (this.status.collectingTwoTimeStamps()) {
                    diff = timeStamp1 - ti.topMethodEntryTime1;
                    if (diff > 0L) {
                        curNode.addNetTime1(diff);
                    } else {
                        timeStamp1 = ti.topMethodEntryTime1;
                    }
                    ti.topMethodEntryTime1 = timeStamp1;
                }
            }
            if (!mark.isDefault) {
                CategoryCPUCCTNode calleeNode2 = CategoryCPUCCTNode.Locator.locate(mark, curNode.getChildren());
                if (calleeNode2 == null) {
                    calleeNode2 = this.factory.createCategory(mark);
                    curNode.attachNodeAsChild(calleeNode2);
                    ++ti.totalNNodes;
                }
                ti.push(calleeNode2);
                curNode = calleeNode2;
            }
            if ((calleeNode = MethodCPUCCTNode.Locator.locate(methodId, curNode.getChildren())) == null) {
                calleeNode = this.factory.createMethodNode(methodId);
                curNode.attachNodeAsChild(calleeNode);
                ++ti.totalNNodes;
            }
            ti.push(calleeNode);
            curNode = calleeNode;
        }
        if (!ti.isInRoot()) {
            curNode.setFilteredStatus(2);
            if (stamped) {
                ti.rootMethodEntryTimeAbs = timeStamp0;
                ti.rootMethodEntryTimeThreadCPU = timeStamp1;
                ti.topMethodEntryTime0 = timeStamp0;
                if (this.status.collectingTwoTimeStamps()) {
                    ti.topMethodEntryTime1 = timeStamp1;
                }
            }
        } else {
            String jvmClassName = this.status.getInstrMethodClasses()[((MethodCPUCCTNode)curNode).getMethodId()].replace('.', '/');
            ProfilerClient client = this.getClient();
            if (client != null) {
                if (!client.getSettings().getInstrumentationFilter().passesFilter(jvmClassName)) {
                    curNode.setFilteredStatus(2);
                }
            } else {
                curNode.setFilteredStatus(2);
            }
        }
        return curNode;
    }

    private TimedCPUCCTNode markerMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        return this.markerMethodEntry(methodId, ti, timeStamp0, timeStamp1, true);
    }

    private TimedCPUCCTNode markerMethodEntry(int methodId, ThreadInfo ti) {
        return this.markerMethodEntry(methodId, ti, 0L, 0L, false);
    }

    private TimedCPUCCTNode plainMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1, boolean stamped) {
        MethodCPUCCTNode methodNode;
        if (LOGGER.isLoggable(Level.FINEST) && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("MethodEntry " + (!stamped ? "(unstamped)" : "") + " for tId = " + ti.threadId + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", method:  " + this.debugMethod(methodId));
        }
        TimedCPUCCTNode curNode = ti.peek();
        if (stamped) {
            long diff = timeStamp0 - ti.topMethodEntryTime0;
            if (diff > 0L) {
                curNode.addNetTime0(diff);
            } else {
                timeStamp0 = ti.topMethodEntryTime0;
            }
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.status.collectingTwoTimeStamps()) {
                diff = timeStamp1 - ti.topMethodEntryTime1;
                if (diff > 0L) {
                    curNode.addNetTime1(diff);
                } else {
                    timeStamp1 = ti.topMethodEntryTime1;
                }
                ti.topMethodEntryTime1 = timeStamp1;
            }
        }
        if ((methodNode = MethodCPUCCTNode.Locator.locate(methodId, curNode.getChildren())) != null) {
            ti.push(methodNode);
            return methodNode;
        }
        methodNode = this.factory.createMethodNode(methodId);
        curNode.attachNodeAsChild(methodNode);
        curNode = methodNode;
        ++ti.totalNNodes;
        ti.push(curNode);
        if (!ti.isInRoot()) {
            String jvmClassName = this.status.getInstrMethodClasses()[((MethodCPUCCTNode)curNode).getMethodId()].replace('.', '/');
            ProfilerClient client = this.getClient();
            if (client != null) {
                if (!client.getSettings().getInstrumentationFilter().passesFilter(jvmClassName)) {
                    curNode.setFilteredStatus(2);
                }
            } else {
                curNode.setFilteredStatus(2);
            }
        }
        return curNode;
    }

    private TimedCPUCCTNode plainMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        return this.plainMethodEntry(methodId, ti, timeStamp0, timeStamp1, true);
    }

    private TimedCPUCCTNode plainMethodEntry(int methodId, ThreadInfo ti) {
        return this.plainMethodEntry(methodId, ti, 0L, 0L, false);
    }

    private TimedCPUCCTNode plainMethodExit(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1, boolean stamped) {
        TimedCPUCCTNode curNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("MethodExit" + (!stamped ? "(unstamped)" : "") + ": " + this.debugMethod(methodId) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", ti: " + ti);
            this.delta = timeStamp0;
        }
        if ((curNode = ti.peek()) == null) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        if (!(curNode instanceof MethodCPUCCTNode)) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        MethodCPUCCTNode methodNode = (MethodCPUCCTNode)curNode;
        if (methodId != methodNode.getMethodId()) {
            StringBuffer message = new StringBuffer();
            message.append("*** Profiler engine warning: ").append("critical: stack integrity violation on method exit.\n");
            message.append("*** methodId on simulated stack top: ").append(methodNode.getMethodId());
            message.append(", received methodId (should match) = ").append(methodId).append('\n');
            message.append("received method debug: ").append(this.debugMethod(methodId)).append('\n');
            message.append("*** Please report this problem to feedback@profiler.netbeans.org");
            if (this.status != null && this.status.getInstrMethodClasses() != null && !this.stackIntegrityViolationReported) {
                message.append(this.dumpStack(ti));
                this.stackIntegrityViolationReported = true;
            }
            message.append('\n');
            LOGGER.severe(message.toString());
            return null;
        }
        if (stamped) {
            long diff = timeStamp0 - ti.topMethodEntryTime0;
            if (diff > 0L) {
                curNode.addNetTime0(diff);
            } else {
                timeStamp0 = ti.topMethodEntryTime0;
            }
            if (this.status.collectingTwoTimeStamps()) {
                diff = timeStamp1 - ti.topMethodEntryTime1;
                if (diff > 0L) {
                    curNode.addNetTime1(diff);
                } else {
                    timeStamp1 = ti.topMethodEntryTime1;
                }
            }
        }
        TimedCPUCCTNode oldNode = ti.pop();
        if (stamped) {
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.status.collectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        }
        return oldNode;
    }

    private TimedCPUCCTNode plainMethodExit(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        return this.plainMethodExit(methodId, ti, timeStamp0, timeStamp1, true);
    }

    private TimedCPUCCTNode plainMethodExit(int methodId, ThreadInfo ti) {
        return this.plainMethodExit(methodId, ti, 0L, 0L, false);
    }

    private TimedCPUCCTNode rootMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("RootMEntry for tId = " + ti.threadId + ", time: " + timeStamp0 + ", method:  " + this.debugMethod(methodId));
        }
        MarkingEngine engine = MarkingEngine.getDefault();
        Mark mark = engine.getMarker().getMark(methodId, this.status);
        TimedCPUCCTNode curNode = ti.peek();
        if (ti.isInRoot()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("*** Profiler engine warning: ").append("critical: at root method entry thread stack is not at 0 - should not happen!\n");
            buffer.append("*** thread = ").append(ThreadInfo.threadNames[ti.threadId]);
            buffer.append(", ti.stackTopIdx = ").append(ti.stackTopIdx);
            if (curNode != null) {
                buffer.append(", curNode = " + curNode).append('\n');
            }
            buffer.append("*** Please report this problem to feedback@profiler.netbeans.org");
            LOGGER.severe(buffer.toString());
        }
        if (curNode == null) {
            TimedCPUCCTNode rootNode = this.factory.createThreadNode(ti.threadId);
            ++ti.totalNNodes;
            ti.push(rootNode);
            --ti.totalNInv;
            if (!mark.isDefault) {
                curNode = this.factory.createCategory(mark);
                rootNode.attachNodeAsChild(curNode);
                ++ti.totalNNodes;
                ti.push(curNode);
                rootNode = curNode;
            }
            curNode = this.factory.createMethodNode(methodId);
            rootNode.attachNodeAsChild(curNode);
            ++ti.totalNNodes;
        } else {
            TimedCPUCCTNode calleeNode;
            if (!mark.isDefault) {
                calleeNode = CategoryCPUCCTNode.Locator.locate(mark, curNode.getChildren());
                if (calleeNode == null) {
                    calleeNode = this.factory.createCategory(mark);
                    curNode.attachNodeAsChild(calleeNode);
                    ++ti.totalNNodes;
                }
                ti.push(calleeNode);
                curNode = calleeNode;
            }
            if ((calleeNode = MethodCPUCCTNode.Locator.locate(methodId, curNode.getChildren())) == null) {
                calleeNode = this.factory.createMethodNode(methodId);
                curNode.attachNodeAsChild(calleeNode);
                ++ti.totalNNodes;
            }
            curNode = calleeNode;
        }
        ti.push(curNode);
        ti.rootMethodEntryTimeAbs = timeStamp0;
        ti.rootMethodEntryTimeThreadCPU = timeStamp1;
        ti.topMethodEntryTime0 = timeStamp0;
        if (this.status.collectingTwoTimeStamps()) {
            ti.topMethodEntryTime1 = timeStamp1;
        }
        ++ti.inRoot;
        return curNode;
    }

    private TimedCPUCCTNode rootMethodExit(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        TimedCPUCCTNode curNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("RootMExit for tId = " + ti.threadId + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", method: " + this.debugMethod(methodId));
            this.delta = timeStamp0;
        }
        if ((curNode = ti.peek()) == null) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on root method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        if (!(curNode instanceof MethodCPUCCTNode)) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on root method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        MethodCPUCCTNode methodNode = (MethodCPUCCTNode)curNode;
        if (methodId != methodNode.getMethodId()) {
            StringBuffer message = new StringBuffer();
            message.append("*** Profiler engine warning: ").append("critical: stack integrity violation on root thod exit.\n");
            message.append("*** methodId on simulated stack top: ").append(methodNode.getMethodId()).append('\n');
            message.append(", received methodId (should match) = ").append(methodId).append('\n');
            message.append("received method debug: ").append(this.debugMethod(methodId)).append('\n');
            message.append("*** Please report this problem to feedback@profiler.netbeans.org");
            if (this.status != null && this.status.getInstrMethodClasses() != null && !this.stackIntegrityViolationReported) {
                message.append(this.dumpStack(ti));
                this.stackIntegrityViolationReported = true;
            }
            message.append('\n');
            LOGGER.severe(message.toString());
            return null;
        }
        long diff = timeStamp0 - ti.topMethodEntryTime0;
        if (diff > 0L) {
            curNode.addNetTime0(diff);
        } else {
            timeStamp0 = ti.topMethodEntryTime0;
        }
        if (this.status.collectingTwoTimeStamps()) {
            diff = timeStamp1 - ti.topMethodEntryTime1;
            if (diff > 0L) {
                curNode.addNetTime1(diff);
            } else {
                timeStamp1 = ti.topMethodEntryTime1;
            }
        }
        --ti.inRoot;
        TimedCPUCCTNode oldNode = ti.pop();
        if (ti.isInRoot()) {
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.status.collectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        } else {
            ti.rootGrossTimeAbs += timeStamp0 - ti.rootMethodEntryTimeAbs;
            ti.rootGrossTimeThreadCPU += timeStamp1 - ti.rootMethodEntryTimeThreadCPU;
            ti.rootMethodEntryTimeAbs = 0L;
            ti.rootMethodEntryTimeThreadCPU = 0L;
        }
        return oldNode;
    }

    private class DebugInfoCollector
    extends RuntimeCPUCCTNodeVisitorAdaptor {
        private StringBuffer buffer = new StringBuffer();

        public StringBuffer getBuffer() {
            return this.buffer;
        }

        public synchronized String getInfo(RuntimeCPUCCTNode node) {
            this.buffer = new StringBuffer();
            node.accept(this);
            return this.buffer.toString();
        }

        public void visit(MethodCPUCCTNode node) {
            this.buffer.append(CPUCallGraphBuilder.this.debugMethod(node.getMethodId()));
        }

        public void visit(ServletRequestCPUCCTNode node) {
            this.buffer.append("Boundary");
        }

        public void visit(ThreadCPUCCTNode node) {
            this.buffer.append("threadId = ").append(node.getThreadId());
        }

        public void visit(CategoryCPUCCTNode node) {
            this.buffer.append("Category ").append(node.getMark());
        }

        public void visit(SimpleCPUCCTNode node) {
        }
    }

    static class ThreadInfo {
        static ThreadInfo[] threadInfos;
        static String[] threadNames;
        static String[] threadClassNames;
        static int threadInfosLastIdx;
        private static TransactionalSupport transaction;
        TimedCPUCCTNode[] stack = new TimedCPUCCTNode[40];
        int inRoot = 0;
        int stackTopIdx = -1;
        final int threadId;
        TimedCPUCCTNode comboNodeDst;
        TimedCPUCCTNode comboNodeSrc;
        int totalNNodes;
        long lastCallIndex = -1L;
        long rootGrossTimeAbs;
        long rootGrossTimeThreadCPU;
        long rootMethodEntryTimeAbs;
        long rootMethodEntryTimeThreadCPU;
        long topMethodEntryTime0;
        long topMethodEntryTime1;
        long totalNInv;

        private ThreadInfo(int threadId) {
            this.threadId = threadId;
        }

        static boolean isEmpty() {
            if (threadInfos == null || threadInfos.length == 0) {
                return true;
            }
            for (int i = 0; i < threadInfos.length; ++i) {
                if (threadInfos[i] == null || ThreadInfo.threadInfos[i].stack == null || ThreadInfo.threadInfos[i].stack[0] == null || ThreadInfo.threadInfos[i].stack[0].getChildren() == null || ThreadInfo.threadInfos[i].stack[0].getChildren().size() <= 0) continue;
                return false;
            }
            return true;
        }

        static synchronized String[] getThreadNames() {
            return threadNames;
        }

        static void beginTrans(boolean mutable) {
            transaction.beginTrans(mutable);
        }

        static boolean beginTrans(boolean mutable, boolean failEarly) {
            return transaction.beginTrans(mutable, failEarly);
        }

        static void endTrans() {
            transaction.endTrans();
        }

        static synchronized void newThreadInfo(int threadId, String threadName, String threadClassName) {
            if (threadId > threadInfosLastIdx || threadInfos == null) {
                int newLen = threadId + 1;
                ThreadInfo[] newInfos = new ThreadInfo[newLen];
                String[] newNames = new String[newLen];
                String[] newClassNames = new String[newLen];
                if (threadInfos != null) {
                    System.arraycopy(threadInfos, 0, newInfos, 0, threadInfos.length);
                    System.arraycopy(threadNames, 0, newNames, 0, threadNames.length);
                    System.arraycopy(threadClassNames, 0, newClassNames, 0, threadNames.length);
                }
                threadInfos = newInfos;
                threadNames = newNames;
                threadClassNames = newClassNames;
                threadInfosLastIdx = threadId;
            }
            ThreadInfo.threadInfos[threadId] = new ThreadInfo(threadId);
            ThreadInfo.threadNames[threadId] = threadName;
            ThreadInfo.threadClassNames[threadId] = threadClassName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void reset() {
            ThreadInfo.beginTrans(true);
            try {
                threadInfos = null;
                threadNames = null;
                threadInfosLastIdx = -1;
            }
            finally {
                ThreadInfo.endTrans();
            }
        }

        boolean isInRoot() {
            return this.inRoot > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TimedCPUCCTNode peek() {
            TimedCPUCCTNode[] timedCPUCCTNodeArray = this.stack;
            synchronized (this.stack) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.stackTopIdx > -1 ? this.stack[this.stackTopIdx] : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TimedCPUCCTNode pop() {
            TimedCPUCCTNode node = null;
            TimedCPUCCTNode[] timedCPUCCTNodeArray = this.stack;
            synchronized (this.stack) {
                if (this.stackTopIdx >= 0) {
                    node = this.stack[this.stackTopIdx];
                    this.stack[this.stackTopIdx] = null;
                    --this.stackTopIdx;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return node;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void push(TimedCPUCCTNode node) {
            TimedCPUCCTNode[] timedCPUCCTNodeArray = this.stack;
            synchronized (this.stack) {
                ++this.stackTopIdx;
                if (this.stackTopIdx >= this.stack.length) {
                    this.increaseStack();
                }
                this.stack[this.stackTopIdx] = node;
                node.addNCalls(1);
                ++this.totalNInv;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private void increaseStack() {
            TimedCPUCCTNode[] newStack = new TimedCPUCCTNode[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }

        static {
            transaction = new TransactionalSupport();
            ThreadInfo.reset();
        }
    }
}

