/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.marking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;

public class HierarchicalMark
extends Mark {
    public static final HierarchicalMark DEFAULT = new HierarchicalMark("DEFAULT", "Overall", null);
    private HierarchicalMark parent;
    private final Set children;
    private final Set rootPath;

    public HierarchicalMark(String label, String description, HierarchicalMark parent) {
        super(label, description, parent == null || parent == DEFAULT);
        this.parent = parent == null ? DEFAULT : parent;
        this.rootPath = !this.isDefault ? new LinkedHashSet(this.parent.getRootPath()) : new HashSet();
        this.rootPath.add(label);
        this.children = new HashSet();
        if (this.parent != null && this.parent != DEFAULT) {
            this.parent.addChild(this);
        }
    }

    public Set getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    public Collection getLabels() {
        return new ArrayList(this.rootPath);
    }

    public HierarchicalMark getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null || this.parent == DEFAULT;
    }

    public Set getRootPath() {
        return this.rootPath;
    }

    public Object clone() {
        return new HierarchicalMark(this.label, this.description, this.parent);
    }

    protected void addChild(HierarchicalMark child) {
        this.children.add(child);
    }
}

