/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.OperationValidator;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleProvider;
import org.openide.modules.ModuleInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationContainerImpl<Support> {
    private OperationContainer<Support> container;
    private List<OperationContainer.OperationInfo<Support>> operations = new ArrayList<OperationContainer.OperationInfo<Support>>();
    private Collection<OperationContainer.OperationInfo<Support>> affectedEagers = new HashSet<OperationContainer.OperationInfo<Support>>();
    private OperationType type;

    private OperationContainerImpl() {
    }

    public static OperationContainerImpl<InstallSupport> createForInstall() {
        return new OperationContainerImpl<InstallSupport>(OperationType.INSTALL);
    }

    public static OperationContainerImpl<InstallSupport> createForUpdate() {
        return new OperationContainerImpl<InstallSupport>(OperationType.UPDATE);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectInstall() {
        return new OperationContainerImpl<OperationSupport>(OperationType.INSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectUpdate() {
        return new OperationContainerImpl<OperationSupport>(OperationType.UPDATE);
    }

    public static OperationContainerImpl<OperationSupport> createForUninstall() {
        return new OperationContainerImpl<OperationSupport>(OperationType.UNINSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectUninstall() {
        return new OperationContainerImpl<OperationSupport>(OperationType.DIRECT_UNINSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForEnable() {
        return new OperationContainerImpl<OperationSupport>(OperationType.ENABLE);
    }

    public static OperationContainerImpl<OperationSupport> createForDisable() {
        return new OperationContainerImpl<OperationSupport>(OperationType.DISABLE);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectDisable() {
        return new OperationContainerImpl<OperationSupport>(OperationType.DIRECT_DISABLE);
    }

    public static OperationContainerImpl<OperationSupport> createForInstallNativeComponent() {
        return new OperationContainerImpl<OperationSupport>(OperationType.CUSTOM_INSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForUninstallNativeComponent() {
        return new OperationContainerImpl<OperationSupport>(OperationType.CUSTOM_INSTALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContainer.OperationInfo<Support> add(UpdateUnit updateUnit, UpdateElement updateElement) throws IllegalArgumentException {
        OperationContainer.OperationInfo operationInfo = null;
        boolean bl = this.isValid(updateUnit, updateElement);
        if (!bl) {
            throw new IllegalArgumentException("Invalid " + updateElement.getCodeName() + " for operation " + (Object)((Object)this.type));
        }
        if (UpdateUnitFactory.getDefault().isScheduledForRestart(updateElement)) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, updateElement + " is scheduled for restart IDE.");
            throw new IllegalArgumentException(updateElement + " is scheduled for restart IDE.");
        }
        if (bl) {
            switch (this.type) {
                case UNINSTALL: 
                case DIRECT_UNINSTALL: 
                case CUSTOM_UNINSTALL: 
                case ENABLE: 
                case DISABLE: 
                case DIRECT_DISABLE: {
                    if (updateUnit.getInstalled() == updateElement) break;
                    throw new IllegalArgumentException(updateUnit.getInstalled() + " and " + updateElement + " must be same for operation " + (Object)((Object)this.type));
                }
                case INSTALL: 
                case UPDATE: 
                case CUSTOM_INSTALL: {
                    if (updateUnit.getInstalled() != updateElement) break;
                    throw new IllegalArgumentException(updateUnit.getInstalled() + " and " + updateElement + " cannot be same for operation " + (Object)((Object)this.type));
                }
                default: {
                    assert (false) : "Unknown type of operation " + (Object)((Object)this.type);
                    break;
                }
            }
        }
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            if (!this.contains(updateUnit, updateElement)) {
                operationInfo = Trampoline.API.createOperationInfo(new OperationInfoImpl(updateUnit, updateElement));
                this.operations.add(operationInfo);
            }
        }
        return operationInfo;
    }

    public boolean remove(UpdateElement updateElement) {
        OperationContainer.OperationInfo<Support> operationInfo = this.find(updateElement);
        if (operationInfo != null) {
            this.remove(operationInfo);
        }
        return operationInfo != null;
    }

    public boolean contains(UpdateElement updateElement) {
        return this.find(updateElement) != null;
    }

    public void setOperationContainer(OperationContainer<Support> operationContainer) {
        this.container = operationContainer;
    }

    private OperationContainer.OperationInfo<Support> find(UpdateElement updateElement) {
        OperationContainer.OperationInfo<Support> operationInfo = null;
        for (OperationContainer.OperationInfo<Support> operationInfo2 : this.listAll()) {
            if (!operationInfo2.getUpdateElement().equals(updateElement)) continue;
            operationInfo = operationInfo2;
            break;
        }
        return operationInfo;
    }

    private boolean contains(UpdateUnit updateUnit, UpdateElement updateElement) {
        List<OperationContainer.OperationInfo<Support>> list = this.operations;
        for (OperationContainer.OperationInfo<Support> operationInfo : list) {
            if (!operationInfo.getUpdateElement().equals(updateElement) && !operationInfo.getUpdateUnit().equals(updateUnit)) continue;
            return true;
        }
        return false;
    }

    public List<OperationContainer.OperationInfo<Support>> listAll() {
        return new ArrayList<OperationContainer.OperationInfo<Support>>(this.operations);
    }

    public synchronized List<OperationContainer.OperationInfo<Support>> listAllWithPossibleEager() {
        if (this.type == OperationType.INSTALL) {
            HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
            for (OperationContainer.OperationInfo<Support> object : this.operations) {
                hashSet.add(object.getUpdateElement());
            }
            for (UpdateElement updateElement : UpdateManagerImpl.getInstance().getAvailableEagers()) {
                OperationContainer.OperationInfo<Support> operationInfo;
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                assert (updateElementImpl instanceof ModuleUpdateElementImpl) : updateElement + " must instanceof ModuleUpdateElementImpl";
                ModuleUpdateElementImpl moduleUpdateElementImpl = (ModuleUpdateElementImpl)updateElementImpl;
                ModuleInfo moduleInfo = moduleUpdateElementImpl.getModuleInfo();
                HashSet<ModuleInfo> hashSet2 = new HashSet<ModuleInfo>(InstalledModuleProvider.getInstalledModules().values());
                Set<UpdateElement> set = Utilities.findRequiredModules(moduleInfo.getDependencies(), hashSet2);
                if (set.isEmpty() || !hashSet.containsAll(set) || hashSet.contains(updateElement) || (operationInfo = this.add(updateElement.getUpdateUnit(), updateElement)) == null) continue;
                this.affectedEagers.add(operationInfo);
            }
        }
        return new ArrayList<OperationContainer.OperationInfo<Support>>(this.operations);
    }

    public List<OperationContainer.OperationInfo<Support>> listInvalid() {
        ArrayList<OperationContainer.OperationInfo<Support>> arrayList = new ArrayList<OperationContainer.OperationInfo<Support>>();
        List<OperationContainer.OperationInfo<Support>> list = this.listAll();
        for (OperationContainer.OperationInfo<Support> operationInfo : list) {
            if (this.isValid(operationInfo.getUpdateUnit(), operationInfo.getUpdateElement())) continue;
            arrayList.add(operationInfo);
        }
        return arrayList;
    }

    public boolean isValid(UpdateUnit updateUnit, UpdateElement updateElement) {
        if (updateElement == null) {
            throw new IllegalArgumentException("UpdateElement cannot be null for UpdateUnit " + updateUnit);
        }
        if (updateUnit == null) {
            throw new IllegalArgumentException("UpdateUnit cannot be null for UpdateElement " + updateElement);
        }
        boolean bl = false;
        switch (this.type) {
            case INSTALL: {
                bl = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
                if (bl || this.operations.size() <= 0) break;
                bl = OperationValidator.isValidOperation(OperationType.UPDATE, updateUnit, updateElement);
                break;
            }
            case UPDATE: {
                bl = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
                if (bl || this.operations.size() <= 0) break;
                bl = OperationValidator.isValidOperation(OperationType.INSTALL, updateUnit, updateElement);
                break;
            }
            default: {
                bl = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(OperationContainer.OperationInfo operationInfo) {
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            this.operations.remove(operationInfo);
            this.operations.removeAll(this.affectedEagers);
            this.affectedEagers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll() {
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            this.operations.clear();
            this.affectedEagers.clear();
        }
    }

    private OperationContainerImpl(OperationType operationType) {
        this.type = operationType;
    }

    public OperationType getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        INSTALL,
        UNINSTALL,
        DIRECT_UNINSTALL,
        UPDATE,
        REVERT,
        ENABLE,
        DIRECT_DISABLE,
        DISABLE,
        CUSTOM_INSTALL,
        CUSTOM_UNINSTALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OperationInfoImpl<Support> {
        private final UpdateElement updateElement;
        private final UpdateUnit uUnit;

        private OperationInfoImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            this.updateElement = updateElement;
            this.uUnit = updateUnit;
        }

        public UpdateElement getUpdateElement() {
            return this.updateElement;
        }

        public UpdateUnit getUpdateUnit() {
            return this.uUnit;
        }

        public List<UpdateElement> getRequiredElements() {
            ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
            for (OperationContainer.OperationInfo operationInfo : OperationContainerImpl.this.listAll()) {
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(operationInfo.getUpdateElement());
                List<ModuleInfo> list = updateElementImpl.getModuleInfos();
                assert (list != null) : "ModuleInfo for UpdateElement " + operationInfo.getUpdateElement() + " found.";
                arrayList.addAll(list);
            }
            return OperationValidator.getRequiredElements(OperationContainerImpl.this.type, this.getUpdateElement(), arrayList);
        }

        public Set<String> getBrokenDependencies() {
            ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
            for (OperationContainer.OperationInfo operationInfo : OperationContainerImpl.this.listAll()) {
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(operationInfo.getUpdateElement());
                List<ModuleInfo> list = updateElementImpl.getModuleInfos();
                assert (list != null) : "ModuleInfo for UpdateElement " + operationInfo.getUpdateElement() + " found.";
                arrayList.addAll(list);
            }
            Set<String> set = null;
            switch (OperationContainerImpl.this.type) {
                case ENABLE: {
                    set = Utilities.getBrokenDependenciesInInstalledModules(this.getUpdateElement());
                    break;
                }
                case UNINSTALL: 
                case DIRECT_UNINSTALL: 
                case CUSTOM_UNINSTALL: 
                case DISABLE: 
                case DIRECT_DISABLE: 
                case INSTALL: 
                case UPDATE: 
                case CUSTOM_INSTALL: {
                    set = Utilities.getBrokenDependencies(this.getUpdateElement(), arrayList);
                    break;
                }
                default: {
                    assert (false) : "Unknown type of operation " + (Object)((Object)OperationContainerImpl.access$100(OperationContainerImpl.this));
                    break;
                }
            }
            return set;
        }
    }
}

