/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.openide.awt.Toolbar;
import org.openide.xml.XMLUtil;

public class ToolbarConstraints {
    static final long serialVersionUID = 3065774641403311880L;
    static final int LEFT_ANCHOR = -1;
    static final int NO_ANCHOR = 0;
    public static final String PREFERRED_SIZE = "preferredSize";
    private String name;
    private int position;
    private int anchor;
    private boolean visible;
    private Vector<ToolbarRow> ownRows;
    private Vector<ToolbarConstraints> prevBars;
    private Vector<ToolbarConstraints> nextBars;
    private int prevEnd;
    private int nextBeg;
    private int prevBeg;
    private int nextEnd;
    private Dimension prefSize;
    private Rectangle bounds;
    private ToolbarConfiguration toolbarConfig;
    private int rowCount;
    private int prefLastWidth;
    private int lastRowIndex;
    private int initialIndexInRow;
    private PropertyChangeSupport propSupport;

    ToolbarConstraints(ToolbarConfiguration toolbarConfiguration, String string, Integer n, Boolean bl) {
        this(toolbarConfiguration, string, n, bl, -1);
    }

    ToolbarConstraints(ToolbarConfiguration toolbarConfiguration, String string, Integer n, Boolean bl, int n2) {
        this.toolbarConfig = toolbarConfiguration;
        this.name = string;
        if (n == null) {
            this.position = 0;
            this.anchor = -1;
            this.initialIndexInRow = n2;
        } else {
            this.position = n;
            this.anchor = 0;
            this.initialIndexInRow = -1;
        }
        this.visible = bl;
        this.prefSize = new Dimension();
        this.rowCount = 0;
        this.prefLastWidth = 0;
        this.bounds = new Rectangle();
        this.initValues();
    }

    void initValues() {
        this.ownRows = new Vector();
        this.prevBars = new Vector();
        this.nextBars = new Vector();
        this.resetPrev();
        this.resetNext();
    }

    void checkNextPosition(Integer n, Boolean bl) {
        if (n == null) {
            this.position = 0;
            this.anchor = -1;
        } else {
            this.position = this.anchor == 0 ? (this.position + n) / 2 : n;
            this.anchor = 0;
        }
        this.visible = this.visible || bl != false;
    }

    String getName() {
        return this.name;
    }

    int getAnchor() {
        return this.anchor;
    }

    void setAnchor(int n) {
        this.anchor = n;
    }

    boolean isVisible() {
        return this.visible;
    }

    void setVisible(boolean bl) {
        this.visible = bl;
    }

    int getPosition() {
        return this.position;
    }

    void setPosition(int n) {
        this.position = n;
    }

    int getWidth() {
        return this.prefSize.width;
    }

    int getRowCount() {
        return this.rowCount;
    }

    int checkInitialIndexInRow() {
        int n = this.initialIndexInRow;
        this.initialIndexInRow = -1;
        return n;
    }

    Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    boolean destroy() {
        this.lastRowIndex = this.rowIndex();
        this.rowCount = this.ownRows.size();
        boolean bl = false;
        for (ToolbarRow toolbarRow : this.ownRows) {
            toolbarRow.removeToolbar(this);
            bl = bl || toolbarRow.isEmpty();
        }
        this.initValues();
        return bl;
    }

    void addOwnRow(ToolbarRow toolbarRow) {
        this.ownRows.add(toolbarRow);
    }

    void addPrevBar(ToolbarConstraints toolbarConstraints) {
        if (toolbarConstraints == null) {
            return;
        }
        this.prevBars.add(toolbarConstraints);
        if (this.nextBars.contains(toolbarConstraints)) {
            this.nextBars.remove(toolbarConstraints);
        }
    }

    void addNextBar(ToolbarConstraints toolbarConstraints) {
        if (toolbarConstraints == null) {
            return;
        }
        this.nextBars.add(toolbarConstraints);
        if (this.prevBars.contains(toolbarConstraints)) {
            this.prevBars.remove(toolbarConstraints);
        }
    }

    void removePrevBar(ToolbarConstraints toolbarConstraints) {
        if (toolbarConstraints == null) {
            return;
        }
        this.prevBars.remove(toolbarConstraints);
    }

    void removeNextBar(ToolbarConstraints toolbarConstraints) {
        if (toolbarConstraints == null) {
            return;
        }
        this.nextBars.remove(toolbarConstraints);
    }

    void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.prefSize;
        this.prefSize = dimension;
        if (!this.toolbarConfig.isTogglingIconSize()) {
            this.rowCount = Toolbar.rowCount((int)this.prefSize.height);
        }
        if (this.ownRows.isEmpty()) {
            return;
        }
        if (this.visible && !this.toolbarConfig.isTogglingIconSize()) {
            ToolbarRow toolbarRow;
            boolean bl = false;
            while (this.rowCount < this.ownRows.size()) {
                toolbarRow = this.ownRows.lastElement();
                toolbarRow.removeToolbar(this);
                this.ownRows.remove(toolbarRow);
                bl = bl || toolbarRow.isEmpty();
            }
            if (bl) {
                this.toolbarConfig.checkToolbarRows();
            }
            while (this.rowCount > this.ownRows.size()) {
                toolbarRow = this.ownRows.lastElement();
                ToolbarRow toolbarRow2 = toolbarRow.getNextRow();
                if (toolbarRow2 == null) {
                    toolbarRow2 = this.toolbarConfig.createLastRow();
                }
                toolbarRow2.addToolbar(this, this.position);
            }
        }
        this.updatePosition();
        this.propSupport.firePropertyChange(PREFERRED_SIZE, dimension2, this.prefSize);
    }

    int rowIndex() {
        if (!this.visible) {
            return this.toolbarConfig.getRowCount();
        }
        if (this.ownRows.isEmpty()) {
            return this.lastRowIndex;
        }
        return this.toolbarConfig.rowIndex(this.ownRows.firstElement());
    }

    boolean isAlone() {
        for (ToolbarRow toolbarRow : this.ownRows) {
            if (toolbarRow.toolbarCount() == 1) continue;
            return false;
        }
        return true;
    }

    void updatePreferredSize(Dimension dimension) {
        if (!this.prefSize.equals(dimension)) {
            this.setPreferredSize(dimension);
        }
    }

    void updateBounds() {
        if (this.ownRows.size() > 0) {
            Iterator<ToolbarRow> iterator = this.ownRows.iterator();
            ToolbarRow toolbarRow = iterator.next();
            int n = toolbarRow.getPreferredHeight();
            while (iterator.hasNext()) {
                n += iterator.next().getPreferredHeight() + 1;
            }
            this.bounds = new Rectangle(this.position, this.toolbarConfig.getRowVertLocation(toolbarRow), this.nextBeg - this.position - 1, n);
        } else {
            this.bounds = new Rectangle(this.position, 0, 0, 0);
        }
    }

    void updatePosition() {
        this.updatePrev();
        if (this.anchor == 0) {
            if (this.position < this.prevEnd + 1) {
                this.position = this.prevEnd + 1;
                this.anchor = -1;
            }
        } else {
            this.position = this.prevEnd + 1;
        }
        this.updatePrevBars();
        this.updateNextBars();
        this.updateBounds();
        this.updatePrefWidth();
    }

    void updatePrevPosition() {
        for (ToolbarConstraints toolbarConstraints : this.prevBars) {
            toolbarConstraints.updatePosition();
        }
    }

    void updatePrevBars() {
        for (ToolbarConstraints toolbarConstraints : this.prevBars) {
            toolbarConstraints.updateNext();
        }
    }

    void updateNextBars() {
        Iterator<ToolbarConstraints> iterator = this.nextBars.iterator();
        if (!iterator.hasNext()) {
            this.resetNext();
            this.updatePrefWidth();
        }
        while (iterator.hasNext()) {
            ToolbarConstraints toolbarConstraints = iterator.next();
            if (toolbarConstraints == this) continue;
            toolbarConstraints.updatePosition();
        }
    }

    void updatePrefWidth() {
        if (this.nextBars.size() == 0) {
            this.prefLastWidth = this.getPosition() + this.getWidth() + 1;
            this.toolbarConfig.updatePrefWidth();
        }
    }

    int getPrefWidth() {
        return this.prefLastWidth;
    }

    int getPrefHeight() {
        return this.prefSize.height;
    }

    void updateNext() {
        this.resetNext();
        for (ToolbarConstraints toolbarConstraints : this.nextBars) {
            int n = toolbarConstraints.getPosition();
            this.nextBeg = Math.min(this.nextBeg, n);
            this.nextEnd = Math.min(this.nextEnd, n + toolbarConstraints.getWidth());
        }
        this.updateBounds();
    }

    void updatePrev() {
        this.resetPrev();
        for (ToolbarConstraints toolbarConstraints : this.prevBars) {
            int n = toolbarConstraints.getPosition();
            this.prevBeg = Math.max(this.prevBeg, n);
            this.prevEnd = Math.max(this.prevEnd, n + toolbarConstraints.getWidth());
        }
    }

    void resetPrev() {
        this.prevBeg = 0;
        this.prevEnd = 0;
    }

    void resetNext() {
        this.nextBeg = Integer.MAX_VALUE;
        this.nextEnd = Integer.MAX_VALUE;
    }

    void moveLeft(int n) {
        int n2;
        this.position = n2 = this.position - n;
        this.anchor = 0;
        if (n2 > this.prevEnd) {
            this.setAnchorTo(0, this.nextBars);
        } else if (ToolbarConstraints.canSwitchLeft(this.getPosition(), this.getWidth(), this.prevBeg, this.prevEnd - this.prevBeg)) {
            this.switchToolbarLeft();
        }
    }

    void moveRight(int n) {
        int n2 = this.position + n;
        int n3 = n2 + this.getWidth();
        if (n3 < this.nextBeg) {
            this.anchor = 0;
            this.position = n2;
        } else if (ToolbarConstraints.canSwitchRight(n2, this.getWidth(), this.nextBeg, this.nextEnd - this.nextBeg)) {
            this.position = n2;
            this.anchor = 0;
            this.switchToolbarRight();
        } else {
            this.position = this.nextBeg - this.getWidth() - 1;
            this.anchor = 0;
        }
        this.updatePrevPosition();
    }

    void moveLeft2End(int n) {
        int n2 = this.position - n;
        this.anchor = 0;
        if (n2 < this.prevEnd + 1) {
            n2 = this.prevEnd + 1;
        }
        this.move2End(n2 - this.position);
    }

    void moveRight2End(int n) {
        this.move2End(n);
    }

    void move2End(int n) {
        this.position += n;
        for (ToolbarConstraints toolbarConstraints : this.nextBars) {
            toolbarConstraints.move2End(n);
        }
    }

    void setAnchorTo(int n, Vector vector) {
        for (ToolbarConstraints toolbarConstraints : vector) {
            toolbarConstraints.setAnchor(n);
        }
    }

    void switchToolbarLeft() {
        for (ToolbarRow toolbarRow : this.ownRows) {
            toolbarRow.trySwitchLeft(this);
        }
    }

    void switchToolbarRight() {
        for (ToolbarRow toolbarRow : this.ownRows) {
            toolbarRow.trySwitchRight(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport != null) {
            this.propSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    static boolean canSwitchLeft(int n, int n2, int n3, int n4) {
        return n < n3;
    }

    static boolean canSwitchRight(int n, int n2, int n3, int n4) {
        return n > n3;
    }

    static class WritableToolbar {
        String name;
        int position;
        int anchor;
        boolean visible;

        public WritableToolbar(ToolbarConstraints toolbarConstraints) {
            this.name = toolbarConstraints.getName();
            this.position = toolbarConstraints.getPosition();
            this.anchor = toolbarConstraints.getAnchor();
            this.visible = toolbarConstraints.isVisible();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.name;
            try {
                string = XMLUtil.toAttributeValue((String)this.name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringBuffer.append("    <").append("Toolbar");
            stringBuffer.append(" ").append("name").append("=\"").append(string).append("\"");
            if (this.anchor == 0 || !this.visible) {
                stringBuffer.append(" ").append("position").append("=\"").append(this.position).append("\"");
            }
            if (!this.visible) {
                stringBuffer.append(" ").append("visible").append("=\"").append(this.visible).append("\"");
            }
            stringBuffer.append(" />\n");
            return stringBuffer.toString();
        }
    }
}

