/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui.about;

import com.sun.tools.visualvm.core.ui.DesktopUtils;
import com.sun.tools.visualvm.modules.appui.about.AboutDialog;
import com.sun.tools.visualvm.modules.appui.about.TextBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AboutDialogControls
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(AboutDialogControls.class.getName());
    private JLabel buildIDLabel;
    private JButton closeButton;
    private JButton detailsButton;
    private JButton logfileButton;
    private JPanel buttonsContainer;

    AboutDialogControls() {
        this.initComponents();
    }

    JButton getDefaultButton() {
        return this.closeButton;
    }

    void updateAppearance() {
        int buttonsCount = 1;
        String buildID = AboutDialog.getInstance().getBuildID();
        String details = AboutDialog.getInstance().getDetails();
        String logfile = AboutDialog.getInstance().getLogfile();
        this.buildIDLabel.setVisible(buildID != null);
        if (buildID != null) {
            this.buildIDLabel.setText(buildID);
        }
        this.detailsButton.setVisible(details != null);
        if (details != null) {
            ++buttonsCount;
        }
        this.logfileButton.setVisible(logfile != null);
        if (logfile != null) {
            ++buttonsCount;
        }
        this.buttonsContainer.removeAll();
        this.buttonsContainer.setLayout(new GridLayout(1, buttonsCount, 6, 0));
        if (details != null) {
            this.buttonsContainer.add(this.detailsButton);
        }
        if (logfile != null) {
            this.buttonsContainer.add(this.logfileButton);
        }
        this.buttonsContainer.add(this.closeButton);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.buildIDLabel = new JLabel();
        this.buildIDLabel.setFont(this.buildIDLabel.getFont().deriveFont(1));
        this.buildIDLabel.setEnabled(false);
        this.detailsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.detailsButton, (String)NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Details"));
        this.detailsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AboutDialogControls.class, (String)"DESCR_Details"));
        this.detailsButton.setDefaultCapable(false);
        this.detailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialogControls.this.showDetails();
            }
        });
        this.logfileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.logfileButton, (String)NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Logfile"));
        this.logfileButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AboutDialogControls.class, (String)"DESCR_Logfile"));
        this.logfileButton.setDefaultCapable(false);
        this.logfileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialogControls.this.showLogfile();
            }
        });
        this.closeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Close"));
        this.closeButton.setDefaultCapable(true);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AboutDialog.getInstance().close();
                    }
                });
            }
        });
        this.buttonsContainer = new JPanel(new GridLayout(1, 3, 6, 0));
        this.buttonsContainer.add(this.detailsButton);
        this.buttonsContainer.add(this.logfileButton);
        this.buttonsContainer.add(this.closeButton);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 7, 10));
        this.add((Component)this.buildIDLabel, "West");
        this.add((Component)this.buttonsContainer, "East");
    }

    private void showDetails() {
        TextBrowser.getInstance().setCaption(NbBundle.getMessage(AboutDialogControls.class, (String)"TITLE_Details"));
        TextBrowser.getInstance().setPreferredBrowserSize(new Dimension(450, 250));
        TextBrowser.getInstance().showHTMLText(AboutDialog.getInstance().getDetails());
    }

    private void showLogfile() {
        Runnable logfileDisplayer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AboutDialogControls.this.logfileButton.setEnabled(false);
                File logfile = new File(AboutDialog.getInstance().getLogfile());
                try {
                    if (!(logfile.exists() && logfile.isFile() && logfile.canRead())) {
                        JOptionPane.showMessageDialog(AboutDialog.getInstance().getDialog(), NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Cannot_open_the_logfile", (Object)logfile.getAbsolutePath()), NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Error"), 0);
                        return;
                    }
                    TextBrowser.getInstance().setCaption(NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Logfile_Viewer_", (Object)logfile.getAbsolutePath()));
                    if (DesktopUtils.isOpenAvailable()) {
                        try {
                            DesktopUtils.open((File)logfile);
                        }
                        catch (Exception ex) {
                            AboutDialogControls.this.showLogfileInBrowser(logfile);
                            LOGGER.throwing(AboutDialogControls.class.getName(), "showLogFile", ex);
                        }
                    } else {
                        AboutDialogControls.this.showLogfileInBrowser(logfile);
                    }
                }
                catch (Exception e) {
                    LOGGER.throwing(AboutDialogControls.class.getName(), "showLogFile", e);
                    JOptionPane.showMessageDialog(AboutDialog.getInstance().getDialog(), NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Cannot_open_the_logfile", (Object)logfile.getAbsolutePath()), NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Error"), 0);
                }
                finally {
                    AboutDialogControls.this.logfileButton.setEnabled(true);
                }
            }
        };
        new Thread(logfileDisplayer).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLogfileInBrowser(File logfile) throws Exception {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(logfile, "r");
            final byte[] buffer = new byte[(int)raf.length()];
            raf.readFully(buffer);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TextBrowser.getInstance().setPreferredBrowserSize(new Dimension(700, 550));
                    TextBrowser.getInstance().showCodeText(new String(buffer));
                }
            });
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }
}

