/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui.about;

import com.sun.tools.visualvm.modules.appui.about.AboutDialog;
import com.sun.tools.visualvm.modules.appui.about.AboutDialogControls;
import com.sun.tools.visualvm.modules.appui.about.TextViewerComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TextBrowser {
    private static TextBrowser instance;
    private JDialog dialog;
    private JComponent contentPane;
    private JButton closeButton;
    private TextViewerComponent textDisplayer;
    private HTMLTextArea htmlTextDisplayer;
    private JScrollPane displayerScrollPane;
    private Dimension preferredSize = new Dimension(400, 300);

    static synchronized TextBrowser getInstance() {
        if (instance == null) {
            instance = new TextBrowser();
            instance.initComponents();
        }
        return instance;
    }

    void setCaption(String caption) {
        this.dialog.setTitle(caption);
    }

    void setPreferredBrowserSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    void showCodeText(String text) {
        this.textDisplayer.setText(text);
        this.displayerScrollPane.setViewportView(this.textDisplayer);
        try {
            this.textDisplayer.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.displayerScrollPane.setPreferredSize(this.preferredSize);
        this.dialog.pack();
        this.closeButton.requestFocusInWindow();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    void showHTMLText(String text) {
        this.htmlTextDisplayer.setText(text);
        this.displayerScrollPane.setViewportView((Component)this.htmlTextDisplayer);
        try {
            this.htmlTextDisplayer.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.displayerScrollPane.setPreferredSize(this.preferredSize);
        this.dialog.pack();
        this.closeButton.requestFocusInWindow();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private TextBrowser() {
    }

    private void initComponents() {
        this.dialog = new JDialog(AboutDialog.getInstance().getDialog(), "", true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                TextBrowser.this.cleanup();
            }
        });
        this.contentPane = (JComponent)this.dialog.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "CLOSE_ACTION");
        this.contentPane.getActionMap().put("CLOSE_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TextBrowser.this.close();
            }
        });
        this.textDisplayer = new TextViewerComponent();
        this.htmlTextDisplayer = new HTMLTextArea();
        this.displayerScrollPane = new JScrollPane(20, 30);
        this.textDisplayer.setForeground(this.htmlTextDisplayer.getForeground());
        this.textDisplayer.setBackground(this.htmlTextDisplayer.getBackground());
        this.textDisplayer.setSelectionColor(this.htmlTextDisplayer.getSelectionColor());
        this.textDisplayer.setSelectedTextColor(this.htmlTextDisplayer.getSelectedTextColor());
        this.closeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(AboutDialogControls.class, (String)"LBL_Close"));
        this.closeButton.setDefaultCapable(true);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TextBrowser.this.close();
                    }
                });
            }
        });
        JPanel buttonsContainer = new JPanel(new BorderLayout());
        buttonsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 6, 10));
        buttonsContainer.add((Component)this.closeButton, "East");
        this.contentPane.add((Component)this.displayerScrollPane, "Center");
        this.contentPane.add((Component)buttonsContainer, "South");
        this.dialog.getRootPane().setDefaultButton(this.closeButton);
        this.dialog.setResizable(true);
        this.dialog.setDefaultCloseOperation(2);
    }

    private void cleanup() {
        this.displayerScrollPane.getViewport().removeAll();
        this.textDisplayer.setText("");
        this.htmlTextDisplayer.setText("");
    }
}

