#!/bin/sh

# First, change the setting on the running system:
if [ -r proc/sys/vm/mmap_min_addr ]; then
  if [ "$(cat proc/sys/vm/mmap_min_addr)" = "0" ]; then
    # Set page 4096 as the first mmap()able page:
    echo 4096 > proc/sys/vm/mmap_min_addr
    if [ "$(cat proc/sys/vm/mmap_min_addr)" != "0" ]; then
      echo "Kernel $(uname -r) mmap_min_addr is set to $(cat proc/sys/vm/mmap_min_addr)"
    else
      echo "WARNING: mmap_min_addr could not be set to 4096, and remains set to 0!"
    fi
  fi
else
  echo "WARNING:  mmap_min_addr tunable is not available in this kernel."
  echo "          page 0 mapping by userspace may still be possible."
fi

# Add the setting to /etc/sysctl.conf, unless there's already a setting:
if ! grep -q "vm.mmap_min_addr*.=" etc/sysctl.conf 2> /dev/null ; then
  echo "vm.mmap_min_addr = 4096" >> etc/sysctl.conf
fi

( cd etc/rc.d/rc4.d ; rm -rf S01_mmap_min_addr )
( cd etc/rc.d/rc4.d ; ln -sf ../init.d/rc.mmap_min_addr S01_mmap_min_addr )
( cd etc/rc.d/rc3.d ; rm -rf S01_mmap_min_addr )
( cd etc/rc.d/rc3.d ; ln -sf ../init.d/rc.mmap_min_addr S01_mmap_min_addr )
( cd etc/rc.d ; rm -rf rc.mmap_min_addr )
( cd etc/rc.d ; ln -sf init.d/rc.mmap_min_addr rc.mmap_min_addr )
