/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLMapElement.h"

#include <wtf/GetPtr.h>

#include "HTMLCollection.h"
#include "HTMLMapElement.h"
#include "JSHTMLCollection.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLMapElement)

/* Hash table */

static const HashTableValue JSHTMLMapElementTableValues[4] =
{
    { "areas", DontDelete|ReadOnly, (intptr_t)jsHTMLMapElementAreas, (intptr_t)0 },
    { "name", DontDelete, (intptr_t)jsHTMLMapElementName, (intptr_t)setJSHTMLMapElementName },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLMapElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMapElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLMapElementTableValues, 0 };
#else
    { 9, 7, JSHTMLMapElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLMapElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMapElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLMapElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLMapElementConstructorTableValues, 0 };
#endif

class JSHTMLMapElementConstructor : public DOMObject {
public:
    JSHTMLMapElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLMapElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLMapElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLMapElementConstructor::s_info = { "HTMLMapElementConstructor", 0, &JSHTMLMapElementConstructorTable, 0 };

bool JSHTMLMapElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMapElementConstructor, DOMObject>(exec, &JSHTMLMapElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMapElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMapElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLMapElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLMapElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLMapElementPrototype::s_info = { "HTMLMapElementPrototype", 0, &JSHTMLMapElementPrototypeTable, 0 };

JSObject* JSHTMLMapElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLMapElement>(exec);
}

const ClassInfo JSHTMLMapElement::s_info = { "HTMLMapElement", &JSHTMLElement::s_info, &JSHTMLMapElementTable, 0 };

JSHTMLMapElement::JSHTMLMapElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLMapElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLMapElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLMapElementPrototype(JSHTMLMapElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLMapElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMapElement, Base>(exec, &JSHTMLMapElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLMapElementAreas(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMapElement* imp = static_cast<HTMLMapElement*>(static_cast<JSHTMLMapElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->areas()));
}

JSValuePtr jsHTMLMapElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMapElement* imp = static_cast<HTMLMapElement*>(static_cast<JSHTMLMapElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->name());
}

JSValuePtr jsHTMLMapElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLMapElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLMapElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLMapElement, Base>(exec, propertyName, value, &JSHTMLMapElementTable, this, slot);
}

void setJSHTMLMapElementName(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLMapElement* imp = static_cast<HTMLMapElement*>(static_cast<JSHTMLMapElement*>(thisObject)->impl());
    imp->setName(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLMapElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLMapElementConstructor>(exec);
}


}
