/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.platform;

import info.aduna.platform.DefaultPlatform;
import info.aduna.platform.Platform;
import info.aduna.platform.PlatformBase;
import info.aduna.platform.support.MacOSXPlatform;
import info.aduna.platform.support.PosixGnomePlatform;
import info.aduna.platform.support.PosixKDEPlatform;
import info.aduna.platform.support.PosixPlatform;
import info.aduna.platform.support.WindowsPlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformFactory {
    private static PlatformFactory sharedInstance;
    public final Platform platform;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static PlatformFactory getInstance() {
        if (sharedInstance == null) {
            sharedInstance = new PlatformFactory();
        }
        return sharedInstance;
    }

    public static Platform getPlatform() {
        return PlatformFactory.getInstance().platform;
    }

    private PlatformFactory() {
        this.platform = this.createPlatform();
    }

    private Platform createPlatform() {
        PlatformBase platform;
        try {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                osName = osName.toLowerCase();
                this.logger.debug("os.name = {}", (Object)osName);
                if (osName.contains("windows")) {
                    this.logger.debug("Detected Windows platform");
                    platform = new WindowsPlatform();
                } else if (osName.contains("solaris") || osName.contains("sunos") || osName.contains("linux") || osName.contains("hp-ux")) {
                    if (this.isGnome()) {
                        this.logger.debug("Detected Gnome window manager on Posix platform");
                        platform = new PosixGnomePlatform();
                    } else if (this.isKDE()) {
                        this.logger.debug("Detected KDE window manager on Posix platform");
                        platform = new PosixKDEPlatform();
                    } else {
                        this.logger.debug("Detected Posix platform");
                        platform = new PosixPlatform();
                    }
                } else if (osName.contains("mac os x") || osName.contains("macos") || osName.contains("darwin")) {
                    this.logger.debug("Detected Mac OS X platform");
                    platform = new MacOSXPlatform();
                } else {
                    this.logger.warn("Unrecognized operating system: '{}', falling back to default platform", (Object)osName);
                    platform = new DefaultPlatform();
                }
            } else {
                this.logger.warn("System property 'os.name' is null, falling back to default platform");
                platform = new DefaultPlatform();
            }
        }
        catch (SecurityException e) {
            this.logger.warn("Not allowed to read system property 'os.name', falling back to default platform", (Throwable)e);
            platform = new DefaultPlatform();
        }
        return platform;
    }

    private boolean isGnome() {
        String gdmSession = this.getSystemEnv("GDMSESSION");
        if (gdmSession != null && gdmSession.toLowerCase().contains("gnome")) {
            return true;
        }
        String desktopSession = this.getSystemEnv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.toLowerCase().contains("gnome")) {
            return true;
        }
        String gnomeDesktopSessionId = this.getSystemEnv("GNOME_DESKTOP_SESSION_ID");
        return gnomeDesktopSessionId != null && gnomeDesktopSessionId.trim().length() > 0;
    }

    private boolean isKDE() {
        String gdmSession = this.getSystemEnv("GDMSESSION");
        if (gdmSession != null && gdmSession.toLowerCase().contains("kde")) {
            return true;
        }
        String desktopSession = this.getSystemEnv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.toLowerCase().contains("kde")) {
            return true;
        }
        String windowManager = this.getSystemEnv("WINDOW_MANAGER");
        return windowManager != null && windowManager.trim().toLowerCase().endsWith("kde");
    }

    private String getSystemEnv(String propertyName) {
        try {
            return System.getenv(propertyName);
        }
        catch (SecurityException e) {
            this.logger.warn("Not allowed to read environment variable '" + propertyName + "'", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(PlatformFactory.getPlatform().getApplicationDataDir("My Application: Test").getAbsolutePath());
    }
}

