/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openrdf.http.webclient.server.Server;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.repository.manager.RepositoryInfo;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class RepositorySelectionInterceptor
implements HandlerInterceptor {
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        HttpSession session = request.getSession(true);
        session.removeAttribute("openrdf-repository-exception");
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView mav) {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String id;
        boolean result = true;
        HttpSession session = request.getSession(true);
        RepositoryInfo repoInfo = (RepositoryInfo)session.getAttribute("openrdf-repository-info");
        HTTPRepository repo = (HTTPRepository)session.getAttribute("openrdf-repository");
        if (request.getRequestURI().endsWith("/repository/overview.view") && (id = request.getParameter("id")) != null) {
            Server server = (Server)session.getAttribute("openrdf-server");
            repo = (HTTPRepository)server.getRepositoryManager().getRepository(id);
            try {
                repo.initialize();
                repoInfo = server.getRepositoryManager().getRepositoryInfo(id);
            }
            catch (RepositoryException e) {
                session.setAttribute("openrdf-repository-exception", (Object)e);
            }
            session.setAttribute("openrdf-repository", (Object)repo);
            session.setAttribute("openrdf-repository-info", (Object)repoInfo);
        }
        if (repo == null) {
            result = false;
            response.sendRedirect(request.getContextPath() + "/server/overview.view");
        }
        return result;
    }
}

