/*
 * This file is part of the Soprano Project.
 *
 * This file is based on source generated by kxm_compiler
 *
 * Copyright (C) 2008 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef SPARQL_XML_FORMAT_H
#define SPARQL_XML_FORMAT_H

#include <QString>
#include <QList>
#include <QListIterator>
#include <QUrl>

class QDomElement;

namespace Soprano {
    namespace Client {
        namespace SparqlParser {
            class Unbound
            {
            public:
                /**
                   Parse XML object from DOM element.
                */
                static Unbound parseElement( const QDomElement &element, bool *ok );
                QString writeElement();

            };

            class Literal
            {
            public:
                void setDatatype( const QString &v );
                QString datatype() const;
                void setXsi_type( const QString &v );
                QString xsi_type() const;
                void setXml_lang( const QString &v );
                QString xml_lang() const;

                void setData( const QString &v ) { this->mData = v; };
                QString data() const { return this->mData; }
    
                /**
                   Parse XML object from DOM element.
                */
                static Literal parseElement( const QDomElement &element, bool *ok );
                QString writeElement();

            private:
                QString mDatatype;
                QString mXsi_type;
                QString mXml_lang;
                QString mData;
            };

            class Bnode
            {
            public:
                /**
                   Parse XML object from DOM element.
                */
                static Bnode parseElement( const QDomElement &element, bool *ok );
                QString writeElement();
                void setId( const QString &v ) { this->mId = v; };
                QString id() const { return this->mId; }
    
            private:
                QString mId;
            };

            class Uri
            {
            public:
                /**
                   Parse XML object from DOM element.
                */
                static Uri parseElement( const QDomElement &element, bool *ok );
                QString writeElement();
    
                void setUri( const QUrl &v ) { this->mUri = v; };
                QUrl uri() const { return this->mUri; }
    
            private:
                QUrl mUri;
            };

            class Binding
            {

            public:
                enum BindingType { NONE, URI, BNODE, LITERAL, UNBOUND };
                typedef QList<Binding> List;
                typedef QListIterator<Binding> Iterator;

            public:
                void setName( const QString &v );
                QString name() const;
                void setUri( const Uri &v );
                Uri uri() const;
                void setBnode( const Bnode &v );
                Bnode bnode() const;
                void setLiteral( const Literal &v );
                Literal literal() const;
                void setUnbound( const Unbound &v );
                Unbound unbound() const;

                BindingType type() const ;
    
                /**
                   Parse XML object from DOM element.
                */
                static Binding parseElement( const QDomElement &element, bool *ok );
                QString writeElement();

            private:
                QString mName;
                BindingType mType;
                Uri mUri;
                Bnode mBnode;
                Literal mLiteral;
                Unbound mUnbound;
            };

            class Result
            {
            public:
                typedef QList<Result> List;
                typedef QListIterator<Result> Iterator;
    
            public:
                void setXml_lang( const QString &v );
                QString xml_lang() const;
                void setIndex( const QString &v );
                QString index() const;
                void addBinding( const Binding &v );
                void setBindingList( const Binding::List &v );
                Binding::List bindingList() const;
                /**
                   Parse XML object from DOM element.
                */
                static Result parseElement( const QDomElement &element, bool *ok );
                QString writeElement();

            private:
                QString mXml_lang;
                QString mIndex;
                Binding::List mBindingList;
            };

            class Boolean
            {
            public:
                Boolean()
                    : mIsValid(false),
                    mValue(false) {}

                /**
                   Parse XML object from DOM element.
                */
                static Boolean parseElement( const QDomElement &element, bool *ok );
                QString writeElement();

                bool isValid() const { return mIsValid; }
                bool value() const { return this->mValue; }
            private:
                bool mIsValid;
                bool mValue;
            };

            class Results
            {
            public:
                void addResult( const Result &v );
                void setResultList( const Result::List &v );
                Result::List resultList() const;
                /**
                   Parse XML object from DOM element.
                */
                static Results parseElement( const QDomElement &element, bool *ok );
                QString writeElement();

            private:
                Result::List mResultList;
            };

            class Variable
            {
            public:
                typedef QList<Variable> List;

            public:
                void setName( const QString &v );
                QString name() const;
                /**
                   Parse XML object from DOM element.
                */
                static Variable parseElement( const QDomElement &element, bool *ok );
                QString writeElement();

            private:
                QString mName;
            };

            class Head
            {
            public:
                void addVariable( const Variable &v );
                void setVariableList( const Variable::List &v );
                Variable::List variableList() const;
                /**
                   Parse XML object from DOM element.
                */
                static Head parseElement( const QDomElement &element, bool *ok );
                QString writeElement();

            private:
                Variable::List mVariableList;
            };

            class Sparql
            {
            public:
                void setXml_lang( const QString &v );
                QString xml_lang() const;
                void setXsi_schemaLocation( const QString &v );
                QString xsi_schemaLocation() const;
                void setHead( const Head &v );
                Head head() const;
                void setBoolean( const Boolean &v );
                Boolean boolean() const;
                void setResults( const Results &v );
                Results results() const;
                /**
                   Parse XML object from DOM element.
                */
                static Sparql parseElement( const QDomElement &element, bool *ok );
                QString writeElement();
                static Sparql parseFile( const QString &filename, bool *ok );
                static Sparql parseByteArray( const QByteArray& array, bool *ok );
                bool writeFile( const QString &filename );

            private:
                QString mXml_lang;
                QString mXsi_schemaLocation;
                Head mHead;
                Boolean mBoolean;
                Results mResults;
            };
        }
    }
}

#endif
