/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaList.h"

#include "KURL.h"
#include "MediaList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMediaList);

/* Hash table */

static const HashTableValue JSMediaListTableValues[4] =
{
    { "mediaText", DontDelete, (intptr_t)jsMediaListMediaText, (intptr_t)setJSMediaListMediaText },
    { "length", DontDelete|ReadOnly, (intptr_t)jsMediaListLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMediaListConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSMediaListTableValues, 0 };
#else
    { 9, 7, JSMediaListTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMediaListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaListConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMediaListConstructorTableValues, 0 };
#else
    { 1, 0, JSMediaListConstructorTableValues, 0 };
#endif

class JSMediaListConstructor : public DOMConstructorObject {
public:
    JSMediaListConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSMediaListConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSMediaListPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSMediaListConstructor::s_info = { "MediaListConstructor", 0, &JSMediaListConstructorTable, 0 };

bool JSMediaListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaListConstructor, DOMObject>(exec, &JSMediaListConstructorTable, this, propertyName, slot);
}

bool JSMediaListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaListConstructor, DOMObject>(exec, &JSMediaListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMediaListPrototypeTableValues[4] =
{
    { "item", DontDelete|Function, (intptr_t)jsMediaListPrototypeFunctionItem, (intptr_t)1 },
    { "deleteMedium", DontDelete|Function, (intptr_t)jsMediaListPrototypeFunctionDeleteMedium, (intptr_t)1 },
    { "appendMedium", DontDelete|Function, (intptr_t)jsMediaListPrototypeFunctionAppendMedium, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSMediaListPrototypeTableValues, 0 };
#else
    { 8, 7, JSMediaListPrototypeTableValues, 0 };
#endif

const ClassInfo JSMediaListPrototype::s_info = { "MediaListPrototype", 0, &JSMediaListPrototypeTable, 0 };

JSObject* JSMediaListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaList>(exec, globalObject);
}

bool JSMediaListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMediaListPrototypeTable, this, propertyName, slot);
}

bool JSMediaListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSMediaListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSMediaList::s_info = { "MediaList", 0, &JSMediaListTable, 0 };

JSMediaList::JSMediaList(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaList> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSMediaList::~JSMediaList()
{
    forgetDOMObject(this, impl());
}

JSObject* JSMediaList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMediaListPrototype(JSMediaListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSMediaListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSMediaList, Base>(exec, &JSMediaListTable, this, propertyName, slot);
}

bool JSMediaList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSMediaListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<MediaList*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSMediaList, Base>(exec, &JSMediaListTable, this, propertyName, descriptor);
}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsMediaListMediaText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMediaList* castedThis = static_cast<JSMediaList*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MediaList* imp = static_cast<MediaList*>(castedThis->impl());
    return jsStringOrNull(exec, imp->mediaText());
}

JSValue jsMediaListLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMediaList* castedThis = static_cast<JSMediaList*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MediaList* imp = static_cast<MediaList*>(castedThis->impl());
    return jsNumber(exec, imp->length());
}

JSValue jsMediaListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMediaList* domObject = static_cast<JSMediaList*>(asObject(slot.slotBase()));
    return JSMediaList::getConstructor(exec, domObject->globalObject());
}
void JSMediaList::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSMediaList, Base>(exec, propertyName, value, &JSMediaListTable, this, slot);
}

void setJSMediaListMediaText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    MediaList* imp = static_cast<MediaList*>(static_cast<JSMediaList*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setMediaText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void JSMediaList::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<MediaList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames);
}

JSValue JSMediaList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsMediaListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(asObject(thisValue));
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    unsigned index = args.at(0).toInt32(exec);


    JSC::JSValue result = jsStringOrNull(exec, imp->item(index));
    return result;
}

JSValue JSC_HOST_CALL jsMediaListPrototypeFunctionDeleteMedium(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(asObject(thisValue));
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& oldMedium = args.at(0).toString(exec);

    imp->deleteMedium(oldMedium, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsMediaListPrototypeFunctionAppendMedium(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(asObject(thisValue));
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& newMedium = args.at(0).toString(exec);

    imp->appendMedium(newMedium, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


JSValue JSMediaList::indexGetter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMediaList* thisObj = static_cast<JSMediaList*>(asObject(slot.slotBase()));
    return jsStringOrNull(exec, thisObj->impl()->item(slot.index()));
}
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaList* object)
{
    return getDOMObjectWrapper<JSMediaList>(exec, globalObject, object);
}
MediaList* toMediaList(JSC::JSValue value)
{
    return value.inherits(&JSMediaList::s_info) ? static_cast<JSMediaList*>(asObject(value))->impl() : 0;
}

}
