/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFETileElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFETileElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFETileElement);

/* Hash table */

static const HashTableValue JSSVGFETileElementTableValues[9] =
{
    { "in1", DontDelete|ReadOnly, (intptr_t)jsSVGFETileElementIn1, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFETileElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFETileElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFETileElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFETileElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFETileElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFETileElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFETileElementStyle, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFETileElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFETileElementTableValues, 0 };
#else
    { 18, 15, JSSVGFETileElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGFETileElementPrototypeTableValues[2] =
{
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFETileElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFETileElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFETileElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGFETileElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFETileElementPrototype::s_info = { "SVGFETileElementPrototype", 0, &JSSVGFETileElementPrototypeTable, 0 };

JSObject* JSSVGFETileElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFETileElement>(exec, globalObject);
}

bool JSSVGFETileElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFETileElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFETileElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFETileElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFETileElement::s_info = { "SVGFETileElement", &JSSVGElement::s_info, &JSSVGFETileElementTable, 0 };

JSSVGFETileElement::JSSVGFETileElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFETileElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGFETileElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFETileElementPrototype(JSSVGFETileElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFETileElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFETileElement, Base>(exec, &JSSVGFETileElementTable, this, propertyName, slot);
}

bool JSSVGFETileElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFETileElement, Base>(exec, &JSSVGFETileElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFETileElementIn1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFETileElement* castedThis = static_cast<JSSVGFETileElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFETileElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFETileElement* castedThis = static_cast<JSSVGFETileElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFETileElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFETileElement* castedThis = static_cast<JSSVGFETileElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFETileElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFETileElement* castedThis = static_cast<JSSVGFETileElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFETileElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFETileElement* castedThis = static_cast<JSSVGFETileElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFETileElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFETileElement* castedThis = static_cast<JSSVGFETileElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFETileElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFETileElement* castedThis = static_cast<JSSVGFETileElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFETileElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFETileElement* castedThis = static_cast<JSSVGFETileElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue JSC_HOST_CALL jsSVGFETileElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGFETileElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFETileElement* castedThisObj = static_cast<JSSVGFETileElement*>(asObject(thisValue));
    SVGFETileElement* imp = static_cast<SVGFETileElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
