/* parser auto-generated by pidl */

#include "includes.h"
#include "../librpc/gen_ndr/ndr_srvsvc.h"

#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_svcctl.h"
static enum ndr_err_code ndr_push_srvsvc_NetCharDevInfo0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->device));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->device) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->device, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->device, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->device, ndr_charset_length(r->device, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevInfo0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevInfo0 *r)
{
	uint32_t _ptr_device;
	TALLOC_CTX *_mem_save_device_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_device));
		if (_ptr_device) {
			NDR_PULL_ALLOC(ndr, r->device);
		} else {
			r->device = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->device) {
			_mem_save_device_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->device, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->device));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->device));
			if (ndr_get_array_length(ndr, &r->device) > ndr_get_array_size(ndr, &r->device)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->device), ndr_get_array_length(ndr, &r->device));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->device), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->device, ndr_get_array_length(ndr, &r->device), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_device_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevInfo0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevInfo0 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevInfo0");
	ndr->depth++;
	ndr_print_ptr(ndr, "device", r->device);
	ndr->depth++;
	if (r->device) {
		ndr_print_string(ndr, "device", r->device);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevCtr0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevCtr0 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetCharDevInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetCharDevInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevCtr0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevCtr0 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevCtr0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevCtr0 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevCtr0");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetCharDevInfo0(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevInfo1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->device));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->device) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->device, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->device, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->device, ndr_charset_length(r->device, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevInfo1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevInfo1 *r)
{
	uint32_t _ptr_device;
	TALLOC_CTX *_mem_save_device_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_device));
		if (_ptr_device) {
			NDR_PULL_ALLOC(ndr, r->device);
		} else {
			r->device = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->device) {
			_mem_save_device_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->device, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->device));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->device));
			if (ndr_get_array_length(ndr, &r->device) > ndr_get_array_size(ndr, &r->device)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->device), ndr_get_array_length(ndr, &r->device));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->device), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->device, ndr_get_array_length(ndr, &r->device), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_device_0, 0);
		}
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevInfo1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevInfo1 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "device", r->device);
	ndr->depth++;
	if (r->device) {
		ndr_print_string(ndr, "device", r->device);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "status", r->status);
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "time", r->time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevCtr1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevCtr1 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetCharDevInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetCharDevInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevCtr1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevCtr1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetCharDevInfo1(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevInfo(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetCharDevInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_srvsvc_NetCharDevInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_srvsvc_NetCharDevInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevInfo(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetCharDevInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	TALLOC_CTX *_mem_save_info1_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_info0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_info1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevInfo(struct ndr_print *ndr, const char *name, const union srvsvc_NetCharDevInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetCharDevInfo");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_srvsvc_NetCharDevInfo0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_srvsvc_NetCharDevInfo1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevCtr(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetCharDevCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->ctr0) {
					NDR_CHECK(ndr_push_srvsvc_NetCharDevCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
				}
			break;

			case 1:
				if (r->ctr1) {
					NDR_CHECK(ndr_push_srvsvc_NetCharDevCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevCtr(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetCharDevCtr *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr0_0;
	TALLOC_CTX *_mem_save_ctr1_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_ctr0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr0));
				if (_ptr_ctr0) {
					NDR_PULL_ALLOC(ndr, r->ctr0);
				} else {
					r->ctr0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_ctr1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
				if (_ptr_ctr1) {
					NDR_PULL_ALLOC(ndr, r->ctr1);
				} else {
					r->ctr1 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->ctr0) {
					_mem_save_ctr0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetCharDevCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr0_0, 0);
				}
			break;

			case 1:
				if (r->ctr1) {
					_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetCharDevCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevCtr(struct ndr_print *ndr, const char *name, const union srvsvc_NetCharDevCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetCharDevCtr");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "ctr0", r->ctr0);
			ndr->depth++;
			if (r->ctr0) {
				ndr_print_srvsvc_NetCharDevCtr0(ndr, "ctr0", r->ctr0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "ctr1", r->ctr1);
			ndr->depth++;
			if (r->ctr1) {
				ndr_print_srvsvc_NetCharDevCtr1(ndr, "ctr1", r->ctr1);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_push_srvsvc_NetCharDevCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_srvsvc_NetCharDevCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevInfoCtr(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevInfoCtr *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level);
	ndr_print_srvsvc_NetCharDevCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQInfo0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevQInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->device));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->device) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->device, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->device, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->device, ndr_charset_length(r->device, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQInfo0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevQInfo0 *r)
{
	uint32_t _ptr_device;
	TALLOC_CTX *_mem_save_device_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_device));
		if (_ptr_device) {
			NDR_PULL_ALLOC(ndr, r->device);
		} else {
			r->device = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->device) {
			_mem_save_device_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->device, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->device));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->device));
			if (ndr_get_array_length(ndr, &r->device) > ndr_get_array_size(ndr, &r->device)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->device), ndr_get_array_length(ndr, &r->device));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->device), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->device, ndr_get_array_length(ndr, &r->device), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_device_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQInfo0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevQInfo0 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQInfo0");
	ndr->depth++;
	ndr_print_ptr(ndr, "device", r->device);
	ndr->depth++;
	if (r->device) {
		ndr_print_string(ndr, "device", r->device);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQCtr0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevQCtr0 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQCtr0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevQCtr0 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQCtr0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevQCtr0 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQCtr0");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetCharDevQInfo0(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQInfo1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevQInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->device));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->devices));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_ahead));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->device) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->device, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->device, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->device, ndr_charset_length(r->device, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->devices) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->devices, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->devices, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->devices, ndr_charset_length(r->devices, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQInfo1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevQInfo1 *r)
{
	uint32_t _ptr_device;
	TALLOC_CTX *_mem_save_device_0;
	uint32_t _ptr_devices;
	TALLOC_CTX *_mem_save_devices_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_device));
		if (_ptr_device) {
			NDR_PULL_ALLOC(ndr, r->device);
		} else {
			r->device = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devices));
		if (_ptr_devices) {
			NDR_PULL_ALLOC(ndr, r->devices);
		} else {
			r->devices = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_ahead));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->device) {
			_mem_save_device_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->device, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->device));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->device));
			if (ndr_get_array_length(ndr, &r->device) > ndr_get_array_size(ndr, &r->device)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->device), ndr_get_array_length(ndr, &r->device));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->device), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->device, ndr_get_array_length(ndr, &r->device), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_device_0, 0);
		}
		if (r->devices) {
			_mem_save_devices_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->devices, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->devices));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->devices));
			if (ndr_get_array_length(ndr, &r->devices) > ndr_get_array_size(ndr, &r->devices)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->devices), ndr_get_array_length(ndr, &r->devices));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->devices), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->devices, ndr_get_array_length(ndr, &r->devices), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devices_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQInfo1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevQInfo1 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "device", r->device);
	ndr->depth++;
	if (r->device) {
		ndr_print_string(ndr, "device", r->device);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_ptr(ndr, "devices", r->devices);
	ndr->depth++;
	if (r->devices) {
		ndr_print_string(ndr, "devices", r->devices);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "users", r->users);
	ndr_print_uint32(ndr, "num_ahead", r->num_ahead);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQCtr1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevQCtr1 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQCtr1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevQCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQCtr1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevQCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetCharDevQInfo1(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQInfo(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetCharDevQInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQInfo(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetCharDevQInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	TALLOC_CTX *_mem_save_info1_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_info0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_info1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQInfo(struct ndr_print *ndr, const char *name, const union srvsvc_NetCharDevQInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetCharDevQInfo");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_srvsvc_NetCharDevQInfo0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_srvsvc_NetCharDevQInfo1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQCtr(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetCharDevQCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->ctr0) {
					NDR_CHECK(ndr_push_srvsvc_NetCharDevQCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
				}
			break;

			case 1:
				if (r->ctr1) {
					NDR_CHECK(ndr_push_srvsvc_NetCharDevQCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQCtr(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetCharDevQCtr *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr0_0;
	TALLOC_CTX *_mem_save_ctr1_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_ctr0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr0));
				if (_ptr_ctr0) {
					NDR_PULL_ALLOC(ndr, r->ctr0);
				} else {
					r->ctr0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_ctr1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
				if (_ptr_ctr1) {
					NDR_PULL_ALLOC(ndr, r->ctr1);
				} else {
					r->ctr1 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->ctr0) {
					_mem_save_ctr0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetCharDevQCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr0_0, 0);
				}
			break;

			case 1:
				if (r->ctr1) {
					_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetCharDevQCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQCtr(struct ndr_print *ndr, const char *name, const union srvsvc_NetCharDevQCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetCharDevQCtr");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "ctr0", r->ctr0);
			ndr->depth++;
			if (r->ctr0) {
				ndr_print_srvsvc_NetCharDevQCtr0(ndr, "ctr0", r->ctr0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "ctr1", r->ctr1);
			ndr->depth++;
			if (r->ctr1) {
				ndr_print_srvsvc_NetCharDevQCtr1(ndr, "ctr1", r->ctr1);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetCharDevQInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_push_srvsvc_NetCharDevQCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_srvsvc_NetCharDevQCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetCharDevQInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevQCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevQCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQInfoCtr(struct ndr_print *ndr, const char *name, const struct srvsvc_NetCharDevQInfoCtr *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level);
	ndr_print_srvsvc_NetCharDevQCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetConnInfo0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetConnInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->conn_id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetConnInfo0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetConnInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->conn_id));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetConnInfo0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetConnInfo0 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetConnInfo0");
	ndr->depth++;
	ndr_print_uint32(ndr, "conn_id", r->conn_id);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetConnCtr0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetConnCtr0 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetConnInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetConnCtr0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetConnCtr0 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetConnInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetConnCtr0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetConnCtr0 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetConnCtr0");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetConnInfo0(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetConnInfo1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetConnInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->conn_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->conn_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_open));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->conn_time));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->share));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->share) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->share, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->share, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->share, ndr_charset_length(r->share, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetConnInfo1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetConnInfo1 *r)
{
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	uint32_t _ptr_share;
	TALLOC_CTX *_mem_save_share_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->conn_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->conn_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_open));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->conn_time));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_share));
		if (_ptr_share) {
			NDR_PULL_ALLOC(ndr, r->share);
		} else {
			r->share = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
		if (r->share) {
			_mem_save_share_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->share, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->share));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->share));
			if (ndr_get_array_length(ndr, &r->share) > ndr_get_array_size(ndr, &r->share)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->share), ndr_get_array_length(ndr, &r->share));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->share), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->share, ndr_get_array_length(ndr, &r->share), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_share_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetConnInfo1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetConnInfo1 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetConnInfo1");
	ndr->depth++;
	ndr_print_uint32(ndr, "conn_id", r->conn_id);
	ndr_print_uint32(ndr, "conn_type", r->conn_type);
	ndr_print_uint32(ndr, "num_open", r->num_open);
	ndr_print_uint32(ndr, "num_users", r->num_users);
	ndr_print_uint32(ndr, "conn_time", r->conn_time);
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "share", r->share);
	ndr->depth++;
	if (r->share) {
		ndr_print_string(ndr, "share", r->share);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetConnCtr1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetConnCtr1 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetConnInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetConnInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetConnCtr1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetConnCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetConnInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetConnInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetConnCtr1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetConnCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetConnCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetConnInfo1(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetConnCtr(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetConnCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->ctr0) {
					NDR_CHECK(ndr_push_srvsvc_NetConnCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
				}
			break;

			case 1:
				if (r->ctr1) {
					NDR_CHECK(ndr_push_srvsvc_NetConnCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetConnCtr(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetConnCtr *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr0_0;
	TALLOC_CTX *_mem_save_ctr1_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_ctr0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr0));
				if (_ptr_ctr0) {
					NDR_PULL_ALLOC(ndr, r->ctr0);
				} else {
					r->ctr0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_ctr1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
				if (_ptr_ctr1) {
					NDR_PULL_ALLOC(ndr, r->ctr1);
				} else {
					r->ctr1 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->ctr0) {
					_mem_save_ctr0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetConnCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr0_0, 0);
				}
			break;

			case 1:
				if (r->ctr1) {
					_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetConnCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetConnCtr(struct ndr_print *ndr, const char *name, const union srvsvc_NetConnCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetConnCtr");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "ctr0", r->ctr0);
			ndr->depth++;
			if (r->ctr0) {
				ndr_print_srvsvc_NetConnCtr0(ndr, "ctr0", r->ctr0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "ctr1", r->ctr1);
			ndr->depth++;
			if (r->ctr1) {
				ndr_print_srvsvc_NetConnCtr1(ndr, "ctr1", r->ctr1);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetConnInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetConnInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_push_srvsvc_NetConnCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_srvsvc_NetConnCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetConnInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetConnInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_pull_srvsvc_NetConnCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_srvsvc_NetConnCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetConnInfoCtr(struct ndr_print *ndr, const char *name, const struct srvsvc_NetConnInfoCtr *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetConnInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level);
	ndr_print_srvsvc_NetConnCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetFileInfo2(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetFileInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileInfo2(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetFileInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileInfo2(struct ndr_print *ndr, const char *name, const struct srvsvc_NetFileInfo2 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetFileInfo2");
	ndr->depth++;
	ndr_print_uint32(ndr, "fid", r->fid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetFileCtr2(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetFileCtr2 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetFileInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileCtr2(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetFileCtr2 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetFileInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileCtr2(struct ndr_print *ndr, const char *name, const struct srvsvc_NetFileCtr2 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetFileCtr2");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetFileInfo2(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetFileInfo3(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetFileInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->permissions));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_locks));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->path, ndr_charset_length(r->path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileInfo3(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetFileInfo3 *r)
{
	uint32_t _ptr_path;
	TALLOC_CTX *_mem_save_path_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->permissions));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_locks));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->path);
		} else {
			r->path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->path));
			if (ndr_get_array_length(ndr, &r->path) > ndr_get_array_size(ndr, &r->path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->path), ndr_get_array_length(ndr, &r->path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->path, ndr_get_array_length(ndr, &r->path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileInfo3(struct ndr_print *ndr, const char *name, const struct srvsvc_NetFileInfo3 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetFileInfo3");
	ndr->depth++;
	ndr_print_uint32(ndr, "fid", r->fid);
	ndr_print_uint32(ndr, "permissions", r->permissions);
	ndr_print_uint32(ndr, "num_locks", r->num_locks);
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetFileCtr3(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetFileCtr3 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetFileInfo3(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetFileInfo3(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileCtr3(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetFileCtr3 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetFileInfo3(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetFileInfo3(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileCtr3(struct ndr_print *ndr, const char *name, const struct srvsvc_NetFileCtr3 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetFileCtr3");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetFileInfo3(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetFileInfo(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetFileInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info3));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_srvsvc_NetFileInfo2(ndr, NDR_SCALARS, r->info2));
				}
			break;

			case 3:
				if (r->info3) {
					NDR_CHECK(ndr_push_srvsvc_NetFileInfo3(ndr, NDR_SCALARS|NDR_BUFFERS, r->info3));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileInfo(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetFileInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info2_0;
	TALLOC_CTX *_mem_save_info3_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 2: {
				uint32_t _ptr_info2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			case 3: {
				uint32_t _ptr_info3;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info3));
				if (_ptr_info3) {
					NDR_PULL_ALLOC(ndr, r->info3);
				} else {
					r->info3 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetFileInfo2(ndr, NDR_SCALARS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			case 3:
				if (r->info3) {
					_mem_save_info3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info3, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetFileInfo3(ndr, NDR_SCALARS|NDR_BUFFERS, r->info3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info3_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileInfo(struct ndr_print *ndr, const char *name, const union srvsvc_NetFileInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetFileInfo");
	switch (level) {
		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_srvsvc_NetFileInfo2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "info3", r->info3);
			ndr->depth++;
			if (r->info3) {
				ndr_print_srvsvc_NetFileInfo3(ndr, "info3", r->info3);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetFileCtr(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetFileCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr3));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 2:
				if (r->ctr2) {
					NDR_CHECK(ndr_push_srvsvc_NetFileCtr2(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr2));
				}
			break;

			case 3:
				if (r->ctr3) {
					NDR_CHECK(ndr_push_srvsvc_NetFileCtr3(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr3));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileCtr(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetFileCtr *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr2_0;
	TALLOC_CTX *_mem_save_ctr3_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 2: {
				uint32_t _ptr_ctr2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr2));
				if (_ptr_ctr2) {
					NDR_PULL_ALLOC(ndr, r->ctr2);
				} else {
					r->ctr2 = NULL;
				}
			break; }

			case 3: {
				uint32_t _ptr_ctr3;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr3));
				if (_ptr_ctr3) {
					NDR_PULL_ALLOC(ndr, r->ctr3);
				} else {
					r->ctr3 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 2:
				if (r->ctr2) {
					_mem_save_ctr2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr2, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetFileCtr2(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr2_0, 0);
				}
			break;

			case 3:
				if (r->ctr3) {
					_mem_save_ctr3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr3, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetFileCtr3(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr3_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileCtr(struct ndr_print *ndr, const char *name, const union srvsvc_NetFileCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetFileCtr");
	switch (level) {
		case 2:
			ndr_print_ptr(ndr, "ctr2", r->ctr2);
			ndr->depth++;
			if (r->ctr2) {
				ndr_print_srvsvc_NetFileCtr2(ndr, "ctr2", r->ctr2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "ctr3", r->ctr3);
			ndr->depth++;
			if (r->ctr3) {
				ndr_print_srvsvc_NetFileCtr3(ndr, "ctr3", r->ctr3);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetFileInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetFileInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_push_srvsvc_NetFileCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_srvsvc_NetFileCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetFileInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_pull_srvsvc_NetFileCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_srvsvc_NetFileCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileInfoCtr(struct ndr_print *ndr, const char *name, const struct srvsvc_NetFileInfoCtr *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetFileInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level);
	ndr_print_srvsvc_NetFileCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessInfo0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client, ndr_charset_length(r->client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessInfo0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessInfo0 *r)
{
	uint32_t _ptr_client;
	TALLOC_CTX *_mem_save_client_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->client);
		} else {
			r->client = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client));
			if (ndr_get_array_length(ndr, &r->client) > ndr_get_array_size(ndr, &r->client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client), ndr_get_array_length(ndr, &r->client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessInfo0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessInfo0 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSessInfo0");
	ndr->depth++;
	ndr_print_ptr(ndr, "client", r->client);
	ndr->depth++;
	if (r->client) {
		ndr_print_string(ndr, "client", r->client);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessCtr0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessCtr0 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessCtr0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessCtr0 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessCtr0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessCtr0 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetSessCtr0");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetSessInfo0(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessInfo1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_open));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->user_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client, ndr_charset_length(r->client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessInfo1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessInfo1 *r)
{
	uint32_t _ptr_client;
	TALLOC_CTX *_mem_save_client_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->client);
		} else {
			r->client = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_open));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->user_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client));
			if (ndr_get_array_length(ndr, &r->client) > ndr_get_array_size(ndr, &r->client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client), ndr_get_array_length(ndr, &r->client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessInfo1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessInfo1 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSessInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "client", r->client);
	ndr->depth++;
	if (r->client) {
		ndr_print_string(ndr, "client", r->client);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "num_open", r->num_open);
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint32(ndr, "idle_time", r->idle_time);
	ndr_print_uint32(ndr, "user_flags", r->user_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessCtr1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessCtr1 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessCtr1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessCtr1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetSessCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetSessInfo1(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessInfo2(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_open));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->user_flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client_type));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client, ndr_charset_length(r->client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->client_type) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client_type, ndr_charset_length(r->client_type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessInfo2(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessInfo2 *r)
{
	uint32_t _ptr_client;
	TALLOC_CTX *_mem_save_client_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	uint32_t _ptr_client_type;
	TALLOC_CTX *_mem_save_client_type_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->client);
		} else {
			r->client = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_open));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->user_flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_type));
		if (_ptr_client_type) {
			NDR_PULL_ALLOC(ndr, r->client_type);
		} else {
			r->client_type = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client));
			if (ndr_get_array_length(ndr, &r->client) > ndr_get_array_size(ndr, &r->client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client), ndr_get_array_length(ndr, &r->client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
		if (r->client_type) {
			_mem_save_client_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client_type));
			if (ndr_get_array_length(ndr, &r->client_type) > ndr_get_array_size(ndr, &r->client_type)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client_type), ndr_get_array_length(ndr, &r->client_type));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client_type), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client_type, ndr_get_array_length(ndr, &r->client_type), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_type_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessInfo2(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessInfo2 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSessInfo2");
	ndr->depth++;
	ndr_print_ptr(ndr, "client", r->client);
	ndr->depth++;
	if (r->client) {
		ndr_print_string(ndr, "client", r->client);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "num_open", r->num_open);
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint32(ndr, "idle_time", r->idle_time);
	ndr_print_uint32(ndr, "user_flags", r->user_flags);
	ndr_print_ptr(ndr, "client_type", r->client_type);
	ndr->depth++;
	if (r->client_type) {
		ndr_print_string(ndr, "client_type", r->client_type);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessCtr2(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessCtr2 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessCtr2(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessCtr2 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessCtr2(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessCtr2 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetSessCtr2");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetSessInfo2(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessInfo10(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessInfo10 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client, ndr_charset_length(r->client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessInfo10(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessInfo10 *r)
{
	uint32_t _ptr_client;
	TALLOC_CTX *_mem_save_client_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->client);
		} else {
			r->client = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client));
			if (ndr_get_array_length(ndr, &r->client) > ndr_get_array_size(ndr, &r->client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client), ndr_get_array_length(ndr, &r->client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessInfo10(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessInfo10 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSessInfo10");
	ndr->depth++;
	ndr_print_ptr(ndr, "client", r->client);
	ndr->depth++;
	if (r->client) {
		ndr_print_string(ndr, "client", r->client);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint32(ndr, "idle_time", r->idle_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessCtr10(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessCtr10 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo10(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo10(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessCtr10(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessCtr10 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo10(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo10(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessCtr10(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessCtr10 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetSessCtr10");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetSessInfo10(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessInfo502(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessInfo502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_open));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->user_flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->transport));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client, ndr_charset_length(r->client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->client_type) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client_type, ndr_charset_length(r->client_type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->transport) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->transport, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->transport, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->transport, ndr_charset_length(r->transport, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessInfo502(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessInfo502 *r)
{
	uint32_t _ptr_client;
	TALLOC_CTX *_mem_save_client_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	uint32_t _ptr_client_type;
	TALLOC_CTX *_mem_save_client_type_0;
	uint32_t _ptr_transport;
	TALLOC_CTX *_mem_save_transport_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->client);
		} else {
			r->client = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_open));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->user_flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_type));
		if (_ptr_client_type) {
			NDR_PULL_ALLOC(ndr, r->client_type);
		} else {
			r->client_type = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_transport));
		if (_ptr_transport) {
			NDR_PULL_ALLOC(ndr, r->transport);
		} else {
			r->transport = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client));
			if (ndr_get_array_length(ndr, &r->client) > ndr_get_array_size(ndr, &r->client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client), ndr_get_array_length(ndr, &r->client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
		if (r->client_type) {
			_mem_save_client_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client_type));
			if (ndr_get_array_length(ndr, &r->client_type) > ndr_get_array_size(ndr, &r->client_type)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client_type), ndr_get_array_length(ndr, &r->client_type));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client_type), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client_type, ndr_get_array_length(ndr, &r->client_type), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_type_0, 0);
		}
		if (r->transport) {
			_mem_save_transport_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->transport, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->transport));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->transport));
			if (ndr_get_array_length(ndr, &r->transport) > ndr_get_array_size(ndr, &r->transport)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->transport), ndr_get_array_length(ndr, &r->transport));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->transport), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->transport, ndr_get_array_length(ndr, &r->transport), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transport_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessInfo502(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessInfo502 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSessInfo502");
	ndr->depth++;
	ndr_print_ptr(ndr, "client", r->client);
	ndr->depth++;
	if (r->client) {
		ndr_print_string(ndr, "client", r->client);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "num_open", r->num_open);
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint32(ndr, "idle_time", r->idle_time);
	ndr_print_uint32(ndr, "user_flags", r->user_flags);
	ndr_print_ptr(ndr, "client_type", r->client_type);
	ndr->depth++;
	if (r->client_type) {
		ndr_print_string(ndr, "client_type", r->client_type);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "transport", r->transport);
	ndr->depth++;
	if (r->transport) {
		ndr_print_string(ndr, "transport", r->transport);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessCtr502(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessCtr502 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo502(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSessInfo502(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessCtr502(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessCtr502 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo502(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSessInfo502(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessCtr502(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessCtr502 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetSessCtr502");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetSessInfo502(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessCtr(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetSessCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr2));
			break; }

			case 10: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr10));
			break; }

			case 502: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr502));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->ctr0) {
					NDR_CHECK(ndr_push_srvsvc_NetSessCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
				}
			break;

			case 1:
				if (r->ctr1) {
					NDR_CHECK(ndr_push_srvsvc_NetSessCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
				}
			break;

			case 2:
				if (r->ctr2) {
					NDR_CHECK(ndr_push_srvsvc_NetSessCtr2(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr2));
				}
			break;

			case 10:
				if (r->ctr10) {
					NDR_CHECK(ndr_push_srvsvc_NetSessCtr10(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr10));
				}
			break;

			case 502:
				if (r->ctr502) {
					NDR_CHECK(ndr_push_srvsvc_NetSessCtr502(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr502));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessCtr(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetSessCtr *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr0_0;
	TALLOC_CTX *_mem_save_ctr1_0;
	TALLOC_CTX *_mem_save_ctr2_0;
	TALLOC_CTX *_mem_save_ctr10_0;
	TALLOC_CTX *_mem_save_ctr502_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_ctr0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr0));
				if (_ptr_ctr0) {
					NDR_PULL_ALLOC(ndr, r->ctr0);
				} else {
					r->ctr0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_ctr1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
				if (_ptr_ctr1) {
					NDR_PULL_ALLOC(ndr, r->ctr1);
				} else {
					r->ctr1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_ctr2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr2));
				if (_ptr_ctr2) {
					NDR_PULL_ALLOC(ndr, r->ctr2);
				} else {
					r->ctr2 = NULL;
				}
			break; }

			case 10: {
				uint32_t _ptr_ctr10;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr10));
				if (_ptr_ctr10) {
					NDR_PULL_ALLOC(ndr, r->ctr10);
				} else {
					r->ctr10 = NULL;
				}
			break; }

			case 502: {
				uint32_t _ptr_ctr502;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr502));
				if (_ptr_ctr502) {
					NDR_PULL_ALLOC(ndr, r->ctr502);
				} else {
					r->ctr502 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->ctr0) {
					_mem_save_ctr0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSessCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr0_0, 0);
				}
			break;

			case 1:
				if (r->ctr1) {
					_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSessCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
				}
			break;

			case 2:
				if (r->ctr2) {
					_mem_save_ctr2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr2, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSessCtr2(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr2_0, 0);
				}
			break;

			case 10:
				if (r->ctr10) {
					_mem_save_ctr10_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr10, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSessCtr10(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr10));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr10_0, 0);
				}
			break;

			case 502:
				if (r->ctr502) {
					_mem_save_ctr502_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr502, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSessCtr502(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr502));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr502_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessCtr(struct ndr_print *ndr, const char *name, const union srvsvc_NetSessCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetSessCtr");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "ctr0", r->ctr0);
			ndr->depth++;
			if (r->ctr0) {
				ndr_print_srvsvc_NetSessCtr0(ndr, "ctr0", r->ctr0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "ctr1", r->ctr1);
			ndr->depth++;
			if (r->ctr1) {
				ndr_print_srvsvc_NetSessCtr1(ndr, "ctr1", r->ctr1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "ctr2", r->ctr2);
			ndr->depth++;
			if (r->ctr2) {
				ndr_print_srvsvc_NetSessCtr2(ndr, "ctr2", r->ctr2);
			}
			ndr->depth--;
		break;

		case 10:
			ndr_print_ptr(ndr, "ctr10", r->ctr10);
			ndr->depth++;
			if (r->ctr10) {
				ndr_print_srvsvc_NetSessCtr10(ndr, "ctr10", r->ctr10);
			}
			ndr->depth--;
		break;

		case 502:
			ndr_print_ptr(ndr, "ctr502", r->ctr502);
			ndr->depth++;
			if (r->ctr502) {
				ndr_print_srvsvc_NetSessCtr502(ndr, "ctr502", r->ctr502);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetSessInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSessInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_push_srvsvc_NetSessCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_srvsvc_NetSessCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSessInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_pull_srvsvc_NetSessCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_srvsvc_NetSessCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessInfoCtr(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSessInfoCtr *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSessInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level);
	ndr_print_srvsvc_NetSessCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_ShareType(struct ndr_push *ndr, int ndr_flags, enum srvsvc_ShareType r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_ShareType(struct ndr_pull *ndr, int ndr_flags, enum srvsvc_ShareType *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_ShareType(struct ndr_print *ndr, const char *name, enum srvsvc_ShareType r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case STYPE_DISKTREE: val = "STYPE_DISKTREE"; break;
			case STYPE_DISKTREE_TEMPORARY: val = "STYPE_DISKTREE_TEMPORARY"; break;
			case STYPE_DISKTREE_HIDDEN: val = "STYPE_DISKTREE_HIDDEN"; break;
			case STYPE_PRINTQ: val = "STYPE_PRINTQ"; break;
			case STYPE_PRINTQ_TEMPORARY: val = "STYPE_PRINTQ_TEMPORARY"; break;
			case STYPE_PRINTQ_HIDDEN: val = "STYPE_PRINTQ_HIDDEN"; break;
			case STYPE_DEVICE: val = "STYPE_DEVICE"; break;
			case STYPE_DEVICE_TEMPORARY: val = "STYPE_DEVICE_TEMPORARY"; break;
			case STYPE_DEVICE_HIDDEN: val = "STYPE_DEVICE_HIDDEN"; break;
			case STYPE_IPC: val = "STYPE_IPC"; break;
			case STYPE_IPC_TEMPORARY: val = "STYPE_IPC_TEMPORARY"; break;
			case STYPE_IPC_HIDDEN: val = "STYPE_IPC_HIDDEN"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo0 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo0 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo0");
	ndr->depth++;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr0 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr0 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr0 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr0");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo0(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_srvsvc_ShareType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo1 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_srvsvc_ShareType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo1 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_srvsvc_ShareType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr1 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo1(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo2(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_srvsvc_ShareType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->permissions));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->current_users));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->path, ndr_charset_length(r->path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->password) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->password, ndr_charset_length(r->password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo2(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo2 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_path;
	TALLOC_CTX *_mem_save_path_0;
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_password_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_srvsvc_ShareType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->permissions));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->current_users));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->path);
		} else {
			r->path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->password);
		} else {
			r->password = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
		if (r->path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->path));
			if (ndr_get_array_length(ndr, &r->path) > ndr_get_array_size(ndr, &r->path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->path), ndr_get_array_length(ndr, &r->path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->path, ndr_get_array_length(ndr, &r->path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		if (r->password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->password));
			if (ndr_get_array_length(ndr, &r->password) > ndr_get_array_size(ndr, &r->password)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->password), ndr_get_array_length(ndr, &r->password));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->password), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->password, ndr_get_array_length(ndr, &r->password), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo2(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo2 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo2");
	ndr->depth++;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_srvsvc_ShareType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "permissions", r->permissions);
	ndr_print_uint32(ndr, "max_users", r->max_users);
	ndr_print_uint32(ndr, "current_users", r->current_users);
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "password", r->password);
	ndr->depth++;
	if (r->password) {
		ndr_print_string(ndr, "password", r->password);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr2(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr2 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr2(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr2 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr2(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr2 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr2");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo2(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo501(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo501 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_srvsvc_ShareType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->csc_policy));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo501(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo501 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_srvsvc_ShareType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->csc_policy));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo501(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo501 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo501");
	ndr->depth++;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_srvsvc_ShareType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "csc_policy", r->csc_policy);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr501(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr501 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo501(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo501(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr501(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr501 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo501(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo501(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr501(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr501 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr501");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo501(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo502(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_srvsvc_ShareType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->permissions));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->current_users));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sd_buf));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->path, ndr_charset_length(r->path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->password) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->password, ndr_charset_length(r->password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sd_buf));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo502(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo502 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_path;
	TALLOC_CTX *_mem_save_path_0;
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_password_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_srvsvc_ShareType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->permissions));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->current_users));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->path);
		} else {
			r->path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->password);
		} else {
			r->password = NULL;
		}
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sd_buf));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
		if (r->path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->path));
			if (ndr_get_array_length(ndr, &r->path) > ndr_get_array_size(ndr, &r->path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->path), ndr_get_array_length(ndr, &r->path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->path, ndr_get_array_length(ndr, &r->path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		if (r->password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->password));
			if (ndr_get_array_length(ndr, &r->password) > ndr_get_array_size(ndr, &r->password)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->password), ndr_get_array_length(ndr, &r->password));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->password), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->password, ndr_get_array_length(ndr, &r->password), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sd_buf));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo502(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo502 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo502");
	ndr->depth++;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_srvsvc_ShareType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "permissions", r->permissions);
	ndr_print_uint32(ndr, "max_users", r->max_users);
	ndr_print_uint32(ndr, "current_users", r->current_users);
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "password", r->password);
	ndr->depth++;
	if (r->password) {
		ndr_print_string(ndr, "password", r->password);
	}
	ndr->depth--;
	ndr_print_sec_desc_buf(ndr, "sd_buf", &r->sd_buf);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr502(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr502 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo502(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo502(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr502(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr502 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo502(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo502(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr502(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr502 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr502");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo502(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo1004(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo1004 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->comment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo1004(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo1004 *r)
{
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo1004(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo1004 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo1004");
	ndr->depth++;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr1004(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr1004 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo1004(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo1004(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr1004(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr1004 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1004(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1004(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr1004(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr1004 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr1004");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo1004(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NetShareInfo1005Flags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NetShareInfo1005Flags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NetShareInfo1005Flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHARE_1005_IN_DFS", SHARE_1005_IN_DFS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHARE_1005_DFS_ROOT", SHARE_1005_DFS_ROOT, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo1005(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_NetShareInfo1005Flags(ndr, NDR_SCALARS, r->dfs_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo1005(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_NetShareInfo1005Flags(ndr, NDR_SCALARS, &r->dfs_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo1005(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo1005 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo1005");
	ndr->depth++;
	ndr_print_NetShareInfo1005Flags(ndr, "dfs_flags", r->dfs_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr1005(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr1005 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo1005(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr1005(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr1005 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1005(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr1005(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr1005 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr1005");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo1005(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo1006(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo1006 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_users));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo1006(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo1006 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_users));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo1006(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo1006 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo1006");
	ndr->depth++;
	ndr_print_uint32(ndr, "max_users", r->max_users);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr1006(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr1006 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo1006(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr1006(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr1006 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1006(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr1006(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr1006 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr1006");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo1006(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo1007(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfo1007 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->alternate_directory_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->alternate_directory_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->alternate_directory_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->alternate_directory_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->alternate_directory_name, ndr_charset_length(r->alternate_directory_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo1007(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfo1007 *r)
{
	uint32_t _ptr_alternate_directory_name;
	TALLOC_CTX *_mem_save_alternate_directory_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_alternate_directory_name));
		if (_ptr_alternate_directory_name) {
			NDR_PULL_ALLOC(ndr, r->alternate_directory_name);
		} else {
			r->alternate_directory_name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->alternate_directory_name) {
			_mem_save_alternate_directory_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->alternate_directory_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->alternate_directory_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->alternate_directory_name));
			if (ndr_get_array_length(ndr, &r->alternate_directory_name) > ndr_get_array_size(ndr, &r->alternate_directory_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->alternate_directory_name), ndr_get_array_length(ndr, &r->alternate_directory_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->alternate_directory_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->alternate_directory_name, ndr_get_array_length(ndr, &r->alternate_directory_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alternate_directory_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo1007(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfo1007 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfo1007");
	ndr->depth++;
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "alternate_directory_name", r->alternate_directory_name);
	ndr->depth++;
	if (r->alternate_directory_name) {
		ndr_print_string(ndr, "alternate_directory_name", r->alternate_directory_name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr1007(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr1007 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo1007(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetShareInfo1007(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr1007(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr1007 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1007(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1007(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr1007(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr1007 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr1007");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetShareInfo1007(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr1501(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareCtr1501 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr1501(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareCtr1501 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr1501(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareCtr1501 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetShareCtr1501");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_sec_desc_buf(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfo(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetShareInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			case 501: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info501));
			break; }

			case 502: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info502));
			break; }

			case 1004: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1004));
			break; }

			case 1005: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1005));
			break; }

			case 1006: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1006));
			break; }

			case 1007: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1007));
			break; }

			case 1501: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1501));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
				}
			break;

			case 501:
				if (r->info501) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo501(ndr, NDR_SCALARS|NDR_BUFFERS, r->info501));
				}
			break;

			case 502:
				if (r->info502) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo502(ndr, NDR_SCALARS|NDR_BUFFERS, r->info502));
				}
			break;

			case 1004:
				if (r->info1004) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo1004(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1004));
				}
			break;

			case 1005:
				if (r->info1005) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo1005(ndr, NDR_SCALARS, r->info1005));
				}
			break;

			case 1006:
				if (r->info1006) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo1006(ndr, NDR_SCALARS, r->info1006));
				}
			break;

			case 1007:
				if (r->info1007) {
					NDR_CHECK(ndr_push_srvsvc_NetShareInfo1007(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1007));
				}
			break;

			case 1501:
				if (r->info1501) {
					NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1501));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfo(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetShareInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	TALLOC_CTX *_mem_save_info1_0;
	TALLOC_CTX *_mem_save_info2_0;
	TALLOC_CTX *_mem_save_info501_0;
	TALLOC_CTX *_mem_save_info502_0;
	TALLOC_CTX *_mem_save_info1004_0;
	TALLOC_CTX *_mem_save_info1005_0;
	TALLOC_CTX *_mem_save_info1006_0;
	TALLOC_CTX *_mem_save_info1007_0;
	TALLOC_CTX *_mem_save_info1501_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_info0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_info1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_info2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			case 501: {
				uint32_t _ptr_info501;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info501));
				if (_ptr_info501) {
					NDR_PULL_ALLOC(ndr, r->info501);
				} else {
					r->info501 = NULL;
				}
			break; }

			case 502: {
				uint32_t _ptr_info502;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info502));
				if (_ptr_info502) {
					NDR_PULL_ALLOC(ndr, r->info502);
				} else {
					r->info502 = NULL;
				}
			break; }

			case 1004: {
				uint32_t _ptr_info1004;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1004));
				if (_ptr_info1004) {
					NDR_PULL_ALLOC(ndr, r->info1004);
				} else {
					r->info1004 = NULL;
				}
			break; }

			case 1005: {
				uint32_t _ptr_info1005;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1005));
				if (_ptr_info1005) {
					NDR_PULL_ALLOC(ndr, r->info1005);
				} else {
					r->info1005 = NULL;
				}
			break; }

			case 1006: {
				uint32_t _ptr_info1006;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1006));
				if (_ptr_info1006) {
					NDR_PULL_ALLOC(ndr, r->info1006);
				} else {
					r->info1006 = NULL;
				}
			break; }

			case 1007: {
				uint32_t _ptr_info1007;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1007));
				if (_ptr_info1007) {
					NDR_PULL_ALLOC(ndr, r->info1007);
				} else {
					r->info1007 = NULL;
				}
			break; }

			case 1501: {
				uint32_t _ptr_info1501;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1501));
				if (_ptr_info1501) {
					NDR_PULL_ALLOC(ndr, r->info1501);
				} else {
					r->info1501 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			case 501:
				if (r->info501) {
					_mem_save_info501_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info501, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo501(ndr, NDR_SCALARS|NDR_BUFFERS, r->info501));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info501_0, 0);
				}
			break;

			case 502:
				if (r->info502) {
					_mem_save_info502_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info502, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo502(ndr, NDR_SCALARS|NDR_BUFFERS, r->info502));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info502_0, 0);
				}
			break;

			case 1004:
				if (r->info1004) {
					_mem_save_info1004_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1004, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1004(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1004));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1004_0, 0);
				}
			break;

			case 1005:
				if (r->info1005) {
					_mem_save_info1005_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1005, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1005(ndr, NDR_SCALARS, r->info1005));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1005_0, 0);
				}
			break;

			case 1006:
				if (r->info1006) {
					_mem_save_info1006_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1006, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1006(ndr, NDR_SCALARS, r->info1006));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1006_0, 0);
				}
			break;

			case 1007:
				if (r->info1007) {
					_mem_save_info1007_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1007, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareInfo1007(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1007));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1007_0, 0);
				}
			break;

			case 1501:
				if (r->info1501) {
					_mem_save_info1501_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1501, 0);
					NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1501));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1501_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfo(struct ndr_print *ndr, const char *name, const union srvsvc_NetShareInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetShareInfo");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_srvsvc_NetShareInfo0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_srvsvc_NetShareInfo1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_srvsvc_NetShareInfo2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		case 501:
			ndr_print_ptr(ndr, "info501", r->info501);
			ndr->depth++;
			if (r->info501) {
				ndr_print_srvsvc_NetShareInfo501(ndr, "info501", r->info501);
			}
			ndr->depth--;
		break;

		case 502:
			ndr_print_ptr(ndr, "info502", r->info502);
			ndr->depth++;
			if (r->info502) {
				ndr_print_srvsvc_NetShareInfo502(ndr, "info502", r->info502);
			}
			ndr->depth--;
		break;

		case 1004:
			ndr_print_ptr(ndr, "info1004", r->info1004);
			ndr->depth++;
			if (r->info1004) {
				ndr_print_srvsvc_NetShareInfo1004(ndr, "info1004", r->info1004);
			}
			ndr->depth--;
		break;

		case 1005:
			ndr_print_ptr(ndr, "info1005", r->info1005);
			ndr->depth++;
			if (r->info1005) {
				ndr_print_srvsvc_NetShareInfo1005(ndr, "info1005", r->info1005);
			}
			ndr->depth--;
		break;

		case 1006:
			ndr_print_ptr(ndr, "info1006", r->info1006);
			ndr->depth++;
			if (r->info1006) {
				ndr_print_srvsvc_NetShareInfo1006(ndr, "info1006", r->info1006);
			}
			ndr->depth--;
		break;

		case 1007:
			ndr_print_ptr(ndr, "info1007", r->info1007);
			ndr->depth++;
			if (r->info1007) {
				ndr_print_srvsvc_NetShareInfo1007(ndr, "info1007", r->info1007);
			}
			ndr->depth--;
		break;

		case 1501:
			ndr_print_ptr(ndr, "info1501", r->info1501);
			ndr->depth++;
			if (r->info1501) {
				ndr_print_sec_desc_buf(ndr, "info1501", r->info1501);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCtr(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetShareCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr2));
			break; }

			case 501: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr501));
			break; }

			case 502: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr502));
			break; }

			case 1004: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1004));
			break; }

			case 1005: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1005));
			break; }

			case 1006: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1006));
			break; }

			case 1007: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1007));
			break; }

			case 1501: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1501));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->ctr0) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
				}
			break;

			case 1:
				if (r->ctr1) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
				}
			break;

			case 2:
				if (r->ctr2) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr2(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr2));
				}
			break;

			case 501:
				if (r->ctr501) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr501(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr501));
				}
			break;

			case 502:
				if (r->ctr502) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr502(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr502));
				}
			break;

			case 1004:
				if (r->ctr1004) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr1004(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1004));
				}
			break;

			case 1005:
				if (r->ctr1005) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr1005(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1005));
				}
			break;

			case 1006:
				if (r->ctr1006) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr1006(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1006));
				}
			break;

			case 1007:
				if (r->ctr1007) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr1007(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1007));
				}
			break;

			case 1501:
				if (r->ctr1501) {
					NDR_CHECK(ndr_push_srvsvc_NetShareCtr1501(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1501));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCtr(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetShareCtr *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr0_0;
	TALLOC_CTX *_mem_save_ctr1_0;
	TALLOC_CTX *_mem_save_ctr2_0;
	TALLOC_CTX *_mem_save_ctr501_0;
	TALLOC_CTX *_mem_save_ctr502_0;
	TALLOC_CTX *_mem_save_ctr1004_0;
	TALLOC_CTX *_mem_save_ctr1005_0;
	TALLOC_CTX *_mem_save_ctr1006_0;
	TALLOC_CTX *_mem_save_ctr1007_0;
	TALLOC_CTX *_mem_save_ctr1501_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_ctr0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr0));
				if (_ptr_ctr0) {
					NDR_PULL_ALLOC(ndr, r->ctr0);
				} else {
					r->ctr0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_ctr1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
				if (_ptr_ctr1) {
					NDR_PULL_ALLOC(ndr, r->ctr1);
				} else {
					r->ctr1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_ctr2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr2));
				if (_ptr_ctr2) {
					NDR_PULL_ALLOC(ndr, r->ctr2);
				} else {
					r->ctr2 = NULL;
				}
			break; }

			case 501: {
				uint32_t _ptr_ctr501;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr501));
				if (_ptr_ctr501) {
					NDR_PULL_ALLOC(ndr, r->ctr501);
				} else {
					r->ctr501 = NULL;
				}
			break; }

			case 502: {
				uint32_t _ptr_ctr502;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr502));
				if (_ptr_ctr502) {
					NDR_PULL_ALLOC(ndr, r->ctr502);
				} else {
					r->ctr502 = NULL;
				}
			break; }

			case 1004: {
				uint32_t _ptr_ctr1004;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1004));
				if (_ptr_ctr1004) {
					NDR_PULL_ALLOC(ndr, r->ctr1004);
				} else {
					r->ctr1004 = NULL;
				}
			break; }

			case 1005: {
				uint32_t _ptr_ctr1005;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1005));
				if (_ptr_ctr1005) {
					NDR_PULL_ALLOC(ndr, r->ctr1005);
				} else {
					r->ctr1005 = NULL;
				}
			break; }

			case 1006: {
				uint32_t _ptr_ctr1006;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1006));
				if (_ptr_ctr1006) {
					NDR_PULL_ALLOC(ndr, r->ctr1006);
				} else {
					r->ctr1006 = NULL;
				}
			break; }

			case 1007: {
				uint32_t _ptr_ctr1007;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1007));
				if (_ptr_ctr1007) {
					NDR_PULL_ALLOC(ndr, r->ctr1007);
				} else {
					r->ctr1007 = NULL;
				}
			break; }

			case 1501: {
				uint32_t _ptr_ctr1501;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1501));
				if (_ptr_ctr1501) {
					NDR_PULL_ALLOC(ndr, r->ctr1501);
				} else {
					r->ctr1501 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->ctr0) {
					_mem_save_ctr0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr0_0, 0);
				}
			break;

			case 1:
				if (r->ctr1) {
					_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
				}
			break;

			case 2:
				if (r->ctr2) {
					_mem_save_ctr2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr2, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr2(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr2_0, 0);
				}
			break;

			case 501:
				if (r->ctr501) {
					_mem_save_ctr501_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr501, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr501(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr501));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr501_0, 0);
				}
			break;

			case 502:
				if (r->ctr502) {
					_mem_save_ctr502_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr502, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr502(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr502));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr502_0, 0);
				}
			break;

			case 1004:
				if (r->ctr1004) {
					_mem_save_ctr1004_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1004, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr1004(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1004));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1004_0, 0);
				}
			break;

			case 1005:
				if (r->ctr1005) {
					_mem_save_ctr1005_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1005, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr1005(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1005));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1005_0, 0);
				}
			break;

			case 1006:
				if (r->ctr1006) {
					_mem_save_ctr1006_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1006, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr1006(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1006));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1006_0, 0);
				}
			break;

			case 1007:
				if (r->ctr1007) {
					_mem_save_ctr1007_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1007, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr1007(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1007));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1007_0, 0);
				}
			break;

			case 1501:
				if (r->ctr1501) {
					_mem_save_ctr1501_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1501, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetShareCtr1501(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1501));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1501_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCtr(struct ndr_print *ndr, const char *name, const union srvsvc_NetShareCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetShareCtr");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "ctr0", r->ctr0);
			ndr->depth++;
			if (r->ctr0) {
				ndr_print_srvsvc_NetShareCtr0(ndr, "ctr0", r->ctr0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "ctr1", r->ctr1);
			ndr->depth++;
			if (r->ctr1) {
				ndr_print_srvsvc_NetShareCtr1(ndr, "ctr1", r->ctr1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "ctr2", r->ctr2);
			ndr->depth++;
			if (r->ctr2) {
				ndr_print_srvsvc_NetShareCtr2(ndr, "ctr2", r->ctr2);
			}
			ndr->depth--;
		break;

		case 501:
			ndr_print_ptr(ndr, "ctr501", r->ctr501);
			ndr->depth++;
			if (r->ctr501) {
				ndr_print_srvsvc_NetShareCtr501(ndr, "ctr501", r->ctr501);
			}
			ndr->depth--;
		break;

		case 502:
			ndr_print_ptr(ndr, "ctr502", r->ctr502);
			ndr->depth++;
			if (r->ctr502) {
				ndr_print_srvsvc_NetShareCtr502(ndr, "ctr502", r->ctr502);
			}
			ndr->depth--;
		break;

		case 1004:
			ndr_print_ptr(ndr, "ctr1004", r->ctr1004);
			ndr->depth++;
			if (r->ctr1004) {
				ndr_print_srvsvc_NetShareCtr1004(ndr, "ctr1004", r->ctr1004);
			}
			ndr->depth--;
		break;

		case 1005:
			ndr_print_ptr(ndr, "ctr1005", r->ctr1005);
			ndr->depth++;
			if (r->ctr1005) {
				ndr_print_srvsvc_NetShareCtr1005(ndr, "ctr1005", r->ctr1005);
			}
			ndr->depth--;
		break;

		case 1006:
			ndr_print_ptr(ndr, "ctr1006", r->ctr1006);
			ndr->depth++;
			if (r->ctr1006) {
				ndr_print_srvsvc_NetShareCtr1006(ndr, "ctr1006", r->ctr1006);
			}
			ndr->depth--;
		break;

		case 1007:
			ndr_print_ptr(ndr, "ctr1007", r->ctr1007);
			ndr->depth++;
			if (r->ctr1007) {
				ndr_print_srvsvc_NetShareCtr1007(ndr, "ctr1007", r->ctr1007);
			}
			ndr->depth--;
		break;

		case 1501:
			ndr_print_ptr(ndr, "ctr1501", r->ctr1501);
			ndr->depth++;
			if (r->ctr1501) {
				ndr_print_srvsvc_NetShareCtr1501(ndr, "ctr1501", r->ctr1501);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetShareInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetShareInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_push_srvsvc_NetShareCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_srvsvc_NetShareCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetShareInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_pull_srvsvc_NetShareCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_srvsvc_NetShareCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareInfoCtr(struct ndr_print *ndr, const char *name, const struct srvsvc_NetShareInfoCtr *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level);
	ndr_print_srvsvc_NetShareCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_srvsvc_PlatformId(struct ndr_push *ndr, int ndr_flags, enum srvsvc_PlatformId r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_srvsvc_PlatformId(struct ndr_pull *ndr, int ndr_flags, enum srvsvc_PlatformId *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_PlatformId(struct ndr_print *ndr, const char *name, enum srvsvc_PlatformId r)
{
	const char *val = NULL;

	switch (r) {
		case PLATFORM_ID_DOS: val = "PLATFORM_ID_DOS"; break;
		case PLATFORM_ID_OS2: val = "PLATFORM_ID_OS2"; break;
		case PLATFORM_ID_NT: val = "PLATFORM_ID_NT"; break;
		case PLATFORM_ID_OSF: val = "PLATFORM_ID_OSF"; break;
		case PLATFORM_ID_VMS: val = "PLATFORM_ID_VMS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_srvsvc_NetSrvInfo100(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo100 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_srvsvc_PlatformId(ndr, NDR_SCALARS, r->platform_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo100(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo100 *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_srvsvc_PlatformId(ndr, NDR_SCALARS, &r->platform_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo100(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo100 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo100");
	ndr->depth++;
	ndr_print_srvsvc_PlatformId(ndr, "platform_id", r->platform_id);
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_srvsvc_NetSrvInfo101(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo101 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_srvsvc_PlatformId(ndr, NDR_SCALARS, r->platform_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_minor));
		NDR_CHECK(ndr_push_svcctl_ServerType(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo101(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo101 *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_srvsvc_PlatformId(ndr, NDR_SCALARS, &r->platform_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_minor));
		NDR_CHECK(ndr_pull_svcctl_ServerType(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo101(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo101 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo101");
	ndr->depth++;
	ndr_print_srvsvc_PlatformId(ndr, "platform_id", r->platform_id);
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version_major", r->version_major);
	ndr_print_uint32(ndr, "version_minor", r->version_minor);
	ndr_print_svcctl_ServerType(ndr, "server_type", r->server_type);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo102(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo102 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_srvsvc_PlatformId(ndr, NDR_SCALARS, r->platform_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_minor));
		NDR_CHECK(ndr_push_svcctl_ServerType(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->disc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->hidden));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->announce));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->anndelta));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->licenses));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->userpath));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->userpath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->userpath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->userpath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->userpath, ndr_charset_length(r->userpath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo102(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo102 *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_userpath;
	TALLOC_CTX *_mem_save_userpath_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_srvsvc_PlatformId(ndr, NDR_SCALARS, &r->platform_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_minor));
		NDR_CHECK(ndr_pull_svcctl_ServerType(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->disc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->hidden));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->announce));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->anndelta));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->licenses));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_userpath));
		if (_ptr_userpath) {
			NDR_PULL_ALLOC(ndr, r->userpath);
		} else {
			r->userpath = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
		if (r->userpath) {
			_mem_save_userpath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->userpath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->userpath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->userpath));
			if (ndr_get_array_length(ndr, &r->userpath) > ndr_get_array_size(ndr, &r->userpath)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->userpath), ndr_get_array_length(ndr, &r->userpath));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->userpath), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->userpath, ndr_get_array_length(ndr, &r->userpath), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_userpath_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo102(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo102 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo102");
	ndr->depth++;
	ndr_print_srvsvc_PlatformId(ndr, "platform_id", r->platform_id);
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version_major", r->version_major);
	ndr_print_uint32(ndr, "version_minor", r->version_minor);
	ndr_print_svcctl_ServerType(ndr, "server_type", r->server_type);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "users", r->users);
	ndr_print_uint32(ndr, "disc", r->disc);
	ndr_print_uint32(ndr, "hidden", r->hidden);
	ndr_print_uint32(ndr, "announce", r->announce);
	ndr_print_uint32(ndr, "anndelta", r->anndelta);
	ndr_print_uint32(ndr, "licenses", r->licenses);
	ndr_print_ptr(ndr, "userpath", r->userpath);
	ndr->depth++;
	if (r->userpath) {
		ndr_print_string(ndr, "userpath", r->userpath);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo402(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo402 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ulist_mtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->glist_mtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alist_mtime));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->alerts));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->security));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numadmin));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lanmask));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->guestaccount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chdevs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chdevqs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chdevjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->connections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->shares));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->openfiles));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessopen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sesssvc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessreqs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->activelocks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numreqbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sizereqbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numbigbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numfiletasks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alertsched));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->erroralert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->logonalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->accessalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->diskalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->netioalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxaudits));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->srvheuristics));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->alerts) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->alerts, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->alerts, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->alerts, ndr_charset_length(r->alerts, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->guestaccount) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->guestaccount, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->guestaccount, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->guestaccount, ndr_charset_length(r->guestaccount, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->srvheuristics) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->srvheuristics, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->srvheuristics, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->srvheuristics, ndr_charset_length(r->srvheuristics, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo402(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo402 *r)
{
	uint32_t _ptr_alerts;
	TALLOC_CTX *_mem_save_alerts_0;
	uint32_t _ptr_guestaccount;
	TALLOC_CTX *_mem_save_guestaccount_0;
	uint32_t _ptr_srvheuristics;
	TALLOC_CTX *_mem_save_srvheuristics_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ulist_mtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->glist_mtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alist_mtime));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_alerts));
		if (_ptr_alerts) {
			NDR_PULL_ALLOC(ndr, r->alerts);
		} else {
			r->alerts = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->security));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numadmin));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lanmask));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_guestaccount));
		if (_ptr_guestaccount) {
			NDR_PULL_ALLOC(ndr, r->guestaccount);
		} else {
			r->guestaccount = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chdevs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chdevqs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chdevjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->connections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->shares));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->openfiles));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessopen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sesssvc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessreqs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->activelocks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numreqbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sizereqbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numbigbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numfiletasks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alertsched));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->erroralert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->logonalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->accessalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->diskalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->netioalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxaudits));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_srvheuristics));
		if (_ptr_srvheuristics) {
			NDR_PULL_ALLOC(ndr, r->srvheuristics);
		} else {
			r->srvheuristics = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->alerts) {
			_mem_save_alerts_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->alerts, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->alerts));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->alerts));
			if (ndr_get_array_length(ndr, &r->alerts) > ndr_get_array_size(ndr, &r->alerts)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->alerts), ndr_get_array_length(ndr, &r->alerts));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->alerts), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->alerts, ndr_get_array_length(ndr, &r->alerts), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alerts_0, 0);
		}
		if (r->guestaccount) {
			_mem_save_guestaccount_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->guestaccount, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->guestaccount));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->guestaccount));
			if (ndr_get_array_length(ndr, &r->guestaccount) > ndr_get_array_size(ndr, &r->guestaccount)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->guestaccount), ndr_get_array_length(ndr, &r->guestaccount));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->guestaccount), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->guestaccount, ndr_get_array_length(ndr, &r->guestaccount), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_guestaccount_0, 0);
		}
		if (r->srvheuristics) {
			_mem_save_srvheuristics_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->srvheuristics, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->srvheuristics));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->srvheuristics));
			if (ndr_get_array_length(ndr, &r->srvheuristics) > ndr_get_array_size(ndr, &r->srvheuristics)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->srvheuristics), ndr_get_array_length(ndr, &r->srvheuristics));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->srvheuristics), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->srvheuristics, ndr_get_array_length(ndr, &r->srvheuristics), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_srvheuristics_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo402(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo402 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo402");
	ndr->depth++;
	ndr_print_uint32(ndr, "ulist_mtime", r->ulist_mtime);
	ndr_print_uint32(ndr, "glist_mtime", r->glist_mtime);
	ndr_print_uint32(ndr, "alist_mtime", r->alist_mtime);
	ndr_print_ptr(ndr, "alerts", r->alerts);
	ndr->depth++;
	if (r->alerts) {
		ndr_print_string(ndr, "alerts", r->alerts);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "security", r->security);
	ndr_print_uint32(ndr, "numadmin", r->numadmin);
	ndr_print_uint32(ndr, "lanmask", r->lanmask);
	ndr_print_ptr(ndr, "guestaccount", r->guestaccount);
	ndr->depth++;
	if (r->guestaccount) {
		ndr_print_string(ndr, "guestaccount", r->guestaccount);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "chdevs", r->chdevs);
	ndr_print_uint32(ndr, "chdevqs", r->chdevqs);
	ndr_print_uint32(ndr, "chdevjobs", r->chdevjobs);
	ndr_print_uint32(ndr, "connections", r->connections);
	ndr_print_uint32(ndr, "shares", r->shares);
	ndr_print_uint32(ndr, "openfiles", r->openfiles);
	ndr_print_uint32(ndr, "sessopen", r->sessopen);
	ndr_print_uint32(ndr, "sesssvc", r->sesssvc);
	ndr_print_uint32(ndr, "sessreqs", r->sessreqs);
	ndr_print_uint32(ndr, "opensearch", r->opensearch);
	ndr_print_uint32(ndr, "activelocks", r->activelocks);
	ndr_print_uint32(ndr, "numreqbufs", r->numreqbufs);
	ndr_print_uint32(ndr, "sizereqbufs", r->sizereqbufs);
	ndr_print_uint32(ndr, "numbigbufs", r->numbigbufs);
	ndr_print_uint32(ndr, "numfiletasks", r->numfiletasks);
	ndr_print_uint32(ndr, "alertsched", r->alertsched);
	ndr_print_uint32(ndr, "erroralert", r->erroralert);
	ndr_print_uint32(ndr, "logonalert", r->logonalert);
	ndr_print_uint32(ndr, "accessalert", r->accessalert);
	ndr_print_uint32(ndr, "diskalert", r->diskalert);
	ndr_print_uint32(ndr, "netioalert", r->netioalert);
	ndr_print_uint32(ndr, "maxaudits", r->maxaudits);
	ndr_print_ptr(ndr, "srvheuristics", r->srvheuristics);
	ndr->depth++;
	if (r->srvheuristics) {
		ndr_print_string(ndr, "srvheuristics", r->srvheuristics);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo403(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo403 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ulist_mtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->glist_mtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alist_mtime));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->alerts));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->security));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numadmin));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lanmask));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->guestaccount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chdevs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chdevqs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chdevjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->connections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->shares));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->openfiles));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessopen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sesssvc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessreqs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->activelocks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numreqbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sizereqbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numbigbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numfiletasks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alertsched));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->erroralert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->logonalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->accessalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->diskalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->netioalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxaudits));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->srvheuristics));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auditedevents));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auditprofile));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->autopath));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->alerts) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->alerts, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->alerts, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->alerts, ndr_charset_length(r->alerts, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->guestaccount) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->guestaccount, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->guestaccount, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->guestaccount, ndr_charset_length(r->guestaccount, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->srvheuristics) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->srvheuristics, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->srvheuristics, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->srvheuristics, ndr_charset_length(r->srvheuristics, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->autopath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->autopath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->autopath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->autopath, ndr_charset_length(r->autopath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo403(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo403 *r)
{
	uint32_t _ptr_alerts;
	TALLOC_CTX *_mem_save_alerts_0;
	uint32_t _ptr_guestaccount;
	TALLOC_CTX *_mem_save_guestaccount_0;
	uint32_t _ptr_srvheuristics;
	TALLOC_CTX *_mem_save_srvheuristics_0;
	uint32_t _ptr_autopath;
	TALLOC_CTX *_mem_save_autopath_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ulist_mtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->glist_mtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alist_mtime));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_alerts));
		if (_ptr_alerts) {
			NDR_PULL_ALLOC(ndr, r->alerts);
		} else {
			r->alerts = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->security));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numadmin));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lanmask));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_guestaccount));
		if (_ptr_guestaccount) {
			NDR_PULL_ALLOC(ndr, r->guestaccount);
		} else {
			r->guestaccount = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chdevs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chdevqs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chdevjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->connections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->shares));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->openfiles));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessopen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sesssvc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessreqs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->activelocks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numreqbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sizereqbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numbigbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numfiletasks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alertsched));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->erroralert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->logonalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->accessalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->diskalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->netioalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxaudits));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_srvheuristics));
		if (_ptr_srvheuristics) {
			NDR_PULL_ALLOC(ndr, r->srvheuristics);
		} else {
			r->srvheuristics = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auditedevents));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auditprofile));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_autopath));
		if (_ptr_autopath) {
			NDR_PULL_ALLOC(ndr, r->autopath);
		} else {
			r->autopath = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->alerts) {
			_mem_save_alerts_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->alerts, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->alerts));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->alerts));
			if (ndr_get_array_length(ndr, &r->alerts) > ndr_get_array_size(ndr, &r->alerts)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->alerts), ndr_get_array_length(ndr, &r->alerts));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->alerts), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->alerts, ndr_get_array_length(ndr, &r->alerts), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alerts_0, 0);
		}
		if (r->guestaccount) {
			_mem_save_guestaccount_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->guestaccount, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->guestaccount));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->guestaccount));
			if (ndr_get_array_length(ndr, &r->guestaccount) > ndr_get_array_size(ndr, &r->guestaccount)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->guestaccount), ndr_get_array_length(ndr, &r->guestaccount));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->guestaccount), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->guestaccount, ndr_get_array_length(ndr, &r->guestaccount), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_guestaccount_0, 0);
		}
		if (r->srvheuristics) {
			_mem_save_srvheuristics_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->srvheuristics, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->srvheuristics));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->srvheuristics));
			if (ndr_get_array_length(ndr, &r->srvheuristics) > ndr_get_array_size(ndr, &r->srvheuristics)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->srvheuristics), ndr_get_array_length(ndr, &r->srvheuristics));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->srvheuristics), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->srvheuristics, ndr_get_array_length(ndr, &r->srvheuristics), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_srvheuristics_0, 0);
		}
		if (r->autopath) {
			_mem_save_autopath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->autopath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->autopath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->autopath));
			if (ndr_get_array_length(ndr, &r->autopath) > ndr_get_array_size(ndr, &r->autopath)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->autopath), ndr_get_array_length(ndr, &r->autopath));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->autopath), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->autopath, ndr_get_array_length(ndr, &r->autopath), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_autopath_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo403(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo403 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo403");
	ndr->depth++;
	ndr_print_uint32(ndr, "ulist_mtime", r->ulist_mtime);
	ndr_print_uint32(ndr, "glist_mtime", r->glist_mtime);
	ndr_print_uint32(ndr, "alist_mtime", r->alist_mtime);
	ndr_print_ptr(ndr, "alerts", r->alerts);
	ndr->depth++;
	if (r->alerts) {
		ndr_print_string(ndr, "alerts", r->alerts);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "security", r->security);
	ndr_print_uint32(ndr, "numadmin", r->numadmin);
	ndr_print_uint32(ndr, "lanmask", r->lanmask);
	ndr_print_ptr(ndr, "guestaccount", r->guestaccount);
	ndr->depth++;
	if (r->guestaccount) {
		ndr_print_string(ndr, "guestaccount", r->guestaccount);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "chdevs", r->chdevs);
	ndr_print_uint32(ndr, "chdevqs", r->chdevqs);
	ndr_print_uint32(ndr, "chdevjobs", r->chdevjobs);
	ndr_print_uint32(ndr, "connections", r->connections);
	ndr_print_uint32(ndr, "shares", r->shares);
	ndr_print_uint32(ndr, "openfiles", r->openfiles);
	ndr_print_uint32(ndr, "sessopen", r->sessopen);
	ndr_print_uint32(ndr, "sesssvc", r->sesssvc);
	ndr_print_uint32(ndr, "sessreqs", r->sessreqs);
	ndr_print_uint32(ndr, "opensearch", r->opensearch);
	ndr_print_uint32(ndr, "activelocks", r->activelocks);
	ndr_print_uint32(ndr, "numreqbufs", r->numreqbufs);
	ndr_print_uint32(ndr, "sizereqbufs", r->sizereqbufs);
	ndr_print_uint32(ndr, "numbigbufs", r->numbigbufs);
	ndr_print_uint32(ndr, "numfiletasks", r->numfiletasks);
	ndr_print_uint32(ndr, "alertsched", r->alertsched);
	ndr_print_uint32(ndr, "erroralert", r->erroralert);
	ndr_print_uint32(ndr, "logonalert", r->logonalert);
	ndr_print_uint32(ndr, "accessalert", r->accessalert);
	ndr_print_uint32(ndr, "diskalert", r->diskalert);
	ndr_print_uint32(ndr, "netioalert", r->netioalert);
	ndr_print_uint32(ndr, "maxaudits", r->maxaudits);
	ndr_print_ptr(ndr, "srvheuristics", r->srvheuristics);
	ndr->depth++;
	if (r->srvheuristics) {
		ndr_print_string(ndr, "srvheuristics", r->srvheuristics);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "auditedevents", r->auditedevents);
	ndr_print_uint32(ndr, "auditprofile", r->auditprofile);
	ndr_print_ptr(ndr, "autopath", r->autopath);
	ndr->depth++;
	if (r->autopath) {
		ndr_print_string(ndr, "autopath", r->autopath);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo502(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessopen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sesssvc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sizereqbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rawworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->irpstacksize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxrawbuflen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessusers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessconns));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxnonpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablesoftcompat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableforcedlogoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timesource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->acceptdownlevelapis));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lmannounce));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo502(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessopen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sesssvc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sizereqbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rawworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->irpstacksize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxrawbuflen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessusers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessconns));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxnonpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablesoftcompat));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableforcedlogoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timesource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->acceptdownlevelapis));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lmannounce));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo502(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo502 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo502");
	ndr->depth++;
	ndr_print_uint32(ndr, "sessopen", r->sessopen);
	ndr_print_uint32(ndr, "sesssvc", r->sesssvc);
	ndr_print_uint32(ndr, "opensearch", r->opensearch);
	ndr_print_uint32(ndr, "sizereqbufs", r->sizereqbufs);
	ndr_print_uint32(ndr, "initworkitems", r->initworkitems);
	ndr_print_uint32(ndr, "maxworkitems", r->maxworkitems);
	ndr_print_uint32(ndr, "rawworkitems", r->rawworkitems);
	ndr_print_uint32(ndr, "irpstacksize", r->irpstacksize);
	ndr_print_uint32(ndr, "maxrawbuflen", r->maxrawbuflen);
	ndr_print_uint32(ndr, "sessusers", r->sessusers);
	ndr_print_uint32(ndr, "sessconns", r->sessconns);
	ndr_print_uint32(ndr, "maxpagedmemoryusage", r->maxpagedmemoryusage);
	ndr_print_uint32(ndr, "maxnonpagedmemoryusage", r->maxnonpagedmemoryusage);
	ndr_print_uint32(ndr, "enablesoftcompat", r->enablesoftcompat);
	ndr_print_uint32(ndr, "enableforcedlogoff", r->enableforcedlogoff);
	ndr_print_uint32(ndr, "timesource", r->timesource);
	ndr_print_uint32(ndr, "acceptdownlevelapis", r->acceptdownlevelapis);
	ndr_print_uint32(ndr, "lmannounce", r->lmannounce);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo503(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo503 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessopen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sesssvc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sizereqbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rawworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->irpstacksize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxrawbuflen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessusers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessconns));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxnonpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablesoftcompat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableforcedlogoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timesource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->acceptdownlevelapis));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lmannounce));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxcopyreadlen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxcopywritelen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minkeepsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxkeepsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minkeepcomplsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxkeepcomplsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->threadcountadd));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numlockthreads));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->scavtimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minrcvqueue));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minfreeworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->xactmemsize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->threadpriority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxmpxct));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->oplockbreakwait));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->oplockbreakresponsewait));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableoplocks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableoplockforceclose));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablefcbopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableraw));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablesharednetdrives));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minfreeconnections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxfreeconnections));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo503(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo503 *r)
{
	uint32_t _ptr_domain;
	TALLOC_CTX *_mem_save_domain_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessopen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sesssvc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sizereqbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rawworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->irpstacksize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxrawbuflen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessusers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessconns));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxnonpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablesoftcompat));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableforcedlogoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timesource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->acceptdownlevelapis));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lmannounce));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->domain);
		} else {
			r->domain = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxcopyreadlen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxcopywritelen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minkeepsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxkeepsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minkeepcomplsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxkeepcomplsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->threadcountadd));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numlockthreads));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->scavtimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minrcvqueue));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minfreeworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->xactmemsize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->threadpriority));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxmpxct));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->oplockbreakwait));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->oplockbreakresponsewait));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableoplocks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableoplockforceclose));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablefcbopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableraw));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablesharednetdrives));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minfreeconnections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxfreeconnections));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
			if (ndr_get_array_length(ndr, &r->domain) > ndr_get_array_size(ndr, &r->domain)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain), ndr_get_array_length(ndr, &r->domain));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo503(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo503 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo503");
	ndr->depth++;
	ndr_print_uint32(ndr, "sessopen", r->sessopen);
	ndr_print_uint32(ndr, "sesssvc", r->sesssvc);
	ndr_print_uint32(ndr, "opensearch", r->opensearch);
	ndr_print_uint32(ndr, "sizereqbufs", r->sizereqbufs);
	ndr_print_uint32(ndr, "initworkitems", r->initworkitems);
	ndr_print_uint32(ndr, "maxworkitems", r->maxworkitems);
	ndr_print_uint32(ndr, "rawworkitems", r->rawworkitems);
	ndr_print_uint32(ndr, "irpstacksize", r->irpstacksize);
	ndr_print_uint32(ndr, "maxrawbuflen", r->maxrawbuflen);
	ndr_print_uint32(ndr, "sessusers", r->sessusers);
	ndr_print_uint32(ndr, "sessconns", r->sessconns);
	ndr_print_uint32(ndr, "maxpagedmemoryusage", r->maxpagedmemoryusage);
	ndr_print_uint32(ndr, "maxnonpagedmemoryusage", r->maxnonpagedmemoryusage);
	ndr_print_uint32(ndr, "enablesoftcompat", r->enablesoftcompat);
	ndr_print_uint32(ndr, "enableforcedlogoff", r->enableforcedlogoff);
	ndr_print_uint32(ndr, "timesource", r->timesource);
	ndr_print_uint32(ndr, "acceptdownlevelapis", r->acceptdownlevelapis);
	ndr_print_uint32(ndr, "lmannounce", r->lmannounce);
	ndr_print_ptr(ndr, "domain", r->domain);
	ndr->depth++;
	if (r->domain) {
		ndr_print_string(ndr, "domain", r->domain);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "maxcopyreadlen", r->maxcopyreadlen);
	ndr_print_uint32(ndr, "maxcopywritelen", r->maxcopywritelen);
	ndr_print_uint32(ndr, "minkeepsearch", r->minkeepsearch);
	ndr_print_uint32(ndr, "maxkeepsearch", r->maxkeepsearch);
	ndr_print_uint32(ndr, "minkeepcomplsearch", r->minkeepcomplsearch);
	ndr_print_uint32(ndr, "maxkeepcomplsearch", r->maxkeepcomplsearch);
	ndr_print_uint32(ndr, "threadcountadd", r->threadcountadd);
	ndr_print_uint32(ndr, "numlockthreads", r->numlockthreads);
	ndr_print_uint32(ndr, "scavtimeout", r->scavtimeout);
	ndr_print_uint32(ndr, "minrcvqueue", r->minrcvqueue);
	ndr_print_uint32(ndr, "minfreeworkitems", r->minfreeworkitems);
	ndr_print_uint32(ndr, "xactmemsize", r->xactmemsize);
	ndr_print_uint32(ndr, "threadpriority", r->threadpriority);
	ndr_print_uint32(ndr, "maxmpxct", r->maxmpxct);
	ndr_print_uint32(ndr, "oplockbreakwait", r->oplockbreakwait);
	ndr_print_uint32(ndr, "oplockbreakresponsewait", r->oplockbreakresponsewait);
	ndr_print_uint32(ndr, "enableoplocks", r->enableoplocks);
	ndr_print_uint32(ndr, "enableoplockforceclose", r->enableoplockforceclose);
	ndr_print_uint32(ndr, "enablefcbopens", r->enablefcbopens);
	ndr_print_uint32(ndr, "enableraw", r->enableraw);
	ndr_print_uint32(ndr, "enablesharednetdrives", r->enablesharednetdrives);
	ndr_print_uint32(ndr, "minfreeconnections", r->minfreeconnections);
	ndr_print_uint32(ndr, "maxfreeconnections", r->maxfreeconnections);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo599(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo599 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessopen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sesssvc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sizereqbufs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rawworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->irpstacksize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxrawbuflen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessusers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessconns));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxnonpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablesoftcompat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableforcedlogoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timesource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->acceptdownlevelapis));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lmannounce));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxcopyreadlen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxcopywritelen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minkeepsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minkeepcomplsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxkeepcomplsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->threadcountadd));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numlockthreads));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->scavtimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minrcvqueue));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minfreeworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->xactmemsize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->threadpriority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxmpxct));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->oplockbreakwait));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->oplockbreakresponsewait));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableoplocks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableoplockforceclose));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablefcbopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableraw));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablesharednetdrives));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minfreeconnections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxfreeconnections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initsesstable));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initconntable));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initfiletable));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initsearchtable));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alertsched));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->errortreshold));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->networkerrortreshold));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->diskspacetreshold));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxlinkdelay));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minlinkthroughput));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->linkinfovalidtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->scavqosinfoupdatetime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxworkitemidletime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo599(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo599 *r)
{
	uint32_t _ptr_domain;
	TALLOC_CTX *_mem_save_domain_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessopen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sesssvc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sizereqbufs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rawworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->irpstacksize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxrawbuflen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessusers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessconns));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxnonpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablesoftcompat));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableforcedlogoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timesource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->acceptdownlevelapis));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lmannounce));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->domain);
		} else {
			r->domain = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxcopyreadlen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxcopywritelen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minkeepsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minkeepcomplsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxkeepcomplsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->threadcountadd));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numlockthreads));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->scavtimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minrcvqueue));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minfreeworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->xactmemsize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->threadpriority));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxmpxct));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->oplockbreakwait));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->oplockbreakresponsewait));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableoplocks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableoplockforceclose));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablefcbopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableraw));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablesharednetdrives));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minfreeconnections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxfreeconnections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initsesstable));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initconntable));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initfiletable));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initsearchtable));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alertsched));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->errortreshold));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->networkerrortreshold));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->diskspacetreshold));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxlinkdelay));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minlinkthroughput));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->linkinfovalidtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->scavqosinfoupdatetime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxworkitemidletime));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
			if (ndr_get_array_length(ndr, &r->domain) > ndr_get_array_size(ndr, &r->domain)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain), ndr_get_array_length(ndr, &r->domain));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo599(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo599 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo599");
	ndr->depth++;
	ndr_print_uint32(ndr, "sessopen", r->sessopen);
	ndr_print_uint32(ndr, "sesssvc", r->sesssvc);
	ndr_print_uint32(ndr, "opensearch", r->opensearch);
	ndr_print_uint32(ndr, "sizereqbufs", r->sizereqbufs);
	ndr_print_uint32(ndr, "initworkitems", r->initworkitems);
	ndr_print_uint32(ndr, "maxworkitems", r->maxworkitems);
	ndr_print_uint32(ndr, "rawworkitems", r->rawworkitems);
	ndr_print_uint32(ndr, "irpstacksize", r->irpstacksize);
	ndr_print_uint32(ndr, "maxrawbuflen", r->maxrawbuflen);
	ndr_print_uint32(ndr, "sessusers", r->sessusers);
	ndr_print_uint32(ndr, "sessconns", r->sessconns);
	ndr_print_uint32(ndr, "maxpagedmemoryusage", r->maxpagedmemoryusage);
	ndr_print_uint32(ndr, "maxnonpagedmemoryusage", r->maxnonpagedmemoryusage);
	ndr_print_uint32(ndr, "enablesoftcompat", r->enablesoftcompat);
	ndr_print_uint32(ndr, "enableforcedlogoff", r->enableforcedlogoff);
	ndr_print_uint32(ndr, "timesource", r->timesource);
	ndr_print_uint32(ndr, "acceptdownlevelapis", r->acceptdownlevelapis);
	ndr_print_uint32(ndr, "lmannounce", r->lmannounce);
	ndr_print_ptr(ndr, "domain", r->domain);
	ndr->depth++;
	if (r->domain) {
		ndr_print_string(ndr, "domain", r->domain);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "maxcopyreadlen", r->maxcopyreadlen);
	ndr_print_uint32(ndr, "maxcopywritelen", r->maxcopywritelen);
	ndr_print_uint32(ndr, "minkeepsearch", r->minkeepsearch);
	ndr_print_uint32(ndr, "minkeepcomplsearch", r->minkeepcomplsearch);
	ndr_print_uint32(ndr, "maxkeepcomplsearch", r->maxkeepcomplsearch);
	ndr_print_uint32(ndr, "threadcountadd", r->threadcountadd);
	ndr_print_uint32(ndr, "numlockthreads", r->numlockthreads);
	ndr_print_uint32(ndr, "scavtimeout", r->scavtimeout);
	ndr_print_uint32(ndr, "minrcvqueue", r->minrcvqueue);
	ndr_print_uint32(ndr, "minfreeworkitems", r->minfreeworkitems);
	ndr_print_uint32(ndr, "xactmemsize", r->xactmemsize);
	ndr_print_uint32(ndr, "threadpriority", r->threadpriority);
	ndr_print_uint32(ndr, "maxmpxct", r->maxmpxct);
	ndr_print_uint32(ndr, "oplockbreakwait", r->oplockbreakwait);
	ndr_print_uint32(ndr, "oplockbreakresponsewait", r->oplockbreakresponsewait);
	ndr_print_uint32(ndr, "enableoplocks", r->enableoplocks);
	ndr_print_uint32(ndr, "enableoplockforceclose", r->enableoplockforceclose);
	ndr_print_uint32(ndr, "enablefcbopens", r->enablefcbopens);
	ndr_print_uint32(ndr, "enableraw", r->enableraw);
	ndr_print_uint32(ndr, "enablesharednetdrives", r->enablesharednetdrives);
	ndr_print_uint32(ndr, "minfreeconnections", r->minfreeconnections);
	ndr_print_uint32(ndr, "maxfreeconnections", r->maxfreeconnections);
	ndr_print_uint32(ndr, "initsesstable", r->initsesstable);
	ndr_print_uint32(ndr, "initconntable", r->initconntable);
	ndr_print_uint32(ndr, "initfiletable", r->initfiletable);
	ndr_print_uint32(ndr, "initsearchtable", r->initsearchtable);
	ndr_print_uint32(ndr, "alertsched", r->alertsched);
	ndr_print_uint32(ndr, "errortreshold", r->errortreshold);
	ndr_print_uint32(ndr, "networkerrortreshold", r->networkerrortreshold);
	ndr_print_uint32(ndr, "diskspacetreshold", r->diskspacetreshold);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr_print_uint32(ndr, "maxlinkdelay", r->maxlinkdelay);
	ndr_print_uint32(ndr, "minlinkthroughput", r->minlinkthroughput);
	ndr_print_uint32(ndr, "linkinfovalidtime", r->linkinfovalidtime);
	ndr_print_uint32(ndr, "scavqosinfoupdatetime", r->scavqosinfoupdatetime);
	ndr_print_uint32(ndr, "maxworkitemidletime", r->maxworkitemidletime);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1005(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->comment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1005(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1005 *r)
{
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1005(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1005 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1005");
	ndr->depth++;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1010(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->disc));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1010(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->disc));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1010(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1010 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1010");
	ndr->depth++;
	ndr_print_uint32(ndr, "disc", r->disc);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1016(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1016 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->hidden));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1016(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1016 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->hidden));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1016(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1016 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1016");
	ndr->depth++;
	ndr_print_uint32(ndr, "hidden", r->hidden);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1017(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1017 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->announce));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1017(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1017 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->announce));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1017(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1017 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1017");
	ndr->depth++;
	ndr_print_uint32(ndr, "announce", r->announce);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1018(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->anndelta));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1018(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->anndelta));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1018(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1018 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1018");
	ndr->depth++;
	ndr_print_uint32(ndr, "anndelta", r->anndelta);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1107(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1107 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->users));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1107(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1107 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->users));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1107(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1107 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1107");
	ndr->depth++;
	ndr_print_uint32(ndr, "users", r->users);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1501(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1501 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessopens));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1501(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1501 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessopens));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1501(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1501 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1501");
	ndr->depth++;
	ndr_print_uint32(ndr, "sessopens", r->sessopens);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1502(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessvcs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1502(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessvcs));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1502(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1502 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1502");
	ndr->depth++;
	ndr_print_uint32(ndr, "sessvcs", r->sessvcs);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1503(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1503 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->opensearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1503(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1503 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->opensearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1503(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1503 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1503");
	ndr->depth++;
	ndr_print_uint32(ndr, "opensearch", r->opensearch);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1506(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1506 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxworkitems));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1506(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1506 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxworkitems));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1506(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1506 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1506");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxworkitems", r->maxworkitems);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1509(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1509 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxrawbuflen));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1509(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1509 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxrawbuflen));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1509(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1509 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1509");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxrawbuflen", r->maxrawbuflen);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1510(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1510 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sessusers));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1510(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1510 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sessusers));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1510(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1510 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1510");
	ndr->depth++;
	ndr_print_uint32(ndr, "sessusers", r->sessusers);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1511(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1511 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sesscons));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1511(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1511 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sesscons));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1511(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1511 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1511");
	ndr->depth++;
	ndr_print_uint32(ndr, "sesscons", r->sesscons);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1512(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1512 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxnonpagedmemoryusage));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1512(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1512 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxnonpagedmemoryusage));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1512(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1512 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1512");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxnonpagedmemoryusage", r->maxnonpagedmemoryusage);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1513(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1513 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxpagedmemoryusage));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1513(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1513 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxpagedmemoryusage));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1513(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1513 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1513");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxpagedmemoryusage", r->maxpagedmemoryusage);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1514(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1514 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablesoftcompat));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1514(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1514 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablesoftcompat));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1514(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1514 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1514");
	ndr->depth++;
	ndr_print_uint32(ndr, "enablesoftcompat", r->enablesoftcompat);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1515(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1515 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableforcedlogoff));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1515(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1515 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableforcedlogoff));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1515(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1515 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1515");
	ndr->depth++;
	ndr_print_uint32(ndr, "enableforcedlogoff", r->enableforcedlogoff);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1516(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1516 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timesource));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1516(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1516 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timesource));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1516(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1516 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1516");
	ndr->depth++;
	ndr_print_uint32(ndr, "timesource", r->timesource);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1518(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1518 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lmannounce));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1518(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1518 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lmannounce));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1518(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1518 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1518");
	ndr->depth++;
	ndr_print_uint32(ndr, "lmannounce", r->lmannounce);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1520(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1520 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxcopyreadlen));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1520(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1520 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxcopyreadlen));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1520(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1520 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1520");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxcopyreadlen", r->maxcopyreadlen);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1521(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1521 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxcopywritelen));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1521(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1521 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxcopywritelen));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1521(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1521 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1521");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxcopywritelen", r->maxcopywritelen);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1522(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1522 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minkeepsearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1522(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1522 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minkeepsearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1522(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1522 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1522");
	ndr->depth++;
	ndr_print_uint32(ndr, "minkeepsearch", r->minkeepsearch);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1523(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1523 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxkeepsearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1523(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1523 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxkeepsearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1523(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1523 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1523");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxkeepsearch", r->maxkeepsearch);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1524(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1524 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minkeepcomplsearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1524(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1524 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minkeepcomplsearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1524(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1524 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1524");
	ndr->depth++;
	ndr_print_uint32(ndr, "minkeepcomplsearch", r->minkeepcomplsearch);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1525(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1525 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxkeepcomplsearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1525(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1525 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxkeepcomplsearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1525(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1525 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1525");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxkeepcomplsearch", r->maxkeepcomplsearch);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1528(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1528 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->scavtimeout));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1528(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1528 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->scavtimeout));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1528(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1528 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1528");
	ndr->depth++;
	ndr_print_uint32(ndr, "scavtimeout", r->scavtimeout);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1529(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1529 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minrcvqueue));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1529(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1529 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minrcvqueue));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1529(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1529 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1529");
	ndr->depth++;
	ndr_print_uint32(ndr, "minrcvqueue", r->minrcvqueue);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1530(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1530 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minfreeworkitems));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1530(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1530 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minfreeworkitems));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1530(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1530 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1530");
	ndr->depth++;
	ndr_print_uint32(ndr, "minfreeworkitems", r->minfreeworkitems);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1533(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1533 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxmpxct));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1533(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1533 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxmpxct));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1533(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1533 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1533");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxmpxct", r->maxmpxct);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1534(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1534 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->oplockbreakwait));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1534(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1534 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->oplockbreakwait));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1534(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1534 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1534");
	ndr->depth++;
	ndr_print_uint32(ndr, "oplockbreakwait", r->oplockbreakwait);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1535(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1535 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->oplockbreakresponsewait));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1535(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1535 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->oplockbreakresponsewait));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1535(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1535 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1535");
	ndr->depth++;
	ndr_print_uint32(ndr, "oplockbreakresponsewait", r->oplockbreakresponsewait);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1536(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1536 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableoplocks));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1536(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1536 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableoplocks));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1536(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1536 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1536");
	ndr->depth++;
	ndr_print_uint32(ndr, "enableoplocks", r->enableoplocks);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1537(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1537 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableoplockforceclose));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1537(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1537 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableoplockforceclose));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1537(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1537 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1537");
	ndr->depth++;
	ndr_print_uint32(ndr, "enableoplockforceclose", r->enableoplockforceclose);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1538(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1538 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablefcbopens));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1538(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1538 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablefcbopens));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1538(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1538 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1538");
	ndr->depth++;
	ndr_print_uint32(ndr, "enablefcbopens", r->enablefcbopens);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1539(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1539 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enableraw));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1539(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1539 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enableraw));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1539(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1539 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1539");
	ndr->depth++;
	ndr_print_uint32(ndr, "enableraw", r->enableraw);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1540(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1540 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enablesharednetdrives));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1540(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1540 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enablesharednetdrives));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1540(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1540 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1540");
	ndr->depth++;
	ndr_print_uint32(ndr, "enablesharednetdrives", r->enablesharednetdrives);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1541(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1541 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minfreeconnections));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1541(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1541 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minfreeconnections));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1541(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1541 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1541");
	ndr->depth++;
	ndr_print_uint32(ndr, "minfreeconnections", r->minfreeconnections);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1542(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1542 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxfreeconnections));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1542(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1542 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxfreeconnections));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1542(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1542 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1542");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxfreeconnections", r->maxfreeconnections);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1543(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1543 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initsesstable));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1543(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1543 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initsesstable));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1543(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1543 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1543");
	ndr->depth++;
	ndr_print_uint32(ndr, "initsesstable", r->initsesstable);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1544(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1544 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initconntable));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1544(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1544 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initconntable));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1544(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1544 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1544");
	ndr->depth++;
	ndr_print_uint32(ndr, "initconntable", r->initconntable);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1545(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1545 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initfiletable));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1545(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1545 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initfiletable));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1545(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1545 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1545");
	ndr->depth++;
	ndr_print_uint32(ndr, "initfiletable", r->initfiletable);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1546(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1546 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->initsearchtable));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1546(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1546 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->initsearchtable));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1546(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1546 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1546");
	ndr->depth++;
	ndr_print_uint32(ndr, "initsearchtable", r->initsearchtable);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1547(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1547 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alertsched));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1547(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1547 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alertsched));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1547(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1547 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1547");
	ndr->depth++;
	ndr_print_uint32(ndr, "alertsched", r->alertsched);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1548(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1548 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->errortreshold));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1548(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1548 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->errortreshold));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1548(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1548 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1548");
	ndr->depth++;
	ndr_print_uint32(ndr, "errortreshold", r->errortreshold);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1549(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1549 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->networkerrortreshold));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1549(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1549 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->networkerrortreshold));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1549(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1549 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1549");
	ndr->depth++;
	ndr_print_uint32(ndr, "networkerrortreshold", r->networkerrortreshold);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1550(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1550 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->diskspacetreshold));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1550(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1550 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->diskspacetreshold));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1550(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1550 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1550");
	ndr->depth++;
	ndr_print_uint32(ndr, "diskspacetreshold", r->diskspacetreshold);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1552(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1552 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxlinkdelay));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1552(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1552 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxlinkdelay));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1552(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1552 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1552");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxlinkdelay", r->maxlinkdelay);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1553(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1553 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minlinkthroughput));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1553(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1553 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minlinkthroughput));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1553(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1553 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1553");
	ndr->depth++;
	ndr_print_uint32(ndr, "minlinkthroughput", r->minlinkthroughput);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1554(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1554 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->linkinfovalidtime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1554(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1554 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->linkinfovalidtime));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1554(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1554 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1554");
	ndr->depth++;
	ndr_print_uint32(ndr, "linkinfovalidtime", r->linkinfovalidtime);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1555(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1555 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->scavqosinfoupdatetime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1555(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1555 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->scavqosinfoupdatetime));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1555(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1555 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1555");
	ndr->depth++;
	ndr_print_uint32(ndr, "scavqosinfoupdatetime", r->scavqosinfoupdatetime);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo1556(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetSrvInfo1556 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxworkitemidletime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo1556(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetSrvInfo1556 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxworkitemidletime));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo1556(struct ndr_print *ndr, const char *name, const struct srvsvc_NetSrvInfo1556 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvInfo1556");
	ndr->depth++;
	ndr_print_uint32(ndr, "maxworkitemidletime", r->maxworkitemidletime);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvInfo(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetSrvInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 100: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info100));
			break; }

			case 101: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info101));
			break; }

			case 102: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info102));
			break; }

			case 402: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info402));
			break; }

			case 403: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info403));
			break; }

			case 502: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info502));
			break; }

			case 503: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info503));
			break; }

			case 599: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info599));
			break; }

			case 1005: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1005));
			break; }

			case 1010: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1010));
			break; }

			case 1016: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1016));
			break; }

			case 1017: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1017));
			break; }

			case 1018: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1018));
			break; }

			case 1107: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1107));
			break; }

			case 1501: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1501));
			break; }

			case 1502: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1502));
			break; }

			case 1503: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1503));
			break; }

			case 1506: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1506));
			break; }

			case 1509: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1509));
			break; }

			case 1510: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1510));
			break; }

			case 1511: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1511));
			break; }

			case 1512: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1512));
			break; }

			case 1513: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1513));
			break; }

			case 1514: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1514));
			break; }

			case 1515: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1515));
			break; }

			case 1516: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1516));
			break; }

			case 1518: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1518));
			break; }

			case 1520: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1520));
			break; }

			case 1521: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1521));
			break; }

			case 1522: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1522));
			break; }

			case 1523: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1523));
			break; }

			case 1524: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1524));
			break; }

			case 1525: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1525));
			break; }

			case 1528: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1528));
			break; }

			case 1529: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1529));
			break; }

			case 1530: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1530));
			break; }

			case 1533: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1533));
			break; }

			case 1534: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1534));
			break; }

			case 1535: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1535));
			break; }

			case 1536: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1536));
			break; }

			case 1537: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1537));
			break; }

			case 1538: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1538));
			break; }

			case 1539: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1539));
			break; }

			case 1540: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1540));
			break; }

			case 1541: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1541));
			break; }

			case 1542: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1542));
			break; }

			case 1543: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1543));
			break; }

			case 1544: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1544));
			break; }

			case 1545: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1545));
			break; }

			case 1546: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1546));
			break; }

			case 1547: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1547));
			break; }

			case 1548: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1548));
			break; }

			case 1549: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1549));
			break; }

			case 1550: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1550));
			break; }

			case 1552: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1552));
			break; }

			case 1553: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1553));
			break; }

			case 1554: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1554));
			break; }

			case 1555: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1555));
			break; }

			case 1556: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1556));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 100:
				if (r->info100) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo100(ndr, NDR_SCALARS|NDR_BUFFERS, r->info100));
				}
			break;

			case 101:
				if (r->info101) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo101(ndr, NDR_SCALARS|NDR_BUFFERS, r->info101));
				}
			break;

			case 102:
				if (r->info102) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo102(ndr, NDR_SCALARS|NDR_BUFFERS, r->info102));
				}
			break;

			case 402:
				if (r->info402) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo402(ndr, NDR_SCALARS|NDR_BUFFERS, r->info402));
				}
			break;

			case 403:
				if (r->info403) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo403(ndr, NDR_SCALARS|NDR_BUFFERS, r->info403));
				}
			break;

			case 502:
				if (r->info502) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo502(ndr, NDR_SCALARS, r->info502));
				}
			break;

			case 503:
				if (r->info503) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo503(ndr, NDR_SCALARS|NDR_BUFFERS, r->info503));
				}
			break;

			case 599:
				if (r->info599) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo599(ndr, NDR_SCALARS|NDR_BUFFERS, r->info599));
				}
			break;

			case 1005:
				if (r->info1005) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1005(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1005));
				}
			break;

			case 1010:
				if (r->info1010) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1010(ndr, NDR_SCALARS, r->info1010));
				}
			break;

			case 1016:
				if (r->info1016) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1016(ndr, NDR_SCALARS, r->info1016));
				}
			break;

			case 1017:
				if (r->info1017) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1017(ndr, NDR_SCALARS, r->info1017));
				}
			break;

			case 1018:
				if (r->info1018) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1018(ndr, NDR_SCALARS, r->info1018));
				}
			break;

			case 1107:
				if (r->info1107) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1107(ndr, NDR_SCALARS, r->info1107));
				}
			break;

			case 1501:
				if (r->info1501) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1501(ndr, NDR_SCALARS, r->info1501));
				}
			break;

			case 1502:
				if (r->info1502) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1502(ndr, NDR_SCALARS, r->info1502));
				}
			break;

			case 1503:
				if (r->info1503) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1503(ndr, NDR_SCALARS, r->info1503));
				}
			break;

			case 1506:
				if (r->info1506) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1506(ndr, NDR_SCALARS, r->info1506));
				}
			break;

			case 1509:
				if (r->info1509) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1509(ndr, NDR_SCALARS, r->info1509));
				}
			break;

			case 1510:
				if (r->info1510) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1510(ndr, NDR_SCALARS, r->info1510));
				}
			break;

			case 1511:
				if (r->info1511) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1511(ndr, NDR_SCALARS, r->info1511));
				}
			break;

			case 1512:
				if (r->info1512) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1512(ndr, NDR_SCALARS, r->info1512));
				}
			break;

			case 1513:
				if (r->info1513) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1513(ndr, NDR_SCALARS, r->info1513));
				}
			break;

			case 1514:
				if (r->info1514) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1514(ndr, NDR_SCALARS, r->info1514));
				}
			break;

			case 1515:
				if (r->info1515) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1515(ndr, NDR_SCALARS, r->info1515));
				}
			break;

			case 1516:
				if (r->info1516) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1516(ndr, NDR_SCALARS, r->info1516));
				}
			break;

			case 1518:
				if (r->info1518) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1518(ndr, NDR_SCALARS, r->info1518));
				}
			break;

			case 1520:
				if (r->info1520) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1520(ndr, NDR_SCALARS, r->info1520));
				}
			break;

			case 1521:
				if (r->info1521) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1521(ndr, NDR_SCALARS, r->info1521));
				}
			break;

			case 1522:
				if (r->info1522) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1522(ndr, NDR_SCALARS, r->info1522));
				}
			break;

			case 1523:
				if (r->info1523) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1523(ndr, NDR_SCALARS, r->info1523));
				}
			break;

			case 1524:
				if (r->info1524) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1524(ndr, NDR_SCALARS, r->info1524));
				}
			break;

			case 1525:
				if (r->info1525) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1525(ndr, NDR_SCALARS, r->info1525));
				}
			break;

			case 1528:
				if (r->info1528) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1528(ndr, NDR_SCALARS, r->info1528));
				}
			break;

			case 1529:
				if (r->info1529) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1529(ndr, NDR_SCALARS, r->info1529));
				}
			break;

			case 1530:
				if (r->info1530) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1530(ndr, NDR_SCALARS, r->info1530));
				}
			break;

			case 1533:
				if (r->info1533) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1533(ndr, NDR_SCALARS, r->info1533));
				}
			break;

			case 1534:
				if (r->info1534) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1534(ndr, NDR_SCALARS, r->info1534));
				}
			break;

			case 1535:
				if (r->info1535) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1535(ndr, NDR_SCALARS, r->info1535));
				}
			break;

			case 1536:
				if (r->info1536) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1536(ndr, NDR_SCALARS, r->info1536));
				}
			break;

			case 1537:
				if (r->info1537) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1537(ndr, NDR_SCALARS, r->info1537));
				}
			break;

			case 1538:
				if (r->info1538) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1538(ndr, NDR_SCALARS, r->info1538));
				}
			break;

			case 1539:
				if (r->info1539) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1539(ndr, NDR_SCALARS, r->info1539));
				}
			break;

			case 1540:
				if (r->info1540) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1540(ndr, NDR_SCALARS, r->info1540));
				}
			break;

			case 1541:
				if (r->info1541) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1541(ndr, NDR_SCALARS, r->info1541));
				}
			break;

			case 1542:
				if (r->info1542) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1542(ndr, NDR_SCALARS, r->info1542));
				}
			break;

			case 1543:
				if (r->info1543) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1543(ndr, NDR_SCALARS, r->info1543));
				}
			break;

			case 1544:
				if (r->info1544) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1544(ndr, NDR_SCALARS, r->info1544));
				}
			break;

			case 1545:
				if (r->info1545) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1545(ndr, NDR_SCALARS, r->info1545));
				}
			break;

			case 1546:
				if (r->info1546) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1546(ndr, NDR_SCALARS, r->info1546));
				}
			break;

			case 1547:
				if (r->info1547) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1547(ndr, NDR_SCALARS, r->info1547));
				}
			break;

			case 1548:
				if (r->info1548) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1548(ndr, NDR_SCALARS, r->info1548));
				}
			break;

			case 1549:
				if (r->info1549) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1549(ndr, NDR_SCALARS, r->info1549));
				}
			break;

			case 1550:
				if (r->info1550) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1550(ndr, NDR_SCALARS, r->info1550));
				}
			break;

			case 1552:
				if (r->info1552) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1552(ndr, NDR_SCALARS, r->info1552));
				}
			break;

			case 1553:
				if (r->info1553) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1553(ndr, NDR_SCALARS, r->info1553));
				}
			break;

			case 1554:
				if (r->info1554) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1554(ndr, NDR_SCALARS, r->info1554));
				}
			break;

			case 1555:
				if (r->info1555) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1555(ndr, NDR_SCALARS, r->info1555));
				}
			break;

			case 1556:
				if (r->info1556) {
					NDR_CHECK(ndr_push_srvsvc_NetSrvInfo1556(ndr, NDR_SCALARS, r->info1556));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvInfo(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetSrvInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info100_0;
	TALLOC_CTX *_mem_save_info101_0;
	TALLOC_CTX *_mem_save_info102_0;
	TALLOC_CTX *_mem_save_info402_0;
	TALLOC_CTX *_mem_save_info403_0;
	TALLOC_CTX *_mem_save_info502_0;
	TALLOC_CTX *_mem_save_info503_0;
	TALLOC_CTX *_mem_save_info599_0;
	TALLOC_CTX *_mem_save_info1005_0;
	TALLOC_CTX *_mem_save_info1010_0;
	TALLOC_CTX *_mem_save_info1016_0;
	TALLOC_CTX *_mem_save_info1017_0;
	TALLOC_CTX *_mem_save_info1018_0;
	TALLOC_CTX *_mem_save_info1107_0;
	TALLOC_CTX *_mem_save_info1501_0;
	TALLOC_CTX *_mem_save_info1502_0;
	TALLOC_CTX *_mem_save_info1503_0;
	TALLOC_CTX *_mem_save_info1506_0;
	TALLOC_CTX *_mem_save_info1509_0;
	TALLOC_CTX *_mem_save_info1510_0;
	TALLOC_CTX *_mem_save_info1511_0;
	TALLOC_CTX *_mem_save_info1512_0;
	TALLOC_CTX *_mem_save_info1513_0;
	TALLOC_CTX *_mem_save_info1514_0;
	TALLOC_CTX *_mem_save_info1515_0;
	TALLOC_CTX *_mem_save_info1516_0;
	TALLOC_CTX *_mem_save_info1518_0;
	TALLOC_CTX *_mem_save_info1520_0;
	TALLOC_CTX *_mem_save_info1521_0;
	TALLOC_CTX *_mem_save_info1522_0;
	TALLOC_CTX *_mem_save_info1523_0;
	TALLOC_CTX *_mem_save_info1524_0;
	TALLOC_CTX *_mem_save_info1525_0;
	TALLOC_CTX *_mem_save_info1528_0;
	TALLOC_CTX *_mem_save_info1529_0;
	TALLOC_CTX *_mem_save_info1530_0;
	TALLOC_CTX *_mem_save_info1533_0;
	TALLOC_CTX *_mem_save_info1534_0;
	TALLOC_CTX *_mem_save_info1535_0;
	TALLOC_CTX *_mem_save_info1536_0;
	TALLOC_CTX *_mem_save_info1537_0;
	TALLOC_CTX *_mem_save_info1538_0;
	TALLOC_CTX *_mem_save_info1539_0;
	TALLOC_CTX *_mem_save_info1540_0;
	TALLOC_CTX *_mem_save_info1541_0;
	TALLOC_CTX *_mem_save_info1542_0;
	TALLOC_CTX *_mem_save_info1543_0;
	TALLOC_CTX *_mem_save_info1544_0;
	TALLOC_CTX *_mem_save_info1545_0;
	TALLOC_CTX *_mem_save_info1546_0;
	TALLOC_CTX *_mem_save_info1547_0;
	TALLOC_CTX *_mem_save_info1548_0;
	TALLOC_CTX *_mem_save_info1549_0;
	TALLOC_CTX *_mem_save_info1550_0;
	TALLOC_CTX *_mem_save_info1552_0;
	TALLOC_CTX *_mem_save_info1553_0;
	TALLOC_CTX *_mem_save_info1554_0;
	TALLOC_CTX *_mem_save_info1555_0;
	TALLOC_CTX *_mem_save_info1556_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 100: {
				uint32_t _ptr_info100;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info100));
				if (_ptr_info100) {
					NDR_PULL_ALLOC(ndr, r->info100);
				} else {
					r->info100 = NULL;
				}
			break; }

			case 101: {
				uint32_t _ptr_info101;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info101));
				if (_ptr_info101) {
					NDR_PULL_ALLOC(ndr, r->info101);
				} else {
					r->info101 = NULL;
				}
			break; }

			case 102: {
				uint32_t _ptr_info102;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info102));
				if (_ptr_info102) {
					NDR_PULL_ALLOC(ndr, r->info102);
				} else {
					r->info102 = NULL;
				}
			break; }

			case 402: {
				uint32_t _ptr_info402;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info402));
				if (_ptr_info402) {
					NDR_PULL_ALLOC(ndr, r->info402);
				} else {
					r->info402 = NULL;
				}
			break; }

			case 403: {
				uint32_t _ptr_info403;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info403));
				if (_ptr_info403) {
					NDR_PULL_ALLOC(ndr, r->info403);
				} else {
					r->info403 = NULL;
				}
			break; }

			case 502: {
				uint32_t _ptr_info502;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info502));
				if (_ptr_info502) {
					NDR_PULL_ALLOC(ndr, r->info502);
				} else {
					r->info502 = NULL;
				}
			break; }

			case 503: {
				uint32_t _ptr_info503;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info503));
				if (_ptr_info503) {
					NDR_PULL_ALLOC(ndr, r->info503);
				} else {
					r->info503 = NULL;
				}
			break; }

			case 599: {
				uint32_t _ptr_info599;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info599));
				if (_ptr_info599) {
					NDR_PULL_ALLOC(ndr, r->info599);
				} else {
					r->info599 = NULL;
				}
			break; }

			case 1005: {
				uint32_t _ptr_info1005;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1005));
				if (_ptr_info1005) {
					NDR_PULL_ALLOC(ndr, r->info1005);
				} else {
					r->info1005 = NULL;
				}
			break; }

			case 1010: {
				uint32_t _ptr_info1010;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1010));
				if (_ptr_info1010) {
					NDR_PULL_ALLOC(ndr, r->info1010);
				} else {
					r->info1010 = NULL;
				}
			break; }

			case 1016: {
				uint32_t _ptr_info1016;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1016));
				if (_ptr_info1016) {
					NDR_PULL_ALLOC(ndr, r->info1016);
				} else {
					r->info1016 = NULL;
				}
			break; }

			case 1017: {
				uint32_t _ptr_info1017;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1017));
				if (_ptr_info1017) {
					NDR_PULL_ALLOC(ndr, r->info1017);
				} else {
					r->info1017 = NULL;
				}
			break; }

			case 1018: {
				uint32_t _ptr_info1018;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1018));
				if (_ptr_info1018) {
					NDR_PULL_ALLOC(ndr, r->info1018);
				} else {
					r->info1018 = NULL;
				}
			break; }

			case 1107: {
				uint32_t _ptr_info1107;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1107));
				if (_ptr_info1107) {
					NDR_PULL_ALLOC(ndr, r->info1107);
				} else {
					r->info1107 = NULL;
				}
			break; }

			case 1501: {
				uint32_t _ptr_info1501;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1501));
				if (_ptr_info1501) {
					NDR_PULL_ALLOC(ndr, r->info1501);
				} else {
					r->info1501 = NULL;
				}
			break; }

			case 1502: {
				uint32_t _ptr_info1502;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1502));
				if (_ptr_info1502) {
					NDR_PULL_ALLOC(ndr, r->info1502);
				} else {
					r->info1502 = NULL;
				}
			break; }

			case 1503: {
				uint32_t _ptr_info1503;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1503));
				if (_ptr_info1503) {
					NDR_PULL_ALLOC(ndr, r->info1503);
				} else {
					r->info1503 = NULL;
				}
			break; }

			case 1506: {
				uint32_t _ptr_info1506;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1506));
				if (_ptr_info1506) {
					NDR_PULL_ALLOC(ndr, r->info1506);
				} else {
					r->info1506 = NULL;
				}
			break; }

			case 1509: {
				uint32_t _ptr_info1509;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1509));
				if (_ptr_info1509) {
					NDR_PULL_ALLOC(ndr, r->info1509);
				} else {
					r->info1509 = NULL;
				}
			break; }

			case 1510: {
				uint32_t _ptr_info1510;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1510));
				if (_ptr_info1510) {
					NDR_PULL_ALLOC(ndr, r->info1510);
				} else {
					r->info1510 = NULL;
				}
			break; }

			case 1511: {
				uint32_t _ptr_info1511;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1511));
				if (_ptr_info1511) {
					NDR_PULL_ALLOC(ndr, r->info1511);
				} else {
					r->info1511 = NULL;
				}
			break; }

			case 1512: {
				uint32_t _ptr_info1512;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1512));
				if (_ptr_info1512) {
					NDR_PULL_ALLOC(ndr, r->info1512);
				} else {
					r->info1512 = NULL;
				}
			break; }

			case 1513: {
				uint32_t _ptr_info1513;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1513));
				if (_ptr_info1513) {
					NDR_PULL_ALLOC(ndr, r->info1513);
				} else {
					r->info1513 = NULL;
				}
			break; }

			case 1514: {
				uint32_t _ptr_info1514;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1514));
				if (_ptr_info1514) {
					NDR_PULL_ALLOC(ndr, r->info1514);
				} else {
					r->info1514 = NULL;
				}
			break; }

			case 1515: {
				uint32_t _ptr_info1515;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1515));
				if (_ptr_info1515) {
					NDR_PULL_ALLOC(ndr, r->info1515);
				} else {
					r->info1515 = NULL;
				}
			break; }

			case 1516: {
				uint32_t _ptr_info1516;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1516));
				if (_ptr_info1516) {
					NDR_PULL_ALLOC(ndr, r->info1516);
				} else {
					r->info1516 = NULL;
				}
			break; }

			case 1518: {
				uint32_t _ptr_info1518;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1518));
				if (_ptr_info1518) {
					NDR_PULL_ALLOC(ndr, r->info1518);
				} else {
					r->info1518 = NULL;
				}
			break; }

			case 1520: {
				uint32_t _ptr_info1520;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1520));
				if (_ptr_info1520) {
					NDR_PULL_ALLOC(ndr, r->info1520);
				} else {
					r->info1520 = NULL;
				}
			break; }

			case 1521: {
				uint32_t _ptr_info1521;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1521));
				if (_ptr_info1521) {
					NDR_PULL_ALLOC(ndr, r->info1521);
				} else {
					r->info1521 = NULL;
				}
			break; }

			case 1522: {
				uint32_t _ptr_info1522;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1522));
				if (_ptr_info1522) {
					NDR_PULL_ALLOC(ndr, r->info1522);
				} else {
					r->info1522 = NULL;
				}
			break; }

			case 1523: {
				uint32_t _ptr_info1523;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1523));
				if (_ptr_info1523) {
					NDR_PULL_ALLOC(ndr, r->info1523);
				} else {
					r->info1523 = NULL;
				}
			break; }

			case 1524: {
				uint32_t _ptr_info1524;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1524));
				if (_ptr_info1524) {
					NDR_PULL_ALLOC(ndr, r->info1524);
				} else {
					r->info1524 = NULL;
				}
			break; }

			case 1525: {
				uint32_t _ptr_info1525;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1525));
				if (_ptr_info1525) {
					NDR_PULL_ALLOC(ndr, r->info1525);
				} else {
					r->info1525 = NULL;
				}
			break; }

			case 1528: {
				uint32_t _ptr_info1528;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1528));
				if (_ptr_info1528) {
					NDR_PULL_ALLOC(ndr, r->info1528);
				} else {
					r->info1528 = NULL;
				}
			break; }

			case 1529: {
				uint32_t _ptr_info1529;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1529));
				if (_ptr_info1529) {
					NDR_PULL_ALLOC(ndr, r->info1529);
				} else {
					r->info1529 = NULL;
				}
			break; }

			case 1530: {
				uint32_t _ptr_info1530;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1530));
				if (_ptr_info1530) {
					NDR_PULL_ALLOC(ndr, r->info1530);
				} else {
					r->info1530 = NULL;
				}
			break; }

			case 1533: {
				uint32_t _ptr_info1533;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1533));
				if (_ptr_info1533) {
					NDR_PULL_ALLOC(ndr, r->info1533);
				} else {
					r->info1533 = NULL;
				}
			break; }

			case 1534: {
				uint32_t _ptr_info1534;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1534));
				if (_ptr_info1534) {
					NDR_PULL_ALLOC(ndr, r->info1534);
				} else {
					r->info1534 = NULL;
				}
			break; }

			case 1535: {
				uint32_t _ptr_info1535;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1535));
				if (_ptr_info1535) {
					NDR_PULL_ALLOC(ndr, r->info1535);
				} else {
					r->info1535 = NULL;
				}
			break; }

			case 1536: {
				uint32_t _ptr_info1536;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1536));
				if (_ptr_info1536) {
					NDR_PULL_ALLOC(ndr, r->info1536);
				} else {
					r->info1536 = NULL;
				}
			break; }

			case 1537: {
				uint32_t _ptr_info1537;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1537));
				if (_ptr_info1537) {
					NDR_PULL_ALLOC(ndr, r->info1537);
				} else {
					r->info1537 = NULL;
				}
			break; }

			case 1538: {
				uint32_t _ptr_info1538;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1538));
				if (_ptr_info1538) {
					NDR_PULL_ALLOC(ndr, r->info1538);
				} else {
					r->info1538 = NULL;
				}
			break; }

			case 1539: {
				uint32_t _ptr_info1539;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1539));
				if (_ptr_info1539) {
					NDR_PULL_ALLOC(ndr, r->info1539);
				} else {
					r->info1539 = NULL;
				}
			break; }

			case 1540: {
				uint32_t _ptr_info1540;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1540));
				if (_ptr_info1540) {
					NDR_PULL_ALLOC(ndr, r->info1540);
				} else {
					r->info1540 = NULL;
				}
			break; }

			case 1541: {
				uint32_t _ptr_info1541;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1541));
				if (_ptr_info1541) {
					NDR_PULL_ALLOC(ndr, r->info1541);
				} else {
					r->info1541 = NULL;
				}
			break; }

			case 1542: {
				uint32_t _ptr_info1542;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1542));
				if (_ptr_info1542) {
					NDR_PULL_ALLOC(ndr, r->info1542);
				} else {
					r->info1542 = NULL;
				}
			break; }

			case 1543: {
				uint32_t _ptr_info1543;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1543));
				if (_ptr_info1543) {
					NDR_PULL_ALLOC(ndr, r->info1543);
				} else {
					r->info1543 = NULL;
				}
			break; }

			case 1544: {
				uint32_t _ptr_info1544;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1544));
				if (_ptr_info1544) {
					NDR_PULL_ALLOC(ndr, r->info1544);
				} else {
					r->info1544 = NULL;
				}
			break; }

			case 1545: {
				uint32_t _ptr_info1545;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1545));
				if (_ptr_info1545) {
					NDR_PULL_ALLOC(ndr, r->info1545);
				} else {
					r->info1545 = NULL;
				}
			break; }

			case 1546: {
				uint32_t _ptr_info1546;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1546));
				if (_ptr_info1546) {
					NDR_PULL_ALLOC(ndr, r->info1546);
				} else {
					r->info1546 = NULL;
				}
			break; }

			case 1547: {
				uint32_t _ptr_info1547;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1547));
				if (_ptr_info1547) {
					NDR_PULL_ALLOC(ndr, r->info1547);
				} else {
					r->info1547 = NULL;
				}
			break; }

			case 1548: {
				uint32_t _ptr_info1548;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1548));
				if (_ptr_info1548) {
					NDR_PULL_ALLOC(ndr, r->info1548);
				} else {
					r->info1548 = NULL;
				}
			break; }

			case 1549: {
				uint32_t _ptr_info1549;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1549));
				if (_ptr_info1549) {
					NDR_PULL_ALLOC(ndr, r->info1549);
				} else {
					r->info1549 = NULL;
				}
			break; }

			case 1550: {
				uint32_t _ptr_info1550;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1550));
				if (_ptr_info1550) {
					NDR_PULL_ALLOC(ndr, r->info1550);
				} else {
					r->info1550 = NULL;
				}
			break; }

			case 1552: {
				uint32_t _ptr_info1552;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1552));
				if (_ptr_info1552) {
					NDR_PULL_ALLOC(ndr, r->info1552);
				} else {
					r->info1552 = NULL;
				}
			break; }

			case 1553: {
				uint32_t _ptr_info1553;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1553));
				if (_ptr_info1553) {
					NDR_PULL_ALLOC(ndr, r->info1553);
				} else {
					r->info1553 = NULL;
				}
			break; }

			case 1554: {
				uint32_t _ptr_info1554;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1554));
				if (_ptr_info1554) {
					NDR_PULL_ALLOC(ndr, r->info1554);
				} else {
					r->info1554 = NULL;
				}
			break; }

			case 1555: {
				uint32_t _ptr_info1555;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1555));
				if (_ptr_info1555) {
					NDR_PULL_ALLOC(ndr, r->info1555);
				} else {
					r->info1555 = NULL;
				}
			break; }

			case 1556: {
				uint32_t _ptr_info1556;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1556));
				if (_ptr_info1556) {
					NDR_PULL_ALLOC(ndr, r->info1556);
				} else {
					r->info1556 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 100:
				if (r->info100) {
					_mem_save_info100_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info100, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo100(ndr, NDR_SCALARS|NDR_BUFFERS, r->info100));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info100_0, 0);
				}
			break;

			case 101:
				if (r->info101) {
					_mem_save_info101_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info101, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo101(ndr, NDR_SCALARS|NDR_BUFFERS, r->info101));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info101_0, 0);
				}
			break;

			case 102:
				if (r->info102) {
					_mem_save_info102_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info102, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo102(ndr, NDR_SCALARS|NDR_BUFFERS, r->info102));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info102_0, 0);
				}
			break;

			case 402:
				if (r->info402) {
					_mem_save_info402_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info402, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo402(ndr, NDR_SCALARS|NDR_BUFFERS, r->info402));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info402_0, 0);
				}
			break;

			case 403:
				if (r->info403) {
					_mem_save_info403_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info403, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo403(ndr, NDR_SCALARS|NDR_BUFFERS, r->info403));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info403_0, 0);
				}
			break;

			case 502:
				if (r->info502) {
					_mem_save_info502_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info502, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo502(ndr, NDR_SCALARS, r->info502));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info502_0, 0);
				}
			break;

			case 503:
				if (r->info503) {
					_mem_save_info503_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info503, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo503(ndr, NDR_SCALARS|NDR_BUFFERS, r->info503));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info503_0, 0);
				}
			break;

			case 599:
				if (r->info599) {
					_mem_save_info599_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info599, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo599(ndr, NDR_SCALARS|NDR_BUFFERS, r->info599));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info599_0, 0);
				}
			break;

			case 1005:
				if (r->info1005) {
					_mem_save_info1005_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1005, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1005(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1005));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1005_0, 0);
				}
			break;

			case 1010:
				if (r->info1010) {
					_mem_save_info1010_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1010, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1010(ndr, NDR_SCALARS, r->info1010));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1010_0, 0);
				}
			break;

			case 1016:
				if (r->info1016) {
					_mem_save_info1016_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1016, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1016(ndr, NDR_SCALARS, r->info1016));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1016_0, 0);
				}
			break;

			case 1017:
				if (r->info1017) {
					_mem_save_info1017_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1017, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1017(ndr, NDR_SCALARS, r->info1017));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1017_0, 0);
				}
			break;

			case 1018:
				if (r->info1018) {
					_mem_save_info1018_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1018, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1018(ndr, NDR_SCALARS, r->info1018));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1018_0, 0);
				}
			break;

			case 1107:
				if (r->info1107) {
					_mem_save_info1107_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1107, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1107(ndr, NDR_SCALARS, r->info1107));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1107_0, 0);
				}
			break;

			case 1501:
				if (r->info1501) {
					_mem_save_info1501_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1501, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1501(ndr, NDR_SCALARS, r->info1501));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1501_0, 0);
				}
			break;

			case 1502:
				if (r->info1502) {
					_mem_save_info1502_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1502, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1502(ndr, NDR_SCALARS, r->info1502));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1502_0, 0);
				}
			break;

			case 1503:
				if (r->info1503) {
					_mem_save_info1503_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1503, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1503(ndr, NDR_SCALARS, r->info1503));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1503_0, 0);
				}
			break;

			case 1506:
				if (r->info1506) {
					_mem_save_info1506_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1506, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1506(ndr, NDR_SCALARS, r->info1506));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1506_0, 0);
				}
			break;

			case 1509:
				if (r->info1509) {
					_mem_save_info1509_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1509, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1509(ndr, NDR_SCALARS, r->info1509));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1509_0, 0);
				}
			break;

			case 1510:
				if (r->info1510) {
					_mem_save_info1510_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1510, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1510(ndr, NDR_SCALARS, r->info1510));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1510_0, 0);
				}
			break;

			case 1511:
				if (r->info1511) {
					_mem_save_info1511_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1511, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1511(ndr, NDR_SCALARS, r->info1511));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1511_0, 0);
				}
			break;

			case 1512:
				if (r->info1512) {
					_mem_save_info1512_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1512, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1512(ndr, NDR_SCALARS, r->info1512));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1512_0, 0);
				}
			break;

			case 1513:
				if (r->info1513) {
					_mem_save_info1513_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1513, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1513(ndr, NDR_SCALARS, r->info1513));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1513_0, 0);
				}
			break;

			case 1514:
				if (r->info1514) {
					_mem_save_info1514_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1514, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1514(ndr, NDR_SCALARS, r->info1514));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1514_0, 0);
				}
			break;

			case 1515:
				if (r->info1515) {
					_mem_save_info1515_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1515, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1515(ndr, NDR_SCALARS, r->info1515));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1515_0, 0);
				}
			break;

			case 1516:
				if (r->info1516) {
					_mem_save_info1516_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1516, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1516(ndr, NDR_SCALARS, r->info1516));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1516_0, 0);
				}
			break;

			case 1518:
				if (r->info1518) {
					_mem_save_info1518_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1518, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1518(ndr, NDR_SCALARS, r->info1518));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1518_0, 0);
				}
			break;

			case 1520:
				if (r->info1520) {
					_mem_save_info1520_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1520, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1520(ndr, NDR_SCALARS, r->info1520));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1520_0, 0);
				}
			break;

			case 1521:
				if (r->info1521) {
					_mem_save_info1521_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1521, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1521(ndr, NDR_SCALARS, r->info1521));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1521_0, 0);
				}
			break;

			case 1522:
				if (r->info1522) {
					_mem_save_info1522_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1522, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1522(ndr, NDR_SCALARS, r->info1522));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1522_0, 0);
				}
			break;

			case 1523:
				if (r->info1523) {
					_mem_save_info1523_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1523, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1523(ndr, NDR_SCALARS, r->info1523));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1523_0, 0);
				}
			break;

			case 1524:
				if (r->info1524) {
					_mem_save_info1524_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1524, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1524(ndr, NDR_SCALARS, r->info1524));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1524_0, 0);
				}
			break;

			case 1525:
				if (r->info1525) {
					_mem_save_info1525_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1525, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1525(ndr, NDR_SCALARS, r->info1525));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1525_0, 0);
				}
			break;

			case 1528:
				if (r->info1528) {
					_mem_save_info1528_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1528, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1528(ndr, NDR_SCALARS, r->info1528));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1528_0, 0);
				}
			break;

			case 1529:
				if (r->info1529) {
					_mem_save_info1529_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1529, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1529(ndr, NDR_SCALARS, r->info1529));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1529_0, 0);
				}
			break;

			case 1530:
				if (r->info1530) {
					_mem_save_info1530_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1530, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1530(ndr, NDR_SCALARS, r->info1530));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1530_0, 0);
				}
			break;

			case 1533:
				if (r->info1533) {
					_mem_save_info1533_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1533, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1533(ndr, NDR_SCALARS, r->info1533));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1533_0, 0);
				}
			break;

			case 1534:
				if (r->info1534) {
					_mem_save_info1534_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1534, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1534(ndr, NDR_SCALARS, r->info1534));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1534_0, 0);
				}
			break;

			case 1535:
				if (r->info1535) {
					_mem_save_info1535_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1535, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1535(ndr, NDR_SCALARS, r->info1535));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1535_0, 0);
				}
			break;

			case 1536:
				if (r->info1536) {
					_mem_save_info1536_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1536, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1536(ndr, NDR_SCALARS, r->info1536));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1536_0, 0);
				}
			break;

			case 1537:
				if (r->info1537) {
					_mem_save_info1537_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1537, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1537(ndr, NDR_SCALARS, r->info1537));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1537_0, 0);
				}
			break;

			case 1538:
				if (r->info1538) {
					_mem_save_info1538_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1538, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1538(ndr, NDR_SCALARS, r->info1538));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1538_0, 0);
				}
			break;

			case 1539:
				if (r->info1539) {
					_mem_save_info1539_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1539, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1539(ndr, NDR_SCALARS, r->info1539));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1539_0, 0);
				}
			break;

			case 1540:
				if (r->info1540) {
					_mem_save_info1540_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1540, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1540(ndr, NDR_SCALARS, r->info1540));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1540_0, 0);
				}
			break;

			case 1541:
				if (r->info1541) {
					_mem_save_info1541_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1541, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1541(ndr, NDR_SCALARS, r->info1541));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1541_0, 0);
				}
			break;

			case 1542:
				if (r->info1542) {
					_mem_save_info1542_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1542, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1542(ndr, NDR_SCALARS, r->info1542));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1542_0, 0);
				}
			break;

			case 1543:
				if (r->info1543) {
					_mem_save_info1543_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1543, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1543(ndr, NDR_SCALARS, r->info1543));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1543_0, 0);
				}
			break;

			case 1544:
				if (r->info1544) {
					_mem_save_info1544_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1544, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1544(ndr, NDR_SCALARS, r->info1544));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1544_0, 0);
				}
			break;

			case 1545:
				if (r->info1545) {
					_mem_save_info1545_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1545, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1545(ndr, NDR_SCALARS, r->info1545));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1545_0, 0);
				}
			break;

			case 1546:
				if (r->info1546) {
					_mem_save_info1546_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1546, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1546(ndr, NDR_SCALARS, r->info1546));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1546_0, 0);
				}
			break;

			case 1547:
				if (r->info1547) {
					_mem_save_info1547_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1547, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1547(ndr, NDR_SCALARS, r->info1547));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1547_0, 0);
				}
			break;

			case 1548:
				if (r->info1548) {
					_mem_save_info1548_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1548, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1548(ndr, NDR_SCALARS, r->info1548));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1548_0, 0);
				}
			break;

			case 1549:
				if (r->info1549) {
					_mem_save_info1549_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1549, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1549(ndr, NDR_SCALARS, r->info1549));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1549_0, 0);
				}
			break;

			case 1550:
				if (r->info1550) {
					_mem_save_info1550_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1550, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1550(ndr, NDR_SCALARS, r->info1550));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1550_0, 0);
				}
			break;

			case 1552:
				if (r->info1552) {
					_mem_save_info1552_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1552, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1552(ndr, NDR_SCALARS, r->info1552));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1552_0, 0);
				}
			break;

			case 1553:
				if (r->info1553) {
					_mem_save_info1553_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1553, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1553(ndr, NDR_SCALARS, r->info1553));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1553_0, 0);
				}
			break;

			case 1554:
				if (r->info1554) {
					_mem_save_info1554_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1554, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1554(ndr, NDR_SCALARS, r->info1554));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1554_0, 0);
				}
			break;

			case 1555:
				if (r->info1555) {
					_mem_save_info1555_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1555, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1555(ndr, NDR_SCALARS, r->info1555));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1555_0, 0);
				}
			break;

			case 1556:
				if (r->info1556) {
					_mem_save_info1556_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1556, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo1556(ndr, NDR_SCALARS, r->info1556));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1556_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvInfo(struct ndr_print *ndr, const char *name, const union srvsvc_NetSrvInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetSrvInfo");
	switch (level) {
		case 100:
			ndr_print_ptr(ndr, "info100", r->info100);
			ndr->depth++;
			if (r->info100) {
				ndr_print_srvsvc_NetSrvInfo100(ndr, "info100", r->info100);
			}
			ndr->depth--;
		break;

		case 101:
			ndr_print_ptr(ndr, "info101", r->info101);
			ndr->depth++;
			if (r->info101) {
				ndr_print_srvsvc_NetSrvInfo101(ndr, "info101", r->info101);
			}
			ndr->depth--;
		break;

		case 102:
			ndr_print_ptr(ndr, "info102", r->info102);
			ndr->depth++;
			if (r->info102) {
				ndr_print_srvsvc_NetSrvInfo102(ndr, "info102", r->info102);
			}
			ndr->depth--;
		break;

		case 402:
			ndr_print_ptr(ndr, "info402", r->info402);
			ndr->depth++;
			if (r->info402) {
				ndr_print_srvsvc_NetSrvInfo402(ndr, "info402", r->info402);
			}
			ndr->depth--;
		break;

		case 403:
			ndr_print_ptr(ndr, "info403", r->info403);
			ndr->depth++;
			if (r->info403) {
				ndr_print_srvsvc_NetSrvInfo403(ndr, "info403", r->info403);
			}
			ndr->depth--;
		break;

		case 502:
			ndr_print_ptr(ndr, "info502", r->info502);
			ndr->depth++;
			if (r->info502) {
				ndr_print_srvsvc_NetSrvInfo502(ndr, "info502", r->info502);
			}
			ndr->depth--;
		break;

		case 503:
			ndr_print_ptr(ndr, "info503", r->info503);
			ndr->depth++;
			if (r->info503) {
				ndr_print_srvsvc_NetSrvInfo503(ndr, "info503", r->info503);
			}
			ndr->depth--;
		break;

		case 599:
			ndr_print_ptr(ndr, "info599", r->info599);
			ndr->depth++;
			if (r->info599) {
				ndr_print_srvsvc_NetSrvInfo599(ndr, "info599", r->info599);
			}
			ndr->depth--;
		break;

		case 1005:
			ndr_print_ptr(ndr, "info1005", r->info1005);
			ndr->depth++;
			if (r->info1005) {
				ndr_print_srvsvc_NetSrvInfo1005(ndr, "info1005", r->info1005);
			}
			ndr->depth--;
		break;

		case 1010:
			ndr_print_ptr(ndr, "info1010", r->info1010);
			ndr->depth++;
			if (r->info1010) {
				ndr_print_srvsvc_NetSrvInfo1010(ndr, "info1010", r->info1010);
			}
			ndr->depth--;
		break;

		case 1016:
			ndr_print_ptr(ndr, "info1016", r->info1016);
			ndr->depth++;
			if (r->info1016) {
				ndr_print_srvsvc_NetSrvInfo1016(ndr, "info1016", r->info1016);
			}
			ndr->depth--;
		break;

		case 1017:
			ndr_print_ptr(ndr, "info1017", r->info1017);
			ndr->depth++;
			if (r->info1017) {
				ndr_print_srvsvc_NetSrvInfo1017(ndr, "info1017", r->info1017);
			}
			ndr->depth--;
		break;

		case 1018:
			ndr_print_ptr(ndr, "info1018", r->info1018);
			ndr->depth++;
			if (r->info1018) {
				ndr_print_srvsvc_NetSrvInfo1018(ndr, "info1018", r->info1018);
			}
			ndr->depth--;
		break;

		case 1107:
			ndr_print_ptr(ndr, "info1107", r->info1107);
			ndr->depth++;
			if (r->info1107) {
				ndr_print_srvsvc_NetSrvInfo1107(ndr, "info1107", r->info1107);
			}
			ndr->depth--;
		break;

		case 1501:
			ndr_print_ptr(ndr, "info1501", r->info1501);
			ndr->depth++;
			if (r->info1501) {
				ndr_print_srvsvc_NetSrvInfo1501(ndr, "info1501", r->info1501);
			}
			ndr->depth--;
		break;

		case 1502:
			ndr_print_ptr(ndr, "info1502", r->info1502);
			ndr->depth++;
			if (r->info1502) {
				ndr_print_srvsvc_NetSrvInfo1502(ndr, "info1502", r->info1502);
			}
			ndr->depth--;
		break;

		case 1503:
			ndr_print_ptr(ndr, "info1503", r->info1503);
			ndr->depth++;
			if (r->info1503) {
				ndr_print_srvsvc_NetSrvInfo1503(ndr, "info1503", r->info1503);
			}
			ndr->depth--;
		break;

		case 1506:
			ndr_print_ptr(ndr, "info1506", r->info1506);
			ndr->depth++;
			if (r->info1506) {
				ndr_print_srvsvc_NetSrvInfo1506(ndr, "info1506", r->info1506);
			}
			ndr->depth--;
		break;

		case 1509:
			ndr_print_ptr(ndr, "info1509", r->info1509);
			ndr->depth++;
			if (r->info1509) {
				ndr_print_srvsvc_NetSrvInfo1509(ndr, "info1509", r->info1509);
			}
			ndr->depth--;
		break;

		case 1510:
			ndr_print_ptr(ndr, "info1510", r->info1510);
			ndr->depth++;
			if (r->info1510) {
				ndr_print_srvsvc_NetSrvInfo1510(ndr, "info1510", r->info1510);
			}
			ndr->depth--;
		break;

		case 1511:
			ndr_print_ptr(ndr, "info1511", r->info1511);
			ndr->depth++;
			if (r->info1511) {
				ndr_print_srvsvc_NetSrvInfo1511(ndr, "info1511", r->info1511);
			}
			ndr->depth--;
		break;

		case 1512:
			ndr_print_ptr(ndr, "info1512", r->info1512);
			ndr->depth++;
			if (r->info1512) {
				ndr_print_srvsvc_NetSrvInfo1512(ndr, "info1512", r->info1512);
			}
			ndr->depth--;
		break;

		case 1513:
			ndr_print_ptr(ndr, "info1513", r->info1513);
			ndr->depth++;
			if (r->info1513) {
				ndr_print_srvsvc_NetSrvInfo1513(ndr, "info1513", r->info1513);
			}
			ndr->depth--;
		break;

		case 1514:
			ndr_print_ptr(ndr, "info1514", r->info1514);
			ndr->depth++;
			if (r->info1514) {
				ndr_print_srvsvc_NetSrvInfo1514(ndr, "info1514", r->info1514);
			}
			ndr->depth--;
		break;

		case 1515:
			ndr_print_ptr(ndr, "info1515", r->info1515);
			ndr->depth++;
			if (r->info1515) {
				ndr_print_srvsvc_NetSrvInfo1515(ndr, "info1515", r->info1515);
			}
			ndr->depth--;
		break;

		case 1516:
			ndr_print_ptr(ndr, "info1516", r->info1516);
			ndr->depth++;
			if (r->info1516) {
				ndr_print_srvsvc_NetSrvInfo1516(ndr, "info1516", r->info1516);
			}
			ndr->depth--;
		break;

		case 1518:
			ndr_print_ptr(ndr, "info1518", r->info1518);
			ndr->depth++;
			if (r->info1518) {
				ndr_print_srvsvc_NetSrvInfo1518(ndr, "info1518", r->info1518);
			}
			ndr->depth--;
		break;

		case 1520:
			ndr_print_ptr(ndr, "info1520", r->info1520);
			ndr->depth++;
			if (r->info1520) {
				ndr_print_srvsvc_NetSrvInfo1520(ndr, "info1520", r->info1520);
			}
			ndr->depth--;
		break;

		case 1521:
			ndr_print_ptr(ndr, "info1521", r->info1521);
			ndr->depth++;
			if (r->info1521) {
				ndr_print_srvsvc_NetSrvInfo1521(ndr, "info1521", r->info1521);
			}
			ndr->depth--;
		break;

		case 1522:
			ndr_print_ptr(ndr, "info1522", r->info1522);
			ndr->depth++;
			if (r->info1522) {
				ndr_print_srvsvc_NetSrvInfo1522(ndr, "info1522", r->info1522);
			}
			ndr->depth--;
		break;

		case 1523:
			ndr_print_ptr(ndr, "info1523", r->info1523);
			ndr->depth++;
			if (r->info1523) {
				ndr_print_srvsvc_NetSrvInfo1523(ndr, "info1523", r->info1523);
			}
			ndr->depth--;
		break;

		case 1524:
			ndr_print_ptr(ndr, "info1524", r->info1524);
			ndr->depth++;
			if (r->info1524) {
				ndr_print_srvsvc_NetSrvInfo1524(ndr, "info1524", r->info1524);
			}
			ndr->depth--;
		break;

		case 1525:
			ndr_print_ptr(ndr, "info1525", r->info1525);
			ndr->depth++;
			if (r->info1525) {
				ndr_print_srvsvc_NetSrvInfo1525(ndr, "info1525", r->info1525);
			}
			ndr->depth--;
		break;

		case 1528:
			ndr_print_ptr(ndr, "info1528", r->info1528);
			ndr->depth++;
			if (r->info1528) {
				ndr_print_srvsvc_NetSrvInfo1528(ndr, "info1528", r->info1528);
			}
			ndr->depth--;
		break;

		case 1529:
			ndr_print_ptr(ndr, "info1529", r->info1529);
			ndr->depth++;
			if (r->info1529) {
				ndr_print_srvsvc_NetSrvInfo1529(ndr, "info1529", r->info1529);
			}
			ndr->depth--;
		break;

		case 1530:
			ndr_print_ptr(ndr, "info1530", r->info1530);
			ndr->depth++;
			if (r->info1530) {
				ndr_print_srvsvc_NetSrvInfo1530(ndr, "info1530", r->info1530);
			}
			ndr->depth--;
		break;

		case 1533:
			ndr_print_ptr(ndr, "info1533", r->info1533);
			ndr->depth++;
			if (r->info1533) {
				ndr_print_srvsvc_NetSrvInfo1533(ndr, "info1533", r->info1533);
			}
			ndr->depth--;
		break;

		case 1534:
			ndr_print_ptr(ndr, "info1534", r->info1534);
			ndr->depth++;
			if (r->info1534) {
				ndr_print_srvsvc_NetSrvInfo1534(ndr, "info1534", r->info1534);
			}
			ndr->depth--;
		break;

		case 1535:
			ndr_print_ptr(ndr, "info1535", r->info1535);
			ndr->depth++;
			if (r->info1535) {
				ndr_print_srvsvc_NetSrvInfo1535(ndr, "info1535", r->info1535);
			}
			ndr->depth--;
		break;

		case 1536:
			ndr_print_ptr(ndr, "info1536", r->info1536);
			ndr->depth++;
			if (r->info1536) {
				ndr_print_srvsvc_NetSrvInfo1536(ndr, "info1536", r->info1536);
			}
			ndr->depth--;
		break;

		case 1537:
			ndr_print_ptr(ndr, "info1537", r->info1537);
			ndr->depth++;
			if (r->info1537) {
				ndr_print_srvsvc_NetSrvInfo1537(ndr, "info1537", r->info1537);
			}
			ndr->depth--;
		break;

		case 1538:
			ndr_print_ptr(ndr, "info1538", r->info1538);
			ndr->depth++;
			if (r->info1538) {
				ndr_print_srvsvc_NetSrvInfo1538(ndr, "info1538", r->info1538);
			}
			ndr->depth--;
		break;

		case 1539:
			ndr_print_ptr(ndr, "info1539", r->info1539);
			ndr->depth++;
			if (r->info1539) {
				ndr_print_srvsvc_NetSrvInfo1539(ndr, "info1539", r->info1539);
			}
			ndr->depth--;
		break;

		case 1540:
			ndr_print_ptr(ndr, "info1540", r->info1540);
			ndr->depth++;
			if (r->info1540) {
				ndr_print_srvsvc_NetSrvInfo1540(ndr, "info1540", r->info1540);
			}
			ndr->depth--;
		break;

		case 1541:
			ndr_print_ptr(ndr, "info1541", r->info1541);
			ndr->depth++;
			if (r->info1541) {
				ndr_print_srvsvc_NetSrvInfo1541(ndr, "info1541", r->info1541);
			}
			ndr->depth--;
		break;

		case 1542:
			ndr_print_ptr(ndr, "info1542", r->info1542);
			ndr->depth++;
			if (r->info1542) {
				ndr_print_srvsvc_NetSrvInfo1542(ndr, "info1542", r->info1542);
			}
			ndr->depth--;
		break;

		case 1543:
			ndr_print_ptr(ndr, "info1543", r->info1543);
			ndr->depth++;
			if (r->info1543) {
				ndr_print_srvsvc_NetSrvInfo1543(ndr, "info1543", r->info1543);
			}
			ndr->depth--;
		break;

		case 1544:
			ndr_print_ptr(ndr, "info1544", r->info1544);
			ndr->depth++;
			if (r->info1544) {
				ndr_print_srvsvc_NetSrvInfo1544(ndr, "info1544", r->info1544);
			}
			ndr->depth--;
		break;

		case 1545:
			ndr_print_ptr(ndr, "info1545", r->info1545);
			ndr->depth++;
			if (r->info1545) {
				ndr_print_srvsvc_NetSrvInfo1545(ndr, "info1545", r->info1545);
			}
			ndr->depth--;
		break;

		case 1546:
			ndr_print_ptr(ndr, "info1546", r->info1546);
			ndr->depth++;
			if (r->info1546) {
				ndr_print_srvsvc_NetSrvInfo1546(ndr, "info1546", r->info1546);
			}
			ndr->depth--;
		break;

		case 1547:
			ndr_print_ptr(ndr, "info1547", r->info1547);
			ndr->depth++;
			if (r->info1547) {
				ndr_print_srvsvc_NetSrvInfo1547(ndr, "info1547", r->info1547);
			}
			ndr->depth--;
		break;

		case 1548:
			ndr_print_ptr(ndr, "info1548", r->info1548);
			ndr->depth++;
			if (r->info1548) {
				ndr_print_srvsvc_NetSrvInfo1548(ndr, "info1548", r->info1548);
			}
			ndr->depth--;
		break;

		case 1549:
			ndr_print_ptr(ndr, "info1549", r->info1549);
			ndr->depth++;
			if (r->info1549) {
				ndr_print_srvsvc_NetSrvInfo1549(ndr, "info1549", r->info1549);
			}
			ndr->depth--;
		break;

		case 1550:
			ndr_print_ptr(ndr, "info1550", r->info1550);
			ndr->depth++;
			if (r->info1550) {
				ndr_print_srvsvc_NetSrvInfo1550(ndr, "info1550", r->info1550);
			}
			ndr->depth--;
		break;

		case 1552:
			ndr_print_ptr(ndr, "info1552", r->info1552);
			ndr->depth++;
			if (r->info1552) {
				ndr_print_srvsvc_NetSrvInfo1552(ndr, "info1552", r->info1552);
			}
			ndr->depth--;
		break;

		case 1553:
			ndr_print_ptr(ndr, "info1553", r->info1553);
			ndr->depth++;
			if (r->info1553) {
				ndr_print_srvsvc_NetSrvInfo1553(ndr, "info1553", r->info1553);
			}
			ndr->depth--;
		break;

		case 1554:
			ndr_print_ptr(ndr, "info1554", r->info1554);
			ndr->depth++;
			if (r->info1554) {
				ndr_print_srvsvc_NetSrvInfo1554(ndr, "info1554", r->info1554);
			}
			ndr->depth--;
		break;

		case 1555:
			ndr_print_ptr(ndr, "info1555", r->info1555);
			ndr->depth++;
			if (r->info1555) {
				ndr_print_srvsvc_NetSrvInfo1555(ndr, "info1555", r->info1555);
			}
			ndr->depth--;
		break;

		case 1556:
			ndr_print_ptr(ndr, "info1556", r->info1556);
			ndr->depth++;
			if (r->info1556) {
				ndr_print_srvsvc_NetSrvInfo1556(ndr, "info1556", r->info1556);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetDiskInfo0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetDiskInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen(r->disk) + 1));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->disk, strlen(r->disk) + 1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetDiskInfo0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetDiskInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__disk_offset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__disk_length));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->disk, r->__disk_length, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetDiskInfo0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetDiskInfo0 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetDiskInfo0");
	ndr->depth++;
	ndr_print_uint32(ndr, "__disk_offset", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->__disk_offset);
	ndr_print_uint32(ndr, "__disk_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen(r->disk) + 1:r->__disk_length);
	ndr_print_string(ndr, "disk", r->disk);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetDiskInfo(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetDiskInfo *r)
{
	uint32_t cntr_disks_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->disks));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->disks) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_disks_1 = 0; cntr_disks_1 < r->count; cntr_disks_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetDiskInfo0(ndr, NDR_SCALARS, &r->disks[cntr_disks_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetDiskInfo(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetDiskInfo *r)
{
	uint32_t _ptr_disks;
	uint32_t cntr_disks_1;
	TALLOC_CTX *_mem_save_disks_0;
	TALLOC_CTX *_mem_save_disks_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_disks));
		if (_ptr_disks) {
			NDR_PULL_ALLOC(ndr, r->disks);
		} else {
			r->disks = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->disks) {
			_mem_save_disks_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->disks, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->disks));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->disks));
			if (ndr_get_array_length(ndr, &r->disks) > ndr_get_array_size(ndr, &r->disks)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->disks), ndr_get_array_length(ndr, &r->disks));
			}
			NDR_PULL_ALLOC_N(ndr, r->disks, ndr_get_array_size(ndr, &r->disks));
			_mem_save_disks_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->disks, 0);
			for (cntr_disks_1 = 0; cntr_disks_1 < ndr_get_array_length(ndr, &r->disks); cntr_disks_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetDiskInfo0(ndr, NDR_SCALARS, &r->disks[cntr_disks_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_disks_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_disks_0, 0);
		}
		if (r->disks) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->disks, r->count));
		}
		if (r->disks) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->disks, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetDiskInfo(struct ndr_print *ndr, const char *name, const struct srvsvc_NetDiskInfo *r)
{
	uint32_t cntr_disks_1;
	ndr_print_struct(ndr, name, "srvsvc_NetDiskInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "disks", r->disks);
	ndr->depth++;
	if (r->disks) {
		ndr->print(ndr, "%s: ARRAY(%d)", "disks", (int)r->count);
		ndr->depth++;
		for (cntr_disks_1=0;cntr_disks_1<r->count;cntr_disks_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_disks_1) != -1) {
				ndr_print_srvsvc_NetDiskInfo0(ndr, "disks", &r->disks[cntr_disks_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_Statistics(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_Statistics *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->start));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->devopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->jobsqueued));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->stimeouts));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serrorout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pwerrors));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->permerrors));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->syserrors));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bytessent_low));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bytessent_high));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bytesrcvd_low));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bytesrcvd_high));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->avresponse));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reqbufneed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bigbufneed));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_Statistics(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_Statistics *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->start));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->devopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->jobsqueued));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->stimeouts));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serrorout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pwerrors));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->permerrors));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->syserrors));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bytessent_low));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bytessent_high));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bytesrcvd_low));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bytesrcvd_high));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->avresponse));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reqbufneed));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bigbufneed));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_Statistics(struct ndr_print *ndr, const char *name, const struct srvsvc_Statistics *r)
{
	ndr_print_struct(ndr, name, "srvsvc_Statistics");
	ndr->depth++;
	ndr_print_uint32(ndr, "start", r->start);
	ndr_print_uint32(ndr, "fopens", r->fopens);
	ndr_print_uint32(ndr, "devopens", r->devopens);
	ndr_print_uint32(ndr, "jobsqueued", r->jobsqueued);
	ndr_print_uint32(ndr, "sopens", r->sopens);
	ndr_print_uint32(ndr, "stimeouts", r->stimeouts);
	ndr_print_uint32(ndr, "serrorout", r->serrorout);
	ndr_print_uint32(ndr, "pwerrors", r->pwerrors);
	ndr_print_uint32(ndr, "permerrors", r->permerrors);
	ndr_print_uint32(ndr, "syserrors", r->syserrors);
	ndr_print_uint32(ndr, "bytessent_low", r->bytessent_low);
	ndr_print_uint32(ndr, "bytessent_high", r->bytessent_high);
	ndr_print_uint32(ndr, "bytesrcvd_low", r->bytesrcvd_low);
	ndr_print_uint32(ndr, "bytesrcvd_high", r->bytesrcvd_high);
	ndr_print_uint32(ndr, "avresponse", r->avresponse);
	ndr_print_uint32(ndr, "reqbufneed", r->reqbufneed);
	ndr_print_uint32(ndr, "bigbufneed", r->bigbufneed);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportInfo0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->vcs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->addr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->addr_len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->net_addr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->addr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->addr_len));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->addr, r->addr_len));
		}
		if (r->net_addr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_addr, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_addr, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->net_addr, ndr_charset_length(r->net_addr, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportInfo0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportInfo0 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_addr;
	TALLOC_CTX *_mem_save_addr_0;
	uint32_t _ptr_net_addr;
	TALLOC_CTX *_mem_save_net_addr_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->vcs));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_addr));
		if (_ptr_addr) {
			NDR_PULL_ALLOC(ndr, r->addr);
		} else {
			r->addr = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->addr_len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_net_addr));
		if (_ptr_net_addr) {
			NDR_PULL_ALLOC(ndr, r->net_addr);
		} else {
			r->net_addr = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->addr) {
			_mem_save_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->addr));
			NDR_PULL_ALLOC_N(ndr, r->addr, ndr_get_array_size(ndr, &r->addr));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->addr, ndr_get_array_size(ndr, &r->addr)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addr_0, 0);
		}
		if (r->net_addr) {
			_mem_save_net_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->net_addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->net_addr));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->net_addr));
			if (ndr_get_array_length(ndr, &r->net_addr) > ndr_get_array_size(ndr, &r->net_addr)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->net_addr), ndr_get_array_length(ndr, &r->net_addr));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->net_addr), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->net_addr, ndr_get_array_length(ndr, &r->net_addr), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_net_addr_0, 0);
		}
		if (r->addr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->addr, r->addr_len));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportInfo0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportInfo0 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetTransportInfo0");
	ndr->depth++;
	ndr_print_uint32(ndr, "vcs", r->vcs);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "addr", r->addr);
	ndr->depth++;
	if (r->addr) {
		ndr_print_array_uint8(ndr, "addr", r->addr, r->addr_len);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "addr_len", r->addr_len);
	ndr_print_ptr(ndr, "net_addr", r->net_addr);
	ndr->depth++;
	if (r->net_addr) {
		ndr_print_string(ndr, "net_addr", r->net_addr);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportCtr0(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportCtr0 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportCtr0(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportCtr0 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportCtr0(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportCtr0 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetTransportCtr0");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetTransportInfo0(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportInfo1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->vcs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->addr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->addr_len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->net_addr));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->addr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->addr_len));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->addr, r->addr_len));
		}
		if (r->net_addr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_addr, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_addr, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->net_addr, ndr_charset_length(r->net_addr, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportInfo1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportInfo1 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_addr;
	TALLOC_CTX *_mem_save_addr_0;
	uint32_t _ptr_net_addr;
	TALLOC_CTX *_mem_save_net_addr_0;
	uint32_t _ptr_domain;
	TALLOC_CTX *_mem_save_domain_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->vcs));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_addr));
		if (_ptr_addr) {
			NDR_PULL_ALLOC(ndr, r->addr);
		} else {
			r->addr = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->addr_len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_net_addr));
		if (_ptr_net_addr) {
			NDR_PULL_ALLOC(ndr, r->net_addr);
		} else {
			r->net_addr = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->domain);
		} else {
			r->domain = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->addr) {
			_mem_save_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->addr));
			NDR_PULL_ALLOC_N(ndr, r->addr, ndr_get_array_size(ndr, &r->addr));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->addr, ndr_get_array_size(ndr, &r->addr)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addr_0, 0);
		}
		if (r->net_addr) {
			_mem_save_net_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->net_addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->net_addr));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->net_addr));
			if (ndr_get_array_length(ndr, &r->net_addr) > ndr_get_array_size(ndr, &r->net_addr)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->net_addr), ndr_get_array_length(ndr, &r->net_addr));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->net_addr), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->net_addr, ndr_get_array_length(ndr, &r->net_addr), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_net_addr_0, 0);
		}
		if (r->domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
			if (ndr_get_array_length(ndr, &r->domain) > ndr_get_array_size(ndr, &r->domain)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain), ndr_get_array_length(ndr, &r->domain));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
		if (r->addr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->addr, r->addr_len));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportInfo1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportInfo1 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetTransportInfo1");
	ndr->depth++;
	ndr_print_uint32(ndr, "vcs", r->vcs);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "addr", r->addr);
	ndr->depth++;
	if (r->addr) {
		ndr_print_array_uint8(ndr, "addr", r->addr, r->addr_len);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "addr_len", r->addr_len);
	ndr_print_ptr(ndr, "net_addr", r->net_addr);
	ndr->depth++;
	if (r->net_addr) {
		ndr_print_string(ndr, "net_addr", r->net_addr);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain", r->domain);
	ndr->depth++;
	if (r->domain) {
		ndr_print_string(ndr, "domain", r->domain);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportCtr1(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportCtr1 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportCtr1(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportCtr1(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetTransportCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetTransportInfo1(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportInfo2(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->vcs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->addr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->addr_len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->net_addr));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->addr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->addr_len));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->addr, r->addr_len));
		}
		if (r->net_addr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_addr, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_addr, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->net_addr, ndr_charset_length(r->net_addr, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportInfo2(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportInfo2 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_addr;
	TALLOC_CTX *_mem_save_addr_0;
	uint32_t _ptr_net_addr;
	TALLOC_CTX *_mem_save_net_addr_0;
	uint32_t _ptr_domain;
	TALLOC_CTX *_mem_save_domain_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->vcs));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_addr));
		if (_ptr_addr) {
			NDR_PULL_ALLOC(ndr, r->addr);
		} else {
			r->addr = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->addr_len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_net_addr));
		if (_ptr_net_addr) {
			NDR_PULL_ALLOC(ndr, r->net_addr);
		} else {
			r->net_addr = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->domain);
		} else {
			r->domain = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->addr) {
			_mem_save_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->addr));
			NDR_PULL_ALLOC_N(ndr, r->addr, ndr_get_array_size(ndr, &r->addr));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->addr, ndr_get_array_size(ndr, &r->addr)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addr_0, 0);
		}
		if (r->net_addr) {
			_mem_save_net_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->net_addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->net_addr));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->net_addr));
			if (ndr_get_array_length(ndr, &r->net_addr) > ndr_get_array_size(ndr, &r->net_addr)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->net_addr), ndr_get_array_length(ndr, &r->net_addr));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->net_addr), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->net_addr, ndr_get_array_length(ndr, &r->net_addr), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_net_addr_0, 0);
		}
		if (r->domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
			if (ndr_get_array_length(ndr, &r->domain) > ndr_get_array_size(ndr, &r->domain)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain), ndr_get_array_length(ndr, &r->domain));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
		if (r->addr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->addr, r->addr_len));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportInfo2(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportInfo2 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetTransportInfo2");
	ndr->depth++;
	ndr_print_uint32(ndr, "vcs", r->vcs);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "addr", r->addr);
	ndr->depth++;
	if (r->addr) {
		ndr_print_array_uint8(ndr, "addr", r->addr, r->addr_len);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "addr_len", r->addr_len);
	ndr_print_ptr(ndr, "net_addr", r->net_addr);
	ndr->depth++;
	if (r->net_addr) {
		ndr_print_string(ndr, "net_addr", r->net_addr);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain", r->domain);
	ndr->depth++;
	if (r->domain) {
		ndr_print_string(ndr, "domain", r->domain);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportCtr2(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportCtr2 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportCtr2(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportCtr2 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportCtr2(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportCtr2 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetTransportCtr2");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetTransportInfo2(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportInfo3(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->vcs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->addr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->addr_len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->net_addr));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->unknown3, 256));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->addr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->addr_len));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->addr, r->addr_len));
		}
		if (r->net_addr) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_addr, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->net_addr, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->net_addr, ndr_charset_length(r->net_addr, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportInfo3(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportInfo3 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_addr;
	TALLOC_CTX *_mem_save_addr_0;
	uint32_t _ptr_net_addr;
	TALLOC_CTX *_mem_save_net_addr_0;
	uint32_t _ptr_domain;
	TALLOC_CTX *_mem_save_domain_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->vcs));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_addr));
		if (_ptr_addr) {
			NDR_PULL_ALLOC(ndr, r->addr);
		} else {
			r->addr = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->addr_len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_net_addr));
		if (_ptr_net_addr) {
			NDR_PULL_ALLOC(ndr, r->net_addr);
		} else {
			r->net_addr = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->domain);
		} else {
			r->domain = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->unknown3, 256));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->addr) {
			_mem_save_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->addr));
			NDR_PULL_ALLOC_N(ndr, r->addr, ndr_get_array_size(ndr, &r->addr));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->addr, ndr_get_array_size(ndr, &r->addr)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addr_0, 0);
		}
		if (r->net_addr) {
			_mem_save_net_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->net_addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->net_addr));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->net_addr));
			if (ndr_get_array_length(ndr, &r->net_addr) > ndr_get_array_size(ndr, &r->net_addr)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->net_addr), ndr_get_array_length(ndr, &r->net_addr));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->net_addr), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->net_addr, ndr_get_array_length(ndr, &r->net_addr), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_net_addr_0, 0);
		}
		if (r->domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
			if (ndr_get_array_length(ndr, &r->domain) > ndr_get_array_size(ndr, &r->domain)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain), ndr_get_array_length(ndr, &r->domain));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, ndr_get_array_length(ndr, &r->domain), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
		if (r->addr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->addr, r->addr_len));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportInfo3(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportInfo3 *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetTransportInfo3");
	ndr->depth++;
	ndr_print_uint32(ndr, "vcs", r->vcs);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "addr", r->addr);
	ndr->depth++;
	if (r->addr) {
		ndr_print_array_uint8(ndr, "addr", r->addr, r->addr_len);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "addr_len", r->addr_len);
	ndr_print_ptr(ndr, "net_addr", r->net_addr);
	ndr->depth++;
	if (r->net_addr) {
		ndr_print_string(ndr, "net_addr", r->net_addr);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain", r->domain);
	ndr->depth++;
	if (r->domain) {
		ndr_print_string(ndr, "domain", r->domain);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_array_uint8(ndr, "unknown3", r->unknown3, 256);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportCtr3(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportCtr3 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo3(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo3(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportCtr3(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportCtr3 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo3(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo3(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportCtr3(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportCtr3 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "srvsvc_NetTransportCtr3");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_array_1) != -1) {
				ndr_print_srvsvc_NetTransportInfo3(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportCtr(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetTransportCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr3));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->ctr0) {
					NDR_CHECK(ndr_push_srvsvc_NetTransportCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
				}
			break;

			case 1:
				if (r->ctr1) {
					NDR_CHECK(ndr_push_srvsvc_NetTransportCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
				}
			break;

			case 2:
				if (r->ctr2) {
					NDR_CHECK(ndr_push_srvsvc_NetTransportCtr2(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr2));
				}
			break;

			case 3:
				if (r->ctr3) {
					NDR_CHECK(ndr_push_srvsvc_NetTransportCtr3(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr3));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportCtr(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetTransportCtr *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr0_0;
	TALLOC_CTX *_mem_save_ctr1_0;
	TALLOC_CTX *_mem_save_ctr2_0;
	TALLOC_CTX *_mem_save_ctr3_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				uint32_t _ptr_ctr0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr0));
				if (_ptr_ctr0) {
					NDR_PULL_ALLOC(ndr, r->ctr0);
				} else {
					r->ctr0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_ctr1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
				if (_ptr_ctr1) {
					NDR_PULL_ALLOC(ndr, r->ctr1);
				} else {
					r->ctr1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_ctr2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr2));
				if (_ptr_ctr2) {
					NDR_PULL_ALLOC(ndr, r->ctr2);
				} else {
					r->ctr2 = NULL;
				}
			break; }

			case 3: {
				uint32_t _ptr_ctr3;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr3));
				if (_ptr_ctr3) {
					NDR_PULL_ALLOC(ndr, r->ctr3);
				} else {
					r->ctr3 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->ctr0) {
					_mem_save_ctr0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr0, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetTransportCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr0_0, 0);
				}
			break;

			case 1:
				if (r->ctr1) {
					_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetTransportCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
				}
			break;

			case 2:
				if (r->ctr2) {
					_mem_save_ctr2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr2, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetTransportCtr2(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr2_0, 0);
				}
			break;

			case 3:
				if (r->ctr3) {
					_mem_save_ctr3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr3, 0);
					NDR_CHECK(ndr_pull_srvsvc_NetTransportCtr3(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr3_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportCtr(struct ndr_print *ndr, const char *name, const union srvsvc_NetTransportCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetTransportCtr");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "ctr0", r->ctr0);
			ndr->depth++;
			if (r->ctr0) {
				ndr_print_srvsvc_NetTransportCtr0(ndr, "ctr0", r->ctr0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "ctr1", r->ctr1);
			ndr->depth++;
			if (r->ctr1) {
				ndr_print_srvsvc_NetTransportCtr1(ndr, "ctr1", r->ctr1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "ctr2", r->ctr2);
			ndr->depth++;
			if (r->ctr2) {
				ndr_print_srvsvc_NetTransportCtr2(ndr, "ctr2", r->ctr2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "ctr3", r->ctr3);
			ndr->depth++;
			if (r->ctr3) {
				ndr_print_srvsvc_NetTransportCtr3(ndr, "ctr3", r->ctr3);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetTransportInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_push_srvsvc_NetTransportCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_srvsvc_NetTransportCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetTransportInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level));
		NDR_CHECK(ndr_pull_srvsvc_NetTransportCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_srvsvc_NetTransportCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportInfoCtr(struct ndr_print *ndr, const char *name, const struct srvsvc_NetTransportInfoCtr *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetTransportInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level);
	ndr_print_srvsvc_NetTransportCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetRemoteTODInfo(struct ndr_push *ndr, int ndr_flags, const struct srvsvc_NetRemoteTODInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->elapsed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->msecs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->mins));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->secs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->hunds));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->timezone));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tinterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->day));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->month));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->year));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->weekday));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetRemoteTODInfo(struct ndr_pull *ndr, int ndr_flags, struct srvsvc_NetRemoteTODInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->elapsed));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->msecs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->hours));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->mins));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->secs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->hunds));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->timezone));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tinterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->day));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->month));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->year));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->weekday));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetRemoteTODInfo(struct ndr_print *ndr, const char *name, const struct srvsvc_NetRemoteTODInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetRemoteTODInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "elapsed", r->elapsed);
	ndr_print_uint32(ndr, "msecs", r->msecs);
	ndr_print_uint32(ndr, "hours", r->hours);
	ndr_print_uint32(ndr, "mins", r->mins);
	ndr_print_uint32(ndr, "secs", r->secs);
	ndr_print_uint32(ndr, "hunds", r->hunds);
	ndr_print_int32(ndr, "timezone", r->timezone);
	ndr_print_uint32(ndr, "tinterval", r->tinterval);
	ndr_print_uint32(ndr, "day", r->day);
	ndr_print_uint32(ndr, "month", r->month);
	ndr_print_uint32(ndr, "year", r->year);
	ndr_print_uint32(ndr, "weekday", r->weekday);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportInfo(struct ndr_push *ndr, int ndr_flags, const union srvsvc_NetTransportInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo0(ndr, NDR_BUFFERS, &r->info0));
			break;

			case 1:
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_srvsvc_NetTransportInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportInfo(struct ndr_pull *ndr, int ndr_flags, union srvsvc_NetTransportInfo *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo0(ndr, NDR_BUFFERS, &r->info0));
			break;

			case 1:
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportInfo(struct ndr_print *ndr, const char *name, const union srvsvc_NetTransportInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "srvsvc_NetTransportInfo");
	switch (level) {
		case 0:
			ndr_print_srvsvc_NetTransportInfo0(ndr, "info0", &r->info0);
		break;

		case 1:
			ndr_print_srvsvc_NetTransportInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_srvsvc_NetTransportInfo2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_srvsvc_NetTransportInfo3(ndr, "info3", &r->info3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevEnum(struct ndr_push *ndr, int flags, const struct srvsvc_NetCharDevEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetCharDevInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetCharDevInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevEnum(struct ndr_pull *ndr, int flags, struct srvsvc_NetCharDevEnum *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		*r->out.info_ctr = *r->in.info_ctr;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevEnum(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetCharDevEnum *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetCharDevEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetCharDevInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetCharDevEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetCharDevInfoCtr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevGetInfo(struct ndr_push *ndr, int flags, const struct srvsvc_NetCharDevGetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.device_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.device_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.device_name, ndr_charset_length(r->in.device_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetCharDevInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevGetInfo(struct ndr_pull *ndr, int flags, struct srvsvc_NetCharDevGetInfo *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.device_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.device_name));
		if (ndr_get_array_length(ndr, &r->in.device_name) > ndr_get_array_size(ndr, &r->in.device_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.device_name), ndr_get_array_length(ndr, &r->in.device_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.device_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.device_name, ndr_get_array_length(ndr, &r->in.device_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetCharDevGetInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetCharDevGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "device_name", r->in.device_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetCharDevGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_srvsvc_NetCharDevInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevControl(struct ndr_push *ndr, int flags, const struct srvsvc_NetCharDevControl *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.device_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.device_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.device_name, ndr_charset_length(r->in.device_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.opcode));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevControl(struct ndr_pull *ndr, int flags, struct srvsvc_NetCharDevControl *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.device_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.device_name));
		if (ndr_get_array_length(ndr, &r->in.device_name) > ndr_get_array_size(ndr, &r->in.device_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.device_name), ndr_get_array_length(ndr, &r->in.device_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.device_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.device_name, ndr_get_array_length(ndr, &r->in.device_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.opcode));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevControl(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetCharDevControl *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevControl");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetCharDevControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "device_name", r->in.device_name);
		ndr_print_uint32(ndr, "opcode", r->in.opcode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetCharDevControl");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQEnum(struct ndr_push *ndr, int flags, const struct srvsvc_NetCharDevQEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.user));
		if (r->in.user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQEnum(struct ndr_pull *ndr, int flags, struct srvsvc_NetCharDevQEnum *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_user;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_user_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->in.user);
		} else {
			r->in.user = NULL;
		}
		if (r->in.user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
			if (ndr_get_array_length(ndr, &r->in.user) > ndr_get_array_size(ndr, &r->in.user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.user), ndr_get_array_length(ndr, &r->in.user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		*r->out.info_ctr = *r->in.info_ctr;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQEnum(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetCharDevQEnum *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetCharDevQEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "user", r->in.user);
		ndr->depth++;
		if (r->in.user) {
			ndr_print_string(ndr, "user", r->in.user);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetCharDevQInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetCharDevQEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetCharDevQInfoCtr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQGetInfo(struct ndr_push *ndr, int flags, const struct srvsvc_NetCharDevQGetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.queue_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.queue_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.queue_name, ndr_charset_length(r->in.queue_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQGetInfo(struct ndr_pull *ndr, int flags, struct srvsvc_NetCharDevQGetInfo *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.queue_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.queue_name));
		if (ndr_get_array_length(ndr, &r->in.queue_name) > ndr_get_array_size(ndr, &r->in.queue_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.queue_name), ndr_get_array_length(ndr, &r->in.queue_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.queue_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.queue_name, ndr_get_array_length(ndr, &r->in.queue_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
		if (ndr_get_array_length(ndr, &r->in.user) > ndr_get_array_size(ndr, &r->in.user)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.user), ndr_get_array_length(ndr, &r->in.user));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetCharDevQGetInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetCharDevQGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "queue_name", r->in.queue_name);
		ndr_print_string(ndr, "user", r->in.user);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetCharDevQGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_srvsvc_NetCharDevQInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQSetInfo(struct ndr_push *ndr, int flags, const struct srvsvc_NetCharDevQSetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.queue_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.queue_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.queue_name, ndr_charset_length(r->in.queue_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetCharDevQInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parm_error));
		if (r->in.parm_error) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.parm_error));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.parm_error));
		if (r->out.parm_error) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.parm_error));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQSetInfo(struct ndr_pull *ndr, int flags, struct srvsvc_NetCharDevQSetInfo *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_parm_error;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_parm_error_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.queue_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.queue_name));
		if (ndr_get_array_length(ndr, &r->in.queue_name) > ndr_get_array_size(ndr, &r->in.queue_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.queue_name), ndr_get_array_length(ndr, &r->in.queue_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.queue_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.queue_name, ndr_get_array_length(ndr, &r->in.queue_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetCharDevQInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parm_error));
		if (_ptr_parm_error) {
			NDR_PULL_ALLOC(ndr, r->in.parm_error);
		} else {
			r->in.parm_error = NULL;
		}
		if (r->in.parm_error) {
			_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parm_error, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.parm_error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parm_error));
		if (_ptr_parm_error) {
			NDR_PULL_ALLOC(ndr, r->out.parm_error);
		} else {
			r->out.parm_error = NULL;
		}
		if (r->out.parm_error) {
			_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.parm_error, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.parm_error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetCharDevQSetInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetCharDevQSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "queue_name", r->in.queue_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.level);
		ndr_print_srvsvc_NetCharDevQInfo(ndr, "info", &r->in.info);
		ndr_print_ptr(ndr, "parm_error", r->in.parm_error);
		ndr->depth++;
		if (r->in.parm_error) {
			ndr_print_uint32(ndr, "parm_error", *r->in.parm_error);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetCharDevQSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		if (r->out.parm_error) {
			ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQPurge(struct ndr_push *ndr, int flags, const struct srvsvc_NetCharDevQPurge *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.queue_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.queue_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.queue_name, ndr_charset_length(r->in.queue_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQPurge(struct ndr_pull *ndr, int flags, struct srvsvc_NetCharDevQPurge *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.queue_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.queue_name));
		if (ndr_get_array_length(ndr, &r->in.queue_name) > ndr_get_array_size(ndr, &r->in.queue_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.queue_name), ndr_get_array_length(ndr, &r->in.queue_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.queue_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.queue_name, ndr_get_array_length(ndr, &r->in.queue_name), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQPurge(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetCharDevQPurge *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQPurge");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetCharDevQPurge");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "queue_name", r->in.queue_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetCharDevQPurge");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetCharDevQPurgeSelf(struct ndr_push *ndr, int flags, const struct srvsvc_NetCharDevQPurgeSelf *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.queue_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.queue_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.queue_name, ndr_charset_length(r->in.queue_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetCharDevQPurgeSelf(struct ndr_pull *ndr, int flags, struct srvsvc_NetCharDevQPurgeSelf *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.queue_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.queue_name));
		if (ndr_get_array_length(ndr, &r->in.queue_name) > ndr_get_array_size(ndr, &r->in.queue_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.queue_name), ndr_get_array_length(ndr, &r->in.queue_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.queue_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.queue_name, ndr_get_array_length(ndr, &r->in.queue_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		if (ndr_get_array_length(ndr, &r->in.computer_name) > ndr_get_array_size(ndr, &r->in.computer_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.computer_name), ndr_get_array_length(ndr, &r->in.computer_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.computer_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, ndr_get_array_length(ndr, &r->in.computer_name), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetCharDevQPurgeSelf(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetCharDevQPurgeSelf *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetCharDevQPurgeSelf");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetCharDevQPurgeSelf");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "queue_name", r->in.queue_name);
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetCharDevQPurgeSelf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetConnEnum(struct ndr_push *ndr, int flags, const struct srvsvc_NetConnEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.path));
		if (r->in.path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path, ndr_charset_length(r->in.path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetConnInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetConnInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetConnEnum(struct ndr_pull *ndr, int flags, struct srvsvc_NetConnEnum *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_path;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_path_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->in.path);
		} else {
			r->in.path = NULL;
		}
		if (r->in.path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path));
			if (ndr_get_array_length(ndr, &r->in.path) > ndr_get_array_size(ndr, &r->in.path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.path), ndr_get_array_length(ndr, &r->in.path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path, ndr_get_array_length(ndr, &r->in.path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetConnInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		*r->out.info_ctr = *r->in.info_ctr;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetConnInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetConnEnum(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetConnEnum *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetConnEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetConnEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "path", r->in.path);
		ndr->depth++;
		if (r->in.path) {
			ndr_print_string(ndr, "path", r->in.path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetConnInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetConnEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetConnInfoCtr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetFileEnum(struct ndr_push *ndr, int flags, const struct srvsvc_NetFileEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.path));
		if (r->in.path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path, ndr_charset_length(r->in.path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.user));
		if (r->in.user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetFileInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetFileInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileEnum(struct ndr_pull *ndr, int flags, struct srvsvc_NetFileEnum *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_path;
	uint32_t _ptr_user;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_path_0;
	TALLOC_CTX *_mem_save_user_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->in.path);
		} else {
			r->in.path = NULL;
		}
		if (r->in.path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path));
			if (ndr_get_array_length(ndr, &r->in.path) > ndr_get_array_size(ndr, &r->in.path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.path), ndr_get_array_length(ndr, &r->in.path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path, ndr_get_array_length(ndr, &r->in.path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->in.user);
		} else {
			r->in.user = NULL;
		}
		if (r->in.user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
			if (ndr_get_array_length(ndr, &r->in.user) > ndr_get_array_size(ndr, &r->in.user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.user), ndr_get_array_length(ndr, &r->in.user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetFileInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		*r->out.info_ctr = *r->in.info_ctr;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetFileInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileEnum(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetFileEnum *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetFileEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetFileEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "path", r->in.path);
		ndr->depth++;
		if (r->in.path) {
			ndr_print_string(ndr, "path", r->in.path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "user", r->in.user);
		ndr->depth++;
		if (r->in.user) {
			ndr_print_string(ndr, "user", r->in.user);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetFileInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetFileEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetFileInfoCtr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetFileGetInfo(struct ndr_push *ndr, int flags, const struct srvsvc_NetFileGetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.fid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetFileInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileGetInfo(struct ndr_pull *ndr, int flags, struct srvsvc_NetFileGetInfo *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.fid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetFileInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetFileGetInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetFileGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetFileGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "fid", r->in.fid);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetFileGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_srvsvc_NetFileInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetFileClose(struct ndr_push *ndr, int flags, const struct srvsvc_NetFileClose *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.fid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetFileClose(struct ndr_pull *ndr, int flags, struct srvsvc_NetFileClose *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.fid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetFileClose(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetFileClose *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetFileClose");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetFileClose");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "fid", r->in.fid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetFileClose");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessEnum(struct ndr_push *ndr, int flags, const struct srvsvc_NetSessEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.client));
		if (r->in.client) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client, ndr_charset_length(r->in.client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.user));
		if (r->in.user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetSessInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetSessInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessEnum(struct ndr_pull *ndr, int flags, struct srvsvc_NetSessEnum *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_client;
	uint32_t _ptr_user;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_client_0;
	TALLOC_CTX *_mem_save_user_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->in.client);
		} else {
			r->in.client = NULL;
		}
		if (r->in.client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client));
			if (ndr_get_array_length(ndr, &r->in.client) > ndr_get_array_size(ndr, &r->in.client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.client), ndr_get_array_length(ndr, &r->in.client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client, ndr_get_array_length(ndr, &r->in.client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->in.user);
		} else {
			r->in.user = NULL;
		}
		if (r->in.user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
			if (ndr_get_array_length(ndr, &r->in.user) > ndr_get_array_size(ndr, &r->in.user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.user), ndr_get_array_length(ndr, &r->in.user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetSessInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		*r->out.info_ctr = *r->in.info_ctr;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetSessInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessEnum(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetSessEnum *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSessEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetSessEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "client", r->in.client);
		ndr->depth++;
		if (r->in.client) {
			ndr_print_string(ndr, "client", r->in.client);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "user", r->in.user);
		ndr->depth++;
		if (r->in.user) {
			ndr_print_string(ndr, "user", r->in.user);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetSessInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetSessEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetSessInfoCtr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSessDel(struct ndr_push *ndr, int flags, const struct srvsvc_NetSessDel *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.client));
		if (r->in.client) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client, ndr_charset_length(r->in.client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.user));
		if (r->in.user) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSessDel(struct ndr_pull *ndr, int flags, struct srvsvc_NetSessDel *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_client;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_client_0;
	TALLOC_CTX *_mem_save_user_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->in.client);
		} else {
			r->in.client = NULL;
		}
		if (r->in.client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client));
			if (ndr_get_array_length(ndr, &r->in.client) > ndr_get_array_size(ndr, &r->in.client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.client), ndr_get_array_length(ndr, &r->in.client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client, ndr_get_array_length(ndr, &r->in.client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->in.user);
		} else {
			r->in.user = NULL;
		}
		if (r->in.user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
			if (ndr_get_array_length(ndr, &r->in.user) > ndr_get_array_size(ndr, &r->in.user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.user), ndr_get_array_length(ndr, &r->in.user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, ndr_get_array_length(ndr, &r->in.user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSessDel(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetSessDel *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSessDel");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetSessDel");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "client", r->in.client);
		ndr->depth++;
		if (r->in.client) {
			ndr_print_string(ndr, "client", r->in.client);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "user", r->in.user);
		ndr->depth++;
		if (r->in.user) {
			ndr_print_string(ndr, "user", r->in.user);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetSessDel");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareAdd(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareAdd *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetShareInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parm_error));
		if (r->in.parm_error) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.parm_error));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.parm_error));
		if (r->out.parm_error) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.parm_error));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareAdd(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareAdd *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_parm_error;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_parm_error_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetShareInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parm_error));
		if (_ptr_parm_error) {
			NDR_PULL_ALLOC(ndr, r->in.parm_error);
		} else {
			r->in.parm_error = NULL;
		}
		if (r->in.parm_error) {
			_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parm_error, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.parm_error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parm_error));
		if (_ptr_parm_error) {
			NDR_PULL_ALLOC(ndr, r->out.parm_error);
		} else {
			r->out.parm_error = NULL;
		}
		if (r->out.parm_error) {
			_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.parm_error, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.parm_error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareAdd(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareAdd *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareAdd");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_srvsvc_NetShareInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "parm_error", r->in.parm_error);
		ndr->depth++;
		if (r->in.parm_error) {
			ndr_print_uint32(ndr, "parm_error", *r->in.parm_error);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		if (r->out.parm_error) {
			ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareEnumAll(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareEnumAll *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetShareInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetShareInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareEnumAll(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareEnumAll *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetShareInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		*r->out.info_ctr = *r->in.info_ctr;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetShareInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareEnumAll(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareEnumAll *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareEnumAll");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareEnumAll");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetShareInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareEnumAll");
		ndr->depth++;
		ndr_print_ptr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetShareInfoCtr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareGetInfo(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareGetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share_name, ndr_charset_length(r->in.share_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetShareInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareGetInfo(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareGetInfo *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share_name));
		if (ndr_get_array_length(ndr, &r->in.share_name) > ndr_get_array_size(ndr, &r->in.share_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.share_name), ndr_get_array_length(ndr, &r->in.share_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.share_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share_name, ndr_get_array_length(ndr, &r->in.share_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetShareInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareGetInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "share_name", r->in.share_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_srvsvc_NetShareInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareSetInfo(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareSetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share_name, ndr_charset_length(r->in.share_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetShareInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parm_error));
		if (r->in.parm_error) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.parm_error));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.parm_error));
		if (r->out.parm_error) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.parm_error));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareSetInfo(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareSetInfo *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_parm_error;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_parm_error_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share_name));
		if (ndr_get_array_length(ndr, &r->in.share_name) > ndr_get_array_size(ndr, &r->in.share_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.share_name), ndr_get_array_length(ndr, &r->in.share_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.share_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share_name, ndr_get_array_length(ndr, &r->in.share_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetShareInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parm_error));
		if (_ptr_parm_error) {
			NDR_PULL_ALLOC(ndr, r->in.parm_error);
		} else {
			r->in.parm_error = NULL;
		}
		if (r->in.parm_error) {
			_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parm_error, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.parm_error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parm_error));
		if (_ptr_parm_error) {
			NDR_PULL_ALLOC(ndr, r->out.parm_error);
		} else {
			r->out.parm_error = NULL;
		}
		if (r->out.parm_error) {
			_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.parm_error, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.parm_error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareSetInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "share_name", r->in.share_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_srvsvc_NetShareInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "parm_error", r->in.parm_error);
		ndr->depth++;
		if (r->in.parm_error) {
			ndr_print_uint32(ndr, "parm_error", *r->in.parm_error);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		if (r->out.parm_error) {
			ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareDel(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareDel *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share_name, ndr_charset_length(r->in.share_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareDel(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareDel *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share_name));
		if (ndr_get_array_length(ndr, &r->in.share_name) > ndr_get_array_size(ndr, &r->in.share_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.share_name), ndr_get_array_length(ndr, &r->in.share_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.share_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share_name, ndr_get_array_length(ndr, &r->in.share_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareDel(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareDel *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareDel");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareDel");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "share_name", r->in.share_name);
		ndr_print_uint32(ndr, "reserved", r->in.reserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareDel");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareDelSticky(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareDelSticky *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share_name, ndr_charset_length(r->in.share_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareDelSticky(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareDelSticky *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share_name));
		if (ndr_get_array_length(ndr, &r->in.share_name) > ndr_get_array_size(ndr, &r->in.share_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.share_name), ndr_get_array_length(ndr, &r->in.share_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.share_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share_name, ndr_get_array_length(ndr, &r->in.share_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareDelSticky(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareDelSticky *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareDelSticky");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareDelSticky");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "share_name", r->in.share_name);
		ndr_print_uint32(ndr, "reserved", r->in.reserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareDelSticky");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareCheck(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareCheck *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.device_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.device_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.device_name, ndr_charset_length(r->in.device_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_ShareType(ndr, NDR_SCALARS, *r->out.type));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareCheck(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareCheck *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_type_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.device_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.device_name));
		if (ndr_get_array_length(ndr, &r->in.device_name) > ndr_get_array_size(ndr, &r->in.device_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.device_name), ndr_get_array_length(ndr, &r->in.device_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.device_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.device_name, ndr_get_array_length(ndr, &r->in.device_name), sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.type);
		ZERO_STRUCTP(r->out.type);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		}
		_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_ShareType(ndr, NDR_SCALARS, r->out.type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareCheck(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareCheck *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareCheck");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareCheck");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "device_name", r->in.device_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareCheck");
		ndr->depth++;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		ndr_print_srvsvc_ShareType(ndr, "type", *r->out.type);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvGetInfo(struct ndr_push *ndr, int flags, const struct srvsvc_NetSrvGetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetSrvInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvGetInfo(struct ndr_pull *ndr, int flags, struct srvsvc_NetSrvGetInfo *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetSrvGetInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetSrvGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetSrvGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_srvsvc_NetSrvInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSrvSetInfo(struct ndr_push *ndr, int flags, const struct srvsvc_NetSrvSetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetSrvInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parm_error));
		if (r->in.parm_error) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.parm_error));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.parm_error));
		if (r->out.parm_error) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.parm_error));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSrvSetInfo(struct ndr_pull *ndr, int flags, struct srvsvc_NetSrvSetInfo *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_parm_error;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_parm_error_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parm_error));
		if (_ptr_parm_error) {
			NDR_PULL_ALLOC(ndr, r->in.parm_error);
		} else {
			r->in.parm_error = NULL;
		}
		if (r->in.parm_error) {
			_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parm_error, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.parm_error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parm_error));
		if (_ptr_parm_error) {
			NDR_PULL_ALLOC(ndr, r->out.parm_error);
		} else {
			r->out.parm_error = NULL;
		}
		if (r->out.parm_error) {
			_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.parm_error, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.parm_error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSrvSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetSrvSetInfo *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSrvSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetSrvSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_srvsvc_NetSrvInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "parm_error", r->in.parm_error);
		ndr->depth++;
		if (r->in.parm_error) {
			ndr_print_uint32(ndr, "parm_error", *r->in.parm_error);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetSrvSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		if (r->out.parm_error) {
			ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetDiskEnum(struct ndr_push *ndr, int flags, const struct srvsvc_NetDiskEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetDiskInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.maxlen));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetDiskInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetDiskEnum(struct ndr_pull *ndr, int flags, struct srvsvc_NetDiskEnum *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetDiskInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.maxlen));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info);
		*r->out.info = *r->in.info;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetDiskInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetDiskEnum(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetDiskEnum *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetDiskEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetDiskEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_srvsvc_NetDiskInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_uint32(ndr, "maxlen", r->in.maxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetDiskEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_srvsvc_NetDiskInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetServerStatisticsGet(struct ndr_push *ndr, int flags, const struct srvsvc_NetServerStatisticsGet *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service));
		if (r->in.service) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service, ndr_charset_length(r->in.service, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.options));
	}
	if (flags & NDR_OUT) {
		if (r->out.stats == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.stats));
		if (*r->out.stats) {
			NDR_CHECK(ndr_push_srvsvc_Statistics(ndr, NDR_SCALARS, *r->out.stats));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetServerStatisticsGet(struct ndr_pull *ndr, int flags, struct srvsvc_NetServerStatisticsGet *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_service;
	uint32_t _ptr_stats;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_service_0;
	TALLOC_CTX *_mem_save_stats_0;
	TALLOC_CTX *_mem_save_stats_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service));
		if (_ptr_service) {
			NDR_PULL_ALLOC(ndr, r->in.service);
		} else {
			r->in.service = NULL;
		}
		if (r->in.service) {
			_mem_save_service_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service));
			if (ndr_get_array_length(ndr, &r->in.service) > ndr_get_array_size(ndr, &r->in.service)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service), ndr_get_array_length(ndr, &r->in.service));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service, ndr_get_array_length(ndr, &r->in.service), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.options));
		NDR_PULL_ALLOC(ndr, r->out.stats);
		ZERO_STRUCTP(r->out.stats);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.stats);
		}
		_mem_save_stats_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.stats, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stats));
		if (_ptr_stats) {
			NDR_PULL_ALLOC(ndr, *r->out.stats);
		} else {
			*r->out.stats = NULL;
		}
		if (*r->out.stats) {
			_mem_save_stats_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.stats, 0);
			NDR_CHECK(ndr_pull_srvsvc_Statistics(ndr, NDR_SCALARS, *r->out.stats));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stats_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stats_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetServerStatisticsGet(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetServerStatisticsGet *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetServerStatisticsGet");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetServerStatisticsGet");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "service", r->in.service);
		ndr->depth++;
		if (r->in.service) {
			ndr_print_string(ndr, "service", r->in.service);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "options", r->in.options);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetServerStatisticsGet");
		ndr->depth++;
		ndr_print_ptr(ndr, "stats", r->out.stats);
		ndr->depth++;
		ndr_print_ptr(ndr, "stats", *r->out.stats);
		ndr->depth++;
		if (*r->out.stats) {
			ndr_print_srvsvc_Statistics(ndr, "stats", *r->out.stats);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportAdd(struct ndr_push *ndr, int flags, const struct srvsvc_NetTransportAdd *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetTransportInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportAdd(struct ndr_pull *ndr, int flags, struct srvsvc_NetTransportAdd *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportAdd(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetTransportAdd *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetTransportAdd");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetTransportAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.level);
		ndr_print_srvsvc_NetTransportInfo(ndr, "info", &r->in.info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetTransportAdd");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportEnum(struct ndr_push *ndr, int flags, const struct srvsvc_NetTransportEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.transports == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetTransportInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.transports));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.transports == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetTransportInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.transports));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportEnum(struct ndr_pull *ndr, int flags, struct srvsvc_NetTransportEnum *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_transports_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.transports);
		}
		_mem_save_transports_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.transports, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetTransportInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.transports));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transports_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.transports);
		*r->out.transports = *r->in.transports;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.transports);
		}
		_mem_save_transports_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.transports, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetTransportInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.transports));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transports_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportEnum(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetTransportEnum *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetTransportEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetTransportEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "transports", r->in.transports);
		ndr->depth++;
		ndr_print_srvsvc_NetTransportInfoCtr(ndr, "transports", r->in.transports);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetTransportEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "transports", r->out.transports);
		ndr->depth++;
		ndr_print_srvsvc_NetTransportInfoCtr(ndr, "transports", r->out.transports);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetTransportDel(struct ndr_push *ndr, int flags, const struct srvsvc_NetTransportDel *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info0 == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetTransportInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info0));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetTransportDel(struct ndr_pull *ndr, int flags, struct srvsvc_NetTransportDel *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info0_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info0);
		}
		_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info0));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetTransportDel(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetTransportDel *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetTransportDel");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetTransportDel");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info0", r->in.info0);
		ndr->depth++;
		ndr_print_srvsvc_NetTransportInfo0(ndr, "info0", r->in.info0);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetTransportDel");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetRemoteTOD(struct ndr_push *ndr, int flags, const struct srvsvc_NetRemoteTOD *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_srvsvc_NetRemoteTODInfo(ndr, NDR_SCALARS, *r->out.info));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetRemoteTOD(struct ndr_pull *ndr, int flags, struct srvsvc_NetRemoteTOD *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_srvsvc_NetRemoteTODInfo(ndr, NDR_SCALARS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetRemoteTOD(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetRemoteTOD *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetRemoteTOD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetRemoteTOD");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetRemoteTOD");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_srvsvc_NetRemoteTODInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSetServiceBits(struct ndr_push *ndr, int flags, const struct srvsvc_NetSetServiceBits *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.transport));
		if (r->in.transport) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.transport, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.transport, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.transport, ndr_charset_length(r->in.transport, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.servicebits));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.updateimmediately));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSetServiceBits(struct ndr_pull *ndr, int flags, struct srvsvc_NetSetServiceBits *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_transport;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_transport_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_transport));
		if (_ptr_transport) {
			NDR_PULL_ALLOC(ndr, r->in.transport);
		} else {
			r->in.transport = NULL;
		}
		if (r->in.transport) {
			_mem_save_transport_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.transport, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.transport));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.transport));
			if (ndr_get_array_length(ndr, &r->in.transport) > ndr_get_array_size(ndr, &r->in.transport)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.transport), ndr_get_array_length(ndr, &r->in.transport));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.transport), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.transport, ndr_get_array_length(ndr, &r->in.transport), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transport_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.servicebits));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.updateimmediately));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSetServiceBits(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetSetServiceBits *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSetServiceBits");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetSetServiceBits");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "transport", r->in.transport);
		ndr->depth++;
		if (r->in.transport) {
			ndr_print_string(ndr, "transport", r->in.transport);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "servicebits", r->in.servicebits);
		ndr_print_uint32(ndr, "updateimmediately", r->in.updateimmediately);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetSetServiceBits");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetPathType(struct ndr_push *ndr, int flags, const struct srvsvc_NetPathType *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path, ndr_charset_length(r->in.path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.pathflags));
	}
	if (flags & NDR_OUT) {
		if (r->out.pathtype == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pathtype));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetPathType(struct ndr_pull *ndr, int flags, struct srvsvc_NetPathType *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_pathtype_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path));
		if (ndr_get_array_length(ndr, &r->in.path) > ndr_get_array_size(ndr, &r->in.path)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.path), ndr_get_array_length(ndr, &r->in.path));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.path), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path, ndr_get_array_length(ndr, &r->in.path), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.pathflags));
		NDR_PULL_ALLOC(ndr, r->out.pathtype);
		ZERO_STRUCTP(r->out.pathtype);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pathtype);
		}
		_mem_save_pathtype_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pathtype, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pathtype));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pathtype_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetPathType(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetPathType *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetPathType");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetPathType");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "path", r->in.path);
		ndr_print_uint32(ndr, "pathflags", r->in.pathflags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetPathType");
		ndr->depth++;
		ndr_print_ptr(ndr, "pathtype", r->out.pathtype);
		ndr->depth++;
		ndr_print_uint32(ndr, "pathtype", *r->out.pathtype);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetPathCanonicalize(struct ndr_push *ndr, int flags, const struct srvsvc_NetPathCanonicalize *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path, ndr_charset_length(r->in.path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.maxbuf));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.prefix, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.prefix, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.prefix, ndr_charset_length(r->in.prefix, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.pathtype == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.pathtype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.pathflags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.maxbuf));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.can_path, r->in.maxbuf));
		if (r->out.pathtype == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pathtype));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetPathCanonicalize(struct ndr_pull *ndr, int flags, struct srvsvc_NetPathCanonicalize *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_pathtype_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path));
		if (ndr_get_array_length(ndr, &r->in.path) > ndr_get_array_size(ndr, &r->in.path)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.path), ndr_get_array_length(ndr, &r->in.path));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.path), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path, ndr_get_array_length(ndr, &r->in.path), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.maxbuf));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.prefix));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.prefix));
		if (ndr_get_array_length(ndr, &r->in.prefix) > ndr_get_array_size(ndr, &r->in.prefix)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.prefix), ndr_get_array_length(ndr, &r->in.prefix));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.prefix), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.prefix, ndr_get_array_length(ndr, &r->in.prefix), sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pathtype);
		}
		_mem_save_pathtype_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pathtype, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.pathtype));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pathtype_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.pathflags));
		NDR_PULL_ALLOC(ndr, r->out.pathtype);
		*r->out.pathtype = *r->in.pathtype;
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.can_path));
		NDR_PULL_ALLOC_N(ndr, r->out.can_path, ndr_get_array_size(ndr, &r->out.can_path));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.can_path, ndr_get_array_size(ndr, &r->out.can_path)));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pathtype);
		}
		_mem_save_pathtype_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pathtype, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pathtype));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pathtype_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.can_path) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.can_path, r->in.maxbuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetPathCanonicalize(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetPathCanonicalize *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetPathCanonicalize");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetPathCanonicalize");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "path", r->in.path);
		ndr_print_uint32(ndr, "maxbuf", r->in.maxbuf);
		ndr_print_string(ndr, "prefix", r->in.prefix);
		ndr_print_ptr(ndr, "pathtype", r->in.pathtype);
		ndr->depth++;
		ndr_print_uint32(ndr, "pathtype", *r->in.pathtype);
		ndr->depth--;
		ndr_print_uint32(ndr, "pathflags", r->in.pathflags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetPathCanonicalize");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "can_path", r->out.can_path, r->in.maxbuf);
		ndr_print_ptr(ndr, "pathtype", r->out.pathtype);
		ndr->depth++;
		ndr_print_uint32(ndr, "pathtype", *r->out.pathtype);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetPathCompare(struct ndr_push *ndr, int flags, const struct srvsvc_NetPathCompare *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path1, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path1, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path1, ndr_charset_length(r->in.path1, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path2, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.path2, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path2, ndr_charset_length(r->in.path2, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.pathtype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.pathflags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetPathCompare(struct ndr_pull *ndr, int flags, struct srvsvc_NetPathCompare *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path1));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path1));
		if (ndr_get_array_length(ndr, &r->in.path1) > ndr_get_array_size(ndr, &r->in.path1)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.path1), ndr_get_array_length(ndr, &r->in.path1));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.path1), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path1, ndr_get_array_length(ndr, &r->in.path1), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path2));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path2));
		if (ndr_get_array_length(ndr, &r->in.path2) > ndr_get_array_size(ndr, &r->in.path2)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.path2), ndr_get_array_length(ndr, &r->in.path2));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.path2), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path2, ndr_get_array_length(ndr, &r->in.path2), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.pathtype));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.pathflags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetPathCompare(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetPathCompare *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetPathCompare");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetPathCompare");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "path1", r->in.path1);
		ndr_print_string(ndr, "path2", r->in.path2);
		ndr_print_uint32(ndr, "pathtype", r->in.pathtype);
		ndr_print_uint32(ndr, "pathflags", r->in.pathflags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetPathCompare");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetNameValidate(struct ndr_push *ndr, int flags, const struct srvsvc_NetNameValidate *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.name, ndr_charset_length(r->in.name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.name_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetNameValidate(struct ndr_pull *ndr, int flags, struct srvsvc_NetNameValidate *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.name));
		if (ndr_get_array_length(ndr, &r->in.name) > ndr_get_array_size(ndr, &r->in.name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.name), ndr_get_array_length(ndr, &r->in.name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.name, ndr_get_array_length(ndr, &r->in.name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.name_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetNameValidate(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetNameValidate *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetNameValidate");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetNameValidate");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "name", r->in.name);
		ndr_print_uint32(ndr, "name_type", r->in.name_type);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetNameValidate");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRPRNAMECANONICALIZE(struct ndr_push *ndr, int flags, const struct srvsvc_NETRPRNAMECANONICALIZE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRPRNAMECANONICALIZE(struct ndr_pull *ndr, int flags, struct srvsvc_NETRPRNAMECANONICALIZE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRPRNAMECANONICALIZE(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRPRNAMECANONICALIZE *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRPRNAMECANONICALIZE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRPRNAMECANONICALIZE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRPRNAMECANONICALIZE");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetPRNameCompare(struct ndr_push *ndr, int flags, const struct srvsvc_NetPRNameCompare *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name1, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name1, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.name1, ndr_charset_length(r->in.name1, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name2, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name2, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.name2, ndr_charset_length(r->in.name2, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.name_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetPRNameCompare(struct ndr_pull *ndr, int flags, struct srvsvc_NetPRNameCompare *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.name1));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.name1));
		if (ndr_get_array_length(ndr, &r->in.name1) > ndr_get_array_size(ndr, &r->in.name1)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.name1), ndr_get_array_length(ndr, &r->in.name1));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.name1), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.name1, ndr_get_array_length(ndr, &r->in.name1), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.name2));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.name2));
		if (ndr_get_array_length(ndr, &r->in.name2) > ndr_get_array_size(ndr, &r->in.name2)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.name2), ndr_get_array_length(ndr, &r->in.name2));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.name2), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.name2, ndr_get_array_length(ndr, &r->in.name2), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.name_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetPRNameCompare(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetPRNameCompare *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetPRNameCompare");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetPRNameCompare");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "name1", r->in.name1);
		ndr_print_string(ndr, "name2", r->in.name2);
		ndr_print_uint32(ndr, "name_type", r->in.name_type);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetPRNameCompare");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareEnum(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetShareInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_srvsvc_NetShareInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		if (r->out.totalentries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareEnum(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareEnum *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetShareInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		*r->out.info_ctr = *r->in.info_ctr;
		NDR_PULL_ALLOC(ndr, r->out.totalentries);
		ZERO_STRUCTP(r->out.totalentries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_srvsvc_NetShareInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		}
		_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareEnum(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareEnum *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetShareInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth++;
		ndr_print_srvsvc_NetShareInfoCtr(ndr, "info_ctr", r->out.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareDelStart(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareDelStart *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share, ndr_charset_length(r->in.share, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.hnd));
		if (r->out.hnd) {
			NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hnd));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareDelStart(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareDelStart *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_hnd;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_hnd_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share));
		if (ndr_get_array_length(ndr, &r->in.share) > ndr_get_array_size(ndr, &r->in.share)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.share), ndr_get_array_length(ndr, &r->in.share));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.share), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share, ndr_get_array_length(ndr, &r->in.share), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hnd));
		if (_ptr_hnd) {
			NDR_PULL_ALLOC(ndr, r->out.hnd);
		} else {
			r->out.hnd = NULL;
		}
		if (r->out.hnd) {
			_mem_save_hnd_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.hnd, 0);
			NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hnd));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hnd_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareDelStart(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareDelStart *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareDelStart");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareDelStart");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_string(ndr, "share", r->in.share);
		ndr_print_uint32(ndr, "reserved", r->in.reserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareDelStart");
		ndr->depth++;
		ndr_print_ptr(ndr, "hnd", r->out.hnd);
		ndr->depth++;
		if (r->out.hnd) {
			ndr_print_policy_handle(ndr, "hnd", r->out.hnd);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetShareDelCommit(struct ndr_push *ndr, int flags, const struct srvsvc_NetShareDelCommit *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.hnd));
		if (r->in.hnd) {
			NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.hnd));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.hnd));
		if (r->out.hnd) {
			NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hnd));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetShareDelCommit(struct ndr_pull *ndr, int flags, struct srvsvc_NetShareDelCommit *r)
{
	uint32_t _ptr_hnd;
	TALLOC_CTX *_mem_save_hnd_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hnd));
		if (_ptr_hnd) {
			NDR_PULL_ALLOC(ndr, r->in.hnd);
		} else {
			r->in.hnd = NULL;
		}
		if (r->in.hnd) {
			_mem_save_hnd_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.hnd, 0);
			NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.hnd));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hnd_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hnd));
		if (_ptr_hnd) {
			NDR_PULL_ALLOC(ndr, r->out.hnd);
		} else {
			r->out.hnd = NULL;
		}
		if (r->out.hnd) {
			_mem_save_hnd_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.hnd, 0);
			NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hnd));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hnd_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetShareDelCommit(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetShareDelCommit *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetShareDelCommit");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetShareDelCommit");
		ndr->depth++;
		ndr_print_ptr(ndr, "hnd", r->in.hnd);
		ndr->depth++;
		if (r->in.hnd) {
			ndr_print_policy_handle(ndr, "hnd", r->in.hnd);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetShareDelCommit");
		ndr->depth++;
		ndr_print_ptr(ndr, "hnd", r->out.hnd);
		ndr->depth++;
		if (r->out.hnd) {
			ndr_print_policy_handle(ndr, "hnd", r->out.hnd);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetGetFileSecurity(struct ndr_push *ndr, int flags, const struct srvsvc_NetGetFileSecurity *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.share));
		if (r->in.share) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share, ndr_charset_length(r->in.share, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.file, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.file, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.file, ndr_charset_length(r->in.file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.securityinformation));
	}
	if (flags & NDR_OUT) {
		if (r->out.sd_buf == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sd_buf));
		if (*r->out.sd_buf) {
			NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sd_buf));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetGetFileSecurity(struct ndr_pull *ndr, int flags, struct srvsvc_NetGetFileSecurity *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_share;
	uint32_t _ptr_sd_buf;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_share_0;
	TALLOC_CTX *_mem_save_sd_buf_0;
	TALLOC_CTX *_mem_save_sd_buf_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_share));
		if (_ptr_share) {
			NDR_PULL_ALLOC(ndr, r->in.share);
		} else {
			r->in.share = NULL;
		}
		if (r->in.share) {
			_mem_save_share_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.share, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share));
			if (ndr_get_array_length(ndr, &r->in.share) > ndr_get_array_size(ndr, &r->in.share)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.share), ndr_get_array_length(ndr, &r->in.share));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.share), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share, ndr_get_array_length(ndr, &r->in.share), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_share_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.file));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.file));
		if (ndr_get_array_length(ndr, &r->in.file) > ndr_get_array_size(ndr, &r->in.file)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.file), ndr_get_array_length(ndr, &r->in.file));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.file), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.file, ndr_get_array_length(ndr, &r->in.file), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.securityinformation));
		NDR_PULL_ALLOC(ndr, r->out.sd_buf);
		ZERO_STRUCTP(r->out.sd_buf);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sd_buf);
		}
		_mem_save_sd_buf_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sd_buf, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sd_buf));
		if (_ptr_sd_buf) {
			NDR_PULL_ALLOC(ndr, *r->out.sd_buf);
		} else {
			*r->out.sd_buf = NULL;
		}
		if (*r->out.sd_buf) {
			_mem_save_sd_buf_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sd_buf, 0);
			NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sd_buf));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sd_buf_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sd_buf_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetGetFileSecurity(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetGetFileSecurity *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetGetFileSecurity");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetGetFileSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "share", r->in.share);
		ndr->depth++;
		if (r->in.share) {
			ndr_print_string(ndr, "share", r->in.share);
		}
		ndr->depth--;
		ndr_print_string(ndr, "file", r->in.file);
		ndr_print_security_secinfo(ndr, "securityinformation", r->in.securityinformation);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetGetFileSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "sd_buf", r->out.sd_buf);
		ndr->depth++;
		ndr_print_ptr(ndr, "sd_buf", *r->out.sd_buf);
		ndr->depth++;
		if (*r->out.sd_buf) {
			ndr_print_sec_desc_buf(ndr, "sd_buf", *r->out.sd_buf);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetSetFileSecurity(struct ndr_push *ndr, int flags, const struct srvsvc_NetSetFileSecurity *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.share));
		if (r->in.share) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share, ndr_charset_length(r->in.share, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.file, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.file, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.file, ndr_charset_length(r->in.file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.securityinformation));
		if (r->in.sd_buf == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sd_buf));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetSetFileSecurity(struct ndr_pull *ndr, int flags, struct srvsvc_NetSetFileSecurity *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_share;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_share_0;
	TALLOC_CTX *_mem_save_sd_buf_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_share));
		if (_ptr_share) {
			NDR_PULL_ALLOC(ndr, r->in.share);
		} else {
			r->in.share = NULL;
		}
		if (r->in.share) {
			_mem_save_share_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.share, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share));
			if (ndr_get_array_length(ndr, &r->in.share) > ndr_get_array_size(ndr, &r->in.share)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.share), ndr_get_array_length(ndr, &r->in.share));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.share), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share, ndr_get_array_length(ndr, &r->in.share), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_share_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.file));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.file));
		if (ndr_get_array_length(ndr, &r->in.file) > ndr_get_array_size(ndr, &r->in.file)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.file), ndr_get_array_length(ndr, &r->in.file));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.file), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.file, ndr_get_array_length(ndr, &r->in.file), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.securityinformation));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sd_buf);
		}
		_mem_save_sd_buf_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sd_buf, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sd_buf));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sd_buf_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetSetFileSecurity(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetSetFileSecurity *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetSetFileSecurity");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetSetFileSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "share", r->in.share);
		ndr->depth++;
		if (r->in.share) {
			ndr_print_string(ndr, "share", r->in.share);
		}
		ndr->depth--;
		ndr_print_string(ndr, "file", r->in.file);
		ndr_print_security_secinfo(ndr, "securityinformation", r->in.securityinformation);
		ndr_print_ptr(ndr, "sd_buf", r->in.sd_buf);
		ndr->depth++;
		ndr_print_sec_desc_buf(ndr, "sd_buf", r->in.sd_buf);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetSetFileSecurity");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetServerTransportAddEx(struct ndr_push *ndr, int flags, const struct srvsvc_NetServerTransportAddEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_push_srvsvc_NetTransportInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetServerTransportAddEx(struct ndr_pull *ndr, int flags, struct srvsvc_NetServerTransportAddEx *r)
{
	uint32_t _ptr_server_unc;
	TALLOC_CTX *_mem_save_server_unc_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_srvsvc_NetTransportInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetServerTransportAddEx(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetServerTransportAddEx *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetServerTransportAddEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetServerTransportAddEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.level);
		ndr_print_srvsvc_NetTransportInfo(ndr, "info", &r->in.info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetServerTransportAddEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NetServerSetServiceBitsEx(struct ndr_push *ndr, int flags, const struct srvsvc_NetServerSetServiceBitsEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.emulated_server_unc));
		if (r->in.emulated_server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.emulated_server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.emulated_server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.emulated_server_unc, ndr_charset_length(r->in.emulated_server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.transport));
		if (r->in.transport) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.transport, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.transport, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.transport, ndr_charset_length(r->in.transport, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.servicebitsofinterest));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.servicebits));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.updateimmediately));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NetServerSetServiceBitsEx(struct ndr_pull *ndr, int flags, struct srvsvc_NetServerSetServiceBitsEx *r)
{
	uint32_t _ptr_server_unc;
	uint32_t _ptr_emulated_server_unc;
	uint32_t _ptr_transport;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_emulated_server_unc_0;
	TALLOC_CTX *_mem_save_transport_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			if (ndr_get_array_length(ndr, &r->in.server_unc) > ndr_get_array_size(ndr, &r->in.server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_unc), ndr_get_array_length(ndr, &r->in.server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, ndr_get_array_length(ndr, &r->in.server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_emulated_server_unc));
		if (_ptr_emulated_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.emulated_server_unc);
		} else {
			r->in.emulated_server_unc = NULL;
		}
		if (r->in.emulated_server_unc) {
			_mem_save_emulated_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.emulated_server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.emulated_server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.emulated_server_unc));
			if (ndr_get_array_length(ndr, &r->in.emulated_server_unc) > ndr_get_array_size(ndr, &r->in.emulated_server_unc)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.emulated_server_unc), ndr_get_array_length(ndr, &r->in.emulated_server_unc));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.emulated_server_unc), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.emulated_server_unc, ndr_get_array_length(ndr, &r->in.emulated_server_unc), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_emulated_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_transport));
		if (_ptr_transport) {
			NDR_PULL_ALLOC(ndr, r->in.transport);
		} else {
			r->in.transport = NULL;
		}
		if (r->in.transport) {
			_mem_save_transport_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.transport, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.transport));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.transport));
			if (ndr_get_array_length(ndr, &r->in.transport) > ndr_get_array_size(ndr, &r->in.transport)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.transport), ndr_get_array_length(ndr, &r->in.transport));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.transport), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.transport, ndr_get_array_length(ndr, &r->in.transport), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transport_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.servicebitsofinterest));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.servicebits));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.updateimmediately));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NetServerSetServiceBitsEx(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NetServerSetServiceBitsEx *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NetServerSetServiceBitsEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NetServerSetServiceBitsEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "emulated_server_unc", r->in.emulated_server_unc);
		ndr->depth++;
		if (r->in.emulated_server_unc) {
			ndr_print_string(ndr, "emulated_server_unc", r->in.emulated_server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "transport", r->in.transport);
		ndr->depth++;
		if (r->in.transport) {
			ndr_print_string(ndr, "transport", r->in.transport);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "servicebitsofinterest", r->in.servicebitsofinterest);
		ndr_print_uint32(ndr, "servicebits", r->in.servicebits);
		ndr_print_uint32(ndr, "updateimmediately", r->in.updateimmediately);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NetServerSetServiceBitsEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSGETVERSION(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSGETVERSION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSGETVERSION(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSGETVERSION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSGETVERSION(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSGETVERSION *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSGETVERSION");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSGETVERSION");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSGETVERSION");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSCREATELOCALPARTITION(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSCREATELOCALPARTITION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSCREATELOCALPARTITION(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSCREATELOCALPARTITION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSCREATELOCALPARTITION(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSCREATELOCALPARTITION *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSCREATELOCALPARTITION");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSCREATELOCALPARTITION");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSCREATELOCALPARTITION");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSDELETELOCALPARTITION(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSDELETELOCALPARTITION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSDELETELOCALPARTITION(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSDELETELOCALPARTITION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSDELETELOCALPARTITION(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSDELETELOCALPARTITION *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSDELETELOCALPARTITION");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSDELETELOCALPARTITION");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSDELETELOCALPARTITION");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSSETLOCALVOLUMESTATE(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSSETLOCALVOLUMESTATE(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSSETLOCALVOLUMESTATE(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSSETLOCALVOLUMESTATE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSSETLOCALVOLUMESTATE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSSETLOCALVOLUMESTATE");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSSETSERVERINFO(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSSETSERVERINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSSETSERVERINFO(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSSETSERVERINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSSETSERVERINFO(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSSETSERVERINFO *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSSETSERVERINFO");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSSETSERVERINFO");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSSETSERVERINFO");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSCREATEEXITPOINT(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSCREATEEXITPOINT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSCREATEEXITPOINT(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSCREATEEXITPOINT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSCREATEEXITPOINT(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSCREATEEXITPOINT *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSCREATEEXITPOINT");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSCREATEEXITPOINT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSCREATEEXITPOINT");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSDELETEEXITPOINT(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSDELETEEXITPOINT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSDELETEEXITPOINT(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSDELETEEXITPOINT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSDELETEEXITPOINT(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSDELETEEXITPOINT *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSDELETEEXITPOINT");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSDELETEEXITPOINT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSDELETEEXITPOINT");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSMODIFYPREFIX(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSMODIFYPREFIX *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSMODIFYPREFIX(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSMODIFYPREFIX *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSMODIFYPREFIX(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSMODIFYPREFIX *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSMODIFYPREFIX");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSMODIFYPREFIX");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSMODIFYPREFIX");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSFIXLOCALVOLUME(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSFIXLOCALVOLUME *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSFIXLOCALVOLUME(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSFIXLOCALVOLUME *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSFIXLOCALVOLUME(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSFIXLOCALVOLUME *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSFIXLOCALVOLUME");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSFIXLOCALVOLUME");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSFIXLOCALVOLUME");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRDFSMANAGERREPORTSITEINFO(struct ndr_push *ndr, int flags, const struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRDFSMANAGERREPORTSITEINFO(struct ndr_pull *ndr, int flags, struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRDFSMANAGERREPORTSITEINFO(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRDFSMANAGERREPORTSITEINFO");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRDFSMANAGERREPORTSITEINFO");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRDFSMANAGERREPORTSITEINFO");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srvsvc_NETRSERVERTRANSPORTDELEX(struct ndr_push *ndr, int flags, const struct srvsvc_NETRSERVERTRANSPORTDELEX *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srvsvc_NETRSERVERTRANSPORTDELEX(struct ndr_pull *ndr, int flags, struct srvsvc_NETRSERVERTRANSPORTDELEX *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srvsvc_NETRSERVERTRANSPORTDELEX(struct ndr_print *ndr, const char *name, int flags, const struct srvsvc_NETRSERVERTRANSPORTDELEX *r)
{
	ndr_print_struct(ndr, name, "srvsvc_NETRSERVERTRANSPORTDELEX");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "srvsvc_NETRSERVERTRANSPORTDELEX");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "srvsvc_NETRSERVERTRANSPORTDELEX");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call srvsvc_calls[] = {
	{
		"srvsvc_NetCharDevEnum",
		sizeof(struct srvsvc_NetCharDevEnum),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetCharDevEnum,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetCharDevEnum,
		(ndr_print_function_t) ndr_print_srvsvc_NetCharDevEnum,
		false,
	},
	{
		"srvsvc_NetCharDevGetInfo",
		sizeof(struct srvsvc_NetCharDevGetInfo),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetCharDevGetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetCharDevGetInfo,
		(ndr_print_function_t) ndr_print_srvsvc_NetCharDevGetInfo,
		false,
	},
	{
		"srvsvc_NetCharDevControl",
		sizeof(struct srvsvc_NetCharDevControl),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetCharDevControl,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetCharDevControl,
		(ndr_print_function_t) ndr_print_srvsvc_NetCharDevControl,
		false,
	},
	{
		"srvsvc_NetCharDevQEnum",
		sizeof(struct srvsvc_NetCharDevQEnum),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetCharDevQEnum,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetCharDevQEnum,
		(ndr_print_function_t) ndr_print_srvsvc_NetCharDevQEnum,
		false,
	},
	{
		"srvsvc_NetCharDevQGetInfo",
		sizeof(struct srvsvc_NetCharDevQGetInfo),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetCharDevQGetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetCharDevQGetInfo,
		(ndr_print_function_t) ndr_print_srvsvc_NetCharDevQGetInfo,
		false,
	},
	{
		"srvsvc_NetCharDevQSetInfo",
		sizeof(struct srvsvc_NetCharDevQSetInfo),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetCharDevQSetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetCharDevQSetInfo,
		(ndr_print_function_t) ndr_print_srvsvc_NetCharDevQSetInfo,
		false,
	},
	{
		"srvsvc_NetCharDevQPurge",
		sizeof(struct srvsvc_NetCharDevQPurge),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetCharDevQPurge,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetCharDevQPurge,
		(ndr_print_function_t) ndr_print_srvsvc_NetCharDevQPurge,
		false,
	},
	{
		"srvsvc_NetCharDevQPurgeSelf",
		sizeof(struct srvsvc_NetCharDevQPurgeSelf),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetCharDevQPurgeSelf,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetCharDevQPurgeSelf,
		(ndr_print_function_t) ndr_print_srvsvc_NetCharDevQPurgeSelf,
		false,
	},
	{
		"srvsvc_NetConnEnum",
		sizeof(struct srvsvc_NetConnEnum),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetConnEnum,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetConnEnum,
		(ndr_print_function_t) ndr_print_srvsvc_NetConnEnum,
		false,
	},
	{
		"srvsvc_NetFileEnum",
		sizeof(struct srvsvc_NetFileEnum),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetFileEnum,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetFileEnum,
		(ndr_print_function_t) ndr_print_srvsvc_NetFileEnum,
		false,
	},
	{
		"srvsvc_NetFileGetInfo",
		sizeof(struct srvsvc_NetFileGetInfo),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetFileGetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetFileGetInfo,
		(ndr_print_function_t) ndr_print_srvsvc_NetFileGetInfo,
		false,
	},
	{
		"srvsvc_NetFileClose",
		sizeof(struct srvsvc_NetFileClose),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetFileClose,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetFileClose,
		(ndr_print_function_t) ndr_print_srvsvc_NetFileClose,
		false,
	},
	{
		"srvsvc_NetSessEnum",
		sizeof(struct srvsvc_NetSessEnum),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetSessEnum,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetSessEnum,
		(ndr_print_function_t) ndr_print_srvsvc_NetSessEnum,
		false,
	},
	{
		"srvsvc_NetSessDel",
		sizeof(struct srvsvc_NetSessDel),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetSessDel,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetSessDel,
		(ndr_print_function_t) ndr_print_srvsvc_NetSessDel,
		false,
	},
	{
		"srvsvc_NetShareAdd",
		sizeof(struct srvsvc_NetShareAdd),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareAdd,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareAdd,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareAdd,
		false,
	},
	{
		"srvsvc_NetShareEnumAll",
		sizeof(struct srvsvc_NetShareEnumAll),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareEnumAll,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareEnumAll,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareEnumAll,
		false,
	},
	{
		"srvsvc_NetShareGetInfo",
		sizeof(struct srvsvc_NetShareGetInfo),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareGetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareGetInfo,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareGetInfo,
		false,
	},
	{
		"srvsvc_NetShareSetInfo",
		sizeof(struct srvsvc_NetShareSetInfo),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareSetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareSetInfo,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareSetInfo,
		false,
	},
	{
		"srvsvc_NetShareDel",
		sizeof(struct srvsvc_NetShareDel),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareDel,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareDel,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareDel,
		false,
	},
	{
		"srvsvc_NetShareDelSticky",
		sizeof(struct srvsvc_NetShareDelSticky),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareDelSticky,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareDelSticky,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareDelSticky,
		false,
	},
	{
		"srvsvc_NetShareCheck",
		sizeof(struct srvsvc_NetShareCheck),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareCheck,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareCheck,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareCheck,
		false,
	},
	{
		"srvsvc_NetSrvGetInfo",
		sizeof(struct srvsvc_NetSrvGetInfo),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetSrvGetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetSrvGetInfo,
		(ndr_print_function_t) ndr_print_srvsvc_NetSrvGetInfo,
		false,
	},
	{
		"srvsvc_NetSrvSetInfo",
		sizeof(struct srvsvc_NetSrvSetInfo),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetSrvSetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetSrvSetInfo,
		(ndr_print_function_t) ndr_print_srvsvc_NetSrvSetInfo,
		false,
	},
	{
		"srvsvc_NetDiskEnum",
		sizeof(struct srvsvc_NetDiskEnum),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetDiskEnum,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetDiskEnum,
		(ndr_print_function_t) ndr_print_srvsvc_NetDiskEnum,
		false,
	},
	{
		"srvsvc_NetServerStatisticsGet",
		sizeof(struct srvsvc_NetServerStatisticsGet),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetServerStatisticsGet,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetServerStatisticsGet,
		(ndr_print_function_t) ndr_print_srvsvc_NetServerStatisticsGet,
		false,
	},
	{
		"srvsvc_NetTransportAdd",
		sizeof(struct srvsvc_NetTransportAdd),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetTransportAdd,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetTransportAdd,
		(ndr_print_function_t) ndr_print_srvsvc_NetTransportAdd,
		false,
	},
	{
		"srvsvc_NetTransportEnum",
		sizeof(struct srvsvc_NetTransportEnum),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetTransportEnum,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetTransportEnum,
		(ndr_print_function_t) ndr_print_srvsvc_NetTransportEnum,
		false,
	},
	{
		"srvsvc_NetTransportDel",
		sizeof(struct srvsvc_NetTransportDel),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetTransportDel,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetTransportDel,
		(ndr_print_function_t) ndr_print_srvsvc_NetTransportDel,
		false,
	},
	{
		"srvsvc_NetRemoteTOD",
		sizeof(struct srvsvc_NetRemoteTOD),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetRemoteTOD,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetRemoteTOD,
		(ndr_print_function_t) ndr_print_srvsvc_NetRemoteTOD,
		false,
	},
	{
		"srvsvc_NetSetServiceBits",
		sizeof(struct srvsvc_NetSetServiceBits),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetSetServiceBits,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetSetServiceBits,
		(ndr_print_function_t) ndr_print_srvsvc_NetSetServiceBits,
		false,
	},
	{
		"srvsvc_NetPathType",
		sizeof(struct srvsvc_NetPathType),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetPathType,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetPathType,
		(ndr_print_function_t) ndr_print_srvsvc_NetPathType,
		false,
	},
	{
		"srvsvc_NetPathCanonicalize",
		sizeof(struct srvsvc_NetPathCanonicalize),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetPathCanonicalize,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetPathCanonicalize,
		(ndr_print_function_t) ndr_print_srvsvc_NetPathCanonicalize,
		false,
	},
	{
		"srvsvc_NetPathCompare",
		sizeof(struct srvsvc_NetPathCompare),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetPathCompare,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetPathCompare,
		(ndr_print_function_t) ndr_print_srvsvc_NetPathCompare,
		false,
	},
	{
		"srvsvc_NetNameValidate",
		sizeof(struct srvsvc_NetNameValidate),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetNameValidate,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetNameValidate,
		(ndr_print_function_t) ndr_print_srvsvc_NetNameValidate,
		false,
	},
	{
		"srvsvc_NETRPRNAMECANONICALIZE",
		sizeof(struct srvsvc_NETRPRNAMECANONICALIZE),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRPRNAMECANONICALIZE,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRPRNAMECANONICALIZE,
		(ndr_print_function_t) ndr_print_srvsvc_NETRPRNAMECANONICALIZE,
		false,
	},
	{
		"srvsvc_NetPRNameCompare",
		sizeof(struct srvsvc_NetPRNameCompare),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetPRNameCompare,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetPRNameCompare,
		(ndr_print_function_t) ndr_print_srvsvc_NetPRNameCompare,
		false,
	},
	{
		"srvsvc_NetShareEnum",
		sizeof(struct srvsvc_NetShareEnum),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareEnum,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareEnum,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareEnum,
		false,
	},
	{
		"srvsvc_NetShareDelStart",
		sizeof(struct srvsvc_NetShareDelStart),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareDelStart,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareDelStart,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareDelStart,
		false,
	},
	{
		"srvsvc_NetShareDelCommit",
		sizeof(struct srvsvc_NetShareDelCommit),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetShareDelCommit,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetShareDelCommit,
		(ndr_print_function_t) ndr_print_srvsvc_NetShareDelCommit,
		false,
	},
	{
		"srvsvc_NetGetFileSecurity",
		sizeof(struct srvsvc_NetGetFileSecurity),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetGetFileSecurity,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetGetFileSecurity,
		(ndr_print_function_t) ndr_print_srvsvc_NetGetFileSecurity,
		false,
	},
	{
		"srvsvc_NetSetFileSecurity",
		sizeof(struct srvsvc_NetSetFileSecurity),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetSetFileSecurity,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetSetFileSecurity,
		(ndr_print_function_t) ndr_print_srvsvc_NetSetFileSecurity,
		false,
	},
	{
		"srvsvc_NetServerTransportAddEx",
		sizeof(struct srvsvc_NetServerTransportAddEx),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetServerTransportAddEx,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetServerTransportAddEx,
		(ndr_print_function_t) ndr_print_srvsvc_NetServerTransportAddEx,
		false,
	},
	{
		"srvsvc_NetServerSetServiceBitsEx",
		sizeof(struct srvsvc_NetServerSetServiceBitsEx),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NetServerSetServiceBitsEx,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NetServerSetServiceBitsEx,
		(ndr_print_function_t) ndr_print_srvsvc_NetServerSetServiceBitsEx,
		false,
	},
	{
		"srvsvc_NETRDFSGETVERSION",
		sizeof(struct srvsvc_NETRDFSGETVERSION),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSGETVERSION,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSGETVERSION,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSGETVERSION,
		false,
	},
	{
		"srvsvc_NETRDFSCREATELOCALPARTITION",
		sizeof(struct srvsvc_NETRDFSCREATELOCALPARTITION),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSCREATELOCALPARTITION,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSCREATELOCALPARTITION,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSCREATELOCALPARTITION,
		false,
	},
	{
		"srvsvc_NETRDFSDELETELOCALPARTITION",
		sizeof(struct srvsvc_NETRDFSDELETELOCALPARTITION),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSDELETELOCALPARTITION,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSDELETELOCALPARTITION,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSDELETELOCALPARTITION,
		false,
	},
	{
		"srvsvc_NETRDFSSETLOCALVOLUMESTATE",
		sizeof(struct srvsvc_NETRDFSSETLOCALVOLUMESTATE),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSSETLOCALVOLUMESTATE,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSSETLOCALVOLUMESTATE,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSSETLOCALVOLUMESTATE,
		false,
	},
	{
		"srvsvc_NETRDFSSETSERVERINFO",
		sizeof(struct srvsvc_NETRDFSSETSERVERINFO),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSSETSERVERINFO,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSSETSERVERINFO,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSSETSERVERINFO,
		false,
	},
	{
		"srvsvc_NETRDFSCREATEEXITPOINT",
		sizeof(struct srvsvc_NETRDFSCREATEEXITPOINT),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSCREATEEXITPOINT,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSCREATEEXITPOINT,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSCREATEEXITPOINT,
		false,
	},
	{
		"srvsvc_NETRDFSDELETEEXITPOINT",
		sizeof(struct srvsvc_NETRDFSDELETEEXITPOINT),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSDELETEEXITPOINT,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSDELETEEXITPOINT,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSDELETEEXITPOINT,
		false,
	},
	{
		"srvsvc_NETRDFSMODIFYPREFIX",
		sizeof(struct srvsvc_NETRDFSMODIFYPREFIX),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSMODIFYPREFIX,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSMODIFYPREFIX,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSMODIFYPREFIX,
		false,
	},
	{
		"srvsvc_NETRDFSFIXLOCALVOLUME",
		sizeof(struct srvsvc_NETRDFSFIXLOCALVOLUME),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSFIXLOCALVOLUME,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSFIXLOCALVOLUME,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSFIXLOCALVOLUME,
		false,
	},
	{
		"srvsvc_NETRDFSMANAGERREPORTSITEINFO",
		sizeof(struct srvsvc_NETRDFSMANAGERREPORTSITEINFO),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRDFSMANAGERREPORTSITEINFO,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRDFSMANAGERREPORTSITEINFO,
		(ndr_print_function_t) ndr_print_srvsvc_NETRDFSMANAGERREPORTSITEINFO,
		false,
	},
	{
		"srvsvc_NETRSERVERTRANSPORTDELEX",
		sizeof(struct srvsvc_NETRSERVERTRANSPORTDELEX),
		(ndr_push_flags_fn_t) ndr_push_srvsvc_NETRSERVERTRANSPORTDELEX,
		(ndr_pull_flags_fn_t) ndr_pull_srvsvc_NETRSERVERTRANSPORTDELEX,
		(ndr_print_function_t) ndr_print_srvsvc_NETRSERVERTRANSPORTDELEX,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const srvsvc_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\srvsvc]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array srvsvc_endpoints = {
	.count	= 3,
	.names	= srvsvc_endpoint_strings
};

static const char * const srvsvc_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array srvsvc_authservices = {
	.count	= 1,
	.names	= srvsvc_authservice_strings
};


const struct ndr_interface_table ndr_table_srvsvc = {
	.name		= "srvsvc",
	.syntax_id	= {
		{0x4b324fc8,0x1670,0x01d3,{0x12,0x78},{0x5a,0x47,0xbf,0x6e,0xe1,0x88}},
		NDR_SRVSVC_VERSION
	},
	.helpstring	= NDR_SRVSVC_HELPSTRING,
	.num_calls	= 54,
	.calls		= srvsvc_calls,
	.endpoints	= &srvsvc_endpoints,
	.authservices	= &srvsvc_authservices
};

