'\" t
.\"     Title: xidefinecursor
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.76.1 <http://docbook.sf.net/>
.\"      Date: 03/18/2011
.\"    Manual: \ \&
.\"    Source: \ \&
.\"  Language: English
.\"
.TH "XIDEFINECURSOR" "libmansuffix" "03/18/2011" "\ \&" "\ \&"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XIDefineCursor, XIUndefineCursor \- define device cursors\&.
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput2\&.h>
.fi
.sp
.nf
int XIDefineCursor( Display *display,
                    int deviceid,
                    Window win,
                    Cursor cursor);
.fi
.sp
.nf
int XIUndefineCursor( Display *display,
                      int deviceid,
                      Window win);
.fi
.sp
.nf
cursor
       Specifies the cursor that is to be displayed or None\&.
.fi
.sp
.nf
deviceid
       Specifies the device whose cursor is to change\&.
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
win
       Specifies the window\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
If a cursor is set, it will be used when the device\*(Aqs pointer
is in the window\&. If the cursor is None, it is equivalent to
XIUndefineCursor\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The deviceid must be a master pointer device or a BadDevice error is
returned\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIDefineCursor can generate BadDevice, BadCursor and BadWindow\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XIUndefineCursor function undoes the effect of a previous
XIDefineCursor for this window\&. When the pointer is in the
window, the window\*(Aqs default cursor will now be used\&. If no
default cursor is defined, the parent\*(Aqs cursor for this device
will be used (if defined) or the parent\*(Aqs default cursor will
be used\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIDefineCursor and XIUndefineCursor are identical to
XDefineCursor and XUndefineCursor but specify the device
explicitly\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIUndefineCursor can generate a BadDevice and a BadWindow
error\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadCursor
       A value for a cursor argument does not name a defined
       cursor\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The device does not
       exist or is not a pointer device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadWindow
       A value for a Window argument does not name a defined
       window\&.
.fi
.if n \{\
.RE
.\}
.sp
See also
.sp
.if n \{\
.RS 4
.\}
.nf
XDefineCursor, XUndefineCursor
.fi
.if n \{\
.RE
.\}
