; ui.h
;
; header file for ui.asm
;
; Copyright (C) 2000, Suzhe. See file COPYING and CREDITS for details.
;

%define kbUp                 0x4800
%define kbEnhUp              0x48E0
%define kbCtrlUp             0x8D00
%define kbEnhCtrlUp          0x8DE0
%define kbDown               0x5000
%define kbEnhDown            0x50E0
%define kbCtrlDown           0x9100
%define kbEnhCtrlDown        0x91E0
%define kbLeft               0x4b00
%define kbEnhLeft            0x4BE0
%define kbRight              0x4d00
%define kbEnhRight           0x4dE0
%define kbEnter              0x1c0d
%define kbEnhEnter           0xE00D
%define kbEsc                0x011b
%define kbTab                0x0F09
%define kbShiftTab           0x0F00
%define kbBack               0x0e08
%define kbIns                0x5200
%define kbEnhIns             0x52E0
%define kbCtrlIns            0x9200
%define kbEnhCtrlIns         0x92E0
%define kbDel                0x5300
%define kbEnhDel             0x53E0
%define kbCtrlDel            0x9300
%define kbEnhCtrlDel         0x93E0
%define kbHome               0x4700
%define kbEnhHome            0x47E0
%define kbCtrlHome           0x7700
%define kbEnhCtrlHome        0x77E0
%define kbEnd                0x4f00
%define kbEnhEnd             0x4FE0
%define kbCtrlEnd            0x7500
%define kbEnhCtrlEnd         0x75E0
%define kbPgUp               0x4900
%define kbEnhPgUp            0x49E0
%define kbCtrlPgUp           0x8400
%define kbEnhCtrlPgUp        0x84E0
%define kbPgDn               0x5100
%define kbEnhPgDn            0x51E0
%define kbCtrlPgDn           0x7600
%define kbEnhCtrlPgDn        0x76E0
%define kbF1                 0x3b00
%define kbF2                 0x3c00
%define kbF3                 0x3d00
%define kbF4                 0x3e00
%define kbF5                 0x3f00
%define kbF6                 0x4000
%define kbF7                 0x4100
%define kbF8                 0x4200
%define kbF9                 0x4300
%define kbF10                0x4400
%define kbF11                0x8500
%define kbF12                0x8600
%define kbCtrlF1             0x5E00
%define kbCtrlF10            0x6700
%define kbCtrlF12            0x8A00
%define kbAltF10             0x7100

%define kbShiftF8            0x5B00
%define kbGrayMinus          0x4a2d
%define kbGrayPlus           0x4e2b
%define kbCtrlD              0x2004
%define kbCtrlI              0x1709
%define kbCtrlT              0x1414
%define kbCtrlQ              0x1011
%define kbCtrlH              0x2308
%define kbLowerY             0x1579
%define kbUpperY             0x1559
%define kbCtrlP              0x1910
%define kbCtrlU              0x1615
%define kbCtrlN              0x310e
%define kbCtrlS              0x1f13
%define kbCtrlK              0x250b
%define kbCtrlX              0x2d18
%define kbCtrlF              0x2106
%define kbCtrlL              0x260C
%define kbSlash              0x352F
%define kbQuestion           0x353F

%define kbAltS               0x1f00
%define kbAltR               0x1300

%define kbOne                0x0231

%define kbCtrlMask           0x04
%define kbAltMask            0x08
%define kbShiftMask          0x03
%define kbScrollMask         0x10


%define SIZE_OF_MENU	struc_menu.end_of_struc

struc struc_menu
        .title        resw 1    ; pointer to menu title
        .n_items      resw 1    ; number of menu items
        .cur_item     resw 1    ; current item
        .win_pos      resw 1    ; window position, high byte = row
                                ; low byte = column
        .menu_size    resw 1    ; the size of menu area, high byte = height
                                ; low byte = width
        .win_size     resw 1    ; the size of menu box
        .win_attr     resw 1    ; window attribute, high byte = title attr
                                ; low byte = frame attr
        .norm_attr    resw 1    ; normal item attr, high byte = highlight attr
                                ; low byte = normal attr
        .focus_attr   resw 1    ; focus item attr, same as norm_attr
        .str_tbl      resw 1    ; pointer to string table of menu items
        .cmd_tbl      resw 1    ; pointer to command entry table of menu items
        .hkey_tbl     resw 1    ; pointer to hotkey table

        .mnu_cmd_num  resw 1    ; number of menu command
        .mnu_cmd_tbl  resw 1    ; the command table used by menu itself
        .mnu_hkey_tbl resw 1    ; the hkey table used by menu itself
        .post_req_cmd resw 1    ; the command that will be ran after a menu item
                                ; has been called.
        .end_of_struc
endstruc


