------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                            S Y S T E M . X P                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the generic functions which are instantiated with
--  predefined integer and real types to generate the runtime exponentiation
--  functions called by expanded code generated by Expand_Op_Expon.

package System.Xp is
   --  pragma Pure (System.Xp);

   --  Exponentiation for integer base

   generic
      type Type_Of_Base is range <>;
   function Exponentiate_Integer
     (Left : Type_Of_Base; Right : Natural) return Type_Of_Base;

   --  Exponentiation for float base

   generic
      type Type_Of_Base is digits <>;
   function Exponentiate_Float
     (Left : Type_Of_Base; Right : Integer) return Type_Of_Base;

end System.Xp;
