#ifndef _KERNEL_INTERFACE_H
#define _KERNEL_INTERFACE_H

/*
 * Copyright (C) 1993 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-0.9.9d/RCS/kernel-interface.h,v $
 $Author: bas $
 *
 $Revision: 1.13 $
 $Date: 1994/01/16 15:44:54 $
 $State: ALPHA $
 *
 * ----Description----
 *
 */

#include <linux/linkage.h>
#include <linux/autoconf.h>
#include <linux/signal.h>

#define _S(nr) (1<<((nr)-1))
#define _BLOCKABLE (~(_S(SIGKILL)|_S(SIGSTOP)))

#ifndef QIC117_TAPE_MAJOR
#define QIC117_TAPE_MAJOR 27
#endif

#define FTAPE_NO_REWIND 4       /* mask for minor nr */

/*      kernel-interface.c defined global variables.
 */
asmlinkage extern char* ftape_big_buffer;
asmlinkage extern char *tape_buffer;

/*      kernel-interface.c defined global functions.
 */
asmlinkage extern int init_module( void);
asmlinkage extern void cleanup_module( void);

/*      kernel global functions not (yet) standard accessible
 *      (linked at load time by modules package).
 */
asmlinkage extern sys_sgetmask( void);
asmlinkage extern sys_ssetmask( int);

#endif



