/*
 *  krt_rtread_kmem.c,v 1.1 1993/03/22 02:39:43 jch Exp
 */

/* Gated Release 3.0 */
/* Copyright (c) 1990,1991,1992,1993 by Cornell University. All rights reserved. */
/* Refer to Particulars and other Copyright notices at the end of this file. */


#define	INCLUDE_NLIST
#define	INCLUDE_ROUTE
#define	INCLUDE_KVM
#include "include.h"
#ifdef	PROTO_INET
#include "inet.h"
#endif	/* PROTO_INET */
#ifdef	PROTO_ISO
#include "iso.h"
#endif	/* PROTO_ISO */
#include "krt.h"
#include "krt_var.h"
#include <stdio.h>

typedef struct rtable krt_type;

#define	krt_size	sizeof(krt_type)
#define	krt_conv(ptr)	(&(ptr))

/* extern int _rt_get_info(char * t); */

 /*  Read the kernel's routing table.			*/
int
krt_rtread __PF0(void)
{
    int i, hashsize = 4;
    size_t rtbufsize;
    krt_type *krt, m_buf, **base;
    rt_parms rtparms;
    if_addr *ifap;
    FILE *DFile;

    bzero((caddr_t) &rtparms, sizeof (rtparms));
    rtparms.rtp_n_gw = 1;
    DFile= fopen("/proc/net/route","r" );
    if (DFile == NULL)
	return EBADF;

    trace(TR_KRT, 0, NULL);
    trace(TR_KRT, 0, "krt_rtread: Initial routes read from kernel (via /proc/net/route):");

    /* read route data from kernel   */

    rtbufsize = hashsize * sizeof(krt_type *);
    base = (krt_type **) task_block_malloc(rtbufsize);
    krt = &m_buf;
/* skip over header line */
    i=fscanf(DFile,"%*s\t%*s\t%*s\t%*s\t%*s\t%*s\t%*s\t%*s\n");

    while(!feof(DFile)){
		i=fscanf(DFile,"%*s\t%08lX\t%08lX\t%02x\t%hd\t%ld\t%d\t%08lX\n",     
                  &krt->rt_dst, &krt->rt_gateway, &krt->rt_flags,
                  &krt->rt_refcnt, &krt->rt_use, &krt->rt_metric,
                  &krt->rt_mask);
	trace(TR_ALL, LOG_ERR, "krt_rtread: reading route: Dest=%08lX Gate=%08lX Mask=%08lX",
			  krt->rt_dst,krt->rt_gateway,krt->rt_mask);

	rtparms.rtp_dest = sock2gated((struct sockaddr *)&krt->rt_dst, unix_socksize(&krt->rt_dst));
	rtparms.rtp_router = sock2gated((struct sockaddr *)&krt->rt_gateway, unix_socksize(&krt->rt_gateway));
	rtparms.rtp_state = krt_flags_to_state((flag_t) krt->rt_flags);

	switch (krt_addrcheck(&rtparms)) {
		case KRT_ADDR_OK:
		    /* Address is OK */
		    break;

		case KRT_ADDR_IGNORE:
		    /* Ignore it */
		    continue;

		case KRT_ADDR_BOGUS:
		    /* Delete it */
		    goto Delete;

#ifdef	IP_MULTICAST
		case KRT_ADDR_MC:
		    /* Multicast specification */
		    if (krt_multicast_install(rtparms.rtp_dest, rtparms.rtp_router)) {
			goto Delete;
		    }
		    continue;
#endif	/* IP_MULTICAST */
		}

		/* Is it interior or exterior? */
		if ((ifap = if_withdstaddr(rtparms.rtp_dest))
		    || (ifap = if_withnet(rtparms.rtp_dest))) {
		    BIT_SET(rtparms.rtp_state, RTS_INTERIOR);
		} else {
		    BIT_SET(rtparms.rtp_state, RTS_EXTERIOR);
		}

		/* Determine host mask */
		if (BIT_TEST(krt->rt_flags, RTF_HOST)) {
		    rtparms.rtp_dest_mask = sockhostmask(rtparms.rtp_dest);
		} else if (ifap) {
		    rtparms.rtp_dest_mask = ifap->ifa_subnetmask;
		} else {
		    rtparms.rtp_dest_mask = inet_mask_natural(rtparms.rtp_dest);
		}

		/* Add route to our routing table */
		if (!krt_rtadd(&rtparms, krt->rt_flags)) {
		    /* We don't want it around, delete it */

		Delete:
		    krt_delete_dst(krt_task,
				   (rt_entry *) 0,
				   &rtparms,
				   (sockaddr_un *) 0,
				   RTPROTO_KERNEL,
				   &krt_gw_list);
		}
    }  /* while */
    task_block_reclaim(rtbufsize, (caddr_t) base);

    return 0;
}
