/*
 *  linux/abi/emulate.c
 *
 *  Copyright (C) 1993  Linus Torvalds
 *
 *  Feb 14 1994
 *    Added hook for loadable iBCS module to attach the syscall handler.
 *    -- Mike Jagdis (jaggy@purplet.demon.co.uk)
 */

/*
 * Emulate.c contains the entry point for the 'lcall 7,xxx' handler.
 */

#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/stddef.h>
#include <linux/unistd.h>
#include <linux/segment.h>
#include <linux/ptrace.h>

#include <asm/segment.h>
#include <asm/system.h>

void (* iABI_hook)(struct pt_regs * regs) = NULL;

asmlinkage void iABI_emulate(struct pt_regs * regs)
{
	if (iABI_hook) {
		iABI_hook(regs);
	} else {
		printk(KERN_INFO "iBCS: emulation module not loaded\n");
		do_exit(SIGSEGV);
	}
}
