/*
 *  linux/ibcs/wysev386i.h
 *
 *  Copyright (C) 1994  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 * $Id: wysev386i.h,v 1.1.1.2 1994/02/23 17:22:50 mike Exp $
 * $Source: /var/CVS/ibcs/include/ibcs/wysev386i.h,v $
 */

/* Wyse extensions for 4.3 BSD TCP/IP in V/386 3.2.1A */

/* Get struct rtentry from linux/route.h - this should be compatible. */
#include <linux/route.h>

/* Get struct arpreq from linux/if_arp.h - this should be compatible. */
#include <linux/if_arp.h>

/* Get struct ifreq and struct ifconf from linux/if.h - these should
 * be compatible.
 */
#include <linux/if.h>


/* Wyse encode the ioctl numbers using the argument size as part of
 * the number. This will warn us if we haven't got compatible
 * structures :-).
 */

#define	WVR3_IOCPARM_MASK	0x7f		/* parameters must be < 128 bytes */
#define	WVR3_IOC_VOID		0x20000000	/* no parameters */
#define	WVR3_IOC_OUT		0x40000000	/* copy out parameters */
#define	WVR3_IOC_IN		0x80000000	/* copy in parameters */
#define	WVR3_IOC_INOUT	(WVR3_IOC_IN|WVR3_IOC_OUT)
#define	WVR3_IO(x,y)	(WVR3_IOC_VOID|(x<<8)|y)
#define	WVR3_IOR(x,y,t)	(WVR3_IOC_OUT|((sizeof(t)&WVR3_IOCPARM_MASK)<<16)|(x<<8)|y)
#define	WVR3_IOW(x,y,t)	(WVR3_IOC_IN|((sizeof(t)&WVR3_IOCPARM_MASK)<<16)|(x<<8)|y)
#define	WVR3_IOWR(x,y,t)	(WVR3_IOC_INOUT|((sizeof(t)&WVR3_IOCPARM_MASK)<<16)|(x<<8)|y)

/* socket i/o controls */
#define	WVR3_SIOCSHIWAT		WVR3_IOW('s',  0, int)	/* set high watermark */
#define	WVR3_SIOCGHIWAT		WVR3_IOR('s',  1, int)	/* get high watermark */
#define	WVR3_SIOCSLOWAT		WVR3_IOW('s',  2, int)	/* set low watermark */
#define	WVR3_SIOCGLOWAT		WVR3_IOR('s',  3, int)	/* get low watermark */
#define	WVR3_SIOCATMARK		WVR3_IOR('s',  7, int)	/* at oob mark? */
#define	WVR3_SIOCSPGRP		WVR3_IOW('s',  8, int)	/* set process group */
#define	WVR3_SIOCGPGRP		WVR3_IOR('s',  9, int)	/* get process group */

#define	WVR3_SIOCADDRT		WVR3_IOW('r', 10, struct rtentry)	/* add route */
#define	WVR3_SIOCDELRT		WVR3_IOW('r', 11, struct rtentry)	/* delete route */

#define	WVR3_SIOCSIFADDR	WVR3_IOW('i', 12, struct ifreq)	/* set ifnet address */
#define	WVR3_SIOCGIFADDR	WVR3_IOWR('i',13, struct ifreq)	/* get ifnet address */
#define	WVR3_SIOCSIFDSTADDR	WVR3_IOW('i', 14, struct ifreq)	/* set p-p address */
#define	WVR3_SIOCGIFDSTADDR	WVR3_IOWR('i',15, struct ifreq)	/* get p-p address */
#define	WVR3_SIOCSIFFLAGS	WVR3_IOW('i', 16, struct ifreq)	/* set ifnet flags */
#define	WVR3_SIOCGIFFLAGS	WVR3_IOWR('i',17, struct ifreq)	/* get ifnet flags */
#define	WVR3_SIOCGIFBRDADDR	WVR3_IOWR('i',18, struct ifreq)	/* get broadcast addr */
#define	WVR3_SIOCSIFBRDADDR	WVR3_IOW('i',19, struct ifreq)	/* set broadcast addr */
#define	WVR3_SIOCGIFCONF	WVR3_IOWR('i',20, struct ifconf)	/* get ifnet list */
#define	WVR3_SIOCGIFNETMASK	WVR3_IOWR('i',21, struct ifreq)	/* get net addr mask */
#define	WVR3_SIOCSIFNETMASK	WVR3_IOW('i',22, struct ifreq)	/* set net addr mask */
#define	WVR3_SIOCGIFMETRIC	WVR3_IOWR('i',23, struct ifreq)	/* get IF metric */
#define	WVR3_SIOCSIFMETRIC	WVR3_IOW('i',24, struct ifreq)	/* set IF metric */
#define	WVR3_SIOCSIFHADDR	WVR3_IOW('i', 25, struct ifreq)	/* set hardware addr */
#define	WVR3_SIOCGIFHADDR	WVR3_IOWR('i',26, struct ifreq)	/* get hardware addr */
#define	WVR3_SIOCRIFHADDR	WVR3_IOW('i', 27, struct ifreq)     /* reset hardware addr */

#define	WVR3_SIOCSARP		WVR3_IOW('i', 30, struct arpreq)	/* set arp entry */
#define	WVR3_SIOCGARP		WVR3_IOWR('i',31, struct arpreq)	/* get arp entry */
#define	WVR3_SIOCDARP		WVR3_IOW('i', 32, struct arpreq)	/* delete arp entry */

#define	WVR3_SIOCADDMULTI	WVR3_IOW('i', 33, struct ifreq)	/* set multicast addr */
#define	WVR3_SIOCDELMULTI	WVR3_IOW('i', 34, struct ifreq)	/* set multicast addr */
