#include <unistd.h>
#include <stdio.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>
/***************************************************************************
 *
 * Function:    fflush
 *
 * Description:
 *    Flush a specific buffer or all buffers in the system.
 *
 * Entry:
 *    stream   - Pointer to the specific stream or NULL to flush all buffers
 *
 * Returns:
 *    0  if successful
 *  EOF  to indicate some error condition
 */

int fflush (FILE *stream)
    {
    int nChar;
    int nResult = 0;
    FUNC_ENTRY ("fflush");
/*
 *   If the input parameter is NULL then process all files
 */
    if (stream == NULL)
        {
	nResult = flushall();
        }
/*
 *   Determine if the file is acceptable to be flushed
 */
    else
        {
	if ((stream->_flag & (_IOREAD | _IOWRT)) == _IOWRT)
	    {
	    if (bigbuf (stream))
	        {
		nChar = stream->_ptr - stream->_base;
		if (nChar > 0)
		    {
		    if (write (fileno (stream), stream->_base, nChar) != nChar)
		        {
			stream->_flag |= _IOERR;
			nResult = EOF;
		        }
		    }
	        }
	    }
/*
 *  Reset the pointers for the new buffer
 */
	stream->_ptr = stream->_base;
	stream->_cnt = 0;
        }

    FUNC_EXIT ("fflush");
    return (nResult);
    }
