/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	entfld.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_entry_field class header
 *
 *	RCSid = "$Id: entfld.H,v 4.27.1.1 1993/06/01 22:54:10 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_entfld_H
#define OI_entfld_H

#ifndef OI_lngsrvinp_H
#include <OI/lngsrvinp.H>
#endif /* OI_lngsrvinp_H */

	// class forward reference declarations
	class OI_entry_field;
	class OI_mdl_entry_field;

		enum OI_ef_inp_state {		/* input state for directing input keystroke action */
			OI_ef_inp_full		= 0,			/* complete entry, validated; MUST be zero to allow wait_done()
										member function to work properly */
			OI_ef_inp_noinput	= 1,			/* no input received yet */
			OI_ef_inp_1st_char	= 2,			/* waiting for 1st graphic char to process */
			OI_ef_inp_partial	= 3,			/* some input received, still processing */
			OI_ef_inp_bad		= 4,			/* complete entry, invalid */
			OI_EF_INP_FULL		= OI_ef_inp_full,	/* OBSOLETE, backward compatibility only */
			OI_EF_INP_NOINPUT	= OI_ef_inp_noinput,	/* OBSOLETE, backward compatibility only */
			OI_EF_INP_1ST_CHAR	= OI_ef_inp_1st_char,	/* OBSOLETE, backward compatibility only */
			OI_EF_INP_PARTIAL	= OI_ef_inp_partial,	/* OBSOLETE, backward compatibility only */
			OI_EF_INP_BAD		= OI_ef_inp_bad		/* OBSOLETE, backward compatibility only */
		} ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		enum OI_ef_mode	{		/* input mode for entry field */
			OI_ef_mode_insert	= 1,			/* insert character between existing characters */
			OI_ef_mode_replace	= 2,			/* replace character under cursor */
			OI_EF_MODE_INSERT	= OI_ef_mode_insert,	/* OBSOLETE, backward compatibility only */
			OI_EF_MODE_REPLACE	= OI_ef_mode_replace	/* OBSOLETE, backward compatibility only */
		} ;
		enum OI_ef_char_chk_status {	/* return values for per character validation functions */
			OI_ef_char_chk_bad	= 0,			/* reject, character typed is invalid */
			OI_ef_char_chk_insert	= 1,			/* ok, insert character typed */
			OI_ef_char_chk_ignore	= 2,			/* ok, ignore character typed */
			OI_EF_CHAR_CHK_BAD	= OI_ef_char_chk_bad,	/* OBSOLETE, backward compatibility only */
			OI_EF_CHAR_CHK_INSERT	= OI_ef_char_chk_insert,	/* OBSOLETE, backward compatibility only */
			OI_EF_CHAR_CHK_IGNORE	= OI_ef_char_chk_ignore	/* OBSOLETE, backward compatibility only */
		} ;
		enum OI_ef_entry_chk_status {	/* return values for end of entry validation functions */
			OI_ef_entry_chk_bad	= 0,			/* reject, entry is invalid */
			OI_ef_entry_chk_ok	= 1,			/* ok */
			OI_EF_ENTRY_CHK_BAD	= OI_ef_entry_chk_bad,	/* OBSOLETE, backward compatibility only */
			OI_EF_ENTRY_CHK_OK	= OI_ef_entry_chk_ok	/* OBSOLETE, backward compatibility only */
		} ;

#ifdef TYPEDEF_MEMFN
	typedef	OI_ef_entry_chk_status	(OI_ef_entry_check_fn)(OI_entry_field*,void*,OI_ef_entry_chk_status) ;	/* fn to check validity of entry */
	typedef	OI_ef_entry_chk_status	OI_callback::OI_ef_entry_check_memfn(OI_entry_field*,void*,OI_ef_entry_chk_status) ;	/* memfn to check validity */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_ef_entry_chk_status	(*OI_ef_entry_check_fnp)(OI_entry_field*,void*,OI_ef_entry_chk_status) ;	/* fn to check validity of entry */
	typedef	OI_ef_entry_chk_status	(OI_callback::*OI_ef_entry_check_memfnp)(OI_entry_field*,void*,OI_ef_entry_chk_status) ;	/* memfn to check validity */

#ifdef TYPEDEF_MEMFN
	typedef	OI_ef_char_chk_status	(OI_ef_char_check_fn)(OI_entry_field*,void*,OI_ef_char_chk_status,OI_number,char) ;	/* fn to check validity of char */
	typedef	OI_ef_char_chk_status	OI_callback::OI_ef_char_check_memfn(OI_entry_field*,void*,OI_ef_char_chk_status,OI_number,char) ;	/* memfn to chk char validity */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_ef_char_chk_status	(*OI_ef_char_check_fnp)(OI_entry_field*,void*,OI_ef_char_chk_status,OI_number,char) ;	/* fn to check validity of char */
	typedef	OI_ef_char_chk_status	(OI_callback::*OI_ef_char_check_memfnp)(OI_entry_field*,void*,OI_ef_char_chk_status,OI_number,char) ;	/* memfn to chk char validity */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_ef_char_chg_fn)(OI_entry_field*,void*) ;			/* fn to call whenever char has changed */
	typedef	void	(OI_callback::OI_ef_char_chg_memfn)(OI_entry_field*,void*) ;	/* memfn to call whenever char has changed */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_ef_char_chg_fnp)(OI_entry_field*,void*) ;			/* fn to call whenever char has changed */
	typedef	void	(OI_callback::*OI_ef_char_chg_memfnp)(OI_entry_field*,void*) ;	/* memfn to call whenever char has changed */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		Definitions in this section were previously documented, but have been marked as
		//		obsolete.  These definitions have been removed from the programmer's manual.
		//		These definitions are subject to removal from the toolkit and should no longer be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#ifdef TYPEDEF_MEMFN
	typedef	OI_ef_entry_chk_status	(OI_ef_entry_chk_fn)(OI_entry_field*,void*) ;		/* OBSOLETE, use OI_ef_entry_check_fn */
	typedef	OI_ef_entry_chk_status	OI_callback::OI_ef_entry_chk_memfn(OI_entry_field*,void*) ;	/* OBSOLETE, use OI_ef_entry_check_memfn */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_ef_entry_chk_status	(*OI_ef_entry_chk_fnp)(OI_entry_field*,void*) ;			/* OBSOLETE, use OI_ef_entry_check_fnp */
	typedef	OI_ef_entry_chk_status	(OI_callback::*OI_ef_entry_chk_memfnp)(OI_entry_field*,void*) ;	/* OBSOLETE, use OI_ef_entry_check_memfnp */

#ifdef TYPEDEF_MEMFN
	typedef	OI_ef_char_chk_status	(OI_ef_char_chk_fn)(OI_entry_field*,void*,OI_number,char) ;	/* OBSOLETE, use OI_ef_char_check_fn */
	typedef	OI_ef_char_chk_status	OI_callback::OI_ef_char_chk_memfn(OI_entry_field*,void*,OI_number,char) ;	/* OBSOLETE, use OI_ef_char_check_memfn */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_ef_char_chk_status	(*OI_ef_char_chk_fnp)(OI_entry_field*,void*,OI_number,char) ;	/* OBSOLETE, use OI_ef_char_check_fnp */
	typedef	OI_ef_char_chk_status	(OI_callback::*OI_ef_char_chk_memfnp)(OI_entry_field*,void*,OI_number,char) ;	/* OBSOLETE, use OI_ef_char_check_memfnp */

 /* constants */
#define		OI_MX_C_ENTRY_FIELD	1024	/* max # chars in label + data (lbl_len+max_len) */

 /* ctl_bits private bits */
#define		OI_ENTRY_FIELD_UNDERLINE	0x1	/* 1 => draw underline */
#define		OI_ENTRY_FIELD_KB_INPUT		0x2	/* 1 => allow keyboard input or mouse pasting */
#define		OI_ENTRY_FIELD_VALIDATE		0x4	/* 1 => validate all attempts to use text() */
#define		OI_ENTRY_FIELD_KEY_INPROC	0x8	/* 1 => in middle of processing a key event */
#define		OI_ENTRY_FIELD_DASHED_UL	0x10	/* 1 => draw dashed underline for incomplete entries */
#define		OI_ENTRY_FIELD_BEG_BTN_VIS	0x20	/* 1 => beginning of text button visible */
#define		OI_ENTRY_FIELD_END_BTN_VIS	0x40	/* 1 => end of text button visible */
#define		OI_ENTRY_FIELD_BTN_PROCESS	0x80	/* 1 => processing click on beg/end button */
#define		OI_ENTRY_FIELD_DRAG_CURSOR	0x100	/* 1 => move the cursor during drag operations */
#define		OI_ENTRY_FIELD_PEND_DELETE	0x200	/* 1 => pending delete is active */
#define		OI_ENTRY_FIELD_MOUSE_SELECT	0x400	/* 1 => doing a mouse select */
#define		OI_ENTRY_FIELD_INACT_CURSOR	0x800	/* 1 => show an inactive cursor */
#define		OI_ENTRY_FIELD_USER_MODIF	0x1000	/* 1 => user action has modified the text */
#define		OI_ENTRY_FIELD_PROG_MODIF	0x2000	/* 1 => program action has modified the text */
#define		OI_ENTRY_FIELD_CLICK_SELECT	0x4000	/* 1 => selection by clicking allowed */
#define		OI_ENTRY_FIELD_CSR_LIFTED	0x10000	/* 1 => cursor is lifted */

	class OI_entry_field : public OI_lang_server_input {
			OI_mdl_entry_field	*mdl_dep ;		/* ptr to model dependent aspects of OI_box object */
			/**********************************************************************
			 *  entry_field resources
			 **********************************************************************/
			OI_font_bounds		*lbl_fntbnds;		/* font bounds for the label */
			OI_font			*lbl_fntp ;		/* ptr to font info in font cache */
			OI_number		max_len;		/* maximum characters allowed in entry field */
			OI_number		dsp_len;		/* maximum characters displayed */
			OI_number		lbl_right_space;	/* label right space */
			/**********************************************************************
			 *  end of entry_field resources 
			 **********************************************************************/
			unsigned long		ctl_bits ;		/* object specific control bits */
	 protected:
		static	XrmQuark		q_cbEfCharChk ;		/* OBSOLETE quark for character validation callback */
		static	XrmQuark		q_cbEfEntryChk ;	/* OBSOLETE quark for end of entry validation callback */
		static	XrmQuark		q_cbClick ;		/* quark for click callback */
		static	XrmQuark		q_cbEfCharChg ;		/* quark for character change callback */
		static	XrmQuark		q_cbEfCharCheck ;	/* quark for character validation callback */
		static	XrmQuark		q_cbEfEntryCheck ;	/* quark for end of entry validation callback */
			OI_string		*dspp ;			/* ptr to string to display: txtp or maskp */
			OI_string		*txtp ;			/* ptr to text string entered by user */
			OI_string		*def_txtp ;		/* ptr to default text string */
			OI_string		*lblp ;			/* ptr to label, if any */
			OI_string		*maskp ;		/* ptr to string of mask chars, if any */
			OI_number		n_dsp ;			/* # chars currently active in *dspp */
			OI_number		n_txt ;			/* # chars currently active in *txtp */
			OI_number		psn ;			/* current position in *txtp, 0=> ahead of 1st char */
			OI_number		dsp_off ;		/* # characters at beginning of entry text not displayed */
			OI_ef_inp_state		inp_state ;		/* input state for active field */
			OI_ef_mode		ins_mode ;		/* insert mode */
			OI_number		n_click ;		/* # clicks which have occurred */
			Time			tim ;			/* time of last button press/release event */
			OI_number		pri_start ;		/* start char pos for primary selection */
			OI_number		pri_end ;		/* end char pos for primary selection */
			char			*pri_bufp ;		/* ptr to PRIMARY selection buffer */
			OI_number		pri_nchrs ;		/* # chars used in *pri_bufp */
			OI_number		pri_maxchrs ;		/* max # chars in *pri_bufp */
			OI_number		sec_start ;		/* start char pos for secondary selection */
			OI_number		sec_end ;		/* end char pos for secondary selection */
			char			*sec_bufp ;		/* ptr to SECONDARY selection buffer */
			OI_number		sec_nchrs ;		/* # chars used in *sec_bufp */
			OI_number		sec_maxchrs ;		/* max # chars in *sec_bufp */
			char			*clip_bufp ;		/* ptr to CLIPBOARD selection buffer */
			OI_number		clip_nchrs ;		/* # chars used in *clip_bufp */
			OI_number		clip_maxchrs ;		/* max # chars in *clip_bufp */
			OI_number		caret_sp;		/* caret space */
			OI_number		caret_hot_x;		/* caret hot x */
			unsigned int		btn ;			/* button being held down, needed to insure proper release when others pressed */
			OI_number		intrvl ;		/* scroll interval, ms, for repeats */
			char			*enctxt ;		// pointer to encoded text string, for text() & part_text()
			char			*encdef ;		// pointer to encoded default text string, for default_text()
			char			*enclbl ;		// pointer to encoded label string, for label() function
			char			*encmsk ;		// pointer to encoded mask string, for mask() function
			OI_number		scroll_dir;		// scroll direction
			OI_enhance		enhancement;		// what type of enhancement to use
		static	OI_number		sel_start ;		/* start char pos for select. -1 => none, 0=> 1st char */
		static	OI_number		sel_end ;		/* end char pos for select. Meaningless if sel_start == -1 */
		static	OI_number		sel_last ;		// last char pos for selection
		static	OI_number		sel_anchor ;		// char pos for anchored end of selection
		static	OI_bool			quick_cut ;		// OI_yes if doing quick_cut or OI_no if doing quick_copy
	 public:
		static	OI_class		*clsp ;			/* ptr to class record */
		static	OI_bool			processing_data ;	/* flag for OI_wait_done; used by process_select_data */
	 private:
			void			clear_btn_process()	{ctl_bits &= ~OI_ENTRY_FIELD_BTN_PROCESS;}
			void			clear_cursor_lifted()	{ ctl_bits &= ~OI_ENTRY_FIELD_CSR_LIFTED; }
			void			construct (OI_number, const char *, const char *, OI_number) ;
			OI_number		insert_chars_chk_chg(OI_number,OI_number,const char*);
			void			insert_chars_gen(OI_number pos,OI_number nc,const char *cp,OI_number *npos, OI_char_encode_type enctyp);
			OI_bool			is_btn_process()	{return(OI_bool)((ctl_bits&OI_ENTRY_FIELD_BTN_PROCESS) != 0);}
			OI_bool			is_cursor_lifted()	{ return((ctl_bits & OI_ENTRY_FIELD_CSR_LIFTED) ? OI_yes : OI_no); }
			void			set_btn_process()	{ctl_bits |= OI_ENTRY_FIELD_BTN_PROCESS;}
			void			set_cursor_lifted()	{ ctl_bits |= OI_ENTRY_FIELD_CSR_LIFTED; }
			void			redisplay_entry();
			void			refresh_my_callback(OI_cb_inf*) ;
			OI_number		replace_chars_chk_chg(OI_number,OI_number,const char*);
			void			replace_chars_gen(OI_number pos,OI_number nc,const char *cp,OI_number *npos, OI_char_encode_type enctyp);
			void			res_is_inactive_cursor(void *);
			void			res_is_click_select(void *);
			void			res_is_kb_input(void *);
			void			res_is_underline(void *);
			char			*res_get_default_text();			/* callback for default text resource */
			char			*res_get_label();				/* callback for label resource */
			char			*res_get_mask();				/* callback for mask resource */
			char			*res_get_text();				/* callback for text resource */
			void			res_default_text(void *);			/* callback to set default text resource */
			void			res_dsp_length(void *) ;			/* callback to set displayLength resource */
			void			res_label(void *);				/* callback to set label resource */
			void			res_label_font(void *);				/* callback to set label font resource */
			void			res_label_fontset(void *);			/* callback to set label fontSet resource */
			void			res_label_right_space(void *);
			void			res_margin_height(void *);
			void			res_margin_width(void *);
			void			res_mask(void *);				/* callback to set mask resource */
			void			res_max_length(void *) ;			/* callback to set maximumLength resource */
			void			res_text(void *);				/* callback to set text resource */
			void			res_validate_text(void *);
			OI_bool			set_psn(OI_number);				/* set positioning parameters */
			OI_bool			upd_dsp_length(OI_number) ;			/* update internal params due to display length change */
			OI_bool			upd_max_length(OI_number) ;			/* update internal params due to max length change */
	 protected:
		/* d_tech overrides */
			void			void_select() ;					/* cancel current selection */
		/* class specific functions */
						OI_entry_field(OI_class *clsp, const char *usr_namp, OI_number dspln,
							const char *lblp=NULL, const char *defstr=NULL, OI_number mxln=0) ;
			void			cursor_key(long,int) ;				/* handle cursor motion via cursor keys */
			void			chg_inp_state(OI_ef_inp_state) ;		/* set new state and repaint underline */
			void			chg_size(OI_number,OI_number) ;
 			void			ef_scroll(OI_scroll_event,OI_number) ;		/* move displayed text via scroll buttons */
			void			force_empty() ;					/* clear out all text */
			OI_bool			force_end() ;					/* end of entry processing */
			OI_number		gen_boundary(OI_bool fwd, OI_number pos) ;	/* find general boundary */
			OI_bool			get_clipboard_data(Time,OI_bool) ;		/* common parts of clipboard routines */
			OI_number		horz_overhead(OI_number,OI_number);		/* total overhead in horizontal direction */
		virtual	OI_number		horz_overhead_entry(OI_number,OI_number);	/* horizontal overhead related to data entry #chars */
			OI_bool			is_char_ok(char);				// validate char before inserting/replacing
			void			key_extend(const XEvent *, OI_number) ;		/* common parts of key selection routines */
			OI_font_bounds		*label_fontset() ;
			OI_font			*label_font() ;
			OI_number		margin_height();				// extra padding around text in entry area
			OI_number		margin_width();					// extra padding around text in entry area
		virtual	OI_number		max_display_chars(OI_number,OI_number);		/* determine max # chars possible in given space */
			void			move_pri_select(OI_number, const XEvent *, const char* const *, unsigned int *);
		virtual	void			new_connection(OI_connection*);
			void			new_margin_height(OI_number);
			void			new_margin_width(OI_number);
		virtual	void			new_model(OI_model_type) ;
			OI_number		model_width() ;
			void			paint_char(OI_number) ;				/* redraw character */
		virtual	void			resize(OI_d_tech *, void *) ;
			void			scroll_horiz(OI_scroll_event,int) ;		/* scroll left/right */
			void			start_next() ;					/* start up via prev/next chain; ptr is in window */
			void			validate_selection();				/* make sure selection is valid */
			OI_number		word_boundary(OI_bool fwd, OI_bool mv, OI_number pos = -1) ;	/* find word boundary */
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OUT-OF-PLACE DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		These functions should be under DOCUMENTED MEMBER FUNCTIONS, but are here to prevent C++
		//		from generating out-of-line functions for them due to forward references
		//
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

						OI_entry_field(const char *usr_namp, OI_number dspln, const char *lblp=NULL,
							const char *defstr=NULL, OI_number mxln=0) ;
												/* constructor */
						~OI_entry_field() ;				/* destructor */

		virtual	OI_number		alignment_loc_x(OI_alignment = OI_alignment_default);
		virtual	OI_number		alignment_loc_y(OI_alignment = OI_alignment_default);
			void			allow_dashed_ul() ;
			void			allow_drag_cursor()	{ctl_bits |= OI_ENTRY_FIELD_DRAG_CURSOR;}
			void			allow_mouse_select()	{ctl_bits |= OI_ENTRY_FIELD_MOUSE_SELECT;}
			void			allow_pending_delete()	{ctl_bits |= OI_ENTRY_FIELD_PEND_DELETE;}
			void			allow_validate_text() 	{ctl_bits |= OI_ENTRY_FIELD_VALIDATE;}
		virtual	OI_number		baseline() ;					/* offset (pixels) to baseline */
			unsigned int		button()		{return (btn);}		/* button being held down for selection */
			OI_number		char_loc(OI_number, OI_number) ;		/* convert X pixel to character location */
			OI_bool			chk_kb_input();					/* chk kb_input allowed & give msg if not */
			void			chk_resize() ;					/* resize due to char/font change? */
			void			clone_adjust(OI_d_tech*) ;
			OI_stat			create() ;					/* generate item in X environment */
			OI_number		current_select_end()	{return(sel_end);}
			OI_number		current_select_start()	{return(sel_start);}
			OI_bool			decode_extend(const char* const *, unsigned int *) ;	/* figure out if extending kb selection */
 		virtual	OI_bool			delete_selection(Atom) ;			/* delete text of selection */
			void			disable() ;
			void			disallow_dashed_ul() ;
			void			disallow_drag_cursor()	{ctl_bits &= ~OI_ENTRY_FIELD_DRAG_CURSOR;}
			void			disallow_mouse_select()	{ctl_bits &= ~OI_ENTRY_FIELD_MOUSE_SELECT;}
			void			disallow_pending_delete()	{ctl_bits &= ~OI_ENTRY_FIELD_PEND_DELETE;}
			void			disallow_validate_text()	{ctl_bits &= ~OI_ENTRY_FIELD_VALIDATE;}
			OI_bool			do_entry_chk();
		friend	void			dmpOI_entry_field(OI_entry_field*) ;		/* diagnostic dump procedure */
			void			dragdrop_start(OI_dnd_operation, const XEvent *);
			void			drop_preview(OI_d_tech*,void*,OI_dnd_operation,long,long);
			OI_number		dsp_offset()		{return(dsp_off);}
			void			ef_select(const XEvent*) ;				/* various selection events */
			void			enable() ;
			void			enhance(OI_bool,OI_number,OI_number) ;		/* (un)enhance selected portion of text */
			void			enhance_selection(Atom,OI_bool);		/* (un)enhance the selection */
			OI_number		entry_decoration_height() ;			// height of decoration around data entry area
			void			font_resize() ;					/* resize object for font change */
			char			*get_text(OI_bool,OI_char_encode_type);		/* get encoded text string */
		virtual	void			handle_drop(OI_dnd_operation , long, long);
		virtual	OI_number		horz_overhead_other();				/* horizontal overhead for non data entry area only */
		static	OI_bool			init(OI_connection*) ;
			OI_ef_inp_state		input_state()		{return(inp_state);}
			OI_number		interval()		{return(intrvl);}	/* get scroll repeat interval, ms */
			OI_bool			is_dashed_ul() ;
			OI_bool			is_drag_cursor()	{return((ctl_bits&OI_ENTRY_FIELD_DRAG_CURSOR)?OI_yes:OI_no);}
			OI_bool			is_mouse_select()	{return((ctl_bits&OI_ENTRY_FIELD_MOUSE_SELECT)?OI_yes:OI_no);}
			OI_bool			is_pending_delete()	{return((ctl_bits&OI_ENTRY_FIELD_PEND_DELETE)?OI_yes:OI_no);}
			OI_bool			is_validate_text()	{return(OI_bool)((ctl_bits&OI_ENTRY_FIELD_VALIDATE)!=0);}
			OI_bool			is_write_resq(XrmQuark);
			OI_number		label_loc();					/* offset (pixels) to 1st label char */
			OI_number		label_length() ;
			OI_number		label_width() ;
			void			lift_cursor(OI_bool) ;
		static	OI_entry_field		*make_minimal(const char*, OI_minimal_type) ;
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
			OI_stat			new_default_text(const char*,OI_bool,OI_bool,OI_char_encode_type) ;
												/* change default text */
			OI_stat			new_dsp_length(OI_number) ;			/* set max # chars displayed */
			void			new_label(const char*,OI_char_encode_type) ;	/* change label */
			void			new_label_font(OI_font *, OI_charset=OI_charset_latin1);
			void			new_label_fontset(OI_font_bounds*) ;
			void			new_label_right_space(OI_number);
			void			new_mask(const char*,OI_char_encode_type) ;	/* set output mask */
			OI_stat			new_max_length(OI_number) ;			/* set max # chars in field */
		virtual	OI_stat			new_size(OI_number,OI_number);
			OI_stat			new_text(const char*,OI_bool,OI_char_encode_type);
			OI_number		number_displayed()	{return(n_dsp);}
		virtual	OI_number		object_height() ;
			OI_number		object_width() ;
		virtual	void			paint(const XEvent*, void* =NULL) ;		/* draw contents after mapping X window  */
			void			paint_cursor() ;
			OI_string		*ply_default()		{return(def_txtp);}	/* get value of default text */
			OI_string		*ply_display()		{return(dspp);}		/* get value of displayed text */
			OI_string		*ply_label()		{return(lblp);}		/* get value of label */
			OI_string		*ply_mask()		{return(maskp);}	/* get value of mask */
			OI_string		*ply_text()		{return(txtp);}		/* get value of text */
		virtual	void			post_get_resources();
			OI_number		primary_end()		{return (pri_end);}
			OI_number		primary_start()		{return (pri_start);}
			void			private_void_select(Atom);			/* void a specific selection */
			void			process_pending_delete();
			OI_bool			process_select_data(Atom,Atom) ;		/* insert selection data requested */
			void			request_select_data(Atom,Atom,Atom,Time) ;	/* request current selection */
			OI_bool			retrieve_select_data(Atom,Atom) ;		/* copy selection data to clipboard */
			void			reset_n_click()	{n_click = 0;}
			void			save_select(Atom,OI_number,OI_number) ;		/* save current selection */
			void			scroll_timer();
			OI_number		second_end()		{return (sec_end);}
			OI_number		second_start()		{return (sec_start);}
			void			select_line();
			void			select_word();
			OI_bool			selection_convert(OI_d_tech *, void *, const XEvent *);
			OI_bool			send_select_data(Window,Atom,Atom,Atom) ;	/* send data to requestor */
			void			set_caret_hot_x(OI_number x)	{caret_hot_x = x;}
			void			set_caret_space(OI_number s)	{caret_sp = s;}
			void			set_enhancement(OI_enhance e)	{enhancement = e;}
			void			set_interval(OI_number n)	{intrvl=n;}	/* set scroll repeat interval, ms */
			void			set_primary_end(OI_number e)	{pri_end = e;}
			void			set_primary_start(OI_number s)	{pri_start = s;}
			void			set_prog_modified()		{ctl_bits |= OI_ENTRY_FIELD_PROG_MODIF;}
			void			set_second_end(OI_number e)	{sec_end = e;}
			void			set_second_start(OI_number s)	{sec_start = s;}
			void			set_select_end(OI_number s)	{sel_end = s;}
			void			set_select_start(OI_number s)	{sel_start = s;}
			int			set_text_internal(const char*,OI_bool,OI_char_encode_type) ;
			void			set_user_modified()		{ctl_bits |= OI_ENTRY_FIELD_USER_MODIF;}
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_ef_char_chk_status	def_c_chk(OI_entry_field*,void*,OI_number,char) ;		// use def_c_check
			void			set_char_chk(OI_ef_char_chk_fnp fp, void *argp=NULL) ;		// use set_char_check
			void			set_char_chk(OI_callback *objp, OI_ef_char_chk_memfnp mfp, void *argp=NULL) ;	// use set_char_check
		virtual	void			set_entry_chk(OI_ef_entry_chk_fnp fp, void *argp=NULL) ;	// use set_entry_check
		virtual	void			set_entry_chk(OI_callback *objp, OI_ef_entry_chk_memfnp mfp, void *argp=NULL) ;	// use set_entry_check

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	char			*alpha_value() ;
		virtual	void			drag_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void			drag_copy_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void			drag_move_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	char			*selection_data(Atom) ;				/* get selection's data */
		virtual	char			*selection_data(const char *) ;			/* get selection's data */
		virtual	OI_stat			set_state(OI_state) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//	Out of order due to forward reference:
		//-------------------------------------------------------------------------------------------------		
			OI_bool			delete_chars(OI_number,OI_number) ;		/* remove substring of entry */
			OI_bool			insert_chars(OI_number,OI_number,const char*) ;	/* insert substring into entry */
			OI_bool			replace_chars(OI_number,OI_number,const char*) ;	/* replace substring of entry */
		//-------------------------------------------------------------------------------------------------		
		//	Remainder:	
		//-------------------------------------------------------------------------------------------------		
			void			allow_inactive_cursor() ;
			void			allow_click_select() 	{ctl_bits |= OI_ENTRY_FIELD_CLICK_SELECT;}
			void			allow_kb_input()	{ctl_bits |= OI_ENTRY_FIELD_KB_INPUT; allow_takes_focus();}
			void			allow_underline() ;
			void			clear_enhance() ;				/* clear all enhancements */
			void			clear_modified()	{ctl_bits &= ~(OI_ENTRY_FIELD_PROG_MODIF|OI_ENTRY_FIELD_USER_MODIF);}
			void			clear_prog_modified()	{ctl_bits &= ~OI_ENTRY_FIELD_PROG_MODIF;}
			void			clear_user_modified()	{ctl_bits &= ~OI_ENTRY_FIELD_USER_MODIF;}
			OI_ef_char_chk_status	def_c_check(OI_entry_field*,void*,OI_ef_char_chk_status,OI_number,char) ;
												/* default char input check procedure */
			char			*default_text() ;
			OI_bool			delete_char(OI_number pos) 			/* remove character at a given position */
									{return (delete_chars(pos, 1));}
			void			disallow_inactive_cursor() ;
			void			disallow_click_select()	{ctl_bits &= ~OI_ENTRY_FIELD_CLICK_SELECT;}
			void			disallow_kb_input()	{ctl_bits &= ~OI_ENTRY_FIELD_KB_INPUT;}
			void			disallow_underline() ;
			OI_number		dsp_length()		{return(dsp_len);}
			OI_number		entry_loc() ;					/* offset (pixels) to 1st entry char */
			OI_enhance		get_enhance(OI_number) ;			/* get enhance for a character */
			OI_bool			insert_char(OI_number pos,char ch) ;		/* insert character at a given position */
			OI_bool			is_inactive_cursor() ;
			OI_bool			is_click_select()	{return(OI_bool)((ctl_bits&OI_ENTRY_FIELD_CLICK_SELECT)!=0);}
			OI_bool			is_kb_input()		{return(OI_bool)((ctl_bits&OI_ENTRY_FIELD_KB_INPUT) != 0);}
			OI_bool			is_modified()		{return(OI_bool)((ctl_bits&(OI_ENTRY_FIELD_PROG_MODIF| OI_ENTRY_FIELD_USER_MODIF)) != 0);}
			OI_bool			is_prog_modified()	{return(OI_bool)((ctl_bits&OI_ENTRY_FIELD_PROG_MODIF) != 0);}
			OI_bool			is_underline() ;
			OI_bool			is_user_modified()	{return(OI_bool)((ctl_bits&OI_ENTRY_FIELD_USER_MODIF) != 0);}
			char			*label() ;
			OI_number		label_right_space();
			OI_number		length()		{return(n_txt);}	/* # chars in field */
			char			*mask() ;
			OI_number		max_length()		{return(max_len);}
			OI_ef_mode		mode()			{return(ins_mode);}	/* get current insert mode */
			char			*part_text() ;
			OI_number		position()		{return(psn);}
			void			remove_enhance(OI_number,OI_number,OI_enhance) ;/* unenhance portion of text */
			OI_bool			replace_char(OI_number pos, char ch) ;		/* replace char at a given position */
			OI_bool			selection_coords(OI_number *strt, OI_number *end) ;
			void			set_char_chg(OI_ef_char_chg_fnp fp, void *argp=NULL) ;
			void			set_char_chg(OI_callback *objp, OI_ef_char_chg_memfnp mfp, void *argp=NULL) ;
			void			set_char_check(OI_ef_char_check_fnp fp, void *argp=NULL) ;
			void			set_char_check(OI_callback *objp, OI_ef_char_check_memfnp mfp, void *argp=NULL) ;
			OI_stat			set_default_text(const char*,OI_bool=OI_yes,OI_bool=OI_yes);
												/* change default text */
			OI_stat			set_dsp_length(OI_number) ;			/* set max # chars displayed */
			void			set_enhance(OI_number,OI_number,OI_enhance,const char*,const char*,const char* =NULL) ;
												/* enhance portion of text */
			void			set_enhance(OI_number,OI_number,OI_enhance,PIXEL=OI_unknown_pixel,PIXEL=OI_unknown_pixel, const char* =NULL) ;			/* enhance portion of text */
		virtual	void			set_entry_check(OI_ef_entry_check_fnp fp, void *argp=NULL) ;
		virtual	void			set_entry_check(OI_callback *objp, OI_ef_entry_check_memfnp mfp, void *argp=NULL) ;
			void			set_label(const char*) ;			/* change label */
			void			set_label_char(OI_number pos, char) ;		/* change char in label */
			OI_stat			set_label_chars(OI_number pos, OI_number len, const char *textp) ;
												/* change substring in label */
			void			set_label_font(const char *fnp,OI_charset cs=OI_charset_latin1) ;
												/* change label font */
			void			set_label_right_space(OI_number);
			void			set_mask(const char*) ;				/* set output mask */
			OI_stat			set_max_length(OI_number) ;			/* set max # chars in field */
			void			set_mode(OI_ef_mode md)	{ins_mode = md ;}	/* set new insert mode */
			OI_bool			set_position(OI_number) ;			/* set cursor/entry point */
			OI_stat			set_text(const char*,OI_bool=OI_yes);		/* set text as if user had entered it */
			char			*text() ;
			void			wait_done() ;					/* process events until done pressed */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			backward_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			backward_view(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			backward_word(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			beginning_of_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			cancel_select(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			clear_focus_frame(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			click_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			click_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			copy_clipboard(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			copy_primary(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			copy_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			cut_clipboard(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			cut_primary(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			delete_all_characters(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			delete_next_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			delete_next_word(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			delete_previous_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			delete_previous_word(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			delete_to_beginning_of_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			delete_to_end_of_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			end_of_line(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			extend_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
		virtual	void			focus_in(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void			focus_out(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			forward_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			forward_view(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			forward_word(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			input_character(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			input_convert(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			insert_mode(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			insert_selection(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			key_select(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			move_insertion(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			move_selection(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			newline(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			next_object(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			next_tab_group(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			paint_focus_frame(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			paste_clipboard(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			prev_object(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			prev_tab_group(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			quick_paste(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			replace_mode(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			replace_with_default(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			scroll_left(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			scroll_left_edge(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			scroll_right(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			scroll_right_edge(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			secondary_adjust(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			secondary_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			secondary_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			select_adjust(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			select_all(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void			select_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			select_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			set_anchor(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			set_quick_copy(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			set_quick_cut(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			start_input_conversion(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			stop_input_conversion(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			take_focus(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			toggle_mode(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			unselect_all(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_entry_field	*oi_create_entry_field(const char*,OI_number,const char* =NULL,const char* =NULL,OI_number =0) ;

#endif /* OI_entfld_H */
