/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	filedlg.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_file_dialog_box class header
 *
 *	RCSid = "$Id: filedlg.H,v 4.6.1.2 1993/06/02 17:15:26 garya Exp $"
 *
 ****************************************************************************
 */

#ifndef	OI_filedlg_H
#define	OI_filedlg_H

#ifndef	OI_seldlg_H
#include <OI/seldlg.H>
#endif /* OI_seldlg_H */

#ifndef MAXPATHLEN
#include <sys/param.h>
#endif

	// class forward reference declarations
	class OI_mdl_file_dialog_box;

#define	OI_FILE_DB_MIN_VP_HT		5	/* Minimum viewport height. */
#define	OI_FILE_DB_MAX_FN_LEN		MAXPATHLEN	/* Maximum length of file name. */
#define	OI_FILE_DB_FILE_NUM_INC		64	/* Initial number of files in a directory. */

const int OI_file_dialog_box_reg_exp_ed	= 0x00000001;
const int OI_file_dialog_box_in_update	= 0x00000002;

class OI_file_dialog_box : public OI_select_dialog_box {
			OI_mdl_file_dialog_box	*mdl_dep;			/* pointer to model dependent file dlg box. */
	 public:
		static	OI_class		*clsp ;				/* ptr to class record */
	 private:
			void			construct(const char*, const char*) ;
			char			*extract_comp(char *, char**);	/* Separate string into directory and filter components */
	 protected:
			unsigned long		ctl_bits;			/* Control bits */
			char			*dir;				/* Current directory being browsed. */
			char			*fltr;				/* The ed filter used to determin filenames to display */
			time_t			mtime;				/* Modify time (st_mtime) of directory */

	 protected:
						OI_file_dialog_box(OI_class *, const char *, const char* =".", const char* ="*",
							OI_number=-1, OI_menu_cell** =NULL) ;
						OI_file_dialog_box(OI_class *, const char *, const char*, const char*, OI_number,
							OI_cell_spec*) ;
		virtual	void			new_model(OI_model_type) ;
			char			*rel_to_abs_path(const char *,char*);	/* Convert relative paths to absolute ones */
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

						OI_file_dialog_box(const char*, const char* =".", const char* ="*", OI_number=-1,
							OI_menu_cell** = NULL);
						OI_file_dialog_box(const char*, const char*, const char*, OI_number, OI_cell_spec*);
						~OI_file_dialog_box();
			void			allow_in_update()		{ ctl_bits |= OI_file_dialog_box_in_update; }
			void			allow_reg_exp_ed()		{ ctl_bits |= OI_file_dialog_box_reg_exp_ed; }
			void			clone_adjust(OI_d_tech*) ;
			char			*conv_c_to_ed(const char *);		/* Convert from C shell type expression to ed type reg expression. */
			void			dir_select(OI_menu *, OI_menu_cell *, void *, OI_number) ;
			OI_entry_field		*directory_entry_field() ;
			OI_scroll_menu		*directory_menu() ;
			void			disallow_in_update()		{ ctl_bits &= ~OI_file_dialog_box_in_update; }
			void			disallow_reg_exp_ed()		{ ctl_bits &= ~OI_file_dialog_box_reg_exp_ed; }
			void			ff_btn_cb(OI_menu_cell *cp, void *ap, OI_number bn);
			OI_ef_entry_chk_status	ff_cb_common(OI_entry_field *efp) ;
			OI_ef_entry_chk_status	ff_ef_cb(OI_d_tech *objp, void *ap, OI_ef_entry_chk_status);
			OI_entry_field		*filter_entry_field() ;
		virtual	OI_bool			filter_init( const char * );
		virtual	OI_bool			filter_match( const char * );
			OI_menu			*filter_type_menu() ;
		static	OI_bool			init(OI_connection*) ;
			OI_bool			is_in_update()	{ return ((ctl_bits & OI_file_dialog_box_in_update) ? OI_YES : OI_NO); }
			OI_bool			is_reg_exp_ed()	{ return ((ctl_bits & OI_file_dialog_box_reg_exp_ed) ? OI_YES : OI_NO); }
		static	OI_file_dialog_box	*make_minimal(const char*,OI_minimal_type) ;
			char			*merge_dir(const char*, const char*);	/* Expand and merge new dir name with old name */
		virtual	void			mnu_select(OI_menu *, OI_menu_cell *, void *, OI_number);
			void			next_directory(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			next_file(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			previous_directory(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			previous_file(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			reg_exp_cb(OI_menu_cell *, void *, OI_number);
			void			res_filter( void *p )		{ set_files(NULL, *(const char* const *)p); }
			void			res_filterLabel( void *p )	{ set_filter_label(*(const char* const *)p); }
			void			set_mtime( time_t mt )		{ mtime = mt; }
		virtual	OI_stat			set_state(OI_state) ;
			void			sortnames(int, const char* const *, const char* const *);	/* Sort the file names. */
			void			store_dir(const char*);				/* free current dir and store new value. */
			void			store_fltr(const char*);			/* free current fltr and store new value. */
			int			update(const char *dp, const char *fp) ;
		virtual	int			term_dlg(OI_menu_cell*, void*, OI_number);	/* Dialog box wait_fn */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			char			*directory()			{ return(dir); }
			char			*filter()			{ return(fltr); }
			char			*filter_label()	;
			char			*pathname() ;
			void			select_file(const char *path) ;
			int			set_files(const char* =NULL, const char* =NULL);	/* set directory and filter. */
			void			set_filter_label(const char*) ;
			int			update()			{ return(update(dir, fltr)); }
};

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_file_dialog_box *oi_file_dialog_box(const char*, const char * =".", const char * ="*", OI_number =-1, OI_menu_cell** = NULL);

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_file_dialog_box *oi_create_file_dialog_box(const char*, const char * =".", const char * ="*", OI_number =-1,
				OI_cell_spec* = NULL);
	OI_file_dialog_box *oi_create_file_dialog_box(const char*, const char *, const char *, OI_number, OI_menu_cell**);

#endif /* OI_filedlg_H */
