/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	font.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Various font related classes
 *
 *	RCSid = "$Id: font.H,v 4.4.1.1 1993/06/01 22:54:31 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_font_H
#define OI_font_H

#ifndef OI_attr_H
#include <OI/attr.H>
#endif /* OI_attr_H */

	class OI_connection;
	class OI_font_bounds;

#define OI_FONT_USING_DEFAULT_FONT	0x01

	class OI_font : public OI_attr {
		protected:
			XrmQuark		font_namq;	/* quarkified font name */
			XFontStruct		*fontp ;	/* ptr to X font info */
			OI_number		wid ;		/* character width, pixels, includes intercharacter space */
			OI_number		ht ;		/* character height (ascent+descent), pixels, no interline spacing */
			OI_number		x_bdr ;		/* # border pixels to display at each end */
			OI_number		ascnt ;		/* extent of text above baseline */
			OI_number		dscnt ;		/* extent of text below baseline */
			OI_number		y_ref ;		/* baseline psn for drawing chars, rel to win origin assuming window has only 1 line, pixels */
			short unsigned		ctl_bits;	/* control bits */
		private:
			void			init(XrmQuark);			/* initialize data structure */
		public:
						OI_font(const char *);
						OI_font(XrmQuark);
		virtual				~OI_font();
		virtual	OI_bool			compare(OI_attr *);
		virtual	void			create(OI_connection *);
			char			*font_name()			{ return (XrmQuarkToString(font_namq)); }
			XrmQuark		font_name_quark()		{ return (font_namq); }
			XFontStruct		*font()				{ return (fontp); }
		virtual	void			make_sum();
			OI_number		width()				{ return (wid); }
			OI_number		height()			{ return (ht); }
			OI_number		x_border()			{ return (x_bdr); }
			OI_number		ascent()			{ return (ascnt); }
			OI_number		descent()			{ return (dscnt); }
			OI_number		y_reference()			{ return (y_ref); }
			void			allow_using_default_font()	{ ctl_bits |= OI_FONT_USING_DEFAULT_FONT; }
			void			disallow_using_default_font()	{ ctl_bits &= ~OI_FONT_USING_DEFAULT_FONT; }
			OI_bool			is_using_default_font()		{ return ((ctl_bits&OI_FONT_USING_DEFAULT_FONT)?OI_yes:OI_no); }
	} ;

#define OI_FONT_LIST_TAGGED	0x01

	class OI_font_list {
		protected:
			OI_font_list		*nxt;		/* pointer to next list item */
			OI_font_list		*prv;		/* pointer to prev list item */
			OI_font			*fntp;		/* pointer to OI font info */
			OI_font_bounds		*fntbndp ;	/* pointer to font bounds for this list */
			OI_charset		chrset ;	/* charset of font */
			unsigned short		flags;
		public:
						OI_font_list(OI_charset chset, OI_font *oifp, OI_font_bounds *fbp) ;
						~OI_font_list() ;
			void			allow_tagged()		{ flags |= OI_FONT_LIST_TAGGED; }
			void			disallow_tagged()	{ flags &= ~OI_FONT_LIST_TAGGED; }
			OI_bool			is_tagged()		{ return ((flags&OI_FONT_LIST_TAGGED)?OI_YES:OI_NO); }
			OI_charset		char_set()		{ return (chrset); }
			OI_font			*font()			{ return (fntp); }
			OI_font_bounds		*font_bounds()		{ return (fntbndp); }
			OI_font_list		*next()			{ return (nxt); }
			OI_font_list		*prev()			{ return (prv); }
			void			set_char_set(OI_charset c) { chrset = c; }
			void			set_font(OI_font *f) ;
			void			set_next(OI_font_list *n)	{ nxt = n; }
			void			set_prev(OI_font_list *p)	{ prv = p; }
	} ;

	class OI_font_bounds : public OI_attr {			/* Max bounds over all font list entries */
			OI_connection		*conp ;		/* pointer to connection for these fonts */
			OI_font_list		*listp ;	/* pointer to first font list item */
			OI_number		wid ;		/* character width, pixels, includes intercharacter space */
			OI_number		ht ;		/* character height (ascent+descent), pixels, no interline spacing */
			OI_number		x_bdr ;		/* # border pixels to display at each end */
			OI_number		ascnt ;		/* extent of text above baseline */
			OI_number		dscnt ;		/* extent of text below baseline */
			OI_number		y_ref ;		/* baseline psn for drawing chars */

		public:
						OI_font_bounds(OI_connection *con);
		virtual				~OI_font_bounds();
			OI_font_list		*add_font(OI_charset, OI_font*);
//			void			add_font(OI_font_list*);
			OI_number		ascent()			{ return (ascnt); }
			OI_font_bounds		*clone();
		virtual	OI_bool			compare(OI_attr *);
			OI_connection		*connection()		{ return (conp); }
			OI_number		descent()			{ return (dscnt); }
			OI_font_list		*font_and_charset_present(OI_charset, OI_font*);
			OI_font_list		*font_list()			{ return (listp); }
			OI_number		height()			{ return (ht); }
		virtual	void			make_sum();
			void			max_bounds();
			void			remove_font(OI_font *);
			OI_font_bounds		*verify(OI_font_list *);
			OI_number		width()				{ return (wid); }
			OI_number		x_border()			{ return (x_bdr); }
			OI_number		y_reference()			{ return (y_ref); }
	};



#endif /* OI_font_H */
