#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <limits.h>
#include <unistd.h>
#include <sys/stat.h>
#include <linux/umsdos_fs.h>
#include "umsdos_progs.h"

/*
Thu Jan 13 11:21:21 GMT 1994 Private release for Umsdos 0.1+
Tue Mar 15 11:24:09 GMT 1994 First Public release for Umsdos 0.2
This program was made by Glaude David [Glu] (dglaude@is1.ulb.ac.be)
It is based on the udosctl.c from Jacques Gelinas (jacques@solucorp.qc.ca)
*/


/* #Specification: umsdos_progs / umsmanifest
	The umsmanifest utility use acces directly to UMSDOS ioctl on directory.

	umsmanifest directory_name

		Creates a shell script that will aid in the restoration of
		Unix filenames that got clobbered by the MSDOS filename
		restrictions by the UMSDOS mangling algorithme.
		It uses UMSDOS_READDIR_EMD. 
		
	This program was done mostly for faking mkmanifest from the mtools.
*/

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 2){
		fprintf (stderr,
			"umsmanifest directory_path\n"
			"umsmanifest is part of the umsdos file system\n"
			);
	}else{
		char *arg = argv[1];

		UMSDOS_IOCTL ctl (arg,1,1);
		struct dirent dirent;
		struct umsdos_dirent udirent;
		while (ctl.ureaddir(udirent,dirent)!=-1){
                	if (strcmp(dirent.d_name,udirent.name))
				printf ("mv %s %s\n", dirent.d_name,udirent.name);
		}
	}
	return ret;
}

