/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                                PTYPES                                    */
/*                                                                          */
/*                                  Body                                    */
/*                                                                          */
/*                             $Revision: 1.1 $                             */
/*                                                                          */
/*             Copyright (c) 1992,1993, NYU, All Rights Reserved            */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms  of the GNU  General  Public  License  as  published  by the  Free */
/* Software  Foundation;  either version 2,  or (at your option)  any later */
/* version.  GNAT is distributed  in the hope  that it will be useful,  but */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- */
/* ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public */
/* License  for  more details.  You should have received  a copy of the GNU */
/* General Public License along with GNAT;  see file COPYING. If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* Functions for retrieving target types. */

#include "tm.h"
#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))

/* Standard data type sizes.  Most of these are not used.  */

#ifndef CHAR_TYPE_SIZE
#define CHAR_TYPE_SIZE BITS_PER_UNIT
#endif

#ifndef SHORT_TYPE_SIZE
#define SHORT_TYPE_SIZE (BITS_PER_UNIT * MIN ((UNITS_PER_WORD + 1) / 2, 2))
#endif

#ifndef INT_TYPE_SIZE
#define INT_TYPE_SIZE BITS_PER_WORD
#endif

#ifndef LONG_TYPE_SIZE
#define LONG_TYPE_SIZE BITS_PER_WORD
#endif

#ifndef LONG_LONG_TYPE_SIZE
#define LONG_LONG_TYPE_SIZE (BITS_PER_WORD * 2)
#endif

#ifndef FLOAT_TYPE_SIZE
#define FLOAT_TYPE_SIZE BITS_PER_WORD
#endif

#ifndef DOUBLE_TYPE_SIZE
#define DOUBLE_TYPE_SIZE (BITS_PER_WORD * 2)
#endif

#ifndef LONG_DOUBLE_TYPE_SIZE
#define LONG_DOUBLE_TYPE_SIZE (BITS_PER_WORD * 2)
#endif

/* The choice of SIZE_TYPE here is very problematic.  We need a signed
   type whose bit width is Pmode.  Assume "long" is such a type here.  */
#undef SIZE_TYPE
#define SIZE_TYPE "long int"


typedef unsigned Pos;

/* The following provide a functional interface for the front end Ada code
   to determine the sizes that are used for various C types. */

Pos
get_bits_per_unit ()
{
  return BITS_PER_UNIT;
}

Pos
get_bits_per_word ()
{
  return BITS_PER_WORD;
}

Pos
get_target_char_size ()
{
  return CHAR_TYPE_SIZE;
}

Pos
get_target_short_size ()
{
  return SHORT_TYPE_SIZE;
}

Pos
get_target_int_size ()
{
  return INT_TYPE_SIZE;
}

Pos
get_target_long_size ()
{
  return LONG_TYPE_SIZE;
}

Pos
get_target_long_long_size ()
{
  return LONG_LONG_TYPE_SIZE;
}

Pos
get_target_float_size ()
{
  return FLOAT_TYPE_SIZE;
}

Pos
get_target_double_size ()
{
  return DOUBLE_TYPE_SIZE;
}

Pos
get_target_long_double_size ()
{
  return LONG_DOUBLE_TYPE_SIZE;
}

Pos
get_target_pointer_size ()
{
  return POINTER_SIZE;
}

