------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              R T S F I N D                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.38 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;

package Rtsfind is

--  This package contains the routine that is used to obtain runtime library
--  entities, loading in the required runtime library packages on demand. It
--  is also used for such purposes as finding System.Address when System has
--  not been explicitly With'ed.

   ------------------------
   -- Runtime Unit Table --
   ------------------------

   --  The following type includes an enumeration entry for each runtime
   --  unit. The enumeration literal represents the fully qualified
   --  name of the unit, as follows:

   --    Names of the form RTU_xxx are top level library packages whose name
   --    is xxx. For example the name RTU_System refers to package System.

   --    Names of the form RTUA_xxx are first level children of Ada, whose
   --    name is Ada.xxx. For example, the name RTUA_Tags refers to package
   --    Ada.Tags.

   --    Names of the form RTUS_xxx are first level children of System, whose
   --    name is System.xxx. For example, the name RTUS_Str_Concat refers to
   --    package System.Str_Concat.

   --    Names of the form RTUS_TASKING_xxx are second level children of the
   --    package System.Tasking. For example, RTUS_TASKING_ABORTION refers
   --    to package System.Tasking.Abortion.

   --  This list can contain both subprogram and package unit names. For
   --  packages, the accessible entities in the package are separately
   --  listed in the package entity table. The units must be either library
   --  level package declarations, or library level subprogram declarations.
   --  Generic units, library level instantiations and subprogram bodies
   --  acting as specs may not be referenced (all these cases could be added
   --  at the expense of additional complexity in the body of Rtsfind, but
   --  it doesn't seem worth while, since the implementation controls the
   --  set of units that are referenced, and this restrictions is easily met.

   type RTU_Id is (
      RTU_System,                        -- package System

      --  Runtime packages, for list of accessible entities in each package,
      --  see declarations in the runtime entity table below.

      RTUA_Tags,                         -- Ada.Tags
      RTUA_Finalization,                 -- Ada.Finalization
      RTUS_Assertions,                   -- System.Assertions
      RTUS_Compiler_Exceptions,          -- System.Compiler_Exceptions
      RTUS_Finalization_Implementation,  -- System.Finalization_Implementation
      RTUS_Image,                        -- System.Image
      RTUS_Secondary_Stack,              -- System.Secondary_Stack
      RTUS_Storage_Elements,             -- System.Storage_Elements
      RTUS_Tasking,                      -- System.Tasking
      RTUS_Tasking_Abortion,             -- System.Tasking.Abortion
      RTUS_Tasking_Protected_Objects,    -- System.Tasking.Protected_Objects
      RTUS_Tasking_Rendezvous,           -- System.Tasking.Rendezvous
      RTUS_Tasking_Stages,               -- System.Tasking.Stages
      RTUS_Tasking_Soft_Links,           -- System.Tasking_Soft_Links
      RTUS_Traceback,                    -- System.Traceback

      --  Functions for String concatenation and equality

      RTUS_Str_Concat,                   -- System.Str_Concat
      RTUS_Str_Equal,                    -- System.Str_Equal

      --  Functions for Image attribute

      RTUS_Img_B,                        -- Boolean'Image
      RTUS_Img_C,                        -- Character'Image
      RTUS_Img_F,                        -- Float'Image
      RTUS_Img_I,                        -- Integer'Image
      RTUS_Img_LF,                       -- Long_Float'Image
      RTUS_Img_LLF,                      -- Long_Long_Float'Image
      RTUS_Img_LLI,                      -- Long_Long_Integer'Image
      RTUS_Img_SF,                       -- Short_Float'Image
      RTUS_Img_WC,                       -- Wide_Character'Image

      --  Functions for exponentiation

      RTUS_Xp_BMI,                       -- exponentiate binary modular (int)
      RTUS_Xp_BML,                       -- exponentiate binary modular (long)
      RTUS_Xp_F,                         -- exponentiate Float
      RTUS_Xp_I,                         -- exponentiate Integer
      RTUS_Xp_LF,                        -- exponentiate Long_Float
      RTUS_Xp_LLF,                       -- exponentiate Long_Long_Float
      RTUS_Xp_LI,                        -- exponentiate Long_Integer
      RTUS_Xp_LLI,                       -- exponentiate Long_Long_Integer
      RTUS_Xp_NBM,                       -- exponentiate non-binary modular
      RTUS_Xp_SF,                        -- exponentiate Short_Float
      RTUS_Xp_SI,                        -- exponentiate Short_Integer
      RTUS_Xp_SSI);                      -- exponentiate Short_Short_Integer

   --------------------------
   -- Runtime Entity Table --
   --------------------------

   --  This is the enumeration type used to define the argument passed to
   --  the RTE function. The name must exactly match the name of the entity
   --  involved, and in the case of a package entity, this name must uniquely
   --  imply the package containing the entity (i.e. it is not permissible for
   --  two runtime packages to share an entity name if the compiler must be
   --  able to generate references to both entities).

   --  Note that not all entities in the units contained in the runtime unit
   --  table are included in the following table, only those that actually
   --  have to be referenced from generated code.

   type RE_Id is (

      --  Functions for exponentiation

      RE_Xp_BMI,
      RE_Xp_BML,
      RE_Xp_F,
      RE_Xp_I,
      RE_Xp_LF,
      RE_Xp_LLF,
      RE_Xp_LI,
      RE_Xp_LLI,
      RE_Xp_NBM,
      RE_Xp_SF,
      RE_Xp_SI,
      RE_Xp_SSI,

      --  Functions for string operations

      RE_Str_Concat,
      RE_Str_Equal,

      --  Functions for Image attribute

      RE_Img_B,
      RE_Img_C,
      RE_Img_F,
      RE_Img_I,
      RE_Img_LF,
      RE_Img_LLF,
      RE_Img_LLI,
      RE_Img_SF,
      RE_Img_WC,

      --  Entities defined in System

      RE_Address,
      RE_Any_Priority,
      RE_Default_Priority,
      RE_Interrupt_Priority,
      RE_Null_Address,
      RE_Priority,

      --  Entities defined in Ada.Tags

      RE_Expanded_Name,
      RE_External_Tag,
      RE_Internal_Tag,
      RE_Tag,
      RE_Tag_Error,

      --  Entities defined in System.Tasking_Soft_Links

      RE_Abort_Defer,
      RE_Abort_Undefer,

      --  Entities defined in System.Assertions

      RE_Assert_Failure,

      --  Entities defined in System.Compiler_Exceptions

      RE_Current_Exception,

      --  Entities defined in System.Finalization_Implementation

      RE_Attach_To_Final_List,
      RE_Root_Controlled,
      RE_Finalizable,
      RE_Finalizable_Ptr,
      RE_Finalize_List,
      RE_Finalize_One,
      RE_Global_Final_List,

      --  Entities defined in System.Secondary_Stack

      RE_Mark_Id,
      RE_SS_Allocate,
      RE_SS_Init,
      RE_SS_Mark,
      RE_SS_Release,

      --  Entities for System.Storage_Element

      RE_Storage_Offset,
      RE_Storage_Array,

      --  Entities defined in System.Tasking

      RE_Self,
      RE_Task_ID,
      RE_Task_Image,
      RE_Task_String,
      RE_Null_Protected_Entry,
      RE_Max_Protected_Entry,
      RE_Protected_Entry_Index,
      RE_Call_Modes,
      RE_Simple_Call,
      RE_Conditional_Call,
      RE_Asynchronous_Call,

      RE_Task_List,

      RE_Error_Information,
      RE_Init_State,
      RE_Interrupt_ID,
      RE_Interrupt_Info,
      RE_Machine_Exceptions,
      RE_Pre_Call_State,
      RE_Task_Storage_Size,

      RE_Accept_Alternative,
      RE_Accept_List,
      RE_Accept_List_Access,
      RE_Max_Select,
      RE_Max_Task_Entry,

      RE_No_Rendezvous,
      RE_Null_Task_Entry,
      RE_Positive_Select_Index,
      RE_Select_Index,
      RE_Select_Modes,
      RE_Else_Mode,
      RE_Simple_Mode,
      RE_Terminate_Mode,

      RE_Task_Entry_Index,
      RE_Master_Id,
      RE_Size_Type,
      RE_Unspecified_Priority,
      RE_Unspecified_Size,
      RE_Activation_Chain,

      RE_Protected_Entry_Queue_Array,
      RE_Protection,
      RE_Protection_Access,
      RE_Barrier_Vector,

      --  Entities defined in System.Tasking.Abortion

      RE_Abort_Tasks,

      --  Entities defined in System.Tasking.Protected_Objects

      RE_Initialize_Protection,
      RE_Finalize_Protection,
      RE_Lock,
      RE_Lock_Read_Only,
      RE_Unlock,
      RE_Protected_Entry_Call,
      RE_Complete_Protected_Entry_Call,
      RE_Next_Entry_Call,
      RE_Complete_Entry_Body,
      RE_Exceptional_Complete_Entry_Body,
      RE_Requeue_Protected_Entry,
      RE_Requeue_Task_Entry,
      RE_Protected_Count,
      RE_Broadcast_Program_Error,
      RE_Get_Call_In_Progress,
      RE_Set_Call_In_Progress,
      RE_Check_Exception,

      --  Entities defined in System.Tasking.Rendezvous

      RE_Accept_Call,
      RE_Accept_Trivial,
      RE_Callable,
      RE_Call_Simple,
      RE_Cancel_Task_Entry_Call,
      RE_Complete_Rendezvous,
      RE_Task_Count,
      RE_Exceptional_Complete_Rendezvous,
      RE_Selective_Wait,
      RE_Task_Entry_Call,

      --  Entities defined in System.Tasking.Stages

      RE_Activate_Tasks,
      RE_Complete_Activation,
      RE_Current_Master,
      RE_Complete_Master,
      RE_Complete_Task,
      RE_Create_Task,
      RE_Enter_Master,
      RE_Expunge_Unactivated_Tasks,
      RE_Terminated,

      --  Entities defined in System.Traceback

      RE_Store_TB);

   --  The following declarations build a table that is indexed by the
   --  RTE function to determine the unit containing the given entity.

   RE_Unit_Table : array (RE_Id) of RTU_Id := (
      RE_Str_Concat                        => RTUS_Str_Concat,
      RE_Str_Equal                         => RTUS_Str_Equal,

      RE_Img_B                             => RTUS_Img_B,
      RE_Img_C                             => RTUS_Img_C,
      RE_Img_F                             => RTUS_Img_F,
      RE_Img_I                             => RTUS_Img_I,
      RE_Img_LF                            => RTUS_Img_LF,
      RE_Img_LLF                           => RTUS_Img_LLF,
      RE_Img_LLI                           => RTUS_Img_LLI,
      RE_Img_SF                            => RTUS_Img_SF,
      RE_Img_WC                            => RTUS_Img_WC,

      RE_Xp_BMI                            => RTUS_Xp_BMI,
      RE_Xp_BML                            => RTUS_Xp_BML,
      RE_Xp_F                              => RTUS_Xp_F,
      RE_Xp_I                              => RTUS_Xp_I,
      RE_Xp_LF                             => RTUS_Xp_LF,
      RE_Xp_LLF                            => RTUS_Xp_LLF,
      RE_Xp_LI                             => RTUS_Xp_LI,
      RE_Xp_LLI                            => RTUS_Xp_LLI,
      RE_Xp_NBM                            => RTUS_Xp_NBM,
      RE_Xp_SF                             => RTUS_Xp_SF,
      RE_Xp_SI                             => RTUS_Xp_SI,
      RE_Xp_SSI                            => RTUS_Xp_SSI,

      RE_Address                           => RTU_System,
      RE_Any_Priority                      => RTU_System,
      RE_Default_Priority                  => RTU_System,
      RE_Interrupt_Priority                => RTU_System,
      RE_Null_Address                      => RTU_System,
      RE_Priority                          => RTU_System,

      RE_Expanded_Name                     => RTUA_Tags,
      RE_External_Tag                      => RTUA_Tags,
      RE_Internal_Tag                      => RTUA_Tags,
      RE_Tag                               => RTUA_Tags,
      RE_Tag_Error                         => RTUA_Tags,

      RE_Abort_Defer                       => RTUS_Tasking_Soft_Links,
      RE_Abort_Undefer                     => RTUS_Tasking_Soft_Links,

      RE_Assert_Failure                    => RTUS_Assertions,

      RE_Current_Exception                 => RTUS_Compiler_Exceptions,

      RE_Attach_To_Final_List              => RTUS_Finalization_Implementation,
      RE_Root_Controlled                   => RTUS_Finalization_Implementation,
      RE_Finalizable                       => RTUS_Finalization_Implementation,
      RE_Finalizable_Ptr                   => RTUS_Finalization_Implementation,
      RE_Finalize_List                     => RTUS_Finalization_Implementation,
      RE_Finalize_One                      => RTUS_Finalization_Implementation,
      RE_Global_Final_List                 => RTUS_Finalization_Implementation,

      RE_Mark_Id                           => RTUS_Secondary_Stack,
      RE_SS_Allocate                       => RTUS_Secondary_Stack,
      RE_SS_Init                           => RTUS_Secondary_Stack,
      RE_SS_Mark                           => RTUS_Secondary_Stack,
      RE_SS_Release                        => RTUS_Secondary_Stack,

      RE_Storage_Offset                    => RTUS_Storage_Elements,
      RE_Storage_Array                     => RTUS_Storage_Elements,

      RE_Error_Information                 => RTUS_Tasking,
      RE_Init_State                        => RTUS_Tasking,
      RE_Interrupt_ID                      => RTUS_Tasking,
      RE_Interrupt_Info                    => RTUS_Tasking,
      RE_Machine_Exceptions                => RTUS_Tasking,
      RE_Pre_Call_State                    => RTUS_Tasking,
      RE_Task_Storage_Size                 => RTUS_Tasking,

      RE_Task_ID                           => RTUS_Tasking,
      RE_Task_Image                        => RTUS_Tasking,
      RE_Task_String                       => RTUS_Tasking,

      RE_Null_Protected_Entry              => RTUS_Tasking,
      RE_Max_Protected_Entry               => RTUS_Tasking,
      RE_Protected_Entry_Index             => RTUS_Tasking,
      RE_Call_Modes                        => RTUS_Tasking,
      RE_Simple_Call                       => RTUS_Tasking,
      RE_Conditional_Call                  => RTUS_Tasking,
      RE_Asynchronous_Call                 => RTUS_Tasking,

      RE_Task_List                         => RTUS_Tasking,

      RE_Protected_Entry_Queue_Array       => RTUS_Tasking,
      RE_Protection                        => RTUS_Tasking,
      RE_Protection_Access                 => RTUS_Tasking,
      RE_Barrier_Vector                    => RTUS_Tasking,

      RE_Accept_Alternative                => RTUS_Tasking,
      RE_Accept_List                       => RTUS_Tasking,
      RE_Accept_List_Access                => RTUS_Tasking,
      RE_Max_Select                        => RTUS_Tasking,
      RE_Max_Task_Entry                    => RTUS_Tasking,
      RE_No_Rendezvous                     => RTUS_Tasking,
      RE_Null_Task_Entry                   => RTUS_Tasking,
      RE_Positive_Select_Index             => RTUS_Tasking,
      RE_Select_Index                      => RTUS_Tasking,
      RE_Select_Modes                      => RTUS_Tasking,
      RE_Else_Mode                         => RTUS_Tasking,
      RE_Simple_Mode                       => RTUS_Tasking,
      RE_Terminate_Mode                    => RTUS_Tasking,
      RE_Task_Entry_Index                  => RTUS_Tasking,

      RE_Master_Id                         => RTUS_Tasking,
      RE_Self                              => RTUS_Tasking,
      RE_Size_Type                         => RTUS_Tasking,
      RE_Unspecified_Priority              => RTUS_Tasking,
      RE_Unspecified_Size                  => RTUS_Tasking,

      RE_Activation_Chain                  => RTUS_Tasking,

      RE_Abort_Tasks                       => RTUS_Tasking_Abortion,

      RE_Initialize_Protection             => RTUS_Tasking_Protected_Objects,
      RE_Finalize_Protection               => RTUS_Tasking_Protected_Objects,
      RE_Lock                              => RTUS_Tasking_Protected_Objects,
      RE_Lock_Read_Only                    => RTUS_Tasking_Protected_Objects,
      RE_Unlock                            => RTUS_Tasking_Protected_Objects,
      RE_Protected_Entry_Call              => RTUS_Tasking_Protected_Objects,
      RE_Complete_Protected_Entry_Call     => RTUS_Tasking_Protected_Objects,
      RE_Next_Entry_Call                   => RTUS_Tasking_Protected_Objects,
      RE_Complete_Entry_Body               => RTUS_Tasking_Protected_Objects,
      RE_Exceptional_Complete_Entry_Body   => RTUS_Tasking_Protected_Objects,
      RE_Requeue_Protected_Entry           => RTUS_Tasking_Protected_Objects,
      RE_Requeue_Task_Entry                => RTUS_Tasking_Protected_Objects,
      RE_Protected_Count                   => RTUS_Tasking_Protected_Objects,
      RE_Broadcast_Program_Error           => RTUS_Tasking_Protected_Objects,
      RE_Get_Call_In_Progress              => RTUS_Tasking_Protected_Objects,
      RE_Set_Call_In_Progress              => RTUS_Tasking_Protected_Objects,
      RE_Check_Exception                   => RTUS_Tasking_Protected_Objects,

      RE_Accept_Call                       => RTUS_Tasking_Rendezvous,
      RE_Accept_Trivial                    => RTUS_Tasking_Rendezvous,
      RE_Callable                          => RTUS_Tasking_Rendezvous,
      RE_Call_Simple                       => RTUS_Tasking_Rendezvous,
      RE_Cancel_Task_Entry_Call            => RTUS_Tasking_Rendezvous,
      RE_Complete_Rendezvous               => RTUS_Tasking_Rendezvous,
      RE_Task_Count                        => RTUS_Tasking_Rendezvous,
      RE_Exceptional_Complete_Rendezvous   => RTUS_Tasking_Rendezvous,
      RE_Selective_Wait                    => RTUS_Tasking_Rendezvous,
      RE_Task_Entry_Call                   => RTUS_Tasking_Rendezvous,

      RE_Activate_Tasks                    => RTUS_Tasking_Stages,
      RE_Complete_Activation               => RTUS_Tasking_Stages,
      RE_Create_Task                       => RTUS_Tasking_Stages,
      RE_Current_Master                    => RTUS_Tasking_Stages,
      RE_Complete_Master                   => RTUS_Tasking_Stages,
      RE_Complete_Task                     => RTUS_Tasking_Stages,
      RE_Enter_Master                      => RTUS_Tasking_Stages,
      RE_Expunge_Unactivated_Tasks         => RTUS_Tasking_Stages,
      RE_Terminated                        => RTUS_Tasking_Stages,

      RE_Store_TB                          => RTUS_Traceback);

   -----------------
   -- Subprograms --
   -----------------

   procedure Initialize;
   --  Procedure to initialize data structures used by RTE. Called at the
   --  start of processing a new main source file. Must be called after
   --  Initialize_Snames (since names it enters into name table must come
   --  after names entered by Snames).

   function RTE (E : RE_Id) return Entity_Id;
   --  Given the entity defined in the above tables, as identified by the
   --  corresponding value in the RE_Id enumeration type, returns the Id
   --  of the corresponding entity, first loading in (parsing, analyzing and
   --  expanding) its spec if the unit has not already been loaded. If the
   --  unit cannot be found, or if it does not contain the specified entity,
   --  then an appropriate error message is output ("Runtime Configuration
   --  Error") and an Unrecoverable_Error exception is raised.

end Rtsfind;
