------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--          S Y S T E M . T A S K I N G . R U N T Y P E _ T Y P E S         --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.4 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2,  or (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Task_Primitives;  use System.Task_Primitives;

package body System.Tasking.Runtime_Types is

   ------------------------------------
   -- Vulnerable_Complete_Activation --
   ------------------------------------

   --  WARNING : Only call this procedure with priority already boosted.
   --  That's why the name has "Vulnerable" in it.

   procedure Vulnerable_Complete_Activation
     (T : ATCB_Ptr)
   is
      This_Task : ATCB_Ptr := ID_To_ATCB (Self);
      Activator : ATCB_Ptr;

   begin
      Activator := T.Activator;

      --  Decrement the count of tasks to be activated by the activator and
      --  wake it up so it can check to see if all tasks have been activated.
      --  Note that the locks of the activator and created task are locked
      --  here.  This is necessary because C.Stage and
      --  T.Activation_Count have to be synchronized.  This is also
      --  done in Activate_Tasks and Init_Abortion.  So long as the
      --  activator lock is always locked first, this cannot lead to deadlock.

      Write_Lock (Activator.L);
      Write_Lock (T.L);

      if T.Stage = Can_Activate then
         T.Stage := Active;
         Activator.Activation_Count := Activator.Activation_Count - 1;
      end if;

      Unlock (T.L);

      Cond_Signal (Activator.Cond);
      Unlock (Activator.L);

   end Vulnerable_Complete_Activation;

end System.Tasking.Runtime_Types;
