#include "config.h"

#define CONST

CONST unsigned char key_map_finnish[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '}', 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '|',
  '{', 0, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_finnish[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', ']', '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '\\',
  '[', 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_finnish[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_finnish_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', 180, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 229, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 246,
  228, 167, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_finnish_latin1[] =
{
  0, 27, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 197, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 214,
  196, 189, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_finnish_latin1[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_us[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '\\', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_us[] =
{
  0, 27, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '_', '+', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '"', '~', '0', '|', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

#if 0
CONST unsigned char alt_map_us[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
#else
CONST unsigned char alt_map_us[] =
{
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};
#endif

CONST unsigned char key_map_uk[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '#', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_uk[] =
{
  0, 27, '!', '"', 163, '$', '%', '^',
  '&', '*', '(', ')', '_', '+', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '@', '~', '0', '~', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_uk[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_gr[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', '', '+', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '',
  '', '^', 0, '#', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_gr[] =
{
  0, 27, '!', '"', '', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', '', '*', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '',
  '', '', 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_gr[] =
{
  0, 0, 0, '', '', 0, 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '', 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_gr_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 225, 39, 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 129, '+', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 94, 0, '#', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_gr_latin1[] =
{
  0, 27, '!', '"', 21, '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 154, '*', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 248, 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_gr_latin1[] =
{
  0, 0, 0, 253, 252, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 230, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_fr[] =
{
  0, 27, '&', '{', '"', '\'', '(', '-',
  '}', '_', '/', '@', ')', '=', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '^', '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  '|', '`', 0, 42, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '!', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_fr[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', ']', '+', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '<', '>', 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', '~', 0, '#', 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', '\\', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_fr[] =
{
  0, 0, 0, '~', '#', '{', '[', '|',
  '`', '\\', '^', '@', ']', '}', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_fr_latin1[] =
{
  0, 27, '&', 233, '"', '\'', '(', '-',
  232, '_', 231, 224, ')', '=', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '^', '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  249, 178, 0, 42, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '!', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_fr_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 176, '+', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 168, 163, 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', 0, 0, 181, 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', 167, 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_fr_latin1[] =
{
  0, 0, 0, '~', '#', '{', '[', '|',
  '`', '\\', '^', '@', ']', '}', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 164, 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dk[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 229, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 230,
  162, 0, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_dk[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 197, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 198,
  165, 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dk[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', 0, '|', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dk_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', 180, 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 229, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 230,
  162, 189, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_dk_latin1[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 197, '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 198,
  165, 167, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dk_latin1[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', 0, '|', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_dvorak[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\\', '=', 127, 9,
  '\'', ',', '.', 'p', 'y', 'f', 'g', 'c',
  'r', 'l', '/', ']', 13, 0, 'a', 'o',
  'e', 'u', 'i', 'd', 'h', 't', 'n', 's',
  '-', '`', 0, '[', ';', 'q', 'j', 'k',
  'x', 'b', 'm', 'w', 'v', 'z', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_dvorak[] =
{
  0, 27, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '|', '+', 127, 9,
  '"', '<', '>', 'P', 'Y', 'F', 'G', 'C',
  'R', 'L', '?', '}', 13, 0, 'A', 'O',
  'E', 'U', 'I', 'D', 'H', 'T', 'N', 'S',
  '_', '~', 0, '{', ':', 'Q', 'J', 'K',
  'X', 'B', 'M', 'W', 'V', 'Z', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_dvorak[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sg[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0,
  0, 0, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sg[] =
{
  0, 27, '+', '"', '*', 0, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0,
  0, 0, 0, 0, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sg[] =
{
  0, 0, 0, '@', '#', 0, 0, 0,
  '|', 0, 0, 0, '\'', '~', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sg_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 252, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 246,
  228, 167, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sg_latin1[] =
{
  0, 27, '+', '"', '*', 231, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 220, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 214,
  196, 176, 0, 163, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sg_latin1[] =
{
  0, 0, 0, '@', '#', 0, 0, 172,
  '|', 162, 0, 0, '\'', '~', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 233,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_no[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\\', 127, 9,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '}', '~', 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '|',
  '{', '|', 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_no[] =
{
  0, 27, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', ']', '^', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '\\',
  '[', 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_no[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', 0, '\'', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sf[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0, 0, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0,
  0, 0, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sf[] =
{
  0, 27, '+', '"', '*', 0, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0,
  0, 0, 0, 0, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sf[] =
{
  0, 0, 0, '@', '#', 0, 0, 0,
  '|', 0, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_sf_latin1[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', 127, 9,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 232, 168, 13, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 233,
  224, 167, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_sf_latin1[] =
{
  0, 27, '+', '"', '*', 231, '%', '&',
  '/', '(', ')', '=', '?', '`', 127, 9,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 252, '!', 13, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 246,
  228, 176, 0, 163, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_sf_latin1[] =
{
  0, 0, 0, '@', '#', 0, 0, 172,
  '|', 162, 0, 0, 180, '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char key_map_es[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\'',    0,  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '`',  '+',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',    0,
   '\'',  '`',    0,    0,  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char shift_map_es[] = {
      0,   27,  '!',  '"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',    0,  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  '^',  '*',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',    0,
      0,  '~',    0,    0,  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char alt_map_es[] = {
      0,    0,  '|',  '@',  '#',  '$',    0,    0,
    '{',  '[',  ']',  '}', '\\',  '~',    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '[',  ']',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
    '{', '\\',    0,  '}',    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '~',    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char key_map_es_latin1[] = {
      0,   27,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\'',  173,  127,    9,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '`',  '+',   13,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  164,
    '\'',  167,    0,  135,  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char shift_map_es_latin1[] = {
      0,   27,  '!',  '"',  250,  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  168,  127,    9, 
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  '^',  '*',   13,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  165,
    '"',  166,    0,  128,  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

CONST unsigned char alt_map_es_latin1[] = {
      0,    0,  '|',  '@',  '#',  '$',    0,  172,
    '{',  '[',  ']',  '}', '\\',  '~',    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '[',  ']',   13,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
    '{', '\\',    0,  '}',    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '~',    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

/* keyboard driver for BELGIAN KEYBOARD */

CONST unsigned char key_map_be[] =
{
  0, 27, '&', 130, '"', '\'', '(', 21,
  138, '!', 128, 133, ')', '-', 127, 9,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '^', '$', 13, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  151, 230, 0, '<', 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '=', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char shift_map_be[] =
{
  0, 27, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 248, '_', 127, 9,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 0, '*', 13, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', 156, 0, '>', 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', '+', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

CONST unsigned char alt_map_be[] =
{
  0, 0, '|', '@', '#', 0, 0, '^',
  0, 0, '{', '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']', 13, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '\'', 96, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};


CONST unsigned char num_table_dot[]   = "789-456+1230.";
CONST unsigned char num_table_comma[] = "789-456+1230,";

